/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.InputStream;
import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SimpleSampler;

public class Main {
    private boolean hasPrintedUsage = false;
    private RubyInstanceConfig config;

    public Main(RubyInstanceConfig config) {
        this.config = config;
    }

    public Main(final InputStream in, final PrintStream out, final PrintStream err) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(in);
                this.setOutput(out);
                this.setError(err);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    public static void main(String[] args) {
        Main main = new Main();
        int status = main.run(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    public int run(String[] args) {
        this.config.processArguments(args);
        return this.run();
    }

    public int run() {
        int status;
        if (this.config.isShowVersion()) {
            this.showVersion();
        }
        if (!this.config.shouldRunInterpreter()) {
            if (this.config.shouldPrintUsage()) {
                this.printUsage();
            }
            if (this.config.shouldPrintProperties()) {
                this.printProperties();
            }
            return 0;
        }
        long now = -1L;
        if (this.config.isBenchmarking()) {
            now = System.currentTimeMillis();
        }
        try {
            status = this.runInterpreter();
        }
        catch (MainExitException mee) {
            this.config.getOutput().println(mee.getMessage());
            if (mee.isUsageError()) {
                this.printUsage();
            }
            status = mee.getStatus();
        }
        if (this.config.isBenchmarking()) {
            this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
        }
        return status;
    }

    private void showVersion() {
        this.config.getOutput().print(this.config.getVersionString());
    }

    public void printUsage() {
        if (!this.hasPrintedUsage) {
            this.config.getOutput().print(this.config.getBasicUsageHelp());
            this.hasPrintedUsage = true;
        }
    }

    public void printProperties() {
        this.config.getOutput().print(this.config.getPropertyHelp());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runInterpreter() {
        int n;
        InputStream in = this.config.getScriptSource();
        String filename = this.config.displayedFileName();
        Ruby runtime = Ruby.newInstance(this.config);
        runtime.setKCode(this.config.getKCode());
        if (this.config.isSamplingEnabled()) {
            SimpleSampler.startSampleThread();
        }
        if (this.config.isVerbose()) {
            runtime.setVerbose(runtime.getTrue());
        }
        if (in == null) {
            return 0;
        }
        try {
            try {
                this.runInterpreter(runtime, in, filename);
                n = 0;
                Object var9_8 = null;
            }
            catch (RaiseException rj) {
                RubyException raisedException = rj.getException();
                if (runtime.fastGetClass("SystemExit").isInstance(raisedException)) {
                    IRubyObject status = raisedException.callMethod(runtime.getCurrentContext(), "status");
                    if (status != null && !status.isNil()) {
                        int n2 = RubyNumeric.fix2int(status);
                        Object var9_9 = null;
                        if (!Ruby.isSecurityRestricted() && !runtime.getRuntimeInformation().isEmpty()) {
                            System.err.println("Runtime information dump:");
                            for (Object key : runtime.getRuntimeInformation().keySet()) {
                                System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                            }
                        }
                        if (!this.config.isSamplingEnabled()) return n2;
                        SimpleSampler.report();
                        return n2;
                    }
                    int n3 = 0;
                    Object var9_10 = null;
                    if (!Ruby.isSecurityRestricted() && !runtime.getRuntimeInformation().isEmpty()) {
                        System.err.println("Runtime information dump:");
                        for (Object key : runtime.getRuntimeInformation().keySet()) {
                            System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                        }
                    }
                    if (!this.config.isSamplingEnabled()) return n3;
                    SimpleSampler.report();
                    return n3;
                }
                runtime.printError(raisedException);
                int n4 = 1;
                Object var9_11 = null;
                if (!Ruby.isSecurityRestricted() && !runtime.getRuntimeInformation().isEmpty()) {
                    System.err.println("Runtime information dump:");
                    for (Object key : runtime.getRuntimeInformation().keySet()) {
                        System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                    }
                }
                if (!this.config.isSamplingEnabled()) return n4;
                SimpleSampler.report();
                return n4;
            }
            catch (JumpException.ThrowJump tj) {
                int n5 = 1;
                Object var9_12 = null;
                if (!Ruby.isSecurityRestricted() && !runtime.getRuntimeInformation().isEmpty()) {
                    System.err.println("Runtime information dump:");
                    for (Object key : runtime.getRuntimeInformation().keySet()) {
                        System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                    }
                }
                if (!this.config.isSamplingEnabled()) return n5;
                SimpleSampler.report();
                return n5;
            }
            catch (MainExitException e) {
                if (!e.isAborted()) throw e;
                int n6 = e.getStatus();
                Object var9_13 = null;
                if (!Ruby.isSecurityRestricted() && !runtime.getRuntimeInformation().isEmpty()) {
                    System.err.println("Runtime information dump:");
                    for (Object key : runtime.getRuntimeInformation().keySet()) {
                        System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                    }
                }
                if (!this.config.isSamplingEnabled()) return n6;
                SimpleSampler.report();
                return n6;
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (!Ruby.isSecurityRestricted() && !runtime.getRuntimeInformation().isEmpty()) {
                System.err.println("Runtime information dump:");
                for (Object key : runtime.getRuntimeInformation().keySet()) {
                    System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                }
            }
            if (!this.config.isSamplingEnabled()) throw throwable;
            SimpleSampler.report();
            throw throwable;
        }
        if (!Ruby.isSecurityRestricted() && !runtime.getRuntimeInformation().isEmpty()) {
            System.err.println("Runtime information dump:");
            for (Object key : runtime.getRuntimeInformation().keySet()) {
                System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
            }
        }
        if (!this.config.isSamplingEnabled()) return n;
        SimpleSampler.report();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInterpreter(Ruby runtime, InputStream in, String filename) {
        try {
            this.initializeRuntime(runtime, this.config, filename);
            runtime.runFromMain(in, filename);
        }
        finally {
            runtime.tearDown();
        }
    }

    private void initializeRuntime(Ruby runtime, RubyInstanceConfig commandline, String filename) {
        runtime.setVerbose(runtime.newBoolean(commandline.isVerbose()));
        runtime.setDebug(runtime.newBoolean(commandline.isDebug()));
        runtime.getObject().setInternalVariable("$VERBOSE", commandline.isVerbose() ? runtime.getTrue() : runtime.getNil());
        this.defineGlobal(runtime, "$-p", commandline.isAssumePrinting());
        this.defineGlobal(runtime, "$-n", commandline.isAssumeLoop());
        this.defineGlobal(runtime, "$-a", commandline.isSplit());
        this.defineGlobal(runtime, "$-l", commandline.isProcessLineEnds());
        ValueAccessor d = new ValueAccessor(runtime.newString(filename));
        runtime.getGlobalVariables().define("$PROGRAM_NAME", d);
        runtime.getGlobalVariables().define("$0", d);
        runtime.getLoadService().init(commandline.loadPaths());
        for (String scriptName : commandline.requiredLibraries()) {
            RubyKernel.require(runtime.getTopSelf(), runtime.newString(scriptName), Block.NULL_BLOCK);
        }
    }

    private void defineGlobal(Ruby runtime, String name, boolean value) {
        runtime.getGlobalVariables().defineReadonly(name, new ValueAccessor(value ? runtime.getTrue() : runtime.getNil()));
    }
}

