/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.io.InputStream;
import jline.ConsoleOperations;
import jline.ConsoleReader;
import jline.UnixTerminal;
import jline.UnsupportedTerminal;
import jline.WindowsTerminal;

public abstract class Terminal
implements ConsoleOperations {
    private static Terminal term;

    public static Terminal getTerminal() {
        return Terminal.setupTerminal();
    }

    public static void resetTerminal() {
        term = null;
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized Terminal setupTerminal() {
        Terminal termProp;
        if (term != null) {
            return term;
        }
        String string = System.getProperty("os.name").toLowerCase();
        String os = System.getProperty("jline.terminal");
        if (os != null && os.length() > 0) {
            try {
                termProp = (Terminal)Class.forName(os).newInstance();
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException(e.toString()).fillInStackTrace();
            }
        } else {
            void t;
            termProp = t.indexOf("windows") != -1 ? new WindowsTerminal() : new UnixTerminal();
        }
        try {
            termProp.initializeTerminal();
        }
        catch (Exception e) {
            e.printStackTrace();
            term = new UnsupportedTerminal();
            return term;
        }
        term = termProp;
        return term;
    }

    public boolean isANSISupported() {
        return true;
    }

    public int readCharacter(InputStream in) throws IOException {
        return in.read();
    }

    public int readVirtualKey(InputStream in) throws IOException {
        return this.readCharacter(in);
    }

    public abstract void initializeTerminal() throws Exception;

    public abstract int getTerminalWidth();

    public abstract int getTerminalHeight();

    public abstract boolean isSupported();

    public abstract boolean getEcho();

    public void beforeReadLine(ConsoleReader reader, String prompt, Character mask) {
    }

    public void afterReadLine(ConsoleReader reader, String prompt, Character mask) {
    }

    public abstract boolean isEchoEnabled();

    public abstract void enableEcho();

    public abstract void disableEcho();

    public InputStream getDefaultBindings() {
        return this.getClass().getResourceAsStream("keybindings.properties");
    }
}

