/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class NativeLibrary {
    private long handle;
    private String libraryName;
    private String libraryPath;
    private final Map functions = new HashMap();
    private static final Map libraries = new HashMap();
    private static final Map searchPaths = Collections.synchronizedMap(new HashMap());
    private static final List librarySearchPath = new LinkedList();

    private NativeLibrary(String libraryName, String libraryPath, long handle) {
        this.libraryName = this.getLibraryName(libraryName);
        this.libraryPath = libraryPath;
        this.handle = handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeLibrary loadLibrary(String libraryName) {
        String libraryPath;
        long l;
        LinkedList searchPath = new LinkedList(librarySearchPath);
        List customPaths = (List)searchPaths.get(libraryName);
        if (customPaths != null) {
            List list = customPaths;
            synchronized (list) {
                searchPath.addAll(0, customPaths);
            }
        }
        if ((l = NativeLibrary.open(libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath))) == 0L) {
            if (Platform.isLinux() && (libraryPath = NativeLibrary.matchLibrary(libraryName, searchPath)) != null) {
                l = NativeLibrary.open(libraryPath);
            }
            if (l == 0L) {
                throw new UnsatisfiedLinkError("Unable to load library '" + libraryName + "'");
            }
        }
        return new NativeLibrary(libraryName, libraryPath, l);
    }

    private String getLibraryName(String libraryName) {
        String suffix;
        int suffixStart;
        String simplified = libraryName;
        String BASE = "---";
        String template = NativeLibrary.mapLibraryName("---");
        int prefixEnd = template.indexOf("---");
        if (prefixEnd > 0 && simplified.startsWith(template.substring(0, prefixEnd))) {
            simplified = simplified.substring(prefixEnd);
        }
        if ((suffixStart = simplified.indexOf(suffix = template.substring(prefixEnd + "---".length()))) != -1) {
            simplified = simplified.substring(0, suffixStart);
        }
        return simplified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NativeLibrary getInstance(String libraryName) {
        Map map = libraries;
        synchronized (map) {
            NativeLibrary library;
            WeakReference<NativeLibrary> ref = (WeakReference<NativeLibrary>)libraries.get(libraryName);
            NativeLibrary nativeLibrary = library = ref != null ? (NativeLibrary)ref.get() : null;
            if (library == null) {
                library = NativeLibrary.loadLibrary(libraryName);
                ref = new WeakReference<NativeLibrary>(library);
                libraries.put(library.getName(), ref);
                libraries.put(library.getFile().getAbsolutePath(), ref);
                libraries.put(library.getFile().getName(), ref);
            }
            return library;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addSearchPath(String libraryName, String path) {
        Map map = searchPaths;
        synchronized (map) {
            List<String> customPaths = (List<String>)searchPaths.get(libraryName);
            if (customPaths == null) {
                customPaths = Collections.synchronizedList(new LinkedList());
                searchPaths.put(libraryName, customPaths);
            }
            customPaths.add(path);
        }
    }

    public Function getFunction(String functionName) {
        return this.getFunction(functionName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(String functionName, int callingConvention) {
        Map map = this.functions;
        synchronized (map) {
            Function function = (Function)this.functions.get(functionName);
            if (function == null) {
                function = new Function(this, functionName, callingConvention);
                this.functions.put(functionName, function);
            }
            return function;
        }
    }

    long getFunctionAddress(String functionName) {
        long func = NativeLibrary.findSymbol(this.handle, functionName);
        if (func == 0L) {
            throw new UnsatisfiedLinkError("Cannot locate function '" + functionName + "'");
        }
        return func;
    }

    public String toString() {
        return "Native Library <" + this.libraryPath + "@" + this.handle + ">";
    }

    public String getName() {
        return this.libraryName;
    }

    public File getFile() {
        return new File(this.libraryPath);
    }

    protected void finalize() {
        if (this.handle != 0L) {
            NativeLibrary.close(this.handle);
            this.handle = 0L;
        }
    }

    private static List initPaths(String key) {
        String[] paths = System.getProperty(key, "").split(File.pathSeparator);
        return Arrays.asList(paths);
    }

    private static String findLibraryPath(String libName, List searchPath) {
        if (new File(libName).isAbsolute()) {
            return libName;
        }
        String name = NativeLibrary.mapLibraryName(libName);
        Iterator it = searchPath.iterator();
        while (it.hasNext()) {
            File file = new File(new File((String)it.next()), name);
            if (!file.exists()) continue;
            return file.getAbsolutePath();
        }
        return name;
    }

    private static String mapLibraryName(String libName) {
        if (Platform.isMac()) {
            if (libName.matches("lib.*\\.(dylib|jnilib)$")) {
                return libName;
            }
            String name = System.mapLibraryName(libName);
            if (name.endsWith(".jnilib")) {
                return name.substring(0, name.lastIndexOf(".jnilib")) + ".dylib";
            }
            return name;
        }
        if (Platform.isLinux() && libName.matches("lib.*\\.so\\.[0-9]+$")) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    private static String matchLibrary(final String libName, List searchPath) {
        FilenameFilter filter = new FilenameFilter(){
            Pattern p;
            {
                this.p = Pattern.compile("lib" + libName + "\\.so\\.[0-9]+$");
            }

            public boolean accept(File dir, String name) {
                return this.p.matcher(name).matches();
            }
        };
        LinkedList<File> matches = new LinkedList<File>();
        Iterator it = searchPath.iterator();
        while (it.hasNext()) {
            File[] files = new File((String)it.next()).listFiles(filter);
            if (files == null || files.length <= 0) continue;
            matches.addAll(Arrays.asList(files));
        }
        int version = 0;
        String bestMatch = null;
        Iterator it2 = matches.iterator();
        while (it2.hasNext()) {
            String path = ((File)it2.next()).getAbsolutePath();
            String num = path.substring(path.lastIndexOf(46) + 1);
            try {
                if (Integer.parseInt(num) < version) continue;
                bestMatch = path;
            }
            catch (NumberFormatException e) {}
        }
        return bestMatch;
    }

    private static native long open(String var0);

    private static native void close(long var0);

    private static native long findSymbol(long var0, String var2);

    static {
        if (Native.POINTER_SIZE == 0) {
            throw new Error("Native library not initialized");
        }
        librarySearchPath.addAll(NativeLibrary.initPaths("jna.library.path"));
        if (System.getProperty("jna.platform.library.path") == null && !Platform.isWindows()) {
            String platformPath = "";
            String sep = "";
            String archPath = "";
            if (Platform.isLinux() || Platform.isSolaris() || Platform.isFreeBSD()) {
                archPath = (Platform.isSolaris() ? "/" : "") + Pointer.SIZE * 8;
            }
            if (new File("/usr/lib" + archPath).exists()) {
                platformPath = platformPath + sep + "/usr/lib" + archPath;
                sep = File.pathSeparator;
            } else if (new File("/usr/lib").exists()) {
                platformPath = platformPath + sep + "/usr/lib";
                sep = File.pathSeparator;
            }
            if (new File("/lib" + archPath).exists()) {
                platformPath = platformPath + sep + "/lib" + archPath;
                sep = File.pathSeparator;
            } else if (new File("/lib").exists()) {
                platformPath = platformPath + sep + "/lib";
                sep = File.pathSeparator;
            }
            if (!"".equals(platformPath)) {
                System.setProperty("jna.platform.library.path", platformPath);
            }
        }
        librarySearchPath.addAll(NativeLibrary.initPaths("jna.platform.library.path"));
    }
}

