/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public abstract class CachingCallSite
extends CallSite {
    protected volatile CacheEntry cache = CacheEntry.NULL_CACHE;
    private int misses = 0;
    private static final int MAX_MISSES = 50;
    public static volatile int totalCallSites;
    public static volatile int failedCallSites;

    public CachingCallSite(String methodName, CallType callType) {
        super(methodName, callType);
        ++totalCallSites;
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject ... args2) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = this.pollAndGetClass(context, self);
        if (myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, args2);
        }
        return this.cacheAndCall(caller2, selfType, args2, context, self);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject[] args2, Block block) {
        try {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.typeOk(selfType)) {
                return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, args2, block);
            }
            return this.cacheAndCall(caller2, selfType, block, args2, context, self);
        }
        catch (JumpException.BreakJump bj) {
            return this.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw this.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject[] args2, Block block) {
        try {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.typeOk(selfType)) {
                IRubyObject iRubyObject = myCache.method.call(context, self, (RubyModule)selfType, this.methodName, args2, block);
                return iRubyObject;
            }
            IRubyObject iRubyObject = this.cacheAndCall(caller2, selfType, block, args2, context, self);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw this.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = this.pollAndGetClass(context, self);
        if (myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, selfType, this.methodName);
        }
        return this.cacheAndCall(caller2, selfType, context, self);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, Block block) {
        try {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.typeOk(selfType)) {
                return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, block);
            }
            return this.cacheAndCall(caller2, selfType, block, context, self);
        }
        catch (JumpException.BreakJump bj) {
            return this.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw this.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self, Block block) {
        try {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.typeOk(selfType)) {
                IRubyObject iRubyObject = myCache.method.call(context, self, (RubyModule)selfType, this.methodName, block);
                return iRubyObject;
            }
            IRubyObject iRubyObject = this.cacheAndCall(caller2, selfType, block, context, self);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw this.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = this.pollAndGetClass(context, self);
        if (myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1);
        }
        return this.cacheAndCall(caller2, selfType, context, self, arg1);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, Block block) {
        RubyClass selfType = this.pollAndGetClass(context, self);
        try {
            CacheEntry myCache = this.cache;
            if (myCache.typeOk(selfType)) {
                return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, block);
            }
            return this.cacheAndCall(caller2, selfType, block, context, self, arg1);
        }
        catch (JumpException.BreakJump bj) {
            return this.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw this.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, Block block) {
        try {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.typeOk(selfType)) {
                IRubyObject iRubyObject = myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, block);
                return iRubyObject;
            }
            IRubyObject iRubyObject = this.cacheAndCall(caller2, selfType, block, context, self, arg1);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw this.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = this.pollAndGetClass(context, self);
        if (myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2);
        }
        return this.cacheAndCall(caller2, selfType, context, self, arg1, arg2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.typeOk(selfType)) {
                return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
            }
            return this.cacheAndCall(caller2, selfType, block, context, self, arg1, arg2);
        }
        catch (JumpException.BreakJump bj) {
            return this.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw this.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.typeOk(selfType)) {
                IRubyObject iRubyObject = myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
                return iRubyObject;
            }
            IRubyObject iRubyObject = this.cacheAndCall(caller2, selfType, block, context, self, arg1, arg2);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw this.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = this.pollAndGetClass(context, self);
        if (myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
        }
        return this.cacheAndCall(caller2, selfType, context, self, arg1, arg2, arg3);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.typeOk(selfType)) {
                return myCache.method.call(context, self, selfType, this.methodName, arg1, arg2, arg3, block);
            }
            return this.cacheAndCall(caller2, selfType, block, context, self, arg1, arg2, arg3);
        }
        catch (JumpException.BreakJump bj) {
            return this.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw this.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.typeOk(selfType)) {
                IRubyObject iRubyObject = myCache.method.call(context, self, selfType, this.methodName, arg1, arg2, arg3, block);
                return iRubyObject;
            }
            IRubyObject iRubyObject = this.cacheAndCall(caller2, selfType, block, context, self, arg1, arg2, arg3);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw this.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, IRubyObject[] args2, ThreadContext context, IRubyObject self) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, args2, block);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, args2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, IRubyObject[] args2, ThreadContext context, IRubyObject self) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, args2);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, args2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2);
        }
        this.cache = entry;
        return method2.call(context, self, selfType, this.methodName);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, block);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, arg2);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, arg2, block);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, arg1, arg2);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, arg1, arg2, block);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, arg1, arg2, arg3);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, arg1, arg2, arg3, block);
        }
        this.cache = entry;
        return method2.call(context, self, selfType, this.methodName, arg1, arg2, arg3, block);
    }

    private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject[] args2) {
        return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, args2, this.callType, Block.NULL_BLOCK);
    }

    private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2) {
        return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, this.callType, Block.NULL_BLOCK);
    }

    private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, Block block) {
        return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, this.callType, block);
    }

    private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg2) {
        return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg2, this.callType, Block.NULL_BLOCK);
    }

    private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, args2, this.callType, block);
    }

    private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg2, Block block) {
        return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg2, this.callType, block);
    }

    private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg1, IRubyObject arg2) {
        return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg1, arg2, this.callType, Block.NULL_BLOCK);
    }

    private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg1, IRubyObject arg2, Block block) {
        return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg1, arg2, this.callType, block);
    }

    private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg1, arg2, arg3, this.callType, Block.NULL_BLOCK);
    }

    private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return RuntimeHelpers.callMethodMissing(context, self, method2, this.methodName, arg1, arg2, arg3, this.callType, block);
    }

    protected abstract boolean methodMissing(DynamicMethod var1, IRubyObject var2);

    private RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
        context.callThreadPoll();
        RubyClass selfType = self.getMetaClass();
        return selfType;
    }

    private IRubyObject handleBreakJump(ThreadContext context, JumpException.BreakJump bj) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    private RaiseException retryJumpError(ThreadContext context) {
        return context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.RETRY, context.getRuntime().getNil(), "retry outside of rescue not supported");
    }
}

