/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNoArgNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class Interpreted19Block
extends BlockBody {
    private final ArgsNode args;
    private final Node body;
    private final StaticScope scope;
    private final Arity arity;

    public static Block newInterpretedClosure(ThreadContext context, BlockBody body, IRubyObject self) {
        Frame frame = context.getCurrentFrame();
        Binding binding2 = new Binding(self, frame, frame.getVisibility(), context.getRubyClass(), context.getCurrentScope());
        return new Block(body, binding2);
    }

    public Interpreted19Block(LambdaNode lambda2) {
        super(-1);
        this.arity = lambda2.getArgs().getArity();
        this.args = lambda2.getArgs();
        this.body = lambda2.getBody() == null ? NilImplicitNode.NIL : lambda2.getBody();
        this.scope = lambda2.getScope();
    }

    public Interpreted19Block(IterNode iter) {
        super(-1);
        ArgsNode argsNode = (ArgsNode)iter.getVarNode();
        if (argsNode == null) {
            System.out.println("ITER HAS NO ARGS: " + iter);
        }
        this.arity = argsNode.getArity();
        this.args = argsNode;
        this.body = iter.getBodyNode() == null ? NilImplicitNode.NIL : iter.getBodyNode();
        this.scope = iter.getScope();
    }

    protected Frame pre(ThreadContext context, RubyModule klass, Binding binding2) {
        return context.preYieldSpecificBlock(binding2, this.scope, klass);
    }

    protected void post(ThreadContext context, Binding binding2, Visibility vis, Frame lastFrame) {
        binding2.getFrame().setVisibility(vis);
        context.postYield(binding2, lastFrame);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        IRubyObject value2 = args2.length == 1 ? args2[0] : context.getRuntime().newArrayNoCopy(args2);
        return this.yield(context, value2, null, null, true, binding2, type2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        IRubyObject value2 = args2.length == 1 ? args2[0] : context.getRuntime().newArrayNoCopy(args2);
        return this.yield(context, value2, null, null, true, binding2, type2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        IRubyObject self = this.prepareSelf(binding2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            this.setupBlockArgs(context, value2, self, Block.NULL_BLOCK, type2);
            IRubyObject iRubyObject = this.evalBlockBody(context, self);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, self, klass, aValue, binding2, type2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2, Block block) {
        if (klass == null) {
            self = this.prepareSelf(binding2);
        }
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, klass, binding2);
        try {
            this.setupBlockArgs(context, value2, self, block, type2);
            IRubyObject iRubyObject = this.evalBlockBody(context, self);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    /*
     * Loose catch block
     */
    private IRubyObject evalBlockBody(ThreadContext context, IRubyObject self) {
        while (true) {
            try {
                return this.body.interpret(context.getRuntime(), context, self, Block.NULL_BLOCK);
            }
            catch (JumpException.RedoJump rj) {
                context.pollThreadEvents();
                continue;
            }
            break;
        }
        catch (StackOverflowError sfe) {
            throw context.getRuntime().newSystemStackError("stack level too deep");
        }
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self = binding2.getSelf();
        binding2.getFrame().setSelf(self);
        return self;
    }

    private IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj, Block.Type type2) {
        return type2 == Block.Type.LAMBDA ? context.getRuntime().getNil() : (IRubyObject)nj.getValue();
    }

    private void setupBlockArgs(ThreadContext context, IRubyObject value2, IRubyObject self, Block block, Block.Type type2) {
        IRubyObject[] parameters = value2 instanceof RubyArray && this.args.getMaxArgumentsCount() != 1 ? ((RubyArray)value2).toJavaArray() : new IRubyObject[]{value2};
        if (!(this.args instanceof ArgsNoArgNode)) {
            Ruby runtime2 = context.getRuntime();
            this.args.prepare(context, runtime2, self, parameters, block);
        }
    }

    public Block cloneBlock(Binding binding2) {
        binding2 = new Binding(binding2.getSelf(), binding2.getFrame().duplicate(), binding2.getVisibility(), binding2.getKlass(), binding2.getDynamicScope());
        return new Block(this, binding2);
    }

    public ArgsNode getArgs() {
        return this.args;
    }

    public Node getBody() {
        return this.body;
    }

    public StaticScope getStaticScope() {
        return this.scope;
    }

    public Arity arity() {
        return this.arity;
    }
}

