/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Pointer;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractBuffer;
import org.jruby.ext.ffi.AbstractMemoryPointer;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jna.JNABasePointer;
import org.jruby.ext.ffi.jna.JNAMemory;
import org.jruby.ext.ffi.jna.JNAMemoryIO;
import org.jruby.ext.ffi.jna.JNAMemoryPointer;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"FFI::Buffer"}, parent="FFI::AbstractMemoryPointer")
public class JNABuffer
extends AbstractBuffer
implements JNAMemory {
    public static final String BUFFER_RUBY_CLASS = "Buffer";
    private static final boolean CLEAR_DEFAULT = true;

    public static RubyClass createBufferClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder(BUFFER_RUBY_CLASS, module.getClass("AbstractBuffer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(JNABuffer.class);
        result.defineAnnotatedConstants(JNABuffer.class);
        return result;
    }

    public JNABuffer(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass, JNAMemoryIO.wrap(Pointer.NULL), 0L, 0L);
    }

    private JNABuffer(Ruby runtime2, IRubyObject klass, JNABuffer ptr, long offset2) {
        this(runtime2, klass, ptr.io, ptr.offset + offset2, ptr.size == Long.MAX_VALUE ? Long.MAX_VALUE : ptr.size - offset2);
    }

    private JNABuffer(Ruby runtime2, IRubyObject klass, MemoryIO io2, long offset2, long size2) {
        super(runtime2, (RubyClass)klass, io2, offset2, size2);
    }

    private static JNABuffer allocate(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, boolean clear2) {
        JNAMemoryIO io2;
        int size2 = Util.int32Value(sizeArg);
        JNAMemoryIO jNAMemoryIO = io2 = size2 > 0 ? JNAMemoryIO.allocateDirect(size2) : JNAMemoryIO.NULL;
        if (clear2 && size2 > 0) {
            io2.setMemory(0L, size2, (byte)0);
        }
        return new JNABuffer(context.getRuntime(), recv2, (MemoryIO)io2, 0L, (long)size2);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout", "__alloc_heap_inout", "__alloc_direct_inout"}, meta=true)
    public static JNABuffer allocateDirect(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg) {
        return JNABuffer.allocate(context, recv2, sizeArg, true);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout", "__alloc_heap_inout", "__alloc_direct_inout"}, meta=true)
    public static JNABuffer allocateDirect(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject clearArg) {
        return JNABuffer.allocate(context, recv2, sizeArg, clearArg.isTrue());
    }

    @JRubyMethod(name={"alloc_in", "__alloc_in", "__alloc_heap_in", "__alloc_direct_in"}, meta=true)
    public static JNABuffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        if (arg2 instanceof RubyString) {
            RubyString s = (RubyString)arg2;
            int size2 = Util.int32Value(s.length());
            ByteList bl = s.getByteList();
            JNAMemoryIO io2 = JNAMemoryIO.allocateDirect(size2);
            io2.put(0L, bl.unsafeBytes(), bl.begin(), bl.length());
            io2.putByte(bl.length(), (byte)0);
            return new JNABuffer(context.getRuntime(), recv2, (MemoryIO)io2, 0L, (long)size2);
        }
        return JNABuffer.allocate(context, recv2, arg2, true);
    }

    @JRubyMethod(name={"alloc_in", "__alloc_in", "__alloc_heap_in", "__alloc_direct_in"}, meta=true)
    public static JNABuffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject clearArg) {
        return JNABuffer.allocate(context, recv2, sizeArg, clearArg.isTrue());
    }

    @JRubyMethod(name={"alloc_out", "__alloc_out", "__alloc_heap_out", "__alloc_direct_out"}, meta=true)
    public static JNABuffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg) {
        return JNABuffer.allocate(context, recv2, sizeArg, true);
    }

    @JRubyMethod(name={"alloc_out", "__alloc_out", "__alloc_heap_out", "__alloc_direct_out"}, meta=true)
    public static JNABuffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject clearArg) {
        return JNABuffer.allocate(context, recv2, sizeArg, clearArg.isTrue());
    }

    public Object getNativeMemory() {
        return ((JNAMemoryIO)this.getMemoryIO()).slice(this.offset).getMemory();
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject value2) {
        return new JNABuffer(context.getRuntime(), (IRubyObject)FFIProvider.getModule(context.getRuntime()).fastGetClass(BUFFER_RUBY_CLASS), this, RubyNumeric.fix2long(value2));
    }

    @JRubyMethod(name={"put_pointer"}, required=2)
    public IRubyObject put_pointer(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        Pointer ptr;
        if (value2 instanceof JNAMemoryPointer) {
            ptr = ((JNAMemoryPointer)value2).getAddress();
        } else if (value2.isNil()) {
            ptr = Pointer.NULL;
        } else {
            throw context.getRuntime().newArgumentError("Cannot convert argument to pointer");
        }
        ((JNAMemoryIO)this.getMemoryIO()).putPointer(this.getOffset(offset2), ptr);
        return this;
    }

    protected AbstractMemoryPointer getPointer(Ruby runtime2, long offset2) {
        return new JNABasePointer(runtime2, this.getMemoryIO().getMemoryIO(this.offset + offset2), 0L, Long.MAX_VALUE);
    }
}

