/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.Label;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubySymbol;
import org.jruby.ast.NodeType;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;

public class InheritedCacheCompiler
implements CacheCompiler {
    protected StandardASMCompiler scriptCompiler;
    int callSiteCount = 0;
    List<String> callSiteList = new ArrayList<String>();
    List<CallType> callTypeList = new ArrayList<CallType>();
    Map<String, Integer> byteListIndices = new HashMap<String, Integer>();
    Map<String, ByteList> byteListValues = new HashMap<String, ByteList>();
    Map<BigInteger, String> bigIntegers = new HashMap<BigInteger, String>();
    int inheritedSymbolCount = 0;
    int inheritedFixnumCount = 0;
    int inheritedConstantCount = 0;
    int inheritedByteListCount = 0;

    public InheritedCacheCompiler(StandardASMCompiler scriptCompiler) {
        this.scriptCompiler = scriptCompiler;
    }

    public void cacheCallSite(BaseBodyCompiler method2, String name2, CallType callType) {
        method2.loadThis();
        method2.method.pushInt(this.callSiteCount);
        method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getCallSite", CodegenUtils.sig(CallSite.class, Integer.TYPE));
        this.callSiteList.add(name2);
        this.callTypeList.add(callType);
        ++this.callSiteCount;
    }

    public void cacheSymbol(BaseBodyCompiler method2, String symbol) {
        method2.loadThis();
        method2.loadRuntime();
        method2.method.pushInt(this.inheritedSymbolCount);
        method2.method.ldc(symbol);
        method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getSymbol", CodegenUtils.sig(RubySymbol.class, Ruby.class, Integer.TYPE, String.class));
        ++this.inheritedSymbolCount;
    }

    public void cacheFixnum(BaseBodyCompiler method2, long value2) {
        block12: {
            block11: {
                if (value2 > 5L || value2 < -1L) break block11;
                method2.loadRuntime();
                switch ((int)value2) {
                    case -1: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "minus_one", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block12;
                    }
                    case 0: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "zero", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block12;
                    }
                    case 1: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "one", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block12;
                    }
                    case 2: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "two", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block12;
                    }
                    case 3: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "three", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block12;
                    }
                    case 4: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "four", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block12;
                    }
                    case 5: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "five", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block12;
                    }
                    default: {
                        throw new RuntimeException("wtf?");
                    }
                }
            }
            method2.loadThis();
            method2.loadRuntime();
            method2.method.pushInt(this.inheritedFixnumCount);
            if (value2 <= Integer.MAX_VALUE && value2 >= Integer.MIN_VALUE) {
                method2.method.pushInt((int)value2);
                method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getFixnum", CodegenUtils.sig(RubyFixnum.class, Ruby.class, Integer.TYPE, Integer.TYPE));
            } else {
                method2.method.ldc(value2);
                method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getFixnum", CodegenUtils.sig(RubyFixnum.class, Ruby.class, Integer.TYPE, Long.TYPE));
            }
            ++this.inheritedFixnumCount;
        }
    }

    public void finish() {
        SkinnyMethodAdapter initMethod = this.scriptCompiler.getInitMethod();
        initMethod.aload(0);
        int size2 = this.callSiteList.size();
        if (size2 != 0) {
            initMethod.aload(0);
            initMethod.pushInt(size2);
            initMethod.anewarray(CodegenUtils.p(CallSite.class));
            for (int i = size2 - 1; i >= 0; --i) {
                String name2 = this.callSiteList.get(i);
                CallType callType = this.callTypeList.get(i);
                initMethod.pushInt(i);
                initMethod.ldc(name2);
                if (callType.equals(CallType.NORMAL)) {
                    initMethod.invokestatic(this.scriptCompiler.getClassname(), "setCallSite", CodegenUtils.sig(CallSite[].class, CodegenUtils.params(CallSite[].class, Integer.TYPE, String.class)));
                    continue;
                }
                if (callType.equals(CallType.FUNCTIONAL)) {
                    initMethod.invokestatic(this.scriptCompiler.getClassname(), "setFunctionalCallSite", CodegenUtils.sig(CallSite[].class, CodegenUtils.params(CallSite[].class, Integer.TYPE, String.class)));
                    continue;
                }
                if (!callType.equals(CallType.VARIABLE)) continue;
                initMethod.invokestatic(this.scriptCompiler.getClassname(), "setVariableCallSite", CodegenUtils.sig(CallSite[].class, CodegenUtils.params(CallSite[].class, Integer.TYPE, String.class)));
            }
            initMethod.putfield(this.scriptCompiler.getClassname(), "callSites", CodegenUtils.ci(CallSite[].class));
        }
        if ((size2 = this.inheritedSymbolCount) != 0) {
            initMethod.aload(0);
            initMethod.pushInt(size2);
            initMethod.invokevirtual(this.scriptCompiler.getClassname(), "initSymbols", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Integer.TYPE)));
        }
        if ((size2 = this.inheritedFixnumCount) != 0) {
            initMethod.aload(0);
            initMethod.pushInt(size2);
            initMethod.invokevirtual(this.scriptCompiler.getClassname(), "initFixnums", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Integer.TYPE)));
        }
        if ((size2 = this.inheritedConstantCount) != 0) {
            initMethod.aload(0);
            initMethod.pushInt(size2);
            initMethod.invokevirtual(this.scriptCompiler.getClassname(), "initConstants", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Integer.TYPE)));
        }
        size2 = this.inheritedByteListCount;
        SkinnyMethodAdapter getter = new SkinnyMethodAdapter(this.scriptCompiler.getClassVisitor().visitMethod(26, "getByteList", CodegenUtils.sig(ByteList.class, Integer.TYPE), null, null));
        getter.start();
        getter.getstatic(this.scriptCompiler.getClassname(), "byteLists", CodegenUtils.ci(ByteList[].class));
        getter.iload(0);
        getter.aaload();
        getter.areturn();
        getter.end();
        SkinnyMethodAdapter clinitMethod = this.scriptCompiler.getClassInitMethod();
        this.scriptCompiler.getClassVisitor().visitField(26, "byteLists", CodegenUtils.ci(ByteList[].class), null, null);
        clinitMethod.ldc(size2);
        clinitMethod.anewarray(CodegenUtils.p(ByteList.class));
        clinitMethod.putstatic(this.scriptCompiler.getClassname(), "byteLists", CodegenUtils.ci(ByteList[].class));
        for (Map.Entry<String, Integer> entry : this.byteListIndices.entrySet()) {
            int index2 = entry.getValue();
            ByteList byteList = this.byteListValues.get(entry.getKey());
            clinitMethod.getstatic(this.scriptCompiler.getClassname(), "byteLists", CodegenUtils.ci(ByteList[].class));
            clinitMethod.ldc(index2);
            clinitMethod.ldc(byteList.toString());
            clinitMethod.invokestatic(CodegenUtils.p(ByteList.class), "create", CodegenUtils.sig(ByteList.class, CharSequence.class));
            clinitMethod.arraystore();
        }
    }

    public void cacheConstant(BaseBodyCompiler method2, String constantName) {
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.ldc(constantName);
        method2.method.pushInt(this.inheritedConstantCount);
        method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstant", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, Integer.TYPE));
        ++this.inheritedConstantCount;
    }

    public void cacheByteList(BaseBodyCompiler method2, ByteList contents) {
        String asString = contents.toString();
        Integer index2 = this.byteListIndices.get(asString);
        if (index2 == null) {
            index2 = new Integer(this.inheritedByteListCount++);
            this.byteListIndices.put(asString, index2);
            this.byteListValues.put(asString, contents);
        }
        method2.method.ldc((int)index2);
        method2.method.invokestatic(this.scriptCompiler.getClassname(), "getByteList", CodegenUtils.sig(ByteList.class, Integer.TYPE));
    }

    public void cacheBigInteger(BaseBodyCompiler method2, BigInteger bigint) {
        String fieldName = this.bigIntegers.get(bigint);
        if (fieldName == null) {
            SkinnyMethodAdapter clinitMethod = this.scriptCompiler.getClassInitMethod();
            fieldName = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(BigInteger.class), "bigInt");
            this.bigIntegers.put(bigint, fieldName);
            clinitMethod.newobj(CodegenUtils.p(BigInteger.class));
            clinitMethod.dup();
            clinitMethod.ldc(bigint.toString());
            clinitMethod.invokespecial(CodegenUtils.p(BigInteger.class), "<init>", CodegenUtils.sig(Void.TYPE, String.class));
            clinitMethod.putstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(BigInteger.class));
        }
        method2.method.getstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(BigInteger.class));
    }

    public void cacheClosure(BaseBodyCompiler method2, String closureMethod, int arity2, StaticScope scope, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        String closureFieldName = this.scriptCompiler.getNewConstant(CodegenUtils.ci(BlockBody.class), "closure");
        String closureMethodName = "getClosure_" + closureFieldName;
        ClassVisitor cv = this.scriptCompiler.getClassVisitor();
        SkinnyMethodAdapter closureGetter = new SkinnyMethodAdapter(cv.visitMethod(4098, closureMethodName, CodegenUtils.sig(BlockBody.class, ThreadContext.class), null, null));
        closureGetter.aload(0);
        closureGetter.getfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(BlockBody.class));
        closureGetter.dup();
        Label alreadyCreated = new Label();
        closureGetter.ifnonnull(alreadyCreated);
        closureGetter.pop();
        closureGetter.aload(0);
        closureGetter.aload(1);
        closureGetter.aload(0);
        closureGetter.ldc(closureMethod);
        closureGetter.pushInt(arity2);
        StandardASMCompiler.buildStaticScopeNames(closureGetter, scope);
        closureGetter.ldc(hasMultipleArgsHead);
        closureGetter.pushInt(BlockBody.asArgumentType(argsNodeId));
        closureGetter.ldc(!inspector.hasClosure() && !inspector.hasScopeAwareMethods());
        closureGetter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "createCompiledBlockBody", CodegenUtils.sig(BlockBody.class, ThreadContext.class, Object.class, String.class, Integer.TYPE, String[].class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE));
        closureGetter.putfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(BlockBody.class));
        closureGetter.aload(0);
        closureGetter.getfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(BlockBody.class));
        closureGetter.label(alreadyCreated);
        closureGetter.areturn();
        closureGetter.end();
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.invokevirtual(this.scriptCompiler.getClassname(), closureMethodName, CodegenUtils.sig(BlockBody.class, ThreadContext.class));
    }

    public void cacheClosureOld(BaseBodyCompiler method2, String closureMethod) {
        String closureFieldName = this.scriptCompiler.getNewConstant(CodegenUtils.ci(CompiledBlockCallback.class), "closure");
        String closureMethodName = "getClosure_" + closureFieldName;
        ClassVisitor cv = this.scriptCompiler.getClassVisitor();
        SkinnyMethodAdapter closureGetter = new SkinnyMethodAdapter(cv.visitMethod(4098, closureMethodName, CodegenUtils.sig(CompiledBlockCallback.class, Ruby.class), null, null));
        closureGetter.aload(0);
        closureGetter.getfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        closureGetter.dup();
        Label alreadyCreated = new Label();
        closureGetter.ifnonnull(alreadyCreated);
        closureGetter.pop();
        closureGetter.aload(0);
        closureGetter.aload(1);
        closureGetter.aload(0);
        closureGetter.ldc(closureMethod);
        closureGetter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "createBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, Ruby.class, Object.class, String.class));
        closureGetter.putfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        closureGetter.aload(0);
        closureGetter.getfield(this.scriptCompiler.getClassname(), closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        closureGetter.label(alreadyCreated);
        closureGetter.areturn();
        closureGetter.end();
        method2.loadThis();
        method2.loadRuntime();
        method2.method.invokevirtual(this.scriptCompiler.getClassname(), closureMethodName, CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(Ruby.class)));
    }
}

