/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node valueNode;
    public final CallSite variableCallAdapter;
    public final CallSite operatorCallAdapter;
    public final CallSite variableAsgnCallAdapter;

    public OpAsgnNode(ISourcePosition position, Node receiverNode, Node valueNode, String variableName, String operatorName) {
        super(position, NodeType.OPASGNNODE);
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
        this.variableCallAdapter = MethodIndex.getCallSite(variableName);
        this.operatorCallAdapter = MethodIndex.getCallSite(operatorName);
        this.variableAsgnCallAdapter = MethodIndex.getCallSite((variableName + "=").intern());
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitOpAsgnNode(this);
    }

    public String getOperatorName() {
        return this.operatorCallAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    public String getVariableName() {
        return this.variableCallAdapter.methodName;
    }

    public String getVariableNameAsgn() {
        return this.variableAsgnCallAdapter.methodName;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver2 = this.receiverNode.interpret(runtime2, context, self, aBlock);
        IRubyObject value2 = this.variableCallAdapter.call(context, self, receiver2);
        if (this.getOperatorName() == "||") {
            if (value2.isTrue()) {
                return ASTInterpreter.pollAndReturn(context, value2);
            }
            value2 = this.valueNode.interpret(runtime2, context, self, aBlock);
        } else if (this.getOperatorName() == "&&") {
            if (!value2.isTrue()) {
                return ASTInterpreter.pollAndReturn(context, value2);
            }
            value2 = this.valueNode.interpret(runtime2, context, self, aBlock);
        } else {
            value2 = this.operatorCallAdapter.call(context, self, value2, this.valueNode.interpret(runtime2, context, self, aBlock));
        }
        this.variableAsgnCallAdapter.call(context, self, receiver2, value2);
        return ASTInterpreter.pollAndReturn(context, value2);
    }
}

