/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleAsgn19Node
extends AssignableNode {
    private final ListNode pre;
    private final Node rest;
    private final ListNode post;
    private final Arity arity;

    public MultipleAsgn19Node(ISourcePosition position, ListNode pre, Node rest2, ListNode post) {
        super(position, NodeType.MULTIPLEASGN19NODE);
        this.pre = pre;
        this.rest = rest2;
        this.post = post;
        this.arity = this.getRest() != null ? Arity.required(this.getPreCount() + this.getPostCount()) : Arity.fixed(this.getPreCount() + this.getPostCount());
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public Node getRest() {
        return this.rest;
    }

    public ListNode getPre() {
        return this.pre;
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public int getPostCount() {
        return this.post == null ? 0 : this.post.size();
    }

    public ListNode getPost() {
        return this.post;
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.pre, this.rest, this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject value2 = this.getValueNode().interpret(runtime2, context, self, aBlock);
        if (!(value2 instanceof RubyArray)) {
            value2 = RubyArray.newArray(runtime2, value2);
        }
        return AssignmentVisitor.multiAssign(runtime2, context, self, this, (RubyArray)value2);
    }

    @Override
    public IRubyObject assign(Ruby runtime2, ThreadContext context, IRubyObject self, IRubyObject value2, Block block, boolean checkArity) {
        if (!(value2 instanceof RubyArray)) {
            value2 = ArgsUtil.convertToRubyArray(runtime2, value2, this.pre != null);
        }
        return null;
    }
}

