/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.MiniJava;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.Pack;
import org.jruby.util.Sprintf;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.string.JavaCrypt;

@JRubyClass(name={"String"}, include={"Enumerable", "Comparable"})
public class RubyString
extends RubyObject
implements EncodingCapable {
    private static final ASCIIEncoding ASCII = ASCIIEncoding.INSTANCE;
    private static final int SHARE_LEVEL_NONE = 0;
    private static final int SHARE_LEVEL_BUFFER = 1;
    private static final int SHARE_LEVEL_BYTELIST = 2;
    private volatile int shareLevel = 0;
    private ByteList value;
    private static ObjectAllocator STRING_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return RubyString.newEmptyString(runtime2, klass);
        }
    };
    private static final ByteList[] EMPTY_BYTELISTS = new ByteList[4];
    private static final ByteList SPACE_BYTELIST = new ByteList(ByteList.plain(" "));
    private static final int TRANS_SIZE = 256;

    public static RubyClass createStringClass(Ruby runtime2) {
        RubyClass stringClass = runtime2.defineClass("String", runtime2.getObject(), STRING_ALLOCATOR);
        runtime2.setString(stringClass);
        stringClass.index = 4;
        stringClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyString;
            }
        };
        stringClass.includeModule(runtime2.getComparable());
        stringClass.includeModule(runtime2.getEnumerable());
        stringClass.defineAnnotatedMethods(RubyString.class);
        return stringClass;
    }

    public Encoding getEncoding() {
        return this.value.encoding;
    }

    public void associateEncoding(Encoding enc) {
        if (this.value.encoding != enc) {
            if (!this.isCodeRangeAsciiOnly() || !enc.isAsciiCompatible()) {
                this.clearCodeRange();
            }
            this.value.encoding = enc;
        }
    }

    public final void setEncodingAndCodeRange(Encoding enc, int cr) {
        this.value.encoding = enc;
        this.setCodeRange(cr);
    }

    public final Encoding toEncoding(Ruby runtime2) {
        if (!this.value.encoding.isAsciiCompatible()) {
            throw runtime2.newArgumentError("invalid name encoding (non ASCII)");
        }
        EncodingDB.Entry entry = runtime2.getEncodingService().findEncodingOrAliasEntry(this.value);
        if (entry == null) {
            throw runtime2.newArgumentError("unknown encoding name - " + this.value);
        }
        return entry.getEncoding();
    }

    public final int getCodeRange() {
        return this.flags & 0x30;
    }

    public final void setCodeRange(int codeRange) {
        this.flags |= codeRange & 0x30;
    }

    public final void clearCodeRange() {
        this.flags &= 0xFFFFFFCF;
    }

    public final boolean isCodeRangeAsciiOnly() {
        return this.getCodeRange() == 16;
    }

    public final boolean isCodeRangeValid() {
        return (this.flags & 0x20) != 0;
    }

    public final boolean isCodeRangeBroken() {
        return (this.flags & 0x30) != 0;
    }

    static int codeRangeAnd(int cr1, int cr2) {
        if (cr1 == 16) {
            return cr2;
        }
        if (cr1 == 32) {
            return cr2 == 16 ? 32 : cr2;
        }
        return 0;
    }

    private void copyCodeRangeForSubstr(RubyString from) {
        Encoding enc = this.value.encoding = from.value.encoding;
        int fromCr = from.getCodeRange();
        if (fromCr == 16) {
            this.setCodeRange(fromCr);
        } else if (fromCr == 32) {
            if (!enc.isAsciiCompatible() || StringSupport.searchNonAscii(this.value) != -1) {
                this.setCodeRange(32);
            } else {
                this.setCodeRange(16);
            }
        } else if (this.value.realSize == 0) {
            this.setCodeRange(!enc.isAsciiCompatible() ? 32 : 16);
        }
    }

    private void copyCodeRange(RubyString from) {
        this.value.encoding = from.value.encoding;
        this.setCodeRange(from.getCodeRange());
    }

    final int scanForCodeRange() {
        int cr = this.getCodeRange();
        if (cr == 0) {
            cr = StringSupport.codeRangeScan(this.value.encoding, this.value);
            this.setCodeRange(cr);
        }
        return cr;
    }

    private final boolean singleByteOptimizable() {
        return this.getCodeRange() == 16 || this.value.encoding.isSingleByte();
    }

    private Encoding isCompatibleWith(RubyString other) {
        Encoding enc1 = this.value.encoding;
        Encoding enc2 = other.value.encoding;
        if (enc1 == enc2) {
            return enc1;
        }
        if (other.getByteList().realSize == 0) {
            return enc1;
        }
        if (this.getByteList().realSize == 0) {
            return enc2;
        }
        if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
            return null;
        }
        return RubyEncoding.areCompatible(enc1, this.scanForCodeRange(), enc2, other.scanForCodeRange());
    }

    final Encoding checkEncoding(RubyString other) {
        Encoding enc = this.isCompatibleWith(other);
        if (enc == null) {
            throw this.getRuntime().newArgumentError("incompatible character encodings: " + this.value.encoding + " and " + other.value.encoding);
        }
        return enc;
    }

    private boolean isComparableWith(RubyString other) {
        ByteList otherValue = other.value;
        if (this.value.realSize == 0 || otherValue.realSize == 0 || this.value.encoding == otherValue.encoding) {
            return true;
        }
        int cr1 = this.scanForCodeRange();
        int cr2 = other.scanForCodeRange();
        if (cr1 == 16 && (cr2 == 16 || otherValue.encoding.isAsciiCompatible())) {
            return true;
        }
        return cr2 == 16 && this.value.encoding.isAsciiCompatible();
    }

    private int strLength(Encoding enc) {
        if (this.singleByteOptimizable()) {
            return this.value.realSize;
        }
        this.value.encoding = enc;
        return this.strLength(this.value);
    }

    private int strLength() {
        if (this.singleByteOptimizable()) {
            return this.value.realSize;
        }
        return this.strLength(this.value);
    }

    private int strLength(ByteList bytes) {
        long lencr = StringSupport.strLengthWithCodeRange(this.value);
        int cr = StringSupport.unpackArg(lencr);
        if (cr != 0) {
            this.setCodeRange(cr);
        }
        return StringSupport.unpackResult(lencr);
    }

    public final boolean eql(IRubyObject other) {
        if (this.otherIsString(other)) {
            return this.eqlString(other);
        }
        return super.eql(other);
    }

    private final boolean otherIsString(IRubyObject other) {
        return other.getMetaClass() == this.getRuntime().getString();
    }

    private final boolean eqlString(IRubyObject other) {
        return this.value.equal(((RubyString)other).value);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, CharSequence value2) {
        super(runtime2, rubyClass);
        assert (value2 != null);
        this.value = new ByteList(ByteList.plain(value2), false);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, byte[] value2) {
        super(runtime2, rubyClass);
        assert (value2 != null);
        this.value = new ByteList(value2);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2) {
        super(runtime2, rubyClass);
        assert (value2 != null);
        this.value = value2;
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, boolean objectSpace) {
        super(runtime2, rubyClass, objectSpace);
        assert (value2 != null);
        this.value = value2;
    }

    protected RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, Encoding enc, int cr) {
        this(runtime2, rubyClass, value2);
        value2.encoding = enc;
        this.flags |= cr;
    }

    protected RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, Encoding enc) {
        this(runtime2, rubyClass, value2);
        value2.encoding = enc;
    }

    @Deprecated
    public RubyString newString(CharSequence s) {
        return new RubyString(this.getRuntime(), this.getType(), s);
    }

    @Deprecated
    public RubyString newString(ByteList s) {
        return new RubyString(this.getRuntime(), this.getMetaClass(), s);
    }

    @Deprecated
    public static RubyString newString(Ruby runtime2, RubyClass clazz, CharSequence str) {
        return new RubyString(runtime2, clazz, str);
    }

    public static RubyString newStringLight(Ruby runtime2, ByteList bytes) {
        return new RubyString(runtime2, runtime2.getString(), bytes, false);
    }

    public static RubyString newString(Ruby runtime2, CharSequence str) {
        return new RubyString(runtime2, runtime2.getString(), str);
    }

    public static RubyString newString(Ruby runtime2, byte[] bytes) {
        return new RubyString(runtime2, runtime2.getString(), bytes);
    }

    public static RubyString newString(Ruby runtime2, byte[] bytes, int start2, int length2) {
        byte[] copy = new byte[length2];
        System.arraycopy(bytes, start2, copy, 0, length2);
        return new RubyString(runtime2, runtime2.getString(), new ByteList(copy, false));
    }

    public static RubyString newString(Ruby runtime2, ByteList bytes) {
        return new RubyString(runtime2, runtime2.getString(), bytes);
    }

    public static RubyString newUnicodeString(Ruby runtime2, String str) {
        try {
            return new RubyString(runtime2, runtime2.getString(), new ByteList(str.getBytes("UTF8"), false));
        }
        catch (UnsupportedEncodingException uee) {
            return new RubyString(runtime2, runtime2.getString(), str);
        }
    }

    public static RubyString newStringShared(Ruby runtime2, RubyString orig) {
        orig.shareLevel = 2;
        RubyString str = new RubyString(runtime2, runtime2.getString(), orig.value);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime2, ByteList bytes) {
        return RubyString.newStringShared(runtime2, runtime2.getString(), bytes);
    }

    public static RubyString newStringShared(Ruby runtime2, RubyClass clazz, ByteList bytes) {
        RubyString str = new RubyString(runtime2, clazz, bytes);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime2, byte[] bytes) {
        return RubyString.newStringShared(runtime2, new ByteList(bytes, false));
    }

    public static RubyString newStringShared(Ruby runtime2, byte[] bytes, int start2, int length2) {
        return RubyString.newStringShared(runtime2, new ByteList(bytes, start2, length2, false));
    }

    public static RubyString newEmptyString(Ruby runtime2) {
        return RubyString.newEmptyString(runtime2, runtime2.getString());
    }

    public static RubyString newEmptyString(Ruby runtime2, RubyClass metaClass) {
        RubyString empty = new RubyString(runtime2, metaClass, ByteList.EMPTY_BYTELIST);
        empty.shareLevel = 2;
        return empty;
    }

    public static RubyString newStringNoCopy(Ruby runtime2, ByteList bytes) {
        return RubyString.newStringNoCopy(runtime2, runtime2.getString(), bytes);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, RubyClass clazz, ByteList bytes) {
        return new RubyString(runtime2, clazz, bytes);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, byte[] bytes, int start2, int length2) {
        return RubyString.newStringNoCopy(runtime2, new ByteList(bytes, start2, length2, false));
    }

    public static RubyString newStringNoCopy(Ruby runtime2, byte[] bytes) {
        return RubyString.newStringNoCopy(runtime2, new ByteList(bytes, false));
    }

    static ByteList getEmptyByteList(Encoding enc) {
        ByteList bytes;
        int index2 = enc.getIndex();
        if (index2 < EMPTY_BYTELISTS.length && (bytes = EMPTY_BYTELISTS[index2]) != null) {
            return bytes;
        }
        return RubyString.prepareEmptyByteList(enc);
    }

    private static ByteList prepareEmptyByteList(Encoding enc) {
        int index2 = enc.getIndex();
        if (index2 >= EMPTY_BYTELISTS.length) {
            ByteList[] tmp = new ByteList[index2 + 4];
            System.arraycopy(EMPTY_BYTELISTS, 0, tmp, 0, EMPTY_BYTELISTS.length);
        }
        RubyString.EMPTY_BYTELISTS[index2] = new ByteList(ByteList.NULL_ARRAY, enc);
        return RubyString.EMPTY_BYTELISTS[index2];
    }

    public static RubyString newEmptyString(Ruby runtime2, RubyClass metaClass, Encoding enc) {
        RubyString empty = new RubyString(runtime2, metaClass, RubyString.getEmptyByteList(enc));
        empty.shareLevel = 2;
        return empty;
    }

    public static RubyString newEmptyString(Ruby runtime2, Encoding enc) {
        return RubyString.newEmptyString(runtime2, runtime2.getString(), enc);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, RubyClass clazz, ByteList bytes, Encoding enc, int cr) {
        return new RubyString(runtime2, clazz, bytes, enc, cr);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, ByteList bytes, Encoding enc, int cr) {
        return RubyString.newStringNoCopy(runtime2, runtime2.getString(), bytes, enc, cr);
    }

    public static RubyString newUsAsciiStringNoCopy(Ruby runtime2, ByteList bytes) {
        return RubyString.newStringNoCopy(runtime2, bytes, USASCIIEncoding.INSTANCE, 16);
    }

    public static RubyString newUsAsciiStringShared(Ruby runtime2, ByteList bytes) {
        RubyString str = RubyString.newStringNoCopy(runtime2, bytes, USASCIIEncoding.INSTANCE, 16);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newUsAsciiStringShared(Ruby runtime2, byte[] bytes, int start2, int length2) {
        byte[] copy = new byte[length2];
        System.arraycopy(bytes, start2, copy, 0, length2);
        return RubyString.newUsAsciiStringShared(runtime2, new ByteList(copy, false));
    }

    public int getNativeTypeIndex() {
        return 4;
    }

    public Class getJavaClass() {
        return String.class;
    }

    public RubyString convertToString() {
        return this;
    }

    public String toString() {
        return this.value.toString();
    }

    @Deprecated
    public final RubyString strDup() {
        return this.strDup(this.getRuntime(), this.getMetaClass());
    }

    public final RubyString strDup(Ruby runtime2) {
        return this.strDup(runtime2, this.getMetaClass());
    }

    @Deprecated
    final RubyString strDup(RubyClass clazz) {
        return this.strDup(this.getRuntime(), this.getMetaClass());
    }

    final RubyString strDup(Ruby runtime2, RubyClass clazz) {
        this.shareLevel = 2;
        RubyString dup2 = new RubyString(runtime2, clazz, this.value);
        dup2.shareLevel = 2;
        dup2.infectBy(this);
        return dup2;
    }

    public final RubyString makeShared(Ruby runtime2, int index2, int len) {
        if (len == 0) {
            RubyString s = RubyString.newEmptyString(runtime2, this.getMetaClass());
            s.infectBy(this);
            return s;
        }
        if (this.shareLevel == 0) {
            this.shareLevel = 1;
        }
        RubyString shared = new RubyString(runtime2, this.getMetaClass(), this.value.makeShared(index2, len));
        shared.shareLevel = 1;
        shared.infectBy(this);
        return shared;
    }

    final void modifyCheck() {
        if ((this.flags & 4) != 0) {
            throw this.getRuntime().newFrozenError("string");
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify string");
        }
    }

    private final void modifyCheck(byte[] b, int len) {
        if (this.value.bytes != b || this.value.realSize != len) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private final void frozenCheck() {
        if (this.isFrozen()) {
            throw this.getRuntime().newRuntimeError("string frozen");
        }
    }

    public final void modify() {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup();
            } else {
                this.value.unshare();
            }
            this.shareLevel = 0;
        }
        this.value.invalidate();
    }

    public final void modify19() {
        this.modify();
        this.clearCodeRange();
    }

    public final void modify(int length2) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup(length2);
            } else {
                this.value.unshare(length2);
            }
            this.shareLevel = 0;
        } else {
            this.value.ensure(length2);
        }
        this.value.invalidate();
    }

    public final void modify19(int length2) {
        this.modify(length2);
        this.clearCodeRange();
    }

    private final void view(ByteList bytes) {
        this.modifyCheck();
        this.value = bytes;
        this.shareLevel = 0;
    }

    private final void view(byte[] bytes) {
        this.modifyCheck();
        this.value.replace(bytes);
        this.shareLevel = 0;
        this.value.invalidate();
    }

    private final void view(int index2, int len) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.makeShared(index2, len);
                this.shareLevel = 1;
            } else {
                this.value.view(index2, len);
            }
        } else {
            this.value.view(index2, len);
            this.shareLevel = 1;
        }
        this.value.invalidate();
    }

    public static String bytesToString(byte[] bytes, int beg, int len) {
        return new String(ByteList.plain(bytes, beg, len));
    }

    public static String byteListToString(ByteList bytes) {
        return RubyString.bytesToString(bytes.unsafeBytes(), bytes.begin(), bytes.length());
    }

    public static String bytesToString(byte[] bytes) {
        return RubyString.bytesToString(bytes, 0, bytes.length);
    }

    public static byte[] stringToBytes(String string2) {
        return ByteList.plain(string2);
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isUpper(int c) {
        return c >= 65 && c <= 90;
    }

    public static boolean isLower(int c) {
        return c >= 97 && c <= 122;
    }

    public static boolean isLetter(int c) {
        return RubyString.isUpper(c) || RubyString.isLower(c);
    }

    public static boolean isAlnum(int c) {
        return RubyString.isUpper(c) || RubyString.isLower(c) || RubyString.isDigit(c);
    }

    public static boolean isPrint(int c) {
        return c >= 32 && c <= 126;
    }

    public RubyString asString() {
        return this;
    }

    public IRubyObject checkStringType() {
        return this;
    }

    @JRubyMethod(name={"to_s", "to_str"})
    public IRubyObject to_s() {
        Ruby runtime2 = this.getRuntime();
        if (this.getMetaClass().getRealClass() != runtime2.getString()) {
            return this.strDup(runtime2, runtime2.getString());
        }
        return this;
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        IRubyObject result;
        if (other instanceof RubyString) {
            return context.getRuntime().newFixnum(this.op_cmp((RubyString)other));
        }
        if (other.respondsTo("to_str") && other.respondsTo("<=>") && (result = other.callMethod(context, "<=>", this)) instanceof RubyNumeric) {
            return ((RubyNumeric)result).op_uminus(context);
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (this == other) {
            return runtime2.getTrue();
        }
        if (!(other instanceof RubyString)) {
            if (!other.respondsTo("to_str")) {
                return runtime2.getFalse();
            }
            return other.callMethod(context, "==", this).isTrue() ? runtime2.getTrue() : runtime2.getFalse();
        }
        return this.value.equal(((RubyString)other).value) ? runtime2.getTrue() : runtime2.getFalse();
    }

    @JRubyMethod(name={"+"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        RubyString str = other.convertToString();
        RubyString resultStr = RubyString.newString(context.getRuntime(), this.addByteLists(this.value, str.value));
        if (this.isTaint() || str.isTaint()) {
            resultStr.setTaint(true);
        }
        return resultStr;
    }

    @JRubyMethod(name={"+"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_plus19(ThreadContext context, IRubyObject other) {
        RubyString str = other.convertToString();
        Encoding enc = this.checkEncoding(str);
        RubyString resultStr = RubyString.newStringNoCopy(context.getRuntime(), this.addByteLists(this.value, str.value), enc, RubyString.codeRangeAnd(this.getCodeRange(), str.getCodeRange()));
        if (this.isTaint() || str.isTaint()) {
            resultStr.setTaint(true);
        }
        return resultStr;
    }

    private ByteList addByteLists(ByteList value1, ByteList value2) {
        ByteList result = new ByteList(value1.realSize + value2.realSize);
        result.realSize = value1.realSize + value2.realSize;
        System.arraycopy(value1.bytes, value1.begin, result.bytes, 0, value1.realSize);
        System.arraycopy(value2.bytes, value2.begin, result.bytes, value1.realSize, value2.realSize);
        return result;
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        return this.multiplyByteList(context, other);
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_mul19(ThreadContext context, IRubyObject other) {
        RubyString result = this.multiplyByteList(context, other);
        result.copyCodeRangeForSubstr(this);
        return result;
    }

    private RubyString multiplyByteList(ThreadContext context, IRubyObject arg2) {
        int len = RubyNumeric.num2int(arg2);
        if (len < 0) {
            throw context.getRuntime().newArgumentError("negative argument");
        }
        if (len > 0 && Integer.MAX_VALUE / len < this.value.realSize) {
            throw context.getRuntime().newArgumentError("argument too big");
        }
        ByteList bytes = new ByteList(len *= this.value.realSize);
        if (len > 0) {
            int n;
            bytes.realSize = len;
            System.arraycopy(this.value.bytes, this.value.begin, bytes.bytes, 0, n);
            for (n = this.value.realSize; n <= len >> 1; n <<= 1) {
                System.arraycopy(bytes.bytes, 0, bytes.bytes, n, n);
            }
            System.arraycopy(bytes.bytes, 0, bytes.bytes, n, len - n);
        }
        RubyString result = new RubyString(context.getRuntime(), this.getMetaClass(), bytes);
        result.setTaint(this.isTaint());
        return result;
    }

    @JRubyMethod(name={"%"}, required=1)
    public IRubyObject op_format(ThreadContext context, IRubyObject arg2) {
        IRubyObject tmp = arg2.checkArrayType();
        if (tmp.isNil()) {
            tmp = arg2;
        }
        RubyString s = Sprintf.sprintf(context.getRuntime(), Locale.US, this.value, tmp);
        s.infectBy(this);
        return s;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RubyString) {
            RubyString string2 = (RubyString)other;
            if (string2.value.equal(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static RubyString objAsString(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject str = obj.callMethod(context, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)obj.anyToString();
        }
        if (obj.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    public int op_cmp(RubyString other) {
        return this.value.cmp(other.value);
    }

    public String asJavaString() {
        return this.toString();
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), this.value.dup());
    }

    public RubyString cat(byte[] str) {
        this.modify(this.value.realSize + str.length);
        System.arraycopy(str, 0, this.value.bytes, this.value.begin + this.value.realSize, str.length);
        this.value.realSize += str.length;
        return this;
    }

    public RubyString cat(byte[] str, int beg, int len) {
        this.modify(this.value.realSize + len);
        System.arraycopy(str, beg, this.value.bytes, this.value.begin + this.value.realSize, len);
        this.value.realSize += len;
        return this;
    }

    public RubyString cat(ByteList str) {
        this.modify(this.value.realSize + str.realSize);
        System.arraycopy(str.bytes, str.begin, this.value.bytes, this.value.begin + this.value.realSize, str.realSize);
        this.value.realSize += str.realSize;
        return this;
    }

    public RubyString cat(byte ch) {
        this.modify(this.value.realSize + 1);
        this.value.bytes[this.value.begin + this.value.realSize] = ch;
        ++this.value.realSize;
        return this;
    }

    @JRubyMethod(name={"replace", "initialize_copy"}, required=1)
    public RubyString replace(IRubyObject other) {
        if (this == other) {
            return this;
        }
        this.modifyCheck();
        RubyString otherStr = RubyString.stringValue(other);
        this.shareLevel = 2;
        otherStr.shareLevel = 2;
        this.value = otherStr.value;
        this.infectBy(other);
        return this;
    }

    @JRubyMethod(name={"reverse"})
    public RubyString reverse(ThreadContext context) {
        if (this.value.length() <= 1) {
            return this.strDup(context.getRuntime());
        }
        ByteList buf = new ByteList(this.value.length() + 2);
        buf.realSize = this.value.length();
        int src = this.value.length() - 1;
        int dst = 0;
        while (src >= 0) {
            buf.set(dst++, this.value.get(src--));
        }
        RubyString rev = new RubyString(context.getRuntime(), this.getMetaClass(), buf);
        rev.infectBy(this);
        return rev;
    }

    @JRubyMethod(name={"reverse!"})
    public RubyString reverse_bang() {
        if (this.value.length() > 1) {
            this.modify();
            for (int i = 0; i < this.value.length() / 2; ++i) {
                byte b = (byte)this.value.get(i);
                this.value.set(i, this.value.get(this.value.length() - i - 1));
                this.value.set(this.value.length() - i - 1, b);
            }
        }
        return this;
    }

    public static RubyString newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString newString = RubyString.newStringShared(recv2.getRuntime(), ByteList.EMPTY_BYTELIST);
        newString.setMetaClass((RubyClass)recv2);
        newString.callInit(args2, block);
        return newString;
    }

    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        switch (args2.length) {
            case 0: {
                return this;
            }
            case 1: {
                return this.initialize(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod(frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize() {
        return this;
    }

    @JRubyMethod(frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject arg0) {
        this.replace(arg0);
        return this;
    }

    @JRubyMethod
    public IRubyObject casecmp(IRubyObject other) {
        int compare = this.value.caseInsensitiveCmp(RubyString.stringValue((IRubyObject)other).value);
        return RubyFixnum.newFixnum(this.getRuntime(), compare);
    }

    @JRubyMethod(name={"=~"})
    public IRubyObject op_match(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).op_match(context, this);
        }
        if (other instanceof RubyString) {
            throw context.getRuntime().newTypeError("type mismatch: String given");
        }
        return other.callMethod(context, "=~", this);
    }

    @JRubyMethod
    public IRubyObject match(ThreadContext context, IRubyObject pattern) {
        return this.getPattern(pattern, false).callMethod(context, "match", this);
    }

    @JRubyMethod
    public IRubyObject capitalize(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.capitalize_bang(context);
        return str;
    }

    @JRubyMethod(name={"capitalize!"})
    public IRubyObject capitalize_bang(ThreadContext context) {
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return context.getRuntime().getNil();
        }
        this.modify();
        int s = this.value.begin;
        int send2 = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        int c = buf[s] & 0xFF;
        if (ASCII.isLower(c)) {
            buf[s] = ASCIIEncoding.asciiToUpper(c);
            modify = true;
        }
        while (++s < send2) {
            c = (char)(buf[s] & 0xFF);
            if (!ASCII.isUpper(c)) continue;
            buf[s] = ASCIIEncoding.asciiToLower(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp((RubyString)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp((RubyString)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp((RubyString)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp((RubyString)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject str_eql_p(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyString)) {
            return context.getRuntime().getFalse();
        }
        RubyString otherString = (RubyString)other;
        return this.value.equal(otherString.value) ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyString upcase(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.upcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"upcase!"})
    public IRubyObject upcase_bang(ThreadContext context) {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return context.getRuntime().getNil();
        }
        this.modify();
        int send2 = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send2; ++s) {
            int c = buf[s] & 0xFF;
            if (!ASCII.isLower(c)) continue;
            buf[s] = ASCIIEncoding.asciiToUpper(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod
    public RubyString downcase(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.downcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"downcase!"})
    public IRubyObject downcase_bang(ThreadContext context) {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return context.getRuntime().getNil();
        }
        this.modify();
        int send2 = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send2; ++s) {
            int c = buf[s] & 0xFF;
            if (!ASCII.isUpper(c)) continue;
            buf[s] = ASCIIEncoding.asciiToLower(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod
    public RubyString swapcase(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.swapcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"swapcase!"})
    public IRubyObject swapcase_bang(ThreadContext context) {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return context.getRuntime().getNil();
        }
        this.modify();
        int send2 = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send2; ++s) {
            int c = buf[s] & 0xFF;
            if (ASCII.isUpper(c)) {
                buf[s] = ASCIIEncoding.asciiToLower(c);
                modify = true;
                continue;
            }
            if (!ASCII.isLower(c)) continue;
            buf[s] = ASCIIEncoding.asciiToUpper(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject dump() {
        RubyString s = new RubyString(this.getRuntime(), this.getMetaClass(), this.inspectIntoByteList(true));
        s.infectBy(this);
        return s;
    }

    @JRubyMethod
    public IRubyObject insert(ThreadContext context, IRubyObject indexArg, IRubyObject stringArg) {
        RubyString s = stringArg.convertToString();
        ByteList insert2 = s.value;
        int index2 = (int)indexArg.convertToInteger().getLongValue();
        if (index2 < 0) {
            index2 += this.value.length() + 1;
        }
        if (index2 < 0 || index2 > this.value.length()) {
            throw context.getRuntime().newIndexError("index " + index2 + " out of range");
        }
        this.modify();
        this.value.unsafeReplace(index2, 0, insert2);
        this.infectBy(s);
        return this;
    }

    @JRubyMethod
    public IRubyObject inspect() {
        RubyString s = this.getRuntime().newString(this.inspectIntoByteList(false));
        s.infectBy(this);
        return s;
    }

    private ByteList inspectIntoByteList(boolean ignoreKCode) {
        Ruby runtime2 = this.getRuntime();
        Encoding enc = runtime2.getKCode().getEncoding();
        int length2 = this.value.length();
        ByteList sb = new ByteList(length2 + 2 + length2 / 100);
        sb.append(34);
        for (int i = 0; i < length2; ++i) {
            int seqLength;
            int c = this.value.get(i) & 0xFF;
            if (!ignoreKCode && (seqLength = enc.length((byte)c)) > 1 && i + seqLength - 1 < length2) {
                sb.append(this.value, i, seqLength);
                i += seqLength - 1;
                continue;
            }
            if (RubyString.isAlnum(c)) {
                sb.append((char)c);
                continue;
            }
            if (c == 34 || c == 92) {
                sb.append(92).append((char)c);
                continue;
            }
            if (c == 35 && this.isEVStr(i, length2)) {
                sb.append(92).append((char)c);
                continue;
            }
            if (RubyString.isPrint(c)) {
                sb.append((char)c);
                continue;
            }
            if (c == 10) {
                sb.append(92).append(110);
                continue;
            }
            if (c == 13) {
                sb.append(92).append(114);
                continue;
            }
            if (c == 9) {
                sb.append(92).append(116);
                continue;
            }
            if (c == 12) {
                sb.append(92).append(102);
                continue;
            }
            if (c == 11) {
                sb.append(92).append(118);
                continue;
            }
            if (c == 7) {
                sb.append(92).append(97);
                continue;
            }
            if (c == 8) {
                sb.append(92).append(98);
                continue;
            }
            if (c == 27) {
                sb.append(92).append(101);
                continue;
            }
            sb.append(ByteList.plain(Sprintf.sprintf(runtime2, (CharSequence)"\\%03o", c)));
        }
        sb.append(34);
        return sb;
    }

    private boolean isEVStr(int i, int length2) {
        if (i + 1 >= length2) {
            return false;
        }
        int c = this.value.get(i + 1) & 0xFF;
        return c == 36 || c == 64 || c == 123;
    }

    @JRubyMethod(name={"length", "size"}, compat=CompatVersion.RUBY1_8)
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.value.realSize);
    }

    @JRubyMethod(name={"length", "size"}, compat=CompatVersion.RUBY1_9)
    public RubyFixnum length19() {
        return this.getRuntime().newFixnum(this.strLength());
    }

    @JRubyMethod(name={"bytesize"}, compat=CompatVersion.RUBY1_9)
    public RubyFixnum bytesize() {
        return this.length();
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return this.isEmpty() ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public RubyString append(IRubyObject other) {
        this.infectBy(other);
        return this.cat(RubyString.stringValue((IRubyObject)other).value);
    }

    @JRubyMethod(name={"concat", "<<"})
    public RubyString concat(IRubyObject other) {
        long value2;
        if (other instanceof RubyFixnum && (value2 = ((RubyFixnum)other).getLongValue()) >= 0L && value2 < 256L) {
            return this.cat((byte)value2);
        }
        return this.append(other);
    }

    @JRubyMethod(name={"crypt"})
    public RubyString crypt(ThreadContext context, IRubyObject other) {
        ByteList salt = RubyString.stringValue(other).getByteList();
        if (salt.realSize < 2) {
            throw context.getRuntime().newArgumentError("salt too short(need >=2 bytes)");
        }
        salt = salt.makeShared(0, 2);
        RubyString s = RubyString.newStringShared(context.getRuntime(), JavaCrypt.crypt(salt, this.getByteList()));
        s.infectBy(this);
        s.infectBy(other);
        return s;
    }

    public static RubyString stringValue(IRubyObject object) {
        return (RubyString)(object instanceof RubyString ? object : object.convertToString());
    }

    public IRubyObject sub(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyString str = this.strDup(context.getRuntime());
        str.sub_bang(context, args2, block);
        return str;
    }

    public IRubyObject sub_bang(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.sub_bang(context, args2[0], block);
            }
            case 2: {
                return this.sub_bang(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"sub"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, Block block) {
        RubyString str = this.strDup(context.getRuntime());
        str.sub_bang(context, arg0, block);
        return str;
    }

    @JRubyMethod(name={"sub"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = this.strDup(context.getRuntime());
        str.sub_bang(context, arg0, arg1, block);
        return str;
    }

    @JRubyMethod(name={"sub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        if (block.isGiven()) {
            return this.subBangIter(context, this.getPattern(arg0, true), block);
        }
        throw context.getRuntime().newArgumentError(1, 2);
    }

    @JRubyMethod(name={"sub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.subBangNoIter(context, this.getPattern(arg0, true), arg1.convertToString());
    }

    private IRubyObject subBangIter(ThreadContext context, RubyRegexp rubyRegex, Block block) {
        Regex regex = rubyRegex.getPattern();
        int range = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, range);
        Frame frame = context.getPreviousFrame();
        if (matcher.search(this.value.begin, range, 0) >= 0) {
            byte[] bytes = this.value.bytes;
            int size2 = this.value.realSize;
            RubyMatchData match2 = rubyRegex.updateBackRef(context, this, frame, matcher);
            match2.use();
            RubyString repl = RubyString.objAsString(context, block.yield(context, this.substr(context.getRuntime(), matcher.getBegin(), matcher.getEnd() - matcher.getBegin())));
            this.modifyCheck(bytes, size2);
            this.frozenCheck();
            frame.setBackRef(match2);
            return this.subBangCommon(context, regex, matcher, repl, false);
        }
        return frame.setBackRef(context.getRuntime().getNil());
    }

    private IRubyObject subBangNoIter(ThreadContext context, RubyRegexp rubyRegex, RubyString repl) {
        boolean tained = repl.isTaint();
        Regex regex = rubyRegex.getPattern();
        int range = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, range);
        Frame frame = context.getPreviousFrame();
        if (matcher.search(this.value.begin, range, 0) >= 0) {
            repl = rubyRegex.regsub(repl, this, matcher);
            rubyRegex.updateBackRef(context, this, frame, matcher);
            return this.subBangCommon(context, regex, matcher, repl, tained);
        }
        return frame.setBackRef(context.getRuntime().getNil());
    }

    private IRubyObject subBangCommon(ThreadContext context, Regex regex, Matcher matcher, RubyString repl, boolean tainted) {
        int beg = matcher.getBegin();
        int plen = matcher.getEnd() - beg;
        ByteList replValue = repl.value;
        if (replValue.realSize > plen) {
            this.modify(this.value.realSize + replValue.realSize - plen);
        } else {
            this.modify();
        }
        if (repl.isTaint()) {
            tainted = true;
        }
        if (replValue.realSize != plen) {
            int src = this.value.begin + beg + plen;
            int dst = this.value.begin + beg + replValue.realSize;
            int length2 = this.value.realSize - beg - plen;
            System.arraycopy(this.value.bytes, src, this.value.bytes, dst, length2);
        }
        System.arraycopy(replValue.bytes, replValue.begin, this.value.bytes, this.value.begin + beg, replValue.realSize);
        this.value.realSize += replValue.realSize - plen;
        if (tainted) {
            this.setTaint(true);
        }
        return this;
    }

    @JRubyMethod(name={"sub"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub19(ThreadContext context, IRubyObject arg0, Block block) {
        RubyString str = this.strDup(context.getRuntime());
        str.sub_bang19(context, arg0, block);
        return str;
    }

    @JRubyMethod(name={"sub"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = this.strDup(context.getRuntime());
        str.sub_bang19(context, arg0, arg1, block);
        return str;
    }

    @JRubyMethod(name={"sub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub_bang19(ThreadContext context, IRubyObject arg0, Block block) {
        if (block.isGiven()) {
            return this.subBangIter19(context, this.getPattern(arg0, true), null, block);
        }
        throw context.getRuntime().newArgumentError(1, 2);
    }

    @JRubyMethod(name={"sub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub_bang19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject hash2 = TypeConverter.convertToTypeWithCheck(arg1, context.getRuntime().getHash(), "to_hash");
        RubyRegexp regexp2 = this.getPattern(arg0, true);
        if (hash2.isNil()) {
            return this.subBangNoIter19(context, regexp2, arg1.convertToString());
        }
        return this.subBangIter19(context, regexp2, (RubyHash)hash2, block);
    }

    private IRubyObject subBangIter19(ThreadContext context, RubyRegexp rubyRegex, IRubyObject hash2, Block block) {
        Regex regex = rubyRegex.getPattern();
        int range = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, range);
        Frame frame = context.getPreviousFrame();
        if (matcher.search(this.value.begin, range, 0) >= 0) {
            RubyString repl;
            boolean tainted;
            byte[] bytes = this.value.bytes;
            int size2 = this.value.realSize;
            RubyMatchData match2 = rubyRegex.updateBackRef(context, this, frame, matcher);
            match2.use();
            IRubyObject subStr = this.substr(context.getRuntime(), matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
            if (hash2 == null) {
                tainted = false;
                repl = RubyString.objAsString(context, block.yield(context, subStr));
            } else {
                tainted = hash2.isTaint();
                repl = RubyString.objAsString(context, ((RubyHash)hash2).fastARef(subStr));
            }
            this.modifyCheck(bytes, size2);
            this.frozenCheck();
            frame.setBackRef(match2);
            return this.subBangCommon19(context, regex, matcher, repl, tainted);
        }
        return frame.setBackRef(context.getRuntime().getNil());
    }

    private IRubyObject subBangNoIter19(ThreadContext context, RubyRegexp rubyRegex, RubyString repl) {
        boolean tained = repl.isTaint();
        Regex regex = rubyRegex.getPattern();
        int range = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, range);
        Frame frame = context.getPreviousFrame();
        if (matcher.search(this.value.begin, range, 0) >= 0) {
            repl = rubyRegex.regsub(repl, this, matcher);
            rubyRegex.updateBackRef(context, this, frame, matcher);
            return this.subBangCommon19(context, regex, matcher, repl, tained);
        }
        return frame.setBackRef(context.getRuntime().getNil());
    }

    private IRubyObject subBangCommon19(ThreadContext context, Regex regex, Matcher matcher, RubyString repl, boolean tainted) {
        int cr;
        int beg = matcher.getBegin();
        int end2 = matcher.getEnd();
        Encoding enc = RubyEncoding.areCompatible(this, repl);
        if (enc == null) {
            enc = this.subBangVerifyEncoding(context, repl, beg, end2);
        }
        int plen = end2 - beg;
        ByteList replValue = repl.value;
        if (replValue.realSize > plen) {
            this.modify19(this.value.realSize + replValue.realSize - plen);
        } else {
            this.modify19();
        }
        this.associateEncoding(enc);
        if (repl.isTaint()) {
            tainted = true;
        }
        if ((cr = this.getCodeRange()) > 0 && cr < 48) {
            int cr2 = repl.getCodeRange();
            cr = cr2 == 48 || cr == 32 && cr2 == 16 ? 0 : cr2;
        }
        if (replValue.realSize != plen) {
            int src = this.value.begin + beg + plen;
            int dst = this.value.begin + beg + replValue.realSize;
            int length2 = this.value.realSize - beg - plen;
            System.arraycopy(this.value.bytes, src, this.value.bytes, dst, length2);
        }
        System.arraycopy(replValue.bytes, replValue.begin, this.value.bytes, this.value.begin + beg, replValue.realSize);
        this.value.realSize += replValue.realSize - plen;
        this.setCodeRange(cr);
        if (tainted) {
            this.setTaint(true);
        }
        return this;
    }

    private Encoding subBangVerifyEncoding(ThreadContext context, RubyString repl, int beg, int end2) {
        byte[] bytes = this.value.bytes;
        int p2 = this.value.begin;
        int len = this.value.realSize;
        Encoding strEnc = this.value.encoding;
        if (StringSupport.codeRangeScan(strEnc, bytes, p2, beg) != 16 || StringSupport.codeRangeScan(strEnc, bytes, p2 + end2, len - end2) != 16) {
            throw context.getRuntime().newArgumentError("incompatible character encodings " + strEnc + " and " + repl.value.encoding);
        }
        return repl.value.encoding;
    }

    public IRubyObject gsub(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.gsub(context, args2[0], block);
            }
            case 2: {
                return this.gsub(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"gsub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, Block block) {
        return this.gsub(context, arg0, block, false);
    }

    @JRubyMethod(name={"gsub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub(context, arg0, arg1, block, false);
    }

    public IRubyObject gsub_bang(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.gsub_bang(context, args2[0], block);
            }
            case 2: {
                return this.gsub_bang(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"gsub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        return this.gsub(context, arg0, block, true);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub(context, arg0, arg1, block, true);
    }

    private final IRubyObject gsub(ThreadContext context, IRubyObject arg0, Block block, boolean bang) {
        if (block.isGiven()) {
            return this.gsubCommon(context, bang, this.getPattern(arg0, true), block, null, false);
        }
        throw context.getRuntime().newArgumentError("wrong number of arguments (1 for 2)");
    }

    private final IRubyObject gsub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block, boolean bang) {
        RubyString repl = arg1.convertToString();
        return this.gsubCommon(context, bang, this.getPattern(arg0, true), block, repl, repl.isTaint());
    }

    private IRubyObject gsubCommon(ThreadContext context, boolean bang, RubyRegexp rubyRegex, Block block, RubyString repl, boolean tainted) {
        Ruby runtime2 = context.getRuntime();
        Regex regex = rubyRegex.getPattern();
        Frame frame = context.getPreviousFrame();
        int begin2 = this.value.begin;
        int range = begin2 + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, begin2, range);
        int beg = matcher.search(begin2, range, 0);
        if (beg < 0) {
            frame.setBackRef(runtime2.getNil());
            return bang ? runtime2.getNil() : this.strDup(runtime2);
        }
        int blen = this.value.realSize + 30;
        ByteList dest = new ByteList(blen);
        dest.realSize = blen;
        int offset2 = 0;
        int buf = 0;
        int bp = 0;
        int cp = begin2;
        RubyMatchData match2 = null;
        while (beg >= 0) {
            RubyString val;
            int begz = matcher.getBegin();
            int endz = matcher.getEnd();
            if (repl == null) {
                byte[] bytes = this.value.bytes;
                int size2 = this.value.realSize;
                match2 = rubyRegex.updateBackRef(context, this, frame, matcher);
                match2.use();
                val = RubyString.objAsString(context, block.yield(context, this.substr(runtime2, begz, endz - begz)));
                this.modifyCheck(bytes, size2);
                if (bang) {
                    this.frozenCheck();
                }
            } else {
                val = rubyRegex.regsub(repl, this, matcher);
            }
            if (val.isTaint()) {
                tainted = true;
            }
            ByteList vbuf = val.value;
            int len = bp - buf + (beg - offset2) + vbuf.realSize + 3;
            if (blen < len) {
                while (blen < len) {
                    blen <<= 1;
                }
                len = bp - buf;
                dest.realloc(blen);
                dest.realSize = blen;
                bp = buf + len;
            }
            len = beg - offset2;
            System.arraycopy(this.value.bytes, cp, dest.bytes, bp, len);
            System.arraycopy(vbuf.bytes, vbuf.begin, dest.bytes, bp += len, vbuf.realSize);
            bp += vbuf.realSize;
            offset2 = endz;
            if (begz == endz) {
                if (this.value.realSize <= endz) break;
                len = regex.getEncoding().length(this.value.bytes, begin2 + endz, range);
                System.arraycopy(this.value.bytes, begin2 + endz, dest.bytes, bp, len);
                bp += len;
                offset2 = endz + len;
            }
            cp = begin2 + offset2;
            if (offset2 > this.value.realSize) break;
            beg = matcher.search(cp, range, 0);
        }
        if (this.value.realSize > offset2) {
            int len = bp - buf;
            if (blen - len < this.value.realSize - offset2) {
                blen = len + this.value.realSize - offset2;
                dest.realloc(blen);
                bp = buf + len;
            }
            System.arraycopy(this.value.bytes, cp, dest.bytes, bp, this.value.realSize - offset2);
            bp += this.value.realSize - offset2;
        }
        if (match2 != null) {
            frame.setBackRef(match2);
        } else {
            rubyRegex.updateBackRef(context, this, frame, matcher);
        }
        dest.realSize = bp - buf;
        if (bang) {
            this.view(dest);
            if (tainted) {
                this.setTaint(true);
            }
            return this;
        }
        RubyString destStr = new RubyString(runtime2, this.getMetaClass(), dest);
        destStr.infectBy(this);
        if (tainted) {
            destStr.setTaint(true);
        }
        return destStr;
    }

    public IRubyObject index(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.index(context, args2[0]);
            }
            case 2: {
                return this.index(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject index(ThreadContext context, IRubyObject arg0) {
        return this.indexCommon(0, arg0, context);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject index(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        if (pos2 < 0 && (pos2 += this.value.realSize) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.getPreviousFrame().setBackRef(context.getRuntime().getNil());
            }
            return context.getRuntime().getNil();
        }
        return this.indexCommon(pos2, arg0, context);
    }

    private IRubyObject indexCommon(int pos2, IRubyObject sub3, ThreadContext context) throws RaiseException {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub3;
            pos2 = regSub.adjustStartPos(this, pos2, false);
            pos2 = regSub.search(context, this, pos2, false);
        } else {
            if (sub3 instanceof RubyFixnum) {
                int c_int = RubyNumeric.fix2int(sub3);
                if (c_int < 0 || c_int > 255) {
                    return context.getRuntime().getNil();
                }
                byte c = (byte)c_int;
                byte[] bytes = this.value.bytes;
                int end2 = this.value.begin + this.value.realSize;
                pos2 += this.value.begin;
                while (pos2 < end2) {
                    if (bytes[pos2] == c) {
                        return RubyFixnum.newFixnum(context.getRuntime(), pos2 - this.value.begin);
                    }
                    ++pos2;
                }
                return context.getRuntime().getNil();
            }
            if (sub3 instanceof RubyString) {
                pos2 = this.strIndex((RubyString)sub3, pos2);
            } else {
                IRubyObject tmp = sub3.checkStringType();
                if (tmp.isNil()) {
                    throw context.getRuntime().newTypeError("type mismatch: " + sub3.getMetaClass().getName() + " given");
                }
                pos2 = this.strIndex((RubyString)tmp, pos2);
            }
        }
        return pos2 == -1 ? context.getRuntime().getNil() : RubyFixnum.newFixnum(context.getRuntime(), pos2);
    }

    private int strIndex(RubyString sub3, int offset2) {
        ByteList byteList = this.value;
        if (offset2 < 0 && (offset2 += byteList.realSize) < 0) {
            return -1;
        }
        ByteList other = sub3.value;
        if (RubyString.sizeIsSmaller(byteList, offset2, other)) {
            return -1;
        }
        if (other.realSize == 0) {
            return offset2;
        }
        return byteList.indexOf(other, offset2);
    }

    private static boolean sizeIsSmaller(ByteList byteList, int offset2, ByteList other) {
        return byteList.realSize - offset2 < other.realSize;
    }

    public IRubyObject rindex(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.rindex(context, args2[0]);
            }
            case 2: {
                return this.rindex(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject rindex(ThreadContext context, IRubyObject arg0) {
        return this.rindexCommon(arg0, this.value.realSize, context);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject rindex(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        if (pos2 < 0 && (pos2 += this.value.realSize) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.getPreviousFrame().setBackRef(context.getRuntime().getNil());
            }
            return context.getRuntime().getNil();
        }
        if (pos2 > this.value.realSize) {
            pos2 = this.value.realSize;
        }
        return this.rindexCommon(arg0, pos2, context);
    }

    private IRubyObject rindexCommon(IRubyObject sub3, int pos2, ThreadContext context) throws RaiseException {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub3;
            if (regSub.length() > 0) {
                pos2 = regSub.adjustStartPos(this, pos2, true);
                pos2 = regSub.search(context, this, pos2, true);
            }
            if (pos2 >= 0) {
                return RubyFixnum.newFixnum(context.getRuntime(), pos2);
            }
        } else if (sub3 instanceof RubyString) {
            if ((pos2 = this.strRindex((RubyString)sub3, pos2)) >= 0) {
                return RubyFixnum.newFixnum(context.getRuntime(), pos2);
            }
        } else {
            if (sub3 instanceof RubyFixnum) {
                int c_int = RubyNumeric.fix2int(sub3);
                if (c_int < 0 || c_int > 255) {
                    return context.getRuntime().getNil();
                }
                byte c = (byte)c_int;
                byte[] bytes = this.value.bytes;
                int pbeg = this.value.begin;
                int p2 = pbeg + pos2;
                if (pos2 == this.value.realSize) {
                    if (pos2 == 0) {
                        return context.getRuntime().getNil();
                    }
                    --p2;
                }
                while (pbeg <= p2) {
                    if (bytes[p2] == c) {
                        return RubyFixnum.newFixnum(context.getRuntime(), p2 - this.value.begin);
                    }
                    --p2;
                }
                return context.getRuntime().getNil();
            }
            IRubyObject tmp = sub3.checkStringType();
            if (tmp.isNil()) {
                throw context.getRuntime().newTypeError("type mismatch: " + sub3.getMetaClass().getName() + " given");
            }
            if ((pos2 = this.strRindex((RubyString)tmp, pos2)) >= 0) {
                return RubyFixnum.newFixnum(context.getRuntime(), pos2);
            }
        }
        return context.getRuntime().getNil();
    }

    private int strRindex(RubyString sub3, int pos2) {
        int subLength = sub3.value.realSize;
        if (this.value.realSize < subLength) {
            return -1;
        }
        if (this.value.realSize - pos2 < subLength) {
            pos2 = this.value.realSize - subLength;
        }
        return this.value.lastIndexOf(sub3.value, pos2);
    }

    public IRubyObject substr(Ruby runtime2, int beg, int len) {
        int length2 = this.value.length();
        if (len < 0 || beg > length2) {
            return runtime2.getNil();
        }
        if (beg < 0 && (beg += length2) < 0) {
            return runtime2.getNil();
        }
        int end2 = Math.min(length2, beg + len);
        return this.makeShared(runtime2, beg, end2 - beg);
    }

    public IRubyObject replace(int beg, int len, RubyString replaceWith) {
        if (beg + len >= this.value.length()) {
            len = this.value.length() - beg;
        }
        this.modify();
        this.value.unsafeReplace(beg, len, replaceWith.value);
        return this.infectBy(replaceWith);
    }

    public IRubyObject op_aref(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.op_aref(context, args2[0]);
            }
            case 2: {
                return this.op_aref(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        if (arg1 instanceof RubyRegexp) {
            if (((RubyRegexp)arg1).search(context, this, 0, false) >= 0) {
                return RubyRegexp.nth_match(RubyNumeric.fix2int(arg2), context.getCurrentFrame().getBackRef());
            }
            return context.getRuntime().getNil();
        }
        return this.substr(context.getRuntime(), RubyNumeric.fix2int(arg1), RubyNumeric.fix2int(arg2));
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyRegexp) {
            if (((RubyRegexp)arg2).search(context, this, 0, false) >= 0) {
                return RubyRegexp.nth_match(0, context.getCurrentFrame().getBackRef());
            }
            return context.getRuntime().getNil();
        }
        if (arg2 instanceof RubyString) {
            return this.value.indexOf(RubyString.stringValue((IRubyObject)arg2).value) != -1 ? arg2 : context.getRuntime().getNil();
        }
        if (arg2 instanceof RubyRange) {
            int[] begLen = ((RubyRange)arg2).begLenInt(this.value.length(), 0);
            return begLen == null ? context.getRuntime().getNil() : this.substr(context.getRuntime(), begLen[0], begLen[1]);
        }
        int idx = (int)arg2.convertToInteger().getLongValue();
        if (idx < 0) {
            idx += this.value.length();
        }
        if (idx < 0 || idx >= this.value.length()) {
            return context.getRuntime().getNil();
        }
        return context.getRuntime().newFixnum(this.value.get(idx) & 0xFF);
    }

    private void subpatSet(ThreadContext context, RubyRegexp regexp2, int nth, IRubyObject repl) {
        int end2;
        int start2;
        if (regexp2.search(context, this, 0, false) < 0) {
            throw context.getRuntime().newIndexError("regexp not matched");
        }
        RubyMatchData match2 = (RubyMatchData)context.getCurrentFrame().getBackRef();
        if (match2.regs == null) {
            if (nth >= 1) {
                throw context.getRuntime().newIndexError("index " + nth + " out of regexp");
            }
            if (nth < 0) {
                if (-nth >= 1) {
                    throw context.getRuntime().newIndexError("index " + nth + " out of regexp");
                }
                ++nth;
            }
            if ((start2 = match2.begin) == -1) {
                throw context.getRuntime().newIndexError("regexp group " + nth + " not matched");
            }
            end2 = match2.end;
        } else {
            if (nth >= match2.regs.numRegs) {
                throw context.getRuntime().newIndexError("index " + nth + " out of regexp");
            }
            if (nth < 0) {
                if (-nth >= match2.regs.numRegs) {
                    throw context.getRuntime().newIndexError("index " + nth + " out of regexp");
                }
                nth += match2.regs.numRegs;
            }
            if ((start2 = match2.regs.beg[nth]) == -1) {
                throw context.getRuntime().newIndexError("regexp group " + nth + " not matched");
            }
            end2 = match2.regs.end[nth];
        }
        int len = end2 - start2;
        this.replace(start2, len, RubyString.stringValue(repl));
    }

    public IRubyObject op_aset(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 2: {
                return this.op_aset(context, args2[0], args2[1]);
            }
            case 3: {
                return this.op_aset(context, args2[0], args2[1], args2[2]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 2, 3);
        return null;
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF})
    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyFixnum || arg0.respondsTo("to_int")) {
            int idx = RubyNumeric.fix2int(arg0);
            if (idx < 0) {
                idx += this.value.length();
            }
            if (idx < 0 || idx >= this.value.length()) {
                throw context.getRuntime().newIndexError("string index out of bounds");
            }
            if (arg1 instanceof RubyFixnum) {
                this.modify();
                this.value.set(idx, (byte)RubyNumeric.fix2int(arg1));
            } else {
                this.replace(idx, 1, RubyString.stringValue(arg1));
            }
            return arg1;
        }
        if (arg0 instanceof RubyRegexp) {
            RubyString repl = RubyString.stringValue(arg1);
            this.subpatSet(context, (RubyRegexp)arg0, 0, repl);
            return repl;
        }
        if (arg0 instanceof RubyString) {
            RubyString orig = (RubyString)arg0;
            int beg = this.value.indexOf(orig.value);
            if (beg < 0) {
                throw context.getRuntime().newIndexError("string not matched");
            }
            this.replace(beg, orig.value.length(), RubyString.stringValue(arg1));
            return arg1;
        }
        if (arg0 instanceof RubyRange) {
            int[] begLen = ((RubyRange)arg0).begLenInt(this.value.realSize, 2);
            this.replace(begLen[0], begLen[1], RubyString.stringValue(arg1));
            return arg1;
        }
        throw context.getRuntime().newTypeError("wrong argument type");
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF})
    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (arg0 instanceof RubyRegexp) {
            RubyString repl = RubyString.stringValue(arg2);
            int nth = RubyNumeric.fix2int(arg1);
            this.subpatSet(context, (RubyRegexp)arg0, nth, repl);
            return repl;
        }
        RubyString repl = RubyString.stringValue(arg2);
        int beg = RubyNumeric.fix2int(arg0);
        int len = RubyNumeric.fix2int(arg1);
        if (len < 0) {
            throw context.getRuntime().newIndexError("negative length");
        }
        int strLen = this.value.length();
        if (beg < 0) {
            beg += strLen;
        }
        if (beg < 0 || beg > 0 && beg > strLen) {
            throw context.getRuntime().newIndexError("string index out of bounds");
        }
        if (beg + len > strLen) {
            len = strLen - beg;
        }
        this.replace(beg, len, repl);
        return repl;
    }

    public IRubyObject slice_bang(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.slice_bang(context, args2[0]);
            }
            case 2: {
                return this.slice_bang(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0) {
        IRubyObject result = this.op_aref(context, arg0);
        if (result.isNil()) {
            return result;
        }
        this.op_aset(context, arg0, RubyString.newEmptyString(context.getRuntime()));
        return result;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result = this.op_aref(context, arg0, arg1);
        if (result.isNil()) {
            return result;
        }
        this.op_aset(context, arg0, arg1, RubyString.newEmptyString(context.getRuntime()));
        return result;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.succ_bang();
        return str;
    }

    @JRubyMethod(name={"succ!", "next!"})
    public IRubyObject succ_bang() {
        int i;
        if (this.value.length() == 0) {
            this.modifyCheck();
            return this;
        }
        this.modify();
        boolean alnumSeen = false;
        int pos2 = -1;
        int c = 0;
        int n = 0;
        for (i = this.value.length() - 1; i >= 0; --i) {
            c = this.value.get(i) & 0xFF;
            if (!RubyString.isAlnum(c)) continue;
            alnumSeen = true;
            if (RubyString.isDigit(c) && c < 57 || RubyString.isLower(c) && c < 122 || RubyString.isUpper(c) && c < 90) {
                this.value.set(i, (byte)(c + 1));
                pos2 = -1;
                break;
            }
            pos2 = i;
            int n2 = RubyString.isDigit(c) ? 49 : (n = RubyString.isLower(c) ? 97 : 65);
            this.value.set(i, (byte)(RubyString.isDigit(c) ? 48 : (RubyString.isLower(c) ? 97 : 65)));
        }
        if (!alnumSeen) {
            for (i = this.value.length() - 1; i >= 0; --i) {
                c = this.value.get(i) & 0xFF;
                if (c < 255) {
                    this.value.set(i, (byte)(c + 1));
                    pos2 = -1;
                    break;
                }
                pos2 = i;
                n = 1;
                this.value.set(i, 0);
            }
        }
        if (pos2 > -1) {
            this.value.insert(pos2, (byte)n);
        }
        return this;
    }

    @JRubyMethod(name={"upto"}, required=1, frame=true)
    public IRubyObject upto(ThreadContext context, IRubyObject str, Block block) {
        return this.upto(context, str, false, block);
    }

    public IRubyObject upto(ThreadContext context, IRubyObject str, boolean excl, Block block) {
        RubyString end2 = str.convertToString();
        int n = this.value.cmp(end2.value);
        if (n > 0 || excl && n == 0) {
            return this;
        }
        IRubyObject afterEnd = end2.callMethod(context, "succ");
        RubyString current2 = this;
        while (!current2.op_equal(context, afterEnd).isTrue()) {
            block.yield(context, current2);
            if (!excl && current2.op_equal(context, end2).isTrue()) break;
            current2 = current2.callMethod(context, "succ").convertToString();
            if ((!excl || !current2.op_equal(context, end2).isTrue()) && current2.value.realSize <= end2.value.realSize && current2.value.realSize != 0) continue;
            break;
        }
        return this;
    }

    @JRubyMethod(name={"include?"}, required=1)
    public RubyBoolean include_p(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyFixnum) {
            int c = RubyNumeric.fix2int(obj);
            for (int i = 0; i < this.value.length(); ++i) {
                if (this.value.get(i) != (byte)c) continue;
                return context.getRuntime().getTrue();
            }
            return context.getRuntime().getFalse();
        }
        ByteList str = RubyString.stringValue((IRubyObject)obj).value;
        return context.getRuntime().newBoolean(this.value.indexOf(str) != -1);
    }

    public IRubyObject to_i(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.to_i();
            }
            case 1: {
                return this.to_i(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i() {
        return RubyNumeric.str2inum(this.getRuntime(), this, 10);
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(IRubyObject arg0) {
        long base = arg0.convertToInteger().getLongValue();
        return RubyNumeric.str2inum(this.getRuntime(), this, (int)base);
    }

    @JRubyMethod(name={"oct"})
    public IRubyObject oct(ThreadContext context) {
        int pos2;
        int ix;
        if (this.isEmpty()) {
            return context.getRuntime().newFixnum(0);
        }
        int base = 8;
        for (ix = this.value.begin; ix < this.value.begin + this.value.realSize && ASCII.isSpace(this.value.bytes[ix] & 0xFF); ++ix) {
        }
        int n = pos2 = this.value.bytes[ix] == 45 || this.value.bytes[ix] == 43 ? ix + 1 : ix;
        if (pos2 + 1 < this.value.begin + this.value.realSize && this.value.bytes[pos2] == 48) {
            if (this.value.bytes[pos2 + 1] == 120 || this.value.bytes[pos2 + 1] == 88) {
                base = 16;
            } else if (this.value.bytes[pos2 + 1] == 98 || this.value.bytes[pos2 + 1] == 66) {
                base = 2;
            } else if (this.value.bytes[pos2 + 1] == 100 || this.value.bytes[pos2 + 1] == 68) {
                base = 10;
            }
        }
        return RubyNumeric.str2inum(context.getRuntime(), this, base);
    }

    @JRubyMethod(name={"hex"})
    public IRubyObject hex(ThreadContext context) {
        return RubyNumeric.str2inum(context.getRuntime(), this, 16);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuntime(), this);
    }

    public RubyArray split(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.split(context);
            }
            case 1: {
                return this.split(context, args2[0]);
            }
            case 2: {
                return this.split(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 0, 2);
        return null;
    }

    @JRubyMethod(writes={FrameField.BACKREF})
    public RubyArray split(ThreadContext context) {
        return this.split(context, context.getRuntime().getNil());
    }

    @JRubyMethod(writes={FrameField.BACKREF})
    public RubyArray split(ThreadContext context, IRubyObject arg0) {
        return this.splitCommon(arg0, false, 0, 0, context);
    }

    @JRubyMethod(writes={FrameField.BACKREF})
    public RubyArray split(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int lim = RubyNumeric.fix2int(arg1);
        if (lim <= 0) {
            return this.splitCommon(arg0, false, lim, 1, context);
        }
        if (lim == 1) {
            return this.value.realSize == 0 ? context.getRuntime().newArray() : context.getRuntime().newArray(this);
        }
        return this.splitCommon(arg0, true, lim, 1, context);
    }

    private RubyArray splitCommon(IRubyObject spat, boolean limit2, int lim, int i, ThreadContext context) {
        RubyArray result;
        if (spat.isNil() && (spat = context.getRuntime().getGlobalVariables().get("$;")).isNil()) {
            result = this.awkSplit(limit2, lim, i);
        } else if (spat instanceof RubyString && ((RubyString)spat).value.realSize == 1) {
            RubyString strSpat = (RubyString)spat;
            result = strSpat.value.bytes[strSpat.value.begin] == 32 ? this.awkSplit(limit2, lim, i) : this.regexSplit(context, spat, limit2, lim, i);
        } else {
            result = this.regexSplit(context, spat, limit2, lim, i);
        }
        if (!limit2 && lim == 0) {
            while (result.size() > 0 && ((RubyString)result.eltInternal((int)(result.size() - 1))).value.realSize == 0) {
                result.pop(context);
            }
        }
        return result;
    }

    private RubyArray regexSplit(ThreadContext context, IRubyObject pat, boolean limit2, int lim, int i) {
        Ruby runtime2 = context.getRuntime();
        Regex regex = this.getPattern(pat, true).getPattern();
        int begin2 = this.value.begin;
        Matcher matcher = regex.matcher(this.value.bytes, begin2, begin2 + this.value.realSize);
        RubyArray result = runtime2.newArray();
        Encoding enc = regex.getEncoding();
        int beg = this.regexSplit(runtime2, result, matcher, enc, limit2, lim, i, regex.numberOfCaptures() != 0);
        context.getCurrentFrame().setBackRef(runtime2.getNil());
        if (this.value.realSize > 0 && (limit2 || this.value.realSize > beg || lim < 0)) {
            if (this.value.realSize == beg) {
                result.append(RubyString.newEmptyString(runtime2, this.getMetaClass()));
            } else {
                result.append(this.substr(runtime2, beg, this.value.realSize - beg));
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private int regexSplit(Ruby runtime2, RubyArray result, Matcher matcher, Encoding enc, boolean limit2, int lim, int i, boolean captures2) {
        int end2;
        int begin2;
        byte[] bytes = this.value.bytes;
        int start2 = begin2 = this.value.begin;
        int range = begin2 + this.value.realSize;
        int beg = 0;
        boolean lastNull = false;
        while ((end2 = matcher.search(start2, range, 0)) >= 0) {
            block6: {
                if (start2 == end2 + begin2 && matcher.getBegin() == matcher.getEnd()) {
                    if (this.value.realSize == 0) {
                        result.append(RubyString.newEmptyString(runtime2, this.getMetaClass()));
                        return beg;
                    }
                    if (lastNull) {
                        result.append(this.substr(runtime2, beg, enc.length(bytes, begin2 + beg, range)));
                        beg = start2 - begin2;
                        break block6;
                    } else {
                        start2 = start2 == range ? ++start2 : (start2 += enc.length(bytes, start2, range));
                        lastNull = true;
                        continue;
                    }
                }
                result.append(this.substr(runtime2, beg, end2 - beg));
                beg = matcher.getEnd();
                start2 = begin2 + matcher.getEnd();
            }
            lastNull = false;
            if (captures2) {
                this.populateCapturesForSplit(runtime2, result, matcher);
            }
            if (limit2 && lim <= ++i) return beg;
        }
        return beg;
    }

    private void populateCapturesForSplit(Ruby runtime2, RubyArray result, Matcher matcher) {
        Region region = matcher.getRegion();
        for (int i = 1; i < region.numRegs; ++i) {
            if (region.beg[i] == -1) continue;
            if (region.beg[i] == region.end[i]) {
                result.append(RubyString.newEmptyString(runtime2, this.getMetaClass()));
                continue;
            }
            result.append(this.substr(runtime2, region.beg[i], region.end[i] - region.beg[i]));
        }
    }

    private RubyArray awkSplit(boolean limit2, int lim, int i) {
        int p2;
        Ruby runtime2 = this.getRuntime();
        RubyArray result = runtime2.newArray();
        byte[] bytes = this.value.bytes;
        int endp = p2 + this.value.realSize;
        boolean skip2 = true;
        int beg = 0;
        beg = 0;
        int end2 = 0;
        for (p2 = this.value.begin; p2 < endp; ++p2) {
            if (skip2) {
                if (ASCII.isSpace(bytes[p2] & 0xFF)) {
                    ++beg;
                    continue;
                }
                end2 = beg + 1;
                skip2 = false;
                if (!limit2 || lim > i) continue;
                break;
            }
            if (ASCII.isSpace(bytes[p2] & 0xFF)) {
                result.append(this.makeShared(runtime2, beg, end2 - beg));
                skip2 = true;
                beg = end2 + 1;
                if (!limit2) continue;
                ++i;
                continue;
            }
            ++end2;
        }
        if (this.value.realSize > 0 && (limit2 || this.value.realSize > beg || lim < 0)) {
            if (this.value.realSize == beg) {
                result.append(RubyString.newEmptyString(runtime2, this.getMetaClass()));
            } else {
                result.append(this.makeShared(runtime2, beg, this.value.realSize - beg));
            }
        }
        return result;
    }

    private final RubyRegexp getPattern(IRubyObject obj, boolean quote2) {
        if (obj instanceof RubyRegexp) {
            return (RubyRegexp)obj;
        }
        if (!(obj instanceof RubyString)) {
            IRubyObject val = obj.checkStringType();
            if (val.isNil()) {
                throw this.getRuntime().newTypeError("wrong argument type " + obj.getMetaClass() + " (expected Regexp)");
            }
            obj = val;
        }
        return RubyRegexp.newRegexp(this.getRuntime(), ((RubyString)obj).value, 0, quote2);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject scan(ThreadContext context, IRubyObject arg2, Block block) {
        return this.scan(context, arg2, context.getRuntime().getKCode().getEncoding(), block);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject scan19(ThreadContext context, IRubyObject arg2, Block block) {
        return this.scan(context, arg2, this.value.encoding, block);
    }

    private IRubyObject scan(ThreadContext context, IRubyObject arg2, Encoding enc, Block block) {
        RubyRegexp rubyRegex = this.getPattern(arg2, true);
        Regex regex = rubyRegex.getPattern();
        int begin2 = this.value.begin;
        int range = begin2 + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, begin2, range);
        if (block.isGiven()) {
            return this.scanIter(context, rubyRegex, matcher, enc, block, begin2, range);
        }
        return this.scanNoIter(context, rubyRegex, matcher, enc, begin2, range);
    }

    private IRubyObject scanIter(ThreadContext context, RubyRegexp rubyRegex, Matcher matcher, Encoding enc, Block block, int begin2, int range) {
        Ruby runtime2 = context.getRuntime();
        byte[] bytes = this.value.bytes;
        int size2 = this.value.realSize;
        IRubyObject match2 = null;
        Frame frame = context.getPreviousFrame();
        int end2 = 0;
        if (rubyRegex.getPattern().numberOfCaptures() == 0) {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                match2 = rubyRegex.updateBackRef(context, this, frame, matcher);
                ((RubyMatchData)match2).use();
                block.yield(context, this.substr(runtime2, matcher.getBegin(), matcher.getEnd() - matcher.getBegin()).infectBy(rubyRegex));
                this.modifyCheck(bytes, size2);
            }
        } else {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                match2 = rubyRegex.updateBackRef(context, this, frame, matcher);
                ((RubyMatchData)match2).use();
                block.yield(context, this.populateCapturesForScan(runtime2, rubyRegex, matcher, range));
                this.modifyCheck(bytes, size2);
            }
        }
        frame.setBackRef(match2 == null ? context.getRuntime().getNil() : match2);
        return this;
    }

    private IRubyObject scanNoIter(ThreadContext context, RubyRegexp rubyRegex, Matcher matcher, Encoding enc, int begin2, int range) {
        Ruby runtime2 = context.getRuntime();
        RubyArray ary = runtime2.newArray();
        int end2 = 0;
        if (rubyRegex.getPattern().numberOfCaptures() == 0) {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                ary.append(this.substr(runtime2, matcher.getBegin(), matcher.getEnd() - matcher.getBegin()).infectBy(rubyRegex));
            }
        } else {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                ary.append(this.populateCapturesForScan(runtime2, rubyRegex, matcher, range));
            }
        }
        Frame frame = context.getPreviousFrame();
        if (ary.size() > 0) {
            rubyRegex.updateBackRef(context, this, frame, matcher);
        } else {
            frame.setBackRef(runtime2.getNil());
        }
        return ary;
    }

    private int positionEnd(Matcher matcher, Encoding enc, int begin2, int range) {
        int end2 = matcher.getEnd();
        if (matcher.getBegin() == end2) {
            if (this.value.realSize > end2) {
                return end2 + enc.length(this.value.bytes, begin2 + end2, range);
            }
            return end2 + 1;
        }
        return end2;
    }

    private IRubyObject populateCapturesForScan(Ruby runtime2, RubyRegexp regex, Matcher matcher, int range) {
        Region region = matcher.getRegion();
        RubyArray result = this.getRuntime().newArray(region.numRegs);
        for (int i = 1; i < region.numRegs; ++i) {
            int beg = region.beg[i];
            if (beg == -1) {
                result.append(this.getRuntime().getNil());
                continue;
            }
            result.append(this.substr(runtime2, beg, region.end[i] - beg).infectBy(regex));
        }
        return result;
    }

    private final IRubyObject justify(IRubyObject arg0, char jflag) {
        Ruby runtime2 = this.getRuntime();
        int width = RubyFixnum.num2int(arg0);
        int flen = 0;
        int f = RubyString.SPACE_BYTELIST.begin;
        flen = RubyString.SPACE_BYTELIST.realSize;
        byte[] fbuf = RubyString.SPACE_BYTELIST.bytes;
        IRubyObject pad = runtime2.getNil();
        return this.justifyCommon(width, jflag, flen, fbuf, f, runtime2, pad);
    }

    private final IRubyObject justify(IRubyObject arg0, IRubyObject arg1, char jflag) {
        Ruby runtime2 = this.getRuntime();
        int width = RubyFixnum.num2int(arg0);
        int flen = 0;
        RubyString pad = arg1.convertToString();
        ByteList fList = pad.value;
        int f = fList.begin;
        flen = fList.realSize;
        if (flen == 0) {
            throw runtime2.newArgumentError("zero width padding");
        }
        byte[] fbuf = fList.bytes;
        return this.justifyCommon(width, jflag, flen, fbuf, f, runtime2, pad);
    }

    private IRubyObject justifyCommon(int width, char jflag, int flen, byte[] fbuf, int f, Ruby runtime2, IRubyObject pad) {
        int pend;
        if (width < 0 || this.value.realSize >= width) {
            return this.strDup(runtime2);
        }
        ByteList res = new ByteList(width);
        res.realSize = width;
        int p2 = res.begin;
        byte[] pbuf = res.bytes;
        if (jflag != 'l') {
            int n = width - this.value.realSize;
            pend = p2 + (jflag == 'r' ? n : n / 2);
            if (flen <= 1) {
                while (p2 < pend) {
                    pbuf[p2++] = fbuf[f];
                }
            } else {
                int q = f;
                while (p2 + flen <= pend) {
                    System.arraycopy(fbuf, f, pbuf, p2, flen);
                    p2 += flen;
                }
                while (p2 < pend) {
                    pbuf[p2++] = fbuf[q++];
                }
            }
        }
        System.arraycopy(this.value.bytes, this.value.begin, pbuf, p2, this.value.realSize);
        if (jflag != 'r') {
            p2 += this.value.realSize;
            pend = res.begin + width;
            if (flen <= 1) {
                while (p2 < pend) {
                    pbuf[p2++] = fbuf[f];
                }
            } else {
                while (p2 + flen <= pend) {
                    System.arraycopy(fbuf, f, pbuf, p2, flen);
                    p2 += flen;
                }
                while (p2 < pend) {
                    pbuf[p2++] = fbuf[f++];
                }
            }
        }
        RubyString resStr = new RubyString(runtime2, this.getMetaClass(), res);
        resStr.infectBy(this);
        if (flen > 0) {
            resStr.infectBy(pad);
        }
        return resStr;
    }

    public IRubyObject ljust(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.ljust(args2[0]);
            }
            case 2: {
                return this.ljust(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject ljust(IRubyObject arg0) {
        return this.justify(arg0, 'l');
    }

    @JRubyMethod
    public IRubyObject ljust(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 'l');
    }

    public IRubyObject rjust(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.rjust(args2[0]);
            }
            case 2: {
                return this.rjust(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject rjust(IRubyObject arg0) {
        return this.justify(arg0, 'r');
    }

    @JRubyMethod
    public IRubyObject rjust(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 'r');
    }

    public IRubyObject center(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.center(args2[0]);
            }
            case 2: {
                return this.center(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject center(IRubyObject arg0) {
        return this.justify(arg0, 'c');
    }

    @JRubyMethod
    public IRubyObject center(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 'c');
    }

    @JRubyMethod(name={"chop"})
    public IRubyObject chop(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.chop_bang();
        return str;
    }

    @JRubyMethod(name={"chop!"})
    public IRubyObject chop_bang() {
        int end2 = this.value.realSize - 1;
        if (end2 < 0) {
            return this.getRuntime().getNil();
        }
        if (this.value.bytes[this.value.begin + end2] == 10 && end2 > 0 && this.value.bytes[this.value.begin + end2 - 1] == 13) {
            --end2;
        }
        this.view(0, end2);
        return this;
    }

    public RubyString chomp(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.chomp();
            }
            case 1: {
                return this.chomp(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod
    public RubyString chomp() {
        RubyString str = this.strDup(this.getRuntime());
        str.chomp_bang();
        return str;
    }

    @JRubyMethod
    public RubyString chomp(IRubyObject arg0) {
        RubyString str = this.strDup(this.getRuntime());
        str.chomp_bang(arg0);
        return str;
    }

    public IRubyObject chomp_bang(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.chomp_bang();
            }
            case 1: {
                return this.chomp_bang(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"chomp!"})
    public IRubyObject chomp_bang() {
        int len = this.value.length();
        if (len == 0) {
            return this.getRuntime().getNil();
        }
        byte[] buff = this.value.bytes;
        IRubyObject rsObj = this.getRuntime().getGlobalVariables().get("$/");
        if (rsObj == this.getRuntime().getGlobalVariables().getDefaultSeparator()) {
            int realSize = this.value.realSize;
            int begin2 = this.value.begin;
            if (buff[begin2 + len - 1] == 10) {
                if (--realSize > 0 && buff[begin2 + realSize - 1] == 13) {
                    --realSize;
                }
                this.view(0, realSize);
            } else if (buff[begin2 + len - 1] == 13) {
                this.view(0, --realSize);
            } else {
                this.modifyCheck();
                return this.getRuntime().getNil();
            }
            return this;
        }
        return this.chompBangCommon(rsObj);
    }

    @JRubyMethod(name={"chomp!"})
    public IRubyObject chomp_bang(IRubyObject arg0) {
        return this.chompBangCommon(arg0);
    }

    private IRubyObject chompBangCommon(IRubyObject rsObj) {
        if (rsObj.isNil()) {
            return this.getRuntime().getNil();
        }
        RubyString rs = rsObj.convertToString();
        int len = this.value.realSize;
        int begin2 = this.value.begin;
        if (len == 0) {
            return this.getRuntime().getNil();
        }
        byte[] buff = this.value.bytes;
        int rslen = rs.value.realSize;
        if (rslen == 0) {
            while (len > 0 && buff[begin2 + len - 1] == 10) {
                if (--len <= 0 || buff[begin2 + len - 1] != 13) continue;
                --len;
            }
            if (len < this.value.realSize) {
                this.view(0, len);
                return this;
            }
            return this.getRuntime().getNil();
        }
        if (rslen > len) {
            return this.getRuntime().getNil();
        }
        byte newline = rs.value.bytes[rslen - 1];
        if (rslen == 1 && newline == 10) {
            buff = this.value.bytes;
            int realSize = this.value.realSize;
            if (buff[begin2 + len - 1] == 10) {
                if (--realSize > 0 && buff[begin2 + realSize - 1] == 13) {
                    --realSize;
                }
                this.view(0, realSize);
            } else if (buff[begin2 + len - 1] == 13) {
                this.view(0, --realSize);
            } else {
                this.modifyCheck();
                return this.getRuntime().getNil();
            }
            return this;
        }
        if (buff[begin2 + len - 1] == newline && rslen <= 1 || this.value.endsWith(rs.value)) {
            this.view(0, this.value.realSize - rslen);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject lstrip(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.lstrip_bang();
        return str;
    }

    @JRubyMethod(name={"lstrip!"})
    public IRubyObject lstrip_bang() {
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (i = 0; i < this.value.realSize && ASCII.isSpace(this.value.bytes[this.value.begin + i] & 0xFF); ++i) {
        }
        if (i > 0) {
            this.view(i, this.value.realSize - i);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject rstrip(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.rstrip_bang();
        return str;
    }

    @JRubyMethod(name={"rstrip!"})
    public IRubyObject rstrip_bang() {
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (i = this.value.realSize - 1; i >= 0 && this.value.bytes[this.value.begin + i] == 0; --i) {
        }
        while (i >= 0 && ASCII.isSpace(this.value.bytes[this.value.begin + i] & 0xFF)) {
            --i;
        }
        if (i < this.value.realSize - 1) {
            this.view(0, i + 1);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject strip(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.strip_bang();
        return str;
    }

    @JRubyMethod(name={"strip!"})
    public IRubyObject strip_bang() {
        IRubyObject l = this.lstrip_bang();
        IRubyObject r = this.rstrip_bang();
        if (l.isNil() && r.isNil()) {
            return l;
        }
        return this;
    }

    @JRubyMethod(name={"count"}, required=1, rest=true)
    public IRubyObject count(IRubyObject[] args2) {
        if (args2.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        if (this.value.realSize == 0) {
            return this.getRuntime().newFixnum(0);
        }
        boolean[] table = new boolean[256];
        boolean init = true;
        for (int i = 0; i < args2.length; ++i) {
            RubyString s = args2[i].convertToString();
            s.setup_table(table, init);
            init = false;
        }
        int s = this.value.begin;
        int send2 = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        int i = 0;
        while (s < send2) {
            if (!table[buf[s++] & 0xFF]) continue;
            ++i;
        }
        return this.getRuntime().newFixnum(i);
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true)
    public IRubyObject delete(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.getRuntime());
        str.delete_bang(args2);
        return str;
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true)
    public IRubyObject delete_bang(IRubyObject[] args2) {
        int s;
        if (args2.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        boolean[] squeeze2 = new boolean[256];
        boolean init = true;
        for (int i = 0; i < args2.length; ++i) {
            RubyString s2 = args2[i].convertToString();
            s2.setup_table(squeeze2, init);
            init = false;
        }
        this.modify();
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        int t = s = this.value.begin;
        int send2 = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        while (s < send2) {
            if (squeeze2[buf[s] & 0xFF]) {
                modify = true;
            } else {
                buf[t++] = buf[s];
            }
            ++s;
        }
        this.value.realSize = t - this.value.begin;
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"squeeze"}, rest=true)
    public IRubyObject squeeze(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.getRuntime());
        str.squeeze_bang(args2);
        return str;
    }

    @JRubyMethod(name={"squeeze!"}, rest=true)
    public IRubyObject squeeze_bang(IRubyObject[] args2) {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        if (args2.length == 0) {
            for (int i = 0; i < 256; ++i) {
                squeeze2[i] = true;
            }
        } else {
            boolean init = true;
            for (int i = 0; i < args2.length; ++i) {
                RubyString s2 = args2[i].convertToString();
                s2.setup_table(squeeze2, init);
                init = false;
            }
        }
        this.modify();
        int t = s = this.value.begin;
        int send2 = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        int save = -1;
        while (s < send2) {
            int c;
            if ((c = buf[s++] & 0xFF) == save && squeeze2[c]) continue;
            int n = t++;
            save = c;
            buf[n] = (byte)save;
        }
        if (t - this.value.begin != this.value.realSize) {
            this.value.realSize = t - this.value.begin;
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject tr(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.getRuntime());
        str.tr_trans(src, repl, false);
        return str;
    }

    @JRubyMethod(name={"tr!"})
    public IRubyObject tr_bang(IRubyObject src, IRubyObject repl) {
        return this.tr_trans(src, repl, false);
    }

    private final void setup_table(boolean[] table, boolean init) {
        int c;
        int i;
        boolean[] buf = new boolean[256];
        TR tr2 = new TR();
        boolean cflag = false;
        tr2.p = this.value.begin;
        tr2.pend = this.value.begin + this.value.realSize;
        tr2.buf = this.value.bytes;
        tr2.max = 0;
        tr2.now = 0;
        tr2.gen = 0;
        if (this.value.realSize > 1 && this.value.bytes[this.value.begin] == 94) {
            cflag = true;
            ++tr2.p;
        }
        if (init) {
            for (i = 0; i < 256; ++i) {
                table[i] = true;
            }
        }
        for (i = 0; i < 256; ++i) {
            buf[i] = cflag;
        }
        while ((c = this.trnext(tr2)) >= 0) {
            buf[c & 0xFF] = !cflag;
        }
        for (i = 0; i < 256; ++i) {
            table[i] = table[i] && buf[i];
        }
    }

    private final IRubyObject tr_trans(IRubyObject src, IRubyObject repl, boolean sflag) {
        int s;
        int c;
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        ByteList replList = repl.convertToString().value;
        if (replList.realSize == 0) {
            return this.delete_bang(new IRubyObject[]{src});
        }
        ByteList srcList = src.convertToString().value;
        TR trsrc = new TR();
        TR trrepl = new TR();
        boolean cflag = false;
        boolean modify = false;
        trsrc.p = srcList.begin;
        trsrc.pend = srcList.begin + srcList.realSize;
        trsrc.buf = srcList.bytes;
        if (srcList.realSize >= 2 && srcList.bytes[srcList.begin] == 94) {
            cflag = true;
            ++trsrc.p;
        }
        trrepl.p = replList.begin;
        trrepl.pend = replList.begin + replList.realSize;
        trrepl.buf = replList.bytes;
        trrepl.gen = 0;
        trsrc.gen = 0;
        trrepl.now = 0;
        trsrc.now = 0;
        trrepl.max = 0;
        trsrc.max = 0;
        int[] trans = new int[256];
        if (cflag) {
            for (i = 0; i < 256; ++i) {
                trans[i] = 1;
            }
            while ((c = this.trnext(trsrc)) >= 0) {
                trans[c & 0xFF] = -1;
            }
            while ((c = this.trnext(trrepl)) >= 0) {
            }
            for (i = 0; i < 256; ++i) {
                if (trans[i] < 0) continue;
                trans[i] = trrepl.now;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                trans[i] = -1;
            }
            while ((c = this.trnext(trsrc)) >= 0) {
                int r = this.trnext(trrepl);
                if (r == -1) {
                    r = trrepl.now;
                }
                trans[c & 0xFF] = r;
            }
        }
        this.modify();
        int send2 = s + this.value.realSize;
        byte[] sbuf = this.value.bytes;
        if (sflag) {
            int t = s;
            int last2 = -1;
            while (s < send2) {
                byte c0;
                if ((c = trans[(c0 = sbuf[s++]) & 0xFF]) >= 0) {
                    if (last2 == c) continue;
                    last2 = c;
                    sbuf[t++] = (byte)(c & 0xFF);
                    modify = true;
                    continue;
                }
                last2 = -1;
                sbuf[t++] = c0;
            }
            if (this.value.realSize > t - this.value.begin) {
                this.value.realSize = t - this.value.begin;
                modify = true;
            }
        } else {
            for (s = this.value.begin; s < send2; ++s) {
                c = trans[sbuf[s] & 0xFF];
                if (c < 0) continue;
                sbuf[s] = (byte)(c & 0xFF);
                modify = true;
            }
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    private final int trnext(TR t) {
        byte[] buf = t.buf;
        while (t.gen == 0) {
            if (t.p == t.pend) {
                return -1;
            }
            if (t.p < t.pend - 1 && buf[t.p] == 92) {
                ++t.p;
            }
            t.now = buf[t.p++];
            if (t.p < t.pend - 1 && buf[t.p] == 45) {
                ++t.p;
                if (t.p < t.pend) {
                    if (t.now > (buf[t.p] & 0xFF)) {
                        ++t.p;
                        continue;
                    }
                    t.gen = 1;
                    t.max = buf[t.p++] & 0xFF;
                }
            }
            return t.now & 0xFF;
        }
        if (++t.now < t.max) {
            return t.now & 0xFF;
        }
        t.gen = 0;
        return t.max & 0xFF;
    }

    @JRubyMethod
    public IRubyObject tr_s(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.getRuntime());
        str.tr_trans(src, repl, true);
        return str;
    }

    @JRubyMethod(name={"tr_s!"})
    public IRubyObject tr_s_bang(IRubyObject src, IRubyObject repl) {
        return this.tr_trans(src, repl, true);
    }

    @JRubyMethod(name={"each_line", "each"}, frame=true)
    public IRubyObject each_line(ThreadContext context, Block block) {
        return this.each_lineCommon(context, context.getRuntime().getGlobalVariables().get("$/"), block);
    }

    @JRubyMethod(name={"each_line", "each"}, frame=true)
    public IRubyObject each_line(ThreadContext context, IRubyObject arg2, Block block) {
        return this.each_lineCommon(context, arg2, block);
    }

    public IRubyObject each_lineCommon(ThreadContext context, IRubyObject sep, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (sep.isNil()) {
            block.yield(context, this);
            return this;
        }
        RubyString rsep = sep.convertToString();
        ByteList rsepValue = rsep.value;
        int rslen = rsepValue.realSize;
        byte newline = rslen == 0 ? (byte)10 : rsepValue.bytes[rsepValue.begin + rslen - 1];
        int p2 = this.value.begin;
        int end2 = p2 + this.value.realSize;
        int ptr = p2;
        int len = this.value.realSize;
        int s = p2;
        p2 += rslen;
        byte[] strBytes = this.value.bytes;
        while (p2 < end2) {
            if (rslen == 0 && strBytes[p2] == 10) {
                if (strBytes[++p2] == 10) {
                    while (p2 < end2 && strBytes[p2] == 10) {
                        ++p2;
                    }
                }
            } else if (ptr < p2 && strBytes[p2 - 1] == newline && (rslen <= 1 || ByteList.memcmp(rsepValue.bytes, rsepValue.begin, rslen, strBytes, p2 - rslen, rslen) == 0)) {
                block.yield(context, this.makeShared(runtime2, s - ptr, p2 - s).infectBy(this));
                this.modifyCheck(strBytes, len);
                s = p2;
            }
            ++p2;
        }
        if (s != end2) {
            if (p2 > end2) {
                p2 = end2;
            }
            block.yield(context, this.makeShared(runtime2, s - ptr, p2 - s).infectBy(this));
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true, compat=CompatVersion.RUBY1_8)
    public RubyString each_byte(ThreadContext context, Block block) {
        Ruby runtime2 = this.getRuntime();
        for (int i = 0; i < this.value.length(); ++i) {
            block.yield(context, runtime2.newFixnum(this.value.get(i) & 0xFF));
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_byte19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byte(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_byte");
    }

    @JRubyMethod(name={"each_char"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_char(ThreadContext context, Block block) {
        int n;
        int p2;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_char");
        }
        byte[] bytes = this.value.bytes;
        int end2 = p2 + this.value.realSize;
        Encoding enc = this.value.encoding;
        for (p2 = this.value.begin; p2 < end2; p2 += n) {
            n = StringSupport.length(enc, bytes, p2, end2);
            block.yield(context, this.substr(context.getRuntime(), p2, n));
        }
        return this;
    }

    @JRubyMethod(name={"each_codepoint"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        int n;
        int p2;
        if (this.singleByteOptimizable()) {
            return this.each_byte19(context, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_codepoint");
        }
        Ruby runtime2 = context.getRuntime();
        byte[] bytes = this.value.bytes;
        int end2 = p2 + this.value.realSize;
        Encoding enc = this.value.encoding;
        for (p2 = this.value.begin; p2 < end2; p2 += n) {
            int c = StringSupport.codePoint(runtime2, enc, bytes, p2, end2);
            n = StringSupport.codeLength(runtime2, enc, c);
            block.yield(context, runtime2.newFixnum(c));
        }
        return this;
    }

    public RubySymbol intern() {
        String s = this.toString();
        if (s.length() == 0) {
            throw this.getRuntime().newArgumentError("interning empty string");
        }
        if (s.indexOf(0) >= 0) {
            throw this.getRuntime().newArgumentError("symbol string may not contain '\\0'");
        }
        return this.getRuntime().newSymbol(s);
    }

    @JRubyMethod(name={"to_sym", "intern"})
    public RubySymbol to_sym() {
        return this.intern();
    }

    @JRubyMethod(name={"sum"}, optional=1)
    public RubyInteger sum(IRubyObject[] args2) {
        long bitSizeArg;
        if (args2.length > 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + args2.length + " for 1)");
        }
        long bitSize = 16L;
        if (args2.length == 1 && (bitSizeArg = args2[0].convertToInteger().getLongValue()) > 0L) {
            bitSize = bitSizeArg;
        }
        long result = 0L;
        for (int i = 0; i < this.value.length(); ++i) {
            result += (long)(this.value.get(i) & 0xFF);
        }
        return this.getRuntime().newFixnum(bitSize == 0L ? result : result % (long)Math.pow(2.0, bitSize));
    }

    @JRubyMethod(name={"to_c"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_c(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        Frame frame = context.getCurrentFrame();
        IRubyObject backref = frame.getBackRef();
        if (backref != null && backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        IRubyObject s = RuntimeHelpers.invoke(context, (IRubyObject)this, "gsub", (IRubyObject)RubyRegexp.newRegexp(runtime2, Numeric.ComplexPatterns.underscores_pat), runtime2.newString(new ByteList(new byte[]{95})));
        RubyArray a = RubyComplex.str_to_c_internal(context, s);
        frame.setBackRef(backref);
        if (!a.eltInternal(0).isNil()) {
            return a.eltInternal(0);
        }
        return RubyComplex.newComplexCanonicalize(context, RubyFixnum.zero(runtime2));
    }

    @JRubyMethod(name={"to_r"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        Frame frame = context.getCurrentFrame();
        IRubyObject backref = frame.getBackRef();
        if (backref != null && backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        IRubyObject s = RuntimeHelpers.invoke(context, (IRubyObject)this, "gsub", (IRubyObject)RubyRegexp.newRegexp(runtime2, Numeric.ComplexPatterns.underscores_pat), runtime2.newString(new ByteList(new byte[]{95})));
        RubyArray a = RubyRational.str_to_r_internal(context, s);
        frame.setBackRef(backref);
        if (!a.eltInternal(0).isNil()) {
            return a.eltInternal(0);
        }
        return RubyRational.newRationalCanonicalize(context, RubyFixnum.zero(runtime2));
    }

    public static RubyString unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyString result = RubyString.newString(input.getRuntime(), input.unmarshalString());
        input.registerLinkTarget(result);
        return result;
    }

    @JRubyMethod
    public RubyArray unpack(IRubyObject obj) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)obj).value);
    }

    public void empty() {
        this.value = ByteList.EMPTY_BYTELIST;
        this.shareLevel = 2;
    }

    @JRubyMethod(name={"encoding"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encoding(ThreadContext context) {
        return context.getRuntime().getEncodingService().getEncoding(this.value.encoding);
    }

    @JRubyMethod(name={"force_encoding"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject force_encoding(ThreadContext context, IRubyObject enc) {
        this.modify();
        this.associateEncoding(enc.convertToString().toEncoding(context.getRuntime()));
        return this;
    }

    @JRubyMethod(name={"valid_encoding?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject valid_encoding_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        return this.scanForCodeRange() == 48 ? runtime2.getFalse() : runtime2.getTrue();
    }

    @JRubyMethod(name={"ascii_only?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject ascii_only_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        return this.scanForCodeRange() == 16 ? runtime2.getFalse() : runtime2.getTrue();
    }

    public void setValue(CharSequence value2) {
        this.view(ByteList.plain(value2));
    }

    public void setValue(ByteList value2) {
        this.view(value2);
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    public ByteList getByteList() {
        return this.value;
    }

    public String getUnicodeValue() {
        try {
            return new String(this.value.bytes, this.value.begin, this.value.realSize, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Something's seriously broken with encodings", e);
        }
    }

    public IRubyObject to_java() {
        return MiniJava.javaToRuby(this.getRuntime(), new String(this.getBytes()));
    }

    private static final class TR {
        int gen;
        int now;
        int max;
        int p;
        int pend;
        byte[] buf;

        private TR() {
        }
    }
}

