/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings;

import org.jcodings.ApplyAllCaseFoldFunction;
import org.jcodings.CaseFoldCodeItem;
import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.constants.PosixBracket;
import org.jcodings.exception.CharacterPropertyException;

abstract class AbstractEncoding
extends Encoding {
    private final short[] CTypeTable;
    protected static final CaseFoldCodeItem[] EMPTY_FOLD_CODES = new CaseFoldCodeItem[0];

    protected AbstractEncoding(int minLength, int maxLength, short[] CTypeTable) {
        super(minLength, maxLength);
        this.CTypeTable = CTypeTable;
    }

    private static int CTypeToBit(int ctype) {
        return 1 << ctype;
    }

    protected final boolean isCodeCTypeInternal(int code, int ctype) {
        return (this.CTypeTable[code] & AbstractEncoding.CTypeToBit(ctype)) != 0;
    }

    public boolean isNewLine(byte[] bytes, int p2, int end2) {
        return p2 < end2 ? bytes[p2] == 10 : false;
    }

    protected final int asciiMbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end2, byte[] lower) {
        lower[0] = AsciiTables.ToLowerCaseTable[bytes[pp.value] & 0xFF];
        ++pp.value;
        return 1;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end2, byte[] lower) {
        return this.asciiMbcCaseFold(flag, bytes, pp, end2, lower);
    }

    protected final void asciiApplyAllCaseFold(int flag, ApplyAllCaseFoldFunction fun, Object arg2) {
        int[] code = new int[]{0};
        for (int i = 0; i < AsciiTables.LowerMap.length; ++i) {
            code[0] = AsciiTables.LowerMap[i][1];
            fun.apply(AsciiTables.LowerMap[i][0], code, 1, arg2);
            code[0] = AsciiTables.LowerMap[i][0];
            fun.apply(AsciiTables.LowerMap[i][1], code, 1, arg2);
        }
    }

    public void applyAllCaseFold(int flag, ApplyAllCaseFoldFunction fun, Object arg2) {
        this.asciiApplyAllCaseFold(flag, fun, arg2);
    }

    protected final CaseFoldCodeItem[] asciiCaseFoldCodesByString(int flag, byte[] bytes, int p2, int end2) {
        int b = bytes[p2] & 0xFF;
        if (65 <= b && b <= 90) {
            return new CaseFoldCodeItem[]{new CaseFoldCodeItem(1, 1, new int[]{b + 32})};
        }
        if (97 <= b && b <= 122) {
            return new CaseFoldCodeItem[]{new CaseFoldCodeItem(1, 1, new int[]{b - 32})};
        }
        return EMPTY_FOLD_CODES;
    }

    public CaseFoldCodeItem[] caseFoldCodesByString(int flag, byte[] bytes, int p2, int end2) {
        return this.asciiCaseFoldCodesByString(flag, bytes, p2, end2);
    }

    public int propertyNameToCType(byte[] bytes, int p2, int end2) {
        Integer ctype = PosixBracket.PBSTableUpper.get(bytes, p2, end2);
        if (ctype != null) {
            return ctype;
        }
        throw new CharacterPropertyException("invalid character property name {%n}", new String(bytes, p2, end2 - p2));
    }
}

