/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyThread;
import org.jruby.runtime.ThreadContext;

public class ThreadService {
    private Ruby runtime;
    private ThreadContext mainContext;
    private ThreadLocal<SoftReference<ThreadContext>> localContext;
    private ThreadGroup rubyThreadGroup;
    private Map<Thread, RubyThread> rubyThreadMap;
    private ReentrantLock criticalLock = new ReentrantLock();

    public ThreadService(Ruby runtime2) {
        this.runtime = runtime2;
        this.mainContext = ThreadContext.newContext(runtime2);
        this.localContext = new ThreadLocal();
        this.rubyThreadGroup = new ThreadGroup("Ruby Threads#" + runtime2.hashCode());
        this.rubyThreadMap = Collections.synchronizedMap(new WeakHashMap());
        this.localContext.set(new SoftReference<ThreadContext>(this.mainContext));
    }

    public void disposeCurrentThread() {
        this.localContext.set(null);
        this.rubyThreadMap.remove(Thread.currentThread());
    }

    public ThreadContext getCurrentContext() {
        SoftReference sr = null;
        ThreadContext context = null;
        while (context == null) {
            sr = this.localContext.get();
            if (sr == null) {
                sr = this.adoptCurrentThread();
                context = (ThreadContext)sr.get();
            } else {
                context = sr.get();
            }
            if (context != null) continue;
            this.localContext.set(null);
        }
        return context;
    }

    private SoftReference adoptCurrentThread() {
        Thread current2 = Thread.currentThread();
        RubyThread.adopt(this.runtime.getThread(), current2);
        return this.localContext.get();
    }

    public RubyThread getMainThread() {
        return this.mainContext.getThread();
    }

    public void setMainThread(Thread thread, RubyThread rubyThread) {
        this.mainContext.setThread(rubyThread);
        this.rubyThreadMap.put(thread, rubyThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RubyThread[] getActiveRubyThreads() {
        Map<Thread, RubyThread> map = this.rubyThreadMap;
        synchronized (map) {
            ArrayList<RubyThread> rtList = new ArrayList<RubyThread>(this.rubyThreadMap.size());
            for (Map.Entry<Thread, RubyThread> entry : this.rubyThreadMap.entrySet()) {
                Thread t = entry.getKey();
                if (!t.isAlive()) continue;
                rtList.add(entry.getValue());
            }
            RubyThread[] rubyThreads = new RubyThread[rtList.size()];
            rtList.toArray(rubyThreads);
            return rubyThreads;
        }
    }

    public ThreadGroup getRubyThreadGroup() {
        return this.rubyThreadGroup;
    }

    public synchronized ThreadContext registerNewThread(RubyThread thread) {
        ThreadContext context = ThreadContext.newContext(this.runtime);
        this.localContext.set(new SoftReference<ThreadContext>(context));
        this.getCurrentContext().setThread(thread);
        this.associateThread(Thread.currentThread(), thread);
        return context;
    }

    public synchronized void associateThread(Thread javaThread, RubyThread rubyThread) {
        this.rubyThreadMap.put(javaThread, rubyThread);
    }

    public synchronized void unregisterThread(RubyThread thread) {
        this.rubyThreadMap.remove(Thread.currentThread());
        this.getCurrentContext().setThread(null);
        this.localContext.set(null);
    }

    private RubyThread getRubyThreadFromThread(Thread activeThread) {
        RubyThread rubyThread = this.rubyThreadMap.get(activeThread);
        return rubyThread;
    }

    public void setCritical(boolean critical2) {
        if (this.criticalLock.isHeldByCurrentThread()) {
            if (!critical2) {
                this.criticalLock.unlock();
            }
        } else if (critical2) {
            this.criticalLock.lock();
        }
    }

    public boolean getCritical() {
        return this.criticalLock.isHeldByCurrentThread();
    }

    public void waitForCritical() {
        if (this.criticalLock.isLocked()) {
            this.criticalLock.lock();
            this.criticalLock.unlock();
        }
    }
}

