/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemoryPointer;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jna.JNAMemory;
import org.jruby.ext.ffi.jna.JNAMemoryIO;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"JRuby::FFI::MemoryPointer"}, parent="JRuby::FFI::AbstractMemoryPointer")
public class JNAMemoryPointer
extends AbstractMemoryPointer
implements JNAMemory {
    public static final String MEMORY_POINTER_NAME = "MemoryPointer";

    public static RubyClass createMemoryPointerClass(Ruby runtime2) {
        RubyModule module = FFIProvider.getModule(runtime2);
        RubyClass result = module.defineClassUnder(MEMORY_POINTER_NAME, module.getClass("AbstractMemoryPointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(JNAMemoryPointer.class);
        result.defineAnnotatedConstants(JNAMemoryPointer.class);
        return result;
    }

    public JNAMemoryPointer(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass, JNAMemoryIO.wrap(Pointer.NULL), 0L, 0L);
    }

    JNAMemoryPointer(Ruby runtime2, Pointer value2) {
        this(runtime2, JNAMemoryIO.wrap(value2), 0L, Long.MAX_VALUE);
    }

    private JNAMemoryPointer(Ruby runtime2, JNAMemoryPointer ptr, long offset2) {
        this(runtime2, ptr.io, ptr.offset + offset2, ptr.size == Long.MAX_VALUE ? Long.MAX_VALUE : ptr.size - offset2);
    }

    JNAMemoryPointer(Ruby runtime2, MemoryIO io2, long offset2, long size2) {
        super(runtime2, FFIProvider.getModule(runtime2).fastGetClass(MEMORY_POINTER_NAME), io2, offset2, size2);
    }

    @JRubyMethod(name={"allocate", "allocate_direct", "allocateDirect"}, meta=true)
    public static JNAMemoryPointer allocateDirect(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg) {
        int size2 = Util.int32Value(sizeArg);
        JNAMemoryIO io2 = size2 > 0 ? JNAMemoryIO.allocateDirect(size2) : JNAMemoryIO.NULL;
        return new JNAMemoryPointer(context.getRuntime(), io2, 0L, size2);
    }

    @JRubyMethod(name={"allocate", "allocate_direct", "allocateDirect"}, meta=true)
    public static JNAMemoryPointer allocateDirect(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject clearArg) {
        JNAMemoryIO io2;
        int size2 = Util.int32Value(sizeArg);
        JNAMemoryIO jNAMemoryIO = io2 = size2 > 0 ? JNAMemoryIO.allocateDirect(size2) : JNAMemoryIO.NULL;
        if (clearArg.isTrue()) {
            io2.setMemory(0L, size2, (byte)0);
        }
        return new JNAMemoryPointer(context.getRuntime(), io2, 0L, size2);
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        Pointer address2 = this.getAddress();
        String hex2 = address2 != null ? address2.toString() : "native@0x0";
        return RubyString.newString(context.getRuntime(), "MemoryPointer[address=" + hex2 + "]");
    }

    Pointer getAddress() {
        return ((JNAMemoryIO)this.getMemoryIO()).getAddress();
    }

    public Object getNativeMemory() {
        return ((JNAMemoryIO)this.getMemoryIO()).slice(this.offset).getMemory();
    }

    private static final long ptr2long(Pointer ptr) {
        return new PointerByReference(ptr).getPointer().getInt(0L);
    }

    @JRubyMethod(name={"address"})
    public IRubyObject address(ThreadContext context) {
        return context.getRuntime().newFixnum(JNAMemoryPointer.ptr2long(this.getAddress()));
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        String hex2 = Long.toHexString(JNAMemoryPointer.ptr2long(this.getAddress()) + this.offset);
        return RubyString.newString(context.getRuntime(), String.format("#<MemoryPointer address=0x%s>", hex2));
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject value2) {
        return new JNAMemoryPointer(context.getRuntime(), this, RubyNumeric.fix2long(value2));
    }

    @JRubyMethod(name={"put_pointer"}, required=2)
    public IRubyObject put_pointer(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        Pointer ptr;
        if (value2 instanceof JNAMemoryPointer) {
            ptr = ((JNAMemoryPointer)value2).getAddress();
        } else if (value2.isNil()) {
            ptr = Pointer.NULL;
        } else {
            throw context.getRuntime().newArgumentError("Cannot convert argument to pointer");
        }
        ((JNAMemoryIO)this.getMemoryIO()).putPointer(this.getOffset(offset2), ptr);
        return this;
    }

    protected AbstractMemoryPointer getMemoryPointer(Ruby runtime2, long offset2) {
        return new JNAMemoryPointer(runtime2, this.getMemoryIO().getMemoryIO(this.offset + offset2), 0L, Long.MAX_VALUE);
    }
}

