/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;

public class Memory
extends Pointer {
    protected long size;

    public Memory(long size2) {
        this.size = size2;
        if (size2 <= 0L) {
            throw new IllegalArgumentException("Allocation size must be >= 0");
        }
        this.peer = Memory.malloc(size2);
        if (this.peer == 0L) {
            throw new OutOfMemoryError("Cannot allocate " + size2 + " bytes");
        }
    }

    protected Memory() {
    }

    public Pointer share(long offset2) {
        return this.share(offset2, this.getSize() - offset2);
    }

    public Pointer share(long offset2, long sz) {
        this.boundsCheck(offset2, sz);
        return new SharedMemory(offset2);
    }

    public Pointer align(int byteBoundary) {
        if (byteBoundary <= 0) {
            throw new IllegalArgumentException("Byte boundary must be positive: " + byteBoundary);
        }
        long mask = (long)byteBoundary - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        if ((this.peer & (mask ^ 0xFFFFFFFFFFFFFFFFL)) != this.peer) {
            long newPeer = this.peer + (mask ^ 0xFFFFFFFFFFFFFFFFL) & mask;
            return this.share(newPeer - this.peer, this.peer + this.size - newPeer);
        }
        return this;
    }

    protected void finalize() {
        if (this.peer != 0L) {
            Memory.free(this.peer);
            this.peer = 0L;
        }
    }

    public void clear() {
        this.clear(this.size);
    }

    public boolean isValid() {
        return this.peer != 0L;
    }

    public long getSize() {
        return this.size;
    }

    protected void boundsCheck(long off, long sz) {
        if (off < 0L) {
            throw new IndexOutOfBoundsException("Invalid offset: " + off);
        }
        if (off + sz > this.size) {
            String msg = "Bounds exceeds available space : size=" + this.size + ", offset=" + (off + sz);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public void read(long bOff, byte[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 1);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, short[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 2);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, char[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 2);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, int[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 4);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, long[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 8);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, float[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 4);
        super.read(bOff, buf, index2, length2);
    }

    public void read(long bOff, double[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 8);
        super.read(bOff, buf, index2, length2);
    }

    public void write(long bOff, byte[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 1);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, short[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 2);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, char[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 2);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, int[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 4);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, long[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 8);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, float[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 4);
        super.write(bOff, buf, index2, length2);
    }

    public void write(long bOff, double[] buf, int index2, int length2) {
        this.boundsCheck(bOff, length2 * 8);
        super.write(bOff, buf, index2, length2);
    }

    public byte getByte(long offset2) {
        this.boundsCheck(offset2, 1L);
        return super.getByte(offset2);
    }

    public char getChar(long offset2) {
        this.boundsCheck(offset2, 1L);
        return super.getChar(offset2);
    }

    public short getShort(long offset2) {
        this.boundsCheck(offset2, 2L);
        return super.getShort(offset2);
    }

    public int getInt(long offset2) {
        this.boundsCheck(offset2, 4L);
        return super.getInt(offset2);
    }

    public long getLong(long offset2) {
        this.boundsCheck(offset2, 8L);
        return super.getLong(offset2);
    }

    public float getFloat(long offset2) {
        this.boundsCheck(offset2, 4L);
        return super.getFloat(offset2);
    }

    public double getDouble(long offset2) {
        this.boundsCheck(offset2, 8L);
        return super.getDouble(offset2);
    }

    public Pointer getPointer(long offset2) {
        this.boundsCheck(offset2, Pointer.SIZE);
        return super.getPointer(offset2);
    }

    public ByteBuffer getByteBuffer(long offset2, long length2) {
        this.boundsCheck(offset2, length2);
        return super.getByteBuffer(offset2, length2);
    }

    public String getString(long offset2, boolean wide) {
        this.boundsCheck(offset2, 0L);
        return super.getString(offset2, wide);
    }

    public void setByte(long offset2, byte value2) {
        this.boundsCheck(offset2, 1L);
        super.setByte(offset2, value2);
    }

    public void setChar(long offset2, char value2) {
        this.boundsCheck(offset2, Native.WCHAR_SIZE);
        super.setChar(offset2, value2);
    }

    public void setShort(long offset2, short value2) {
        this.boundsCheck(offset2, 2L);
        super.setShort(offset2, value2);
    }

    public void setInt(long offset2, int value2) {
        this.boundsCheck(offset2, 4L);
        super.setInt(offset2, value2);
    }

    public void setLong(long offset2, long value2) {
        this.boundsCheck(offset2, 8L);
        super.setLong(offset2, value2);
    }

    public void setFloat(long offset2, float value2) {
        this.boundsCheck(offset2, 4L);
        super.setFloat(offset2, value2);
    }

    public void setDouble(long offset2, double value2) {
        this.boundsCheck(offset2, 8L);
        super.setDouble(offset2, value2);
    }

    public void setPointer(long offset2, Pointer value2) {
        this.boundsCheck(offset2, Pointer.SIZE);
        super.setPointer(offset2, value2);
    }

    public void setString(long offset2, String value2, boolean wide) {
        if (wide) {
            this.boundsCheck(offset2, (value2.length() + 1) * Native.WCHAR_SIZE);
        } else {
            this.boundsCheck(offset2, value2.getBytes().length + 1);
        }
        super.setString(offset2, value2, wide);
    }

    static native long malloc(long var0);

    static native void free(long var0);

    public String toString() {
        return "allocated@0x" + Long.toHexString(this.peer) + " (" + this.size + " bytes)";
    }

    private class SharedMemory
    extends Memory {
        public SharedMemory(long offset2) {
            this.size = Memory.this.size - offset2;
            this.peer = Memory.this.peer + offset2;
        }

        protected void finalize() {
        }

        protected void boundsCheck(long off, long sz) {
            Memory.this.boundsCheck(this.peer - Memory.this.peer + off, sz);
        }

        public String toString() {
            return super.toString() + " (shared from " + Memory.this.toString() + ")";
        }
    }
}

