/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Constants;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.ExternalScript;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.JarredScript;
import org.jruby.runtime.load.JavaCompiledScript;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.JRubyFile;

public class LoadService {
    protected static final String[] sourceSuffixes = new String[]{".class", ".rb"};
    protected static final String[] extensionSuffixes = new String[]{".so", ".jar"};
    protected static final String[] allSuffixes = new String[]{".class", ".rb", ".so", ".jar"};
    protected static final Pattern sourcePattern = Pattern.compile("\\.(?:rb)$");
    protected static final Pattern extensionPattern = Pattern.compile("\\.(?:so|o|dll|jar)$");
    protected RubyArray loadPath;
    protected RubyArray loadedFeatures;
    protected List loadedFeaturesInternal;
    protected final Map<String, Library> builtinLibraries = new HashMap<String, Library>();
    protected final Map<String, JarFile> jarFiles = new HashMap<String, JarFile>();
    protected final Map<String, IAutoloadMethod> autoloadMap = new HashMap<String, IAutoloadMethod>();
    protected final Ruby runtime;

    public LoadService(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public void init(List additionalDirectories) {
        String jrubyHome;
        RubyString env_rubylib;
        this.loadPath = RubyArray.newArray(this.runtime);
        this.loadedFeatures = RubyArray.newArray(this.runtime);
        this.loadedFeaturesInternal = Collections.synchronizedList(this.loadedFeatures);
        Iterator iter = additionalDirectories.iterator();
        while (iter.hasNext()) {
            this.addPath((String)iter.next());
        }
        RubyHash env = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
        if (env.has_key_p(env_rubylib = this.runtime.newString("RUBYLIB")).isTrue()) {
            String rubylib = env.op_aref(this.runtime.getCurrentContext(), env_rubylib).toString();
            String[] paths = rubylib.split(File.pathSeparator);
            for (int i = 0; i < paths.length; ++i) {
                this.addPath(paths[i]);
            }
        }
        if (!Ruby.isSecurityRestricted() && (jrubyHome = this.runtime.getJRubyHome()) != null) {
            char sep = '/';
            String rubyDir = jrubyHome + sep + "lib" + sep + "ruby" + sep;
            if (this.runtime.getInstanceConfig().getCompatVersion() == CompatVersion.RUBY1_9) {
                this.addPath(rubyDir + "site_ruby" + sep + Constants.RUBY1_9_MAJOR_VERSION);
                this.addPath(rubyDir + "site_ruby");
                this.addPath(rubyDir + Constants.RUBY1_9_MAJOR_VERSION);
                this.addPath(rubyDir + Constants.RUBY1_9_MAJOR_VERSION + sep + "java");
            }
            this.addPath(rubyDir + "site_ruby" + sep + Constants.RUBY_MAJOR_VERSION);
            this.addPath(rubyDir + "site_ruby");
            this.addPath(rubyDir + Constants.RUBY_MAJOR_VERSION);
            this.addPath(rubyDir + Constants.RUBY_MAJOR_VERSION + sep + "java");
            this.addPath("lib" + sep + "ruby" + sep + Constants.RUBY_MAJOR_VERSION);
        }
        if (this.runtime.getSafeLevel() == 0) {
            this.addPath(".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPath(String path2) {
        if (path2 == null || path2.length() == 0) {
            return;
        }
        RubyArray rubyArray = this.loadPath;
        synchronized (rubyArray) {
            this.loadPath.append(this.runtime.newString(path2.replace('\\', '/')));
        }
    }

    public void load(String file2, boolean wrap2) {
        if (!this.runtime.getProfile().allowLoad(file2)) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
        Library library = this.findLibrary(file2, false);
        if (library == null && (library = this.findLibraryWithClassloaders(file2)) == null) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
        try {
            library.load(this.runtime, wrap2);
        }
        catch (IOException e) {
            if (this.runtime.getDebug().isTrue()) {
                e.printStackTrace();
            }
            throw this.runtime.newLoadError("IO error -- " + file2);
        }
    }

    public boolean smartLoad(String file2) {
        RubyString loadNameRubyString;
        int i;
        if (file2.equals("")) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
        Library library = null;
        String loadName = file2;
        String[] extensionsToSearch = null;
        if (file2.lastIndexOf(46) > file2.lastIndexOf(47)) {
            Matcher matcher = null;
            matcher = sourcePattern.matcher(file2);
            if (matcher.find()) {
                extensionsToSearch = sourceSuffixes;
                file2 = file2.substring(0, matcher.start());
            } else {
                matcher = extensionPattern.matcher(file2);
                if (matcher.find()) {
                    extensionsToSearch = extensionSuffixes;
                    file2 = file2.substring(0, matcher.start());
                } else {
                    extensionsToSearch = allSuffixes;
                }
            }
        } else {
            extensionsToSearch = allSuffixes;
        }
        for (i = 0; i < extensionsToSearch.length; ++i) {
            library = Ruby.isSecurityRestricted() ? this.findLibrary(file2 + extensionsToSearch[i], false) : this.findLibrary(file2 + extensionsToSearch[i], true);
            if (library == null) continue;
            loadName = file2 + extensionsToSearch[i];
            break;
        }
        if (library == null) {
            for (i = 0; i < extensionsToSearch.length; ++i) {
                library = this.findLibraryWithClassloaders(file2 + extensionsToSearch[i]);
                if (library == null) continue;
                loadName = file2 + extensionsToSearch[i];
                break;
            }
        }
        library = this.tryLoadExtension(library, file2);
        Script script = null;
        if (library == null) {
            int lastSlashIndex;
            String className = file2;
            if ((className = className.replaceFirst("^\\.\\/", "")).lastIndexOf(".") != -1) {
                className = className.substring(0, className.lastIndexOf("."));
            }
            if ((lastSlashIndex = (className = className.replace("-", "_minus_").replace('.', '_')).lastIndexOf(47)) > -1 && lastSlashIndex < className.length() - 1 && !Character.isJavaIdentifierStart(className.charAt(lastSlashIndex + 1))) {
                className = lastSlashIndex == -1 ? "_" + className : className.substring(0, lastSlashIndex + 1) + "_" + className.substring(lastSlashIndex + 1);
            }
            className = className.replace('/', '.');
            try {
                Class<?> scriptClass = Class.forName(className);
                script = (Script)scriptClass.newInstance();
            }
            catch (Exception cnfe) {
                throw this.runtime.newLoadError("no such file to load -- " + file2);
            }
        }
        if (this.loadedFeaturesInternal.contains(loadNameRubyString = this.runtime.newString(loadName))) {
            return false;
        }
        try {
            this.loadedFeaturesInternal.add(loadNameRubyString);
            if (script != null) {
                this.runtime.loadScript(script);
                return true;
            }
            library.load(this.runtime, false);
            return true;
        }
        catch (Throwable e) {
            if (library instanceof JarredScript && file2.endsWith(".jar")) {
                return true;
            }
            this.loadedFeaturesInternal.remove(loadNameRubyString);
            if (e instanceof RaiseException) {
                throw (RaiseException)e;
            }
            if (this.runtime.getDebug().isTrue()) {
                e.printStackTrace();
            }
            RaiseException re2 = this.runtime.newLoadError("IO error -- " + file2);
            re2.initCause(e);
            throw re2;
        }
    }

    public boolean require(String file2) {
        if (!this.runtime.getProfile().allowRequire(file2)) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
        return this.smartLoad(file2);
    }

    public IRubyObject getLoadPath() {
        return this.loadPath;
    }

    public IRubyObject getLoadedFeatures() {
        return this.loadedFeatures;
    }

    public IAutoloadMethod autoloadFor(String name2) {
        return this.autoloadMap.get(name2);
    }

    public void removeAutoLoadFor(String name2) {
        this.autoloadMap.remove(name2);
    }

    public IRubyObject autoload(String name2) {
        IAutoloadMethod loadMethod = this.autoloadMap.remove(name2);
        if (loadMethod != null) {
            return loadMethod.load(this.runtime, name2);
        }
        return null;
    }

    public void addAutoload(String name2, IAutoloadMethod loadMethod) {
        this.autoloadMap.put(name2, loadMethod);
    }

    public void addBuiltinLibrary(String name2, Library library) {
        this.builtinLibraries.put(name2, library);
    }

    public void removeBuiltinLibrary(String name2) {
        this.builtinLibraries.remove(name2);
    }

    public void removeInternalLoadedFeature(String name2) {
        this.loadedFeaturesInternal.remove(name2);
    }

    private Library findLibrary(String file2, boolean checkCWD) {
        if (this.builtinLibraries.containsKey(file2)) {
            return this.builtinLibraries.get(file2);
        }
        return this.createLibrary(file2, this.findFile(file2, checkCWD));
    }

    private Library findLibraryWithClassloaders(String file2) {
        return this.createLibrary(file2, this.findFileInClasspath(file2));
    }

    private Library createLibrary(String file2, LoadServiceResource resource2) {
        if (resource2 == null) {
            return null;
        }
        if (file2.endsWith(".jar")) {
            return new JarredScript(resource2);
        }
        if (file2.endsWith(".class")) {
            return new JavaCompiledScript(resource2);
        }
        return new ExternalScript(resource2, file2);
    }

    private LoadServiceResource findFile(String name2, boolean checkCWD) {
        Object file2;
        if (name2.startsWith("jar:")) {
            try {
                return new LoadServiceResource(new URL(name2), name2);
            }
            catch (MalformedURLException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
        }
        if (name2.startsWith("file:") && name2.indexOf("!/") != -1) {
            try {
                file2 = new JarFile(name2.substring(5, name2.indexOf("!/")));
                String filename2 = name2.substring(name2.indexOf("!/") + 2);
                if (((JarFile)file2).getJarEntry(filename2) != null) {
                    return new LoadServiceResource(new URL("jar:" + name2), name2);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Iterator pathIter = this.loadPath.getList().iterator();
        while (pathIter.hasNext()) {
            Object current2;
            String entry = ((IRubyObject)pathIter.next()).toString();
            if (entry.startsWith("jar:") || entry.endsWith(".jar") || entry.startsWith("file:") && entry.indexOf("!/") != -1) {
                String before;
                current2 = this.jarFiles.get(entry);
                String after = entry.startsWith("file:") && entry.indexOf("!/") != -1 ? entry.substring(entry.indexOf("!/") + 2) + "/" : "";
                String string2 = before = entry.startsWith("file:") && entry.indexOf("!/") != -1 ? entry.substring(0, entry.indexOf("!/")) : entry;
                if (null == current2) {
                    try {
                        current2 = entry.startsWith("jar:") ? new JarFile(entry.substring(4)) : (entry.endsWith(".jar") ? new JarFile(entry) : new JarFile(entry.substring(5, entry.indexOf("!/"))));
                        this.jarFiles.put(entry, (JarFile)current2);
                    }
                    catch (ZipException ignored) {
                        if (this.runtime.getInstanceConfig().isVerbose()) {
                            this.runtime.getErr().println("ZipException trying to access " + entry + ", stack trace follows:");
                            ignored.printStackTrace(this.runtime.getErr());
                        }
                    }
                    catch (FileNotFoundException ignored) {
                    }
                    catch (IOException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
                String canonicalEntry = after + name2;
                if (after.length() > 0) {
                    try {
                        canonicalEntry = new File(after + name2).getCanonicalPath().substring(new File(".").getCanonicalPath().length() + 1).replaceAll("\\\\", "/");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (current2 != null && ((JarFile)current2).getJarEntry(canonicalEntry) != null) {
                    try {
                        if (entry.endsWith(".jar")) {
                            return new LoadServiceResource(new URL("jar:file:" + entry + "!/" + canonicalEntry), "/" + name2);
                        }
                        if (entry.startsWith("file:")) {
                            return new LoadServiceResource(new URL("jar:" + before + "!/" + canonicalEntry), entry + "/" + name2);
                        }
                        return new LoadServiceResource(new URL("jar:file:" + entry.substring(4) + "!/" + name2), entry + name2);
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
            }
            try {
                if (Ruby.isSecurityRestricted() || !((File)(current2 = JRubyFile.create(JRubyFile.create(this.runtime.getCurrentDirectory(), entry).getAbsolutePath(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), name2)))).isFile()) continue;
                try {
                    String resourcePath = name2.startsWith("./") ? name2 : ((JRubyFile)current2).getPath();
                    return new LoadServiceResource(((File)current2).toURI().toURL(), resourcePath);
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
            catch (SecurityException secEx) {
            }
        }
        if (checkCWD) {
            try {
                file2 = JRubyFile.create(this.runtime.getCurrentDirectory(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), name2));
                if (((File)file2).isFile() && ((File)file2).isAbsolute()) {
                    try {
                        return new LoadServiceResource(((File)file2).toURI().toURL(), name2);
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
            }
            catch (IllegalArgumentException illArgEx) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    private LoadServiceResource findFileInClasspath(String name2) {
        ClassLoader classLoader = this.runtime.getJRubyClassLoader();
        if (Ruby.isSecurityRestricted() && classLoader == null) {
            classLoader = this.runtime.getInstanceConfig().getLoader();
        }
        Iterator pathIter = this.loadPath.getList().iterator();
        while (pathIter.hasNext()) {
            URL loc;
            String entry = pathIter.next().toString();
            if (entry.charAt(0) == '/' || entry.length() > 1 && entry.charAt(1) == ':' || !this.isRequireable(loc = classLoader.getResource(entry + "/" + name2))) continue;
            return new LoadServiceResource(loc, loc.getPath());
        }
        if (name2.charAt(0) == '/' || name2.length() > 1 && name2.charAt(1) == ':') {
            return null;
        }
        URL loc = classLoader.getResource(name2);
        return this.isRequireable(loc) ? new LoadServiceResource(loc, loc.getPath()) : null;
    }

    private Library tryLoadExtension(Library library, String file2) {
        Library oldLibrary = library;
        if ((library == null || library instanceof JarredScript) && !file2.equalsIgnoreCase("")) {
            String[] all = file2.split("/");
            StringBuilder finName = new StringBuilder();
            int j = all.length - 1;
            for (int i = 0; i < j; ++i) {
                finName.append(all[i].toLowerCase()).append(".");
            }
            try {
                String[] last2 = all[all.length - 1].split("_");
                int j2 = last2.length;
                for (int i = 0; i < j2; ++i) {
                    finName.append(Character.toUpperCase(last2[i].charAt(0))).append(last2[i].substring(1));
                }
                finName.append("Service");
                String className = finName.toString().replaceAll("^\\.*", "");
                if (library instanceof JarredScript) {
                    this.runtime.getJRubyClassLoader().addURL(((JarredScript)library).getResource().getURL());
                }
                Class theClass = this.runtime.getJavaSupport().loadJavaClassQuiet(className);
                library = new ClassExtensionLibrary(theClass);
            }
            catch (Exception ee) {
                library = null;
                this.runtime.getGlobalVariables().set("$!", this.runtime.getNil());
            }
        }
        if (library == null && oldLibrary != null) {
            library = oldLibrary;
        }
        return library;
    }

    private boolean isRequireable(URL loc) {
        if (loc != null) {
            if (loc.getProtocol().equals("file") && new File(loc.getFile()).isDirectory()) {
                return false;
            }
            try {
                loc.openConnection();
                return true;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return false;
    }
}

