/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.management.MethodCache;
import org.jruby.util.collections.WeakHashSet;

public class CacheMap {
    private final AtomicInteger addCount = new AtomicInteger(0);
    private final AtomicInteger removeCount = new AtomicInteger(0);
    private final AtomicInteger moduleIncludeCount = new AtomicInteger(0);
    private final AtomicInteger moduleTriggeredRemoveCount = new AtomicInteger(0);
    private final AtomicInteger flushTriggeredRemoveCount = new AtomicInteger(0);
    private final AtomicInteger flushCount = new AtomicInteger(0);
    private final Map<DynamicMethod, Set<CacheSite>> mappings = new WeakHashMap<DynamicMethod, Set<CacheSite>>();

    public CacheMap(Ruby ruby) {
        ruby.getBeanManager().register(new MethodCache(this));
    }

    public int getAddCount() {
        return this.addCount.get();
    }

    public int getRemoveCount() {
        return this.removeCount.get();
    }

    public int getModuleIncludeCount() {
        return this.moduleIncludeCount.get();
    }

    public int getModuleTriggeredRemoveCount() {
        return this.moduleTriggeredRemoveCount.get();
    }

    public int getFlushCount() {
        return this.flushCount.get();
    }

    public synchronized void flush() {
        int totalRemoved = 0;
        for (DynamicMethod method2 : this.mappings.keySet()) {
            Set<CacheSite> cacheSites = this.mappings.get(method2);
            if (cacheSites == null) continue;
            for (CacheSite site : cacheSites) {
                ++totalRemoved;
                site.removeCachedMethod();
            }
        }
        this.mappings.clear();
        this.flushTriggeredRemoveCount.addAndGet(totalRemoved);
        this.removeCount.addAndGet(totalRemoved);
        this.flushCount.incrementAndGet();
    }

    public synchronized void add(DynamicMethod method2, CacheSite site) {
        Set<CacheSite> siteList = this.mappings.get(method2);
        if (siteList == null) {
            siteList = new WeakHashSet<CacheSite>();
            this.mappings.put(method2, siteList);
        }
        siteList.add(site);
        this.addCount.incrementAndGet();
    }

    public synchronized void remove(DynamicMethod method2) {
        Set<CacheSite> siteList = this.mappings.remove(method2);
        if (siteList == null) {
            return;
        }
        for (CacheSite site : siteList) {
            if (site == null) continue;
            site.removeCachedMethod();
        }
        this.removeCount.incrementAndGet();
    }

    public synchronized void moduleIncluded(RubyModule targetModule, RubyModule includedModule) {
        int totalRemoved = 0;
        for (String methodName : includedModule.getMethods().keySet()) {
            for (RubyModule current2 = targetModule; current2 != null; current2 = current2.getSuperClass()) {
                Set<CacheSite> adapters;
                DynamicMethod method2;
                if (current2 == includedModule || (method2 = current2.getMethods().get(methodName)) == null || (adapters = this.mappings.remove(method2)) == null) continue;
                for (CacheSite adapter : adapters) {
                    ++totalRemoved;
                    adapter.removeCachedMethod();
                }
            }
        }
        this.moduleTriggeredRemoveCount.addAndGet(totalRemoved);
        this.removeCount.addAndGet(totalRemoved);
        this.moduleIncludeCount.incrementAndGet();
    }

    public static interface CacheSite {
        public void removeCachedMethod();
    }
}

