/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaInterfaceTemplate {
    public static RubyModule createJavaInterfaceTemplateModule(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyModule javaInterfaceTemplate = runtime2.defineModule("JavaInterfaceTemplate");
        RubyClass singleton = javaInterfaceTemplate.getSingletonClass();
        singleton.addReadAttribute(context, "java_class");
        singleton.defineAnnotatedMethods(JavaInterfaceTemplate.class);
        return javaInterfaceTemplate;
    }

    @JRubyMethod(backtrace=true, visibility=Visibility.PRIVATE)
    public static IRubyObject implement(ThreadContext context, IRubyObject self, IRubyObject clazz) {
        Ruby runtime2 = context.getRuntime();
        if (!(clazz instanceof RubyModule)) {
            throw runtime2.newTypeError(clazz, runtime2.getModule());
        }
        RubyModule targetModule = (RubyModule)clazz;
        JavaClass javaClass = (JavaClass)self.getInstanceVariables().fastGetInstanceVariable("@java_class");
        Method[] javaInstanceMethods = javaClass.javaClass().getMethods();
        JavaMethod dummyMethod = new JavaMethod(targetModule, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return context.getRuntime().getNil();
            }
        };
        for (int i = 0; i < javaInstanceMethods.length; ++i) {
            Method method2 = javaInstanceMethods[i];
            String name2 = method2.getName();
            if (targetModule.searchMethod(name2) != UndefinedMethod.INSTANCE) continue;
            targetModule.addMethod(name2, dummyMethod);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(frame=true)
    public static IRubyObject append_features(ThreadContext context, IRubyObject self, IRubyObject clazz, Block block) {
        if (clazz instanceof RubyClass) {
            JavaInterfaceTemplate.appendFeaturesToClass(context, self, (RubyClass)clazz);
        } else if (clazz instanceof RubyModule) {
            JavaInterfaceTemplate.appendFeaturesToModule(context, self, (RubyModule)clazz);
        } else {
            throw context.getRuntime().newTypeError("received " + clazz + ", expected Class/Module");
        }
        return RuntimeHelpers.invokeAs(context, self.getMetaClass().getSuperClass(), self, "append_features", new IRubyObject[]{clazz}, CallType.SUPER, block);
    }

    private static void appendFeaturesToClass(ThreadContext context, IRubyObject self, RubyClass clazz) {
        IRubyObject javaProxyClass;
        IRubyObject javaClass;
        Ruby runtime2 = context.getRuntime();
        IRubyObject javaClassObj = self.getInstanceVariables().fastGetInstanceVariable("@java_class");
        if (javaClassObj == null) {
            javaClassObj = runtime2.getNil();
            self.getInstanceVariables().setInstanceVariable("@java_class", javaClassObj);
        }
        if ((javaClass = clazz.getInstanceVariables().fastGetInstanceVariable("@java_class")) == null) {
            javaClass = runtime2.getNil();
            clazz.getInstanceVariables().fastSetInstanceVariable("@java_class", javaClass);
        }
        if ((javaProxyClass = clazz.getInstanceVariables().fastGetInstanceVariable("@java_proxy_class")) == null) {
            javaProxyClass = runtime2.getNil();
            clazz.getInstanceVariables().fastSetInstanceVariable("@java_proxy_class", javaProxyClass);
        }
        if (javaClass.isTrue() && !clazz.getSingletonClass().isMethodBound("java_proxy_class", false) || javaProxyClass.isTrue()) {
            throw runtime2.newArgumentError("can not add Java interface to existing Java class");
        }
        IRubyObject javaInterfaces = clazz.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
        if (javaInterfaces == null) {
            javaInterfaces = runtime2.getNil();
            clazz.getInstanceVariables().fastSetInstanceVariable("@java_interfaces", javaInterfaces);
        }
        if (javaInterfaces.isNil()) {
            RubyClass singleton;
            javaInterfaces = RubyArray.newArray(runtime2, javaClassObj);
            clazz.getInstanceVariables().fastSetInstanceVariable("@java_interfaces", javaInterfaces);
            if (!clazz.isMethodBound("__jcreate!", false)) {
                singleton = clazz.getSingletonClass();
                singleton.addReadAttribute(context, "java_interfaces");
                DynamicMethod newMethod = singleton.searchMethod("new").dup();
                singleton.addMethod("__jredef_new", newMethod);
                newMethod.setVisibility(Visibility.PRIVATE);
                singleton.addMethod("new", new JavaMethod(singleton, Visibility.PUBLIC){

                    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                        assert (self instanceof RubyClass) : "new defined on non-class";
                        RubyClass clazzSelf = (RubyClass)self;
                        IRubyObject newObj = clazzSelf.allocate();
                        RuntimeHelpers.invoke(context, newObj, "__jcreate!", args2, block);
                        RuntimeHelpers.invoke(context, newObj, "initialize", args2, block);
                        return newObj;
                    }
                });
                clazz.addMethod("__jcreate!", new JavaMethod.JavaMethodNoBlock(clazz, Visibility.PRIVATE){

                    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
                        IRubyObject javaInterfaces = RuntimeHelpers.invoke(context, self.getMetaClass(), "java_interfaces");
                        return JavaInterfaceTemplate.jcreateProxy(self, javaInterfaces, args2);
                    }
                });
                clazz.addMethod("__jcreate_meta!", new JavaMethod.JavaMethodNoBlock(clazz, Visibility.PRIVATE){

                    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
                        IRubyObject javaInterfaces = RuntimeHelpers.invoke(context, self.getSingletonClass(), "java_interfaces");
                        IRubyObject result = JavaInterfaceTemplate.jcreateProxy(self, javaInterfaces, args2);
                        return result;
                    }
                });
                clazz.includeModule(runtime2.getModule("JavaProxyMethods"));
                clazz.addMethod("java_class", new JavaMethod.JavaMethodZero(clazz, Visibility.PUBLIC){

                    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                        return ((JavaObject)self.dataGetStruct()).java_class();
                    }
                });
                clazz.defineAlias("old_eqq", "===");
                clazz.addMethod("===", new JavaMethod.JavaMethodOne(clazz, Visibility.PUBLIC){

                    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                        if (arg2.respondsTo("java_object")) {
                            IRubyObject interfaces2 = self.getMetaClass().getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                            assert (interfaces2 instanceof RubyArray) : "interface list was not an array";
                            return context.getRuntime().newBoolean(((RubyArray)interfaces2).op_diff(((JavaClass)((JavaObject)arg2.dataGetStruct()).java_class()).interfaces()).equals(RubyArray.newArray(context.getRuntime())));
                        }
                        return RuntimeHelpers.invoke(context, self, "old_eqq", arg2);
                    }
                });
            }
            if (!clazz.isMethodBound("implement", false)) {
                singleton = clazz.getSingletonClass();
                singleton.addMethod("implement", new JavaMethod.JavaMethodOne(clazz, Visibility.PRIVATE){

                    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                        IRubyObject javaInterfaces = self.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                        if (javaInterfaces != null && ((RubyArray)javaInterfaces).includes(context, arg2)) {
                            return RuntimeHelpers.invoke(context, arg2, "implement", self);
                        }
                        return context.getRuntime().getNil();
                    }
                });
                singleton.addMethod("implement_all", new JavaMethod.JavaMethodOne(clazz, Visibility.PRIVATE){

                    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                        RubyArray javaInterfaces = (RubyArray)self.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                        for (int i = 0; i < javaInterfaces.size(); ++i) {
                            RuntimeHelpers.invoke(context, Java.JavaUtilities.get_interface_module(self, javaInterfaces.eltInternal(i)), "implement", self);
                        }
                        return javaInterfaces;
                    }
                });
            } else if (!javaInterfaces.isFrozen() && !((RubyArray)javaInterfaces).includes(context, javaClass)) {
                ((RubyArray)javaInterfaces).append(javaClass);
            }
        }
    }

    private static IRubyObject jcreateProxy(IRubyObject self, IRubyObject interfaces2, IRubyObject[] args2) {
        if (!interfaces2.isFrozen()) {
            interfaces2.setFrozen(true);
        }
        IRubyObject newObject = Java.new_proxy_instance2(self, self, interfaces2, Block.NULL_BLOCK);
        return Java.JavaUtilities.set_java_object(self, self, newObject);
    }

    private static void appendFeaturesToModule(ThreadContext context, IRubyObject self, RubyModule module) {
        Ruby runtime2 = context.getRuntime();
        if (module.getInstanceVariables().fastHasInstanceVariable("@java_class") && module.getInstanceVariables().fastGetInstanceVariable("@java_class").isTrue()) {
            throw runtime2.newTypeError("can not add Java interface to existing Java interface");
        }
        if (!module.getInstanceVariables().fastHasInstanceVariable("@java_interface_mods")) {
            final RubyArray javaInterfaceMods = RubyArray.newArray(runtime2, self);
            RubyClass singleton = module.getSingletonClass();
            singleton.addMethod("append_features", new JavaMethod.JavaMethodOneBlock((RubyModule)singleton, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2, Block block) {
                    for (int i = 0; i < javaInterfaceMods.size(); ++i) {
                        RubyModule ifcModule = (RubyModule)javaInterfaceMods.eltInternal(i);
                        ifcModule.append_features(arg2);
                    }
                    return RuntimeHelpers.invokeAs(context, clazz.getSuperClass(), self, name2, new IRubyObject[]{arg2}, CallType.SUPER, block);
                }
            });
        } else {
            RubyArray javaInterfaceMods = (RubyArray)module.getInstanceVariables().fastGetInstanceVariable("@java_interface_mods");
            if (!javaInterfaceMods.includes(context, self)) {
                javaInterfaceMods.append(self);
            }
        }
    }

    @JRubyMethod
    public static IRubyObject extended(ThreadContext context, IRubyObject self, IRubyObject object) {
        if (!(self instanceof RubyModule)) {
            throw context.getRuntime().newTypeError(self, context.getRuntime().getModule());
        }
        RubyClass singleton = object.getSingletonClass();
        singleton.include(new IRubyObject[]{self});
        return singleton;
    }

    @JRubyMethod(name={"[]"}, rest=true, backtrace=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        if (args2.length == 0) {
            return Java.JavaUtilities.get_proxy_class(self, ((JavaClass)RuntimeHelpers.invoke(context, self, "java_class")).array_class());
        }
        RubyClass arrayJavaProxyCreator = context.getRuntime().getClass("ArrayJavaProxyCreator");
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 1, args2.length);
        newArgs[0] = RuntimeHelpers.invoke(context, self, "java_class");
        return RuntimeHelpers.invoke(context, (IRubyObject)arrayJavaProxyCreator, "new", newArgs);
    }

    @JRubyMethod(rest=true, backtrace=true)
    public static IRubyObject impl(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        IRubyObject proxy2 = Java.JavaUtilities.get_deprecated_interface_proxy(context, self, self.getInstanceVariables().fastGetInstanceVariable("@java_class"));
        return RuntimeHelpers.invoke(context, proxy2, "impl", args2, block);
    }

    @JRubyMethod(name={"new"}, rest=true, backtrace=true)
    public static IRubyObject rbNew(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        IRubyObject proxy2 = Java.JavaUtilities.get_deprecated_interface_proxy(context, self, self.getInstanceVariables().fastGetInstanceVariable("@java_class"));
        return RuntimeHelpers.invoke(context, proxy2, "new", args2, block);
    }
}

