/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.sun.jna.ptr.IntByReference;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"UNIXServer"}, parent="UNIXSocket")
public class RubyUNIXServer
extends RubyUNIXSocket {
    private static ObjectAllocator UNIXSERVER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyUNIXServer(runtime2, klass);
        }
    };

    static void createUNIXServer(Ruby runtime2) {
        RubyClass rb_cUNIXServer = runtime2.defineClass("UNIXServer", runtime2.fastGetClass("UNIXSocket"), UNIXSERVER_ALLOCATOR);
        runtime2.getObject().fastSetConstant("UNIXserver", rb_cUNIXServer);
        rb_cUNIXServer.defineAnnotatedMethods(RubyUNIXServer.class);
    }

    public RubyUNIXServer(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject path2) throws Exception {
        this.init_unixsock(path2, true);
        return this;
    }

    @JRubyMethod
    public IRubyObject accept() throws Exception {
        RubyUNIXSocket.LibCSocket.sockaddr_un from = new RubyUNIXSocket.LibCSocket.sockaddr_un();
        int fd2 = INSTANCE.accept(this.fd, from, new IntByReference(106));
        if (fd2 < 0) {
            this.rb_sys_fail(null);
        }
        Ruby runtime2 = this.getRuntime();
        RubyUNIXSocket sock = (RubyUNIXSocket)RuntimeHelpers.invoke(runtime2.getCurrentContext(), runtime2.fastGetClass("UNIXSocket"), "allocate");
        sock.fd = fd2;
        sock.fpath = new String(from.sun_path);
        sock.init_sock();
        return sock;
    }

    @JRubyMethod
    public IRubyObject accept_nonblock() throws Exception {
        RubyUNIXSocket.LibCSocket.sockaddr_un from = new RubyUNIXSocket.LibCSocket.sockaddr_un();
        IntByReference fromlen = new IntByReference(106);
        int flags = INSTANCE.fcntl(this.fd, 3, 0);
        INSTANCE.fcntl(this.fd, 4, flags | 4);
        int fd2 = INSTANCE.accept(this.fd, from, new IntByReference(106));
        if (fd2 < 0) {
            this.rb_sys_fail(null);
        }
        Ruby runtime2 = this.getRuntime();
        RubyUNIXSocket sock = (RubyUNIXSocket)RuntimeHelpers.invoke(runtime2.getCurrentContext(), runtime2.fastGetClass("UNIXSocket"), "allocate");
        sock.fd = fd2;
        sock.fpath = new String(from.sun_path);
        sock.init_sock();
        return sock;
    }

    @JRubyMethod
    public IRubyObject sysaccept() throws Exception {
        return this.accept();
    }

    @JRubyMethod
    public IRubyObject listen(IRubyObject log2) {
        if (INSTANCE.listen(this.fd, RubyNumeric.fix2int(log2)) < 0) {
            this.rb_sys_fail("listen(2)");
        }
        return this.getRuntime().newFixnum(0);
    }
}

