/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Pointer;
import java.io.FileDescriptor;
import org.jruby.ext.posix.BaseNativePOSIX;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.SolarisHeapFileStat;
import org.jruby.ext.posix.SolarisPasswd;

public class SolarisPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg2, FromNativeContext ctx) {
            return new SolarisPasswd((Pointer)arg2);
        }
    };

    public SolarisPOSIX(String libraryName, LibC libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
    }

    public FileStat allocateStat() {
        return new SolarisHeapFileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        FileStat stat2 = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if (this.libc.fstat64(fd, stat2) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, "" + fd);
        }
        return stat2;
    }

    public int lchmod(String filename2, int mode2) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public FileStat lstat(String path2) {
        FileStat stat2 = this.allocateStat();
        if (this.libc.lstat64(path2, stat2) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path2);
        }
        return stat2;
    }

    public FileStat stat(String path2) {
        FileStat stat2 = this.allocateStat();
        if (this.libc.stat64(path2, stat2) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path2);
        }
        return stat2;
    }
}

