/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.Factory;

public abstract class Platform {
    private static final String DARWIN = "darwin";
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String FREEBSD = "freebsd";
    private static final String OPENBSD = "openbsd";
    private static final String SOLARIS = "solaris";
    public static final Map<String, String> OS_NAMES = new HashMap<String, String>(){
        {
            this.put("Mac OS X", Platform.DARWIN);
        }
    };
    public static final Map<String, String> ARCH_NAMES = new HashMap<String, String>(){
        {
            this.put("x86", "i386");
        }
    };
    public static final String ARCH = Platform.getArchitecture();
    public static final String OS = Platform.getOperatingSystem();
    public static final boolean IS_WINDOWS = OS.equals("windows");
    public static final boolean IS_MAC = OS.equals("darwin");
    public static final boolean IS_FREEBSD = OS.equals("freebsd");
    public static final boolean IS_OPENBSD = OS.equals("openbsd");
    public static final boolean IS_LINUX = OS.equals("linux");
    public static final boolean IS_SOLARIS = OS.equals("solaris");
    public static final boolean IS_BSD = IS_MAC || IS_FREEBSD || IS_OPENBSD;
    public static final String LIBC = IS_WINDOWS ? "msvcrt" : "c";
    public static final String NAME = String.format("%s-%s", ARCH, OS);
    public static final int BIG_ENDIAN = 4321;
    public static final int LITTLE_ENDIAN = 1234;
    public static final int BYTE_ORDER = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 4321 : 1234;

    public static final Platform getPlatform() {
        return Factory.getInstance().getPlatform();
    }

    private static final String getOperatingSystem() {
        String osname = System.getProperty("os.name").toLowerCase();
        for (String s : OS_NAMES.keySet()) {
            if (!s.equalsIgnoreCase(osname)) continue;
            return OS_NAMES.get(s);
        }
        if (osname.startsWith(WINDOWS)) {
            return WINDOWS;
        }
        return osname;
    }

    private static final String getArchitecture() {
        String arch = System.getProperty("os.arch").toLowerCase();
        for (String s : ARCH_NAMES.keySet()) {
            if (!s.equalsIgnoreCase(arch)) continue;
            return ARCH_NAMES.get(s);
        }
        return arch;
    }

    protected Platform() {
    }

    public void init(Ruby runtime2, RubyModule ffi2) {
        RubyModule platform = ffi2.defineModuleUnder("Platform");
        platform.defineConstant("ADDRESS_SIZE", runtime2.newFixnum(this.addressSize()));
        platform.defineConstant("LONG_SIZE", runtime2.newFixnum(this.longSize()));
        platform.defineConstant("OS", runtime2.newString(OS));
        platform.defineConstant("ARCH", runtime2.newString(ARCH));
        platform.defineConstant("NAME", runtime2.newString(NAME));
        platform.defineConstant("IS_WINDOWS", runtime2.newBoolean(IS_WINDOWS));
        platform.defineConstant("IS_BSD", runtime2.newBoolean(IS_BSD));
        platform.defineConstant("IS_FREEBSD", runtime2.newBoolean(IS_FREEBSD));
        platform.defineConstant("IS_OPENBSD", runtime2.newBoolean(IS_OPENBSD));
        platform.defineConstant("IS_SOLARIS", runtime2.newBoolean(IS_SOLARIS));
        platform.defineConstant("IS_LINUX", runtime2.newBoolean(IS_LINUX));
        platform.defineConstant("IS_MAC", runtime2.newBoolean(IS_MAC));
        platform.defineConstant("LIBC", runtime2.newString(LIBC));
        platform.defineConstant("BYTE_ORDER", runtime2.newFixnum(BYTE_ORDER));
        platform.defineConstant("BIG_ENDIAN", runtime2.newFixnum(4321));
        platform.defineConstant("LITTLE_ENDIAN", runtime2.newFixnum(1234));
    }

    public static String getProperty(String property, String defValue) {
        try {
            return System.getProperty(property, defValue);
        }
        catch (SecurityException se) {
            return defValue;
        }
    }

    public abstract int addressSize();

    public abstract int longSize();
}

