/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IdUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Colon2Node
extends Colon3Node
implements INameNode {
    private final Node leftNode;

    public Colon2Node(ISourcePosition position, Node leftNode, String name2) {
        super(position, NodeType.COLON2NODE, name2);
        this.leftNode = leftNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitColon2Node(this);
    }

    public Node getLeftNode() {
        return this.leftNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.leftNode);
    }

    @Override
    public String toString() {
        String result = "Colon2Node [";
        if (this.leftNode != null) {
            result = result + this.leftNode;
        }
        result = result + this.getName();
        return result + "]";
    }

    @Override
    public RubyModule getEnclosingModule(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.leftNode != null) {
            IRubyObject result = this.leftNode.interpret(runtime2, context, self, aBlock);
            return RuntimeHelpers.prepareClassNamespace(context, result);
        }
        return context.getCurrentScope().getStaticScope().getModule();
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.leftNode == null) {
            return runtime2.getObject().fastGetConstantFrom(this.name);
        }
        IRubyObject result = this.leftNode.interpret(runtime2, context, self, aBlock);
        if (IdUtil.isConstant(this.name)) {
            if (result instanceof RubyModule) {
                return ((RubyModule)result).fastGetConstantFrom(this.name);
            }
            throw runtime2.newTypeError(result + " is not a class/module");
        }
        return RuntimeHelpers.invoke(context, result, this.name, aBlock);
    }

    @Override
    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            IRubyObject left = this.leftNode.interpret(runtime2, context, self, aBlock);
            if (left instanceof RubyModule && ((RubyModule)left).fastGetConstantAt(this.name) != null) {
                return "constant";
            }
            if (left.getMetaClass().isMethodBound(this.name, true)) {
                return "method";
            }
        }
        catch (JumpException e) {
            // empty catch block
        }
        return null;
    }
}

