/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import jruby.objectweb.asm.ClassReader;
import jruby.objectweb.asm.util.TraceClassVisitor;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.TypeConverter;

@JRubyModule(name={"JRuby"})
public class RubyJRuby {
    public static RubyModule createJRuby(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        runtime2.getKernel().callMethod(context, "require", runtime2.newString("java"));
        RubyModule jrubyModule = runtime2.defineModule("JRuby");
        jrubyModule.defineAnnotatedMethods(RubyJRuby.class);
        RubyClass compiledScriptClass = jrubyModule.defineClassUnder("CompiledScript", runtime2.getObject(), runtime2.getObject().getAllocator());
        compiledScriptClass.attr_accessor(context, new IRubyObject[]{runtime2.newSymbol("name"), runtime2.newSymbol("class_name"), runtime2.newSymbol("original_script"), runtime2.newSymbol("code")});
        compiledScriptClass.defineAnnotatedMethods(JRubyCompiledScript.class);
        return jrubyModule;
    }

    public static RubyModule createJRubyExt(Ruby runtime2) {
        runtime2.getKernel().callMethod(runtime2.getCurrentContext(), "require", runtime2.newString("java"));
        RubyModule mJRubyExt = runtime2.getOrCreateModule("JRuby").defineModuleUnder("Extensions");
        mJRubyExt.defineAnnotatedMethods(JRubyExtensions.class);
        runtime2.getObject().includeModule(mJRubyExt);
        return mJRubyExt;
    }

    @JRubyMethod(name={"runtime"}, frame=true, module=true)
    public static IRubyObject runtime(IRubyObject recv2, Block unusedBlock) {
        return Java.java_to_ruby(recv2, JavaObject.wrap(recv2.getRuntime(), recv2.getRuntime()), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"objectspace"}, frame=true, module=true)
    public static IRubyObject getObjectSpaceEnabled(IRubyObject recv2, Block b) {
        Ruby runtime2 = recv2.getRuntime();
        return RubyBoolean.newBoolean(runtime2, runtime2.isObjectSpaceEnabled());
    }

    @JRubyMethod(name={"objectspace="}, required=1, frame=true, module=true)
    public static IRubyObject setObjectSpaceEnabled(IRubyObject recv2, IRubyObject arg2, Block b) {
        Ruby runtime2 = recv2.getRuntime();
        runtime2.setObjectSpaceEnabled(arg2.isTrue());
        return runtime2.getNil();
    }

    @JRubyMethod(name={"parse", "ast_for"}, optional=3, frame=true, module=true)
    public static IRubyObject parse(IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (block.isGiven()) {
            if (block.getBody() instanceof CompiledBlock) {
                throw new RuntimeException("Cannot compile an already compiled block. Use -J-Djruby.jit.enabled=false to avoid this problem.");
            }
            Arity.checkArgumentCount(recv2.getRuntime(), args2, 0, 0);
            return Java.java_to_ruby(recv2, JavaObject.wrap(recv2.getRuntime(), ((InterpretedBlock)block.getBody()).getIterNode().getBodyNode()), Block.NULL_BLOCK);
        }
        Arity.checkArgumentCount(recv2.getRuntime(), args2, 1, 3);
        String filename2 = "-";
        boolean extraPositionInformation = false;
        RubyString content = args2[0].convertToString();
        if (args2.length > 1) {
            filename2 = args2[1].convertToString().toString();
            if (args2.length > 2) {
                extraPositionInformation = args2[2].isTrue();
            }
        }
        return Java.java_to_ruby(recv2, JavaObject.wrap(recv2.getRuntime(), recv2.getRuntime().parse(content.getByteList(), filename2, null, 0, extraPositionInformation)), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"compile"}, optional=3, frame=true, module=true)
    public static IRubyObject compile(IRubyObject recv2, IRubyObject[] args2, Block block) {
        String filename2;
        Node node;
        RubyString content;
        if (block.isGiven()) {
            Arity.checkArgumentCount(recv2.getRuntime(), args2, 0, 0);
            if (block.getBody() instanceof CompiledBlock) {
                throw new RuntimeException("Cannot compile an already compiled block. Use -J-Djruby.jit.enabled=false to avoid this problem.");
            }
            content = RubyString.newEmptyString(recv2.getRuntime());
            Node bnode = ((InterpretedBlock)block.getBody()).getIterNode().getBodyNode();
            node = new RootNode(bnode.getPosition(), block.getBinding().getDynamicScope(), bnode);
            filename2 = "__block_" + node.getPosition().getFile();
        } else {
            Arity.checkArgumentCount(recv2.getRuntime(), args2, 1, 3);
            filename2 = "-";
            boolean extraPositionInformation = false;
            content = args2[0].convertToString();
            if (args2.length > 1) {
                filename2 = args2[1].convertToString().toString();
                if (args2.length > 2) {
                    extraPositionInformation = args2[2].isTrue();
                }
            }
            node = recv2.getRuntime().parse(content.getByteList(), filename2, null, 0, extraPositionInformation);
        }
        String classname = filename2.equals("-e") ? "__dash_e__" : filename2.replace('\\', '/').replaceAll(".rb", "").replaceAll("-", "_dash_");
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(node);
        StandardASMCompiler asmCompiler = new StandardASMCompiler(classname, filename2);
        ASTCompiler compiler = new ASTCompiler();
        compiler.compileRoot(node, asmCompiler, inspector);
        byte[] bts = asmCompiler.getClassByteArray();
        IRubyObject compiledScript = ((RubyModule)recv2).fastGetConstant("CompiledScript").callMethod(recv2.getRuntime().getCurrentContext(), "new");
        compiledScript.callMethod(recv2.getRuntime().getCurrentContext(), "name=", recv2.getRuntime().newString(filename2));
        compiledScript.callMethod(recv2.getRuntime().getCurrentContext(), "class_name=", recv2.getRuntime().newString(classname));
        compiledScript.callMethod(recv2.getRuntime().getCurrentContext(), "original_script=", content);
        compiledScript.callMethod(recv2.getRuntime().getCurrentContext(), "code=", Java.java_to_ruby(recv2, JavaObject.wrap(recv2.getRuntime(), bts), Block.NULL_BLOCK));
        return compiledScript;
    }

    @JRubyMethod(name={"reference"}, required=1, module=true)
    public static IRubyObject reference(IRubyObject recv2, IRubyObject obj) {
        return Java.wrap(recv2.getRuntime().getJavaSupport().getJavaUtilitiesModule(), (IRubyObject)JavaObject.wrap(recv2.getRuntime(), obj));
    }

    @JRubyMethod(name={"dereference"}, required=1, module=true)
    public static IRubyObject dereference(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        if (!(obj.dataGetStruct() instanceof JavaObject)) {
            throw context.getRuntime().newTypeError("got " + obj + ", expected wrapped Java object");
        }
        Object unwrapped = JavaUtil.unwrapJavaObject(obj);
        if (!(unwrapped instanceof IRubyObject)) {
            throw context.getRuntime().newTypeError("got " + obj + ", expected Java-wrapped Ruby object");
        }
        return (IRubyObject)unwrapped;
    }

    public static class MethodExtensions {
        @JRubyMethod(name={"args"})
        public static IRubyObject methodArgs(IRubyObject recv2) {
            Ruby ruby = recv2.getRuntime();
            RubyMethod rubyMethod = (RubyMethod)recv2;
            DynamicMethod method2 = rubyMethod.method;
            if (method2 instanceof MethodArgs) {
                MethodArgs interpMethod = (MethodArgs)((Object)method2);
                ArgsNode args2 = interpMethod.getArgsNode();
                RubyArray argsArray = RubyArray.newArray(ruby);
                RubyArray reqArray = RubyArray.newArray(ruby);
                ListNode requiredArgs = args2.getArgs();
                for (int i = 0; requiredArgs != null && i < requiredArgs.size(); ++i) {
                    ArgumentNode arg2 = (ArgumentNode)requiredArgs.get(i);
                    reqArray.append(RubySymbol.newSymbol(ruby, arg2.getName()));
                }
                argsArray.append(reqArray);
                RubyArray optArray = RubyArray.newArray(ruby);
                ListNode optArgs = args2.getOptArgs();
                for (int i = 0; optArgs != null && i < optArgs.size(); ++i) {
                    LocalAsgnNode arg3 = (LocalAsgnNode)optArgs.get(i);
                    optArray.append(RubySymbol.newSymbol(ruby, arg3.getName()));
                }
                argsArray.append(optArray);
                if (args2.getRestArgNode() != null) {
                    argsArray.append(RubySymbol.newSymbol(ruby, args2.getRestArgNode().getName()));
                } else {
                    argsArray.append(ruby.getNil());
                }
                if (args2.getBlockArgNode() != null) {
                    argsArray.append(RubySymbol.newSymbol(ruby, args2.getBlockArgNode().getName()));
                } else {
                    argsArray.append(ruby.getNil());
                }
                return argsArray;
            }
            throw ruby.newTypeError("Method args are only available for standard interpreted or jitted methods");
        }
    }

    @JRubyModule(name={"JRubyExtensions"})
    public static class JRubyExtensions {
        @JRubyMethod(name={"steal_method"}, required=2, module=true)
        public static IRubyObject steal_method(IRubyObject recv2, IRubyObject type2, IRubyObject methodName) {
            RubyModule to_add = null;
            to_add = recv2 instanceof RubyModule ? (RubyModule)recv2 : recv2.getSingletonClass();
            String name2 = methodName.toString();
            if (!(type2 instanceof RubyModule)) {
                throw recv2.getRuntime().newArgumentError("First argument must be a module/class");
            }
            DynamicMethod method2 = ((RubyModule)type2).searchMethod(name2);
            if (method2 == null || method2.isUndefined()) {
                throw recv2.getRuntime().newArgumentError("No such method " + name2 + " on " + type2);
            }
            to_add.addMethod(name2, method2);
            return recv2.getRuntime().getNil();
        }

        @JRubyMethod(name={"steal_methods"}, required=1, rest=true, module=true)
        public static IRubyObject steal_methods(IRubyObject recv2, IRubyObject[] args2) {
            IRubyObject type2 = args2[0];
            for (int i = 1; i < args2.length; ++i) {
                JRubyExtensions.steal_method(recv2, type2, args2[i]);
            }
            return recv2.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"JRuby::CompiledScript"})
    public static class JRubyCompiledScript {
        @JRubyMethod(name={"to_s"})
        public static IRubyObject compiled_script_to_s(IRubyObject recv2) {
            return recv2.getInstanceVariables().fastGetInstanceVariable("@original_script");
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject compiled_script_inspect(IRubyObject recv2) {
            return recv2.getRuntime().newString("#<JRuby::CompiledScript " + recv2.getInstanceVariables().fastGetInstanceVariable("@name") + ">");
        }

        @JRubyMethod(name={"inspect_bytecode"})
        public static IRubyObject compiled_script_inspect_bytecode(IRubyObject recv2) {
            StringWriter sw = new StringWriter();
            ClassReader cr = new ClassReader((byte[])JavaUtil.convertRubyToJava(recv2.getInstanceVariables().fastGetInstanceVariable("@code"), byte[].class));
            TraceClassVisitor cv = new TraceClassVisitor(new PrintWriter(sw));
            cr.accept(cv, 2);
            return recv2.getRuntime().newString(sw.toString());
        }
    }

    public static class TypeLibrary
    implements Library {
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            RubyModule jrubyType = runtime2.defineModule("Type");
            jrubyType.defineAnnotatedMethods(TypeLibrary.class);
        }

        @JRubyMethod(module=true)
        public static IRubyObject coerce_to(ThreadContext context, IRubyObject self, IRubyObject object, IRubyObject clazz, IRubyObject method2) {
            Ruby ruby = object.getRuntime();
            if (!(clazz instanceof RubyClass)) {
                throw ruby.newTypeError(clazz, ruby.getClassClass());
            }
            if (!(method2 instanceof RubySymbol)) {
                throw ruby.newTypeError(method2, ruby.getSymbol());
            }
            RubyClass rubyClass = (RubyClass)clazz;
            RubySymbol methodSym = (RubySymbol)method2;
            return TypeConverter.convertToTypeOrRaise(object, rubyClass, methodSym.asJavaString());
        }
    }

    public static class ExtLibrary
    implements Library {
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            RubyJRuby.createJRubyExt(runtime2);
            runtime2.getMethod().defineAnnotatedMethods(MethodExtensions.class);
        }
    }
}

