/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;

@JRubyClass(name={"Array"})
public class RubyArray
extends RubyObject
implements List {
    private static ObjectAllocator ARRAY_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyArray(runtime2, klass);
        }
    };
    public static final int ARRAY_DEFAULT_SIZE = 16;
    private volatile IRubyObject[] values;
    private static final int TMPLOCK_ARR_F = 512;
    private static final int TMPLOCK_OR_FROZEN_ARR_F = 516;
    private volatile boolean isShared = false;
    private int begin = 0;
    private int realLength = 0;

    public static RubyClass createArrayClass(Ruby runtime2) {
        RubyClass arrayc = runtime2.defineClass("Array", runtime2.getObject(), ARRAY_ALLOCATOR);
        runtime2.setArray(arrayc);
        arrayc.index = 3;
        arrayc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyArray;
            }
        };
        arrayc.includeModule(runtime2.getEnumerable());
        arrayc.defineAnnotatedMethods(RubyArray.class);
        return arrayc;
    }

    public int getNativeTypeIndex() {
        return 3;
    }

    private final void concurrentModification() {
        throw this.getRuntime().newConcurrencyError("Detected invalid array contents due to unsynchronized modifications with concurrent users");
    }

    @JRubyMethod(name={"[]"}, rest=true, frame=true, meta=true)
    public static IRubyObject create(IRubyObject klass, IRubyObject[] args2, Block block) {
        RubyArray arr = (RubyArray)((RubyClass)klass).allocate();
        arr.callInit(IRubyObject.NULL_ARRAY, block);
        if (args2.length > 0) {
            arr.alloc(args2.length);
            System.arraycopy(args2, 0, arr.values, 0, args2.length);
            arr.realLength = args2.length;
        }
        return arr;
    }

    public static final RubyArray newArray(Ruby runtime2, long len) {
        return new RubyArray(runtime2, len);
    }

    public static final RubyArray newArrayLight(Ruby runtime2, long len) {
        return new RubyArray(runtime2, len, false);
    }

    public static final RubyArray newArray(Ruby runtime2) {
        return new RubyArray(runtime2, 16L);
    }

    public static final RubyArray newArrayLight(Ruby runtime2) {
        RubyArray arr = new RubyArray(runtime2, false);
        arr.alloc(16);
        return arr;
    }

    public static RubyArray newArray(Ruby runtime2, IRubyObject obj) {
        return new RubyArray(runtime2, new IRubyObject[]{obj});
    }

    public static RubyArray newArrayLight(Ruby runtime2, IRubyObject obj) {
        return new RubyArray(runtime2, new IRubyObject[]{obj}, false);
    }

    public static RubyArray newArray(Ruby runtime2, IRubyObject car, IRubyObject cdr) {
        return new RubyArray(runtime2, new IRubyObject[]{car, cdr});
    }

    public static RubyArray newEmptyArray(Ruby runtime2) {
        return new RubyArray(runtime2, NULL_ARRAY);
    }

    public static RubyArray newArray(Ruby runtime2, IRubyObject[] args2) {
        RubyArray arr = new RubyArray(runtime2, args2.length);
        System.arraycopy(args2, 0, arr.values, 0, args2.length);
        arr.realLength = args2.length;
        return arr;
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject[] args2) {
        return new RubyArray(runtime2, args2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject[] args2, int begin2) {
        return new RubyArray(runtime2, args2, begin2);
    }

    public static RubyArray newArrayNoCopyLight(Ruby runtime2, IRubyObject[] args2) {
        RubyArray arr = new RubyArray(runtime2, false);
        arr.values = args2;
        arr.realLength = args2.length;
        return arr;
    }

    public static RubyArray newArray(Ruby runtime2, Collection collection) {
        RubyArray arr = new RubyArray(runtime2, collection.size());
        collection.toArray(arr.values);
        arr.realLength = arr.values.length;
        return arr;
    }

    private RubyArray(Ruby runtime2, IRubyObject[] vals) {
        super(runtime2, runtime2.getArray());
        this.values = vals;
        this.realLength = vals.length;
    }

    private RubyArray(Ruby runtime2, IRubyObject[] vals, boolean objectSpace) {
        super(runtime2, runtime2.getArray(), objectSpace);
        this.values = vals;
        this.realLength = vals.length;
    }

    private RubyArray(Ruby runtime2, IRubyObject[] vals, int begin2) {
        super(runtime2, runtime2.getArray());
        this.values = vals;
        this.begin = begin2;
        this.realLength = vals.length - begin2;
        this.isShared = true;
    }

    private RubyArray(Ruby runtime2, long length2) {
        super(runtime2, runtime2.getArray());
        this.checkLength(length2);
        this.alloc((int)length2);
    }

    private RubyArray(Ruby runtime2, long length2, boolean objectspace) {
        super(runtime2, runtime2.getArray(), objectspace);
        this.checkLength(length2);
        this.alloc((int)length2);
    }

    public RubyArray(Ruby runtime2, long length2, IRubyObject[] vals) {
        super(runtime2, runtime2.getArray());
        this.checkLength(length2);
        int ilength = (int)length2;
        this.alloc(ilength);
        if (ilength > 0 && vals.length > 0) {
            System.arraycopy(vals, 0, this.values, 0, ilength);
        }
        this.realLength = ilength;
    }

    private RubyArray(Ruby runtime2, boolean objectSpace) {
        super(runtime2, runtime2.getArray(), objectSpace);
    }

    private RubyArray(Ruby runtime2) {
        super(runtime2, runtime2.getArray());
        this.alloc(16);
    }

    public RubyArray(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.alloc(16);
    }

    private RubyArray(Ruby runtime2, RubyClass klass, int length2) {
        super(runtime2, klass);
        this.alloc(length2);
    }

    private RubyArray(Ruby runtime2, RubyClass klass, long length2) {
        super(runtime2, klass);
        this.checkLength(length2);
        this.alloc((int)length2);
    }

    private RubyArray(Ruby runtime2, RubyClass klass, long length2, boolean objectspace) {
        super(runtime2, klass, objectspace);
        this.checkLength(length2);
        this.alloc((int)length2);
    }

    private RubyArray(Ruby runtime2, RubyClass klass, boolean objectSpace) {
        super(runtime2, klass, objectSpace);
    }

    private RubyArray(Ruby runtime2, RubyClass klass, RubyArray original) {
        super(runtime2, klass);
        this.realLength = original.realLength;
        this.alloc(this.realLength);
        try {
            System.arraycopy(original.values, original.begin, this.values, 0, this.realLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
    }

    private final IRubyObject[] reserve(int length2) {
        Object[] arr = new IRubyObject[length2];
        Arrays.fill(arr, this.getRuntime().getNil());
        return arr;
    }

    private final void alloc(int length2) {
        Object[] newValues = new IRubyObject[length2];
        Arrays.fill(newValues, this.getRuntime().getNil());
        this.values = newValues;
    }

    private final void realloc(int newLength) {
        Object[] reallocated = new IRubyObject[newLength];
        Arrays.fill(reallocated, this.getRuntime().getNil());
        try {
            System.arraycopy(this.values, 0, reallocated, 0, newLength > this.realLength ? this.realLength : newLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        this.values = reallocated;
    }

    private final void checkLength(long length2) {
        if (length2 < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        if (length2 >= Integer.MAX_VALUE) {
            throw this.getRuntime().newArgumentError("array size too big");
        }
    }

    public List getList() {
        return Arrays.asList(this.toJavaArray());
    }

    public int getLength() {
        return this.realLength;
    }

    public IRubyObject[] toJavaArray() {
        IRubyObject[] copy = this.reserve(this.realLength);
        try {
            System.arraycopy(this.values, this.begin, copy, 0, this.realLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return copy;
    }

    public IRubyObject[] toJavaArrayUnsafe() {
        return !this.isShared ? this.values : this.toJavaArray();
    }

    public IRubyObject[] toJavaArrayMaybeUnsafe() {
        return !this.isShared && this.begin == 0 && this.values.length == this.realLength ? this.values : this.toJavaArray();
    }

    private final RubyArray makeShared(int beg, int len, RubyClass klass) {
        return this.makeShared(beg, len, klass, klass.getRuntime().isObjectSpaceEnabled());
    }

    private final RubyArray makeShared(int beg, int len, RubyClass klass, boolean objectSpace) {
        RubyArray sharedArray = new RubyArray(this.getRuntime(), klass, objectSpace);
        this.isShared = true;
        sharedArray.values = this.values;
        sharedArray.isShared = true;
        sharedArray.begin = beg;
        sharedArray.realLength = len;
        return sharedArray;
    }

    private final void modifyCheck() {
        if ((this.flags & 0x204) != 0) {
            if ((this.flags & 4) != 0) {
                throw this.getRuntime().newFrozenError("array");
            }
            if ((this.flags & 0x200) != 0) {
                throw this.getRuntime().newTypeError("can't modify array during iteration");
            }
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify array");
        }
    }

    private final void modify() {
        this.modifyCheck();
        if (this.isShared) {
            IRubyObject[] vals = this.reserve(this.realLength);
            this.isShared = false;
            try {
                System.arraycopy(this.values, this.begin, vals, 0, this.realLength);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
            this.begin = 0;
            this.values = vals;
        }
    }

    @JRubyMethod(name={"initialize"}, required=0, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject val;
        int argc = args2.length;
        Ruby runtime2 = this.getRuntime();
        if (argc == 0) {
            this.modifyCheck();
            this.realLength = 0;
            if (block.isGiven()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used", new Object[0]);
            }
            return this;
        }
        if (argc == 1 && !(args2[0] instanceof RubyFixnum) && !(val = args2[0].checkArrayType()).isNil()) {
            this.replace(val);
            return this;
        }
        long len = RubyNumeric.num2long(args2[0]);
        if (len < 0L) {
            throw runtime2.newArgumentError("negative array size");
        }
        if (len >= Integer.MAX_VALUE) {
            throw runtime2.newArgumentError("array size too big");
        }
        int ilen = (int)len;
        this.modify();
        if (ilen > this.values.length) {
            this.values = this.reserve(ilen);
        }
        if (block.isGiven()) {
            if (argc == 2) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument", new Object[0]);
            }
            for (int i = 0; i < ilen; ++i) {
                this.store(i, block.yield(context, new RubyFixnum(runtime2, i)));
                this.realLength = i + 1;
            }
        } else {
            try {
                Arrays.fill(this.values, 0, ilen, argc == 2 ? args2[1] : runtime2.getNil());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
            this.realLength = ilen;
        }
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject orig) {
        return this.replace(orig);
    }

    @JRubyMethod(name={"replace"}, required=1)
    public IRubyObject replace(IRubyObject orig) {
        this.modifyCheck();
        RubyArray origArr = orig.convertToArray();
        if (this == orig) {
            return this;
        }
        origArr.isShared = true;
        this.isShared = true;
        this.values = origArr.values;
        this.realLength = origArr.realLength;
        this.begin = origArr.begin;
        return this;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.realLength == 0) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        return this.join(this.getRuntime().getCurrentContext(), this.getRuntime().getGlobalVariables().get("$,"));
    }

    public boolean includes(ThreadContext context, IRubyObject item) {
        int begin2;
        for (int i = begin2 = this.begin; i < begin2 + this.realLength; ++i) {
            IRubyObject value2;
            try {
                value2 = this.values[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                continue;
            }
            if (!RubyArray.equalInternal(context, value2, item)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        int begin2;
        int h = this.realLength;
        Ruby runtime2 = this.getRuntime();
        for (int i = begin2 = this.begin; i < begin2 + this.realLength; ++i) {
            IRubyObject value2;
            h = h << 1 | (h < 0 ? 1 : 0);
            try {
                value2 = this.values[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                continue;
            }
            h = (int)((long)h ^ RubyNumeric.num2long(value2.callMethod(context, MethodIndex.HASH, "hash")));
        }
        return runtime2.newFixnum(h);
    }

    public final IRubyObject store(long index2, IRubyObject value2) {
        if (index2 < 0L && (index2 += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (index2 - (long)this.realLength) + " out of array");
        }
        this.modify();
        if (index2 >= (long)this.realLength) {
            if (index2 >= (long)this.values.length) {
                long newLength = this.values.length >> 1;
                if (newLength < 16L) {
                    newLength = 16L;
                }
                if (index2 >= Integer.MAX_VALUE || (newLength += index2) >= Integer.MAX_VALUE) {
                    throw this.getRuntime().newArgumentError("index too big");
                }
                this.realloc((int)newLength);
            }
            this.realLength = (int)index2 + 1;
        }
        try {
            this.values[(int)index2] = value2;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return value2;
    }

    private final IRubyObject elt(long offset2) {
        if (offset2 < 0L || offset2 >= (long)this.realLength) {
            return this.getRuntime().getNil();
        }
        try {
            return this.values[this.begin + (int)offset2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return this.getRuntime().getNil();
        }
    }

    public final IRubyObject entry(long offset2) {
        return offset2 < 0L ? this.elt(offset2 + (long)this.realLength) : this.elt(offset2);
    }

    public final IRubyObject entry(int offset2) {
        return offset2 < 0 ? this.elt(offset2 + this.realLength) : this.elt(offset2);
    }

    public final IRubyObject eltInternal(int offset2) {
        return this.values[this.begin + offset2];
    }

    public final IRubyObject eltInternalSet(int offset2, IRubyObject item) {
        IRubyObject iRubyObject = item;
        this.values[this.begin + offset2] = iRubyObject;
        return iRubyObject;
    }

    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.fetch(context, args2[0], block);
            }
            case 2: {
                return this.fetch(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"fetch"}, frame=true)
    public IRubyObject fetch(ThreadContext context, IRubyObject arg0, Block block) {
        long index2 = RubyNumeric.num2long(arg0);
        if (index2 < 0L) {
            index2 += (long)this.realLength;
        }
        if (index2 < 0L || index2 >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(context, arg0);
            }
            throw this.getRuntime().newIndexError("index " + index2 + " out of array");
        }
        try {
            return this.values[this.begin + (int)index2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return this.getRuntime().getNil();
        }
    }

    @JRubyMethod(name={"fetch"}, frame=true)
    public IRubyObject fetch(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        long index2;
        if (block.isGiven()) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument", new Object[0]);
        }
        if ((index2 = RubyNumeric.num2long(arg0)) < 0L) {
            index2 += (long)this.realLength;
        }
        if (index2 < 0L || index2 >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(context, arg0);
            }
            return arg1;
        }
        try {
            return this.values[this.begin + (int)index2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return this.getRuntime().getNil();
        }
    }

    private static RubyArray aryToAry(IRubyObject obj) {
        if (obj instanceof RubyArray) {
            return (RubyArray)obj;
        }
        if (obj.respondsTo("to_ary")) {
            return obj.convertToArray();
        }
        RubyArray arr = new RubyArray(obj.getRuntime(), false);
        arr.alloc(1);
        arr.values[0] = obj;
        arr.realLength = 1;
        return arr;
    }

    private final void splice(long beg, long len, IRubyObject rpl) {
        int rlen;
        RubyArray rplArr;
        if (len < 0L) {
            throw this.getRuntime().newIndexError("negative length (" + len + ")");
        }
        if (beg < 0L && (beg += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (beg -= (long)this.realLength) + " out of array");
        }
        if (rpl == null || rpl.isNil()) {
            rplArr = null;
            rlen = 0;
        } else {
            rplArr = RubyArray.aryToAry(rpl);
            rlen = rplArr.realLength;
        }
        this.modify();
        if (beg >= (long)this.realLength) {
            len = beg + (long)rlen;
            if (len >= (long)this.values.length) {
                int tryNewLength = this.values.length + (this.values.length >> 1);
                this.realloc(len > (long)tryNewLength ? (int)len : tryNewLength);
            }
            this.realLength = (int)len;
        } else {
            long alen;
            if (beg + len > (long)this.realLength) {
                len = (long)this.realLength - beg;
            }
            if ((alen = (long)(this.realLength + rlen) - len) >= (long)this.values.length) {
                int tryNewLength = this.values.length + (this.values.length >> 1);
                this.realloc(alen > (long)tryNewLength ? (int)alen : tryNewLength);
            }
            if (len != (long)rlen) {
                try {
                    System.arraycopy(this.values, (int)(beg + len), this.values, (int)beg + rlen, this.realLength - (int)(beg + len));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.concurrentModification();
                }
                this.realLength = (int)alen;
            }
        }
        if (rlen > 0) {
            try {
                System.arraycopy(rplArr.values, rplArr.begin, this.values, (int)beg, rlen);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
        }
    }

    private final void spliceOne(long beg, long len, IRubyObject rpl) {
        if (len < 0L) {
            throw this.getRuntime().newIndexError("negative length (" + len + ")");
        }
        if (beg < 0L && (beg += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (beg -= (long)this.realLength) + " out of array");
        }
        this.modify();
        if (beg >= (long)this.realLength) {
            len = beg + 1L;
            if (len >= (long)this.values.length) {
                int tryNewLength = this.values.length + (this.values.length >> 1);
                this.realloc(len > (long)tryNewLength ? (int)len : tryNewLength);
            }
            this.realLength = (int)len;
        } else {
            int alen;
            if (beg + len > (long)this.realLength) {
                len = (long)this.realLength - beg;
            }
            if ((alen = this.realLength + 1 - (int)len) >= this.values.length) {
                int tryNewLength = this.values.length + (this.values.length >> 1);
                this.realloc(alen > tryNewLength ? alen : tryNewLength);
            }
            if (len != 1L) {
                try {
                    System.arraycopy(this.values, (int)(beg + len), this.values, (int)beg + 1, this.realLength - (int)(beg + len));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.concurrentModification();
                }
                this.realLength = alen;
            }
        }
        try {
            this.values[(int)beg] = rpl;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
    }

    @JRubyMethod
    public IRubyObject insert() {
        throw this.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod
    public IRubyObject insert(IRubyObject arg2) {
        return this;
    }

    @JRubyMethod
    public IRubyObject insert(IRubyObject arg1, IRubyObject arg2) {
        long pos2 = RubyNumeric.num2long(arg1);
        if (pos2 == -1L) {
            pos2 = this.realLength;
        }
        if (pos2 < 0L) {
            ++pos2;
        }
        this.spliceOne(pos2, 0L, arg2);
        return this;
    }

    @JRubyMethod(name={"insert"}, required=1, rest=true)
    public IRubyObject insert(IRubyObject[] args2) {
        if (args2.length == 1) {
            return this;
        }
        long pos2 = RubyNumeric.num2long(args2[0]);
        if (pos2 == -1L) {
            pos2 = this.realLength;
        }
        if (pos2 < 0L) {
            ++pos2;
        }
        RubyArray inserted = new RubyArray(this.getRuntime(), false);
        inserted.values = args2;
        inserted.begin = 1;
        inserted.realLength = args2.length - 1;
        this.splice(pos2, 0L, inserted);
        return this;
    }

    public final RubyArray aryDup() {
        RubyArray dup2 = new RubyArray(this.getRuntime(), this.getMetaClass(), this);
        dup2.flags |= this.flags & 8;
        return dup2;
    }

    @JRubyMethod(name={"transpose"})
    public RubyArray transpose() {
        RubyArray result = null;
        int alen = this.realLength;
        if (alen == 0) {
            return this.aryDup();
        }
        Ruby runtime2 = this.getRuntime();
        int elen = -1;
        int end2 = this.begin + alen;
        for (int i = this.begin; i < end2; ++i) {
            int j;
            RubyArray tmp = this.elt(i).convertToArray();
            if (elen < 0) {
                elen = tmp.realLength;
                result = new RubyArray(runtime2, elen);
                for (j = 0; j < elen; ++j) {
                    result.store(j, new RubyArray(runtime2, alen));
                }
            } else if (elen != tmp.realLength) {
                throw runtime2.newIndexError("element size differs (" + tmp.realLength + " should be " + elen + ")");
            }
            for (j = 0; j < elen; ++j) {
                ((RubyArray)result.elt(j)).store(i - this.begin, tmp.elt(j));
            }
        }
        return result;
    }

    private final IRubyObject values_at(long olen, IRubyObject[] args2) {
        RubyArray result = new RubyArray(this.getRuntime(), args2.length);
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i] instanceof RubyFixnum) {
                result.append(this.entry(((RubyFixnum)args2[i]).getLongValue()));
                continue;
            }
            if (args2[i] instanceof RubyRange) {
                long[] beglen = ((RubyRange)args2[i]).begLen(olen, 0);
                if (beglen == null) continue;
                int beg = (int)beglen[0];
                int len = (int)beglen[1];
                int end2 = this.begin + len;
                for (int j = this.begin; j < end2; ++j) {
                    result.append(this.entry(j + beg));
                }
                continue;
            }
            result.append(this.entry(RubyNumeric.num2long(args2[i])));
        }
        return result;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public IRubyObject values_at(IRubyObject[] args2) {
        return this.values_at(this.realLength, args2);
    }

    public IRubyObject subseq(long beg, long len) {
        if (beg > (long)this.realLength || beg < 0L || len < 0L) {
            return this.getRuntime().getNil();
        }
        if (beg + len > (long)this.realLength && (len = (long)this.realLength - beg) < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return new RubyArray(this.getRuntime(), this.getMetaClass(), 0);
        }
        return this.makeShared(this.begin + (int)beg, (int)len, this.getMetaClass());
    }

    public IRubyObject subseqLight(long beg, long len) {
        if (beg > (long)this.realLength || beg < 0L || len < 0L) {
            return this.getRuntime().getNil();
        }
        if (beg + len > (long)this.realLength && (len = (long)this.realLength - beg) < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return new RubyArray(this.getRuntime(), this.getMetaClass(), 0L, false);
        }
        return this.makeShared(this.begin + (int)beg, (int)len, this.getMetaClass(), false);
    }

    @JRubyMethod(name={"length"}, alias={"size"})
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.realLength);
    }

    @JRubyMethod(name={"<<"}, required=1)
    public RubyArray append(IRubyObject item) {
        this.modify();
        if (this.realLength == this.values.length) {
            if (this.realLength == Integer.MAX_VALUE) {
                throw this.getRuntime().newArgumentError("index too big");
            }
            long newLength = this.values.length + (this.values.length >> 1);
            if (newLength > Integer.MAX_VALUE) {
                newLength = Integer.MAX_VALUE;
            } else if (newLength < 16L) {
                newLength = 16L;
            }
            this.realloc((int)newLength);
        }
        try {
            this.values[this.realLength++] = item;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return this;
    }

    @JRubyMethod(name={"push"}, rest=true)
    public RubyArray push_m(IRubyObject[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.append(items[i]);
        }
        return this;
    }

    @JRubyMethod(name={"pop"})
    public IRubyObject pop() {
        this.modifyCheck();
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        if (this.isShared) {
            try {
                return this.values[this.begin + --this.realLength];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                return this.getRuntime().getNil();
            }
        }
        int index2 = this.begin + --this.realLength;
        try {
            IRubyObject obj = this.values[index2];
            this.values[index2] = this.getRuntime().getNil();
            return obj;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return this.getRuntime().getNil();
        }
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift() {
        IRubyObject obj;
        this.modify();
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        try {
            obj = this.values[this.begin];
            this.values[this.begin] = this.getRuntime().getNil();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return this.getRuntime().getNil();
        }
        this.isShared = true;
        ++this.begin;
        --this.realLength;
        return obj;
    }

    public RubyArray unshift(IRubyObject item) {
        this.modify();
        if (this.realLength == this.values.length) {
            int newLength = this.values.length >> 1;
            if (newLength < 16) {
                newLength = 16;
            }
            this.realloc(newLength += this.values.length);
        }
        try {
            System.arraycopy(this.values, 0, this.values, 1, this.realLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        ++this.realLength;
        this.values[0] = item;
        return this;
    }

    @JRubyMethod(name={"unshift"}, rest=true)
    public RubyArray unshift_m(IRubyObject[] items) {
        long len = this.realLength;
        if (items.length == 0) {
            return this;
        }
        this.store(len + (long)items.length - 1L, this.getRuntime().getNil());
        try {
            System.arraycopy(this.values, 0, this.values, items.length, (int)len);
            System.arraycopy(items, 0, this.values, 0, items.length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return this;
    }

    @JRubyMethod(name={"include?"}, required=1)
    public RubyBoolean include_p(ThreadContext context, IRubyObject item) {
        return context.getRuntime().newBoolean(this.includes(context, item));
    }

    @JRubyMethod(name={"frozen?"})
    public RubyBoolean frozen_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isFrozen() || (this.flags & 0x200) != 0);
    }

    public IRubyObject aref(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.aref(args2[0]);
            }
            case 2: {
                return this.aref(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject aref(IRubyObject arg0) {
        if (arg0 instanceof RubyFixnum) {
            return this.entry(((RubyFixnum)arg0).getLongValue());
        }
        if (arg0 instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        if (arg0 instanceof RubyRange) {
            long[] beglen = ((RubyRange)arg0).begLen(this.realLength, 0);
            if (beglen == null) {
                return this.getRuntime().getNil();
            }
            return this.subseq(beglen[0], beglen[1]);
        }
        return this.entry(RubyNumeric.num2long(arg0));
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject aref(IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        long beg = RubyNumeric.num2long(arg0);
        if (beg < 0L) {
            beg += (long)this.realLength;
        }
        return this.subseq(beg, RubyNumeric.num2long(arg1));
    }

    public IRubyObject aset(IRubyObject[] args2) {
        switch (args2.length) {
            case 2: {
                return this.aset(args2[0], args2[1]);
            }
            case 3: {
                return this.aset(args2[0], args2[1], args2[2]);
            }
        }
        throw this.getRuntime().newArgumentError("wrong number of arguments (" + args2.length + " for 2)");
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyFixnum) {
            this.store(((RubyFixnum)arg0).getLongValue(), arg1);
            return arg1;
        }
        if (arg0 instanceof RubyRange) {
            long[] beglen = ((RubyRange)arg0).begLen(this.realLength, 1);
            this.splice(beglen[0], beglen[1], arg1);
            return arg1;
        }
        if (arg0 instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        this.store(RubyNumeric.num2long(arg0), arg1);
        return arg1;
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (arg0 instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        if (arg1 instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as subarray length");
        }
        this.splice(RubyNumeric.num2long(arg0), RubyNumeric.num2long(arg1), arg2);
        return arg2;
    }

    @JRubyMethod(name={"at"}, required=1)
    public IRubyObject at(IRubyObject pos2) {
        return this.entry(RubyNumeric.num2long(pos2));
    }

    @JRubyMethod(name={"concat"}, required=1)
    public RubyArray concat(IRubyObject obj) {
        RubyArray ary = obj.convertToArray();
        if (ary.realLength > 0) {
            this.splice(this.realLength, 0L, ary);
        }
        return this;
    }

    private IRubyObject inspectAry(ThreadContext context) {
        ByteList buffer = new ByteList();
        buffer.append(91);
        boolean tainted = this.isTaint();
        for (int i = 0; i < this.realLength; ++i) {
            RubyString str;
            if (i > 0) {
                buffer.append(44).append(32);
            }
            if ((str = RubyArray.inspect(context, this.values[this.begin + i])).isTaint()) {
                tainted = true;
            }
            buffer.append(str.getByteList());
        }
        buffer.append(93);
        RubyString str = this.getRuntime().newString(buffer);
        if (tainted) {
            str.setTaint(true);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.realLength == 0) {
            return this.getRuntime().newString("[]");
        }
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("[...]");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectAry(this.getRuntime().getCurrentContext());
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    public IRubyObject first(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.first(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first() {
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin];
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first(IRubyObject arg0) {
        long n = RubyNumeric.num2long(arg0);
        if (n > (long)this.realLength) {
            n = this.realLength;
        } else if (n < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        return this.makeShared(this.begin, (int)n, this.getRuntime().getArray());
    }

    public IRubyObject last(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.last();
            }
            case 1: {
                return this.last(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last() {
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + this.realLength - 1];
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last(IRubyObject arg0) {
        long n = RubyNumeric.num2long(arg0);
        if (n > (long)this.realLength) {
            n = this.realLength;
        } else if (n < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        return this.makeShared(this.begin + this.realLength - (int)n, (int)n, this.getRuntime().getArray());
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext context, Block block) {
        for (int i = 0; i < this.realLength; ++i) {
            block.yield(context, this.values[this.begin + i]);
        }
        return this;
    }

    @JRubyMethod(name={"each_index"}, frame=true)
    public IRubyObject each_index(ThreadContext context, Block block) {
        Ruby runtime2 = this.getRuntime();
        for (int i = 0; i < this.realLength; ++i) {
            block.yield(context, runtime2.newFixnum(i));
        }
        return this;
    }

    @JRubyMethod(name={"reverse_each"}, frame=true)
    public IRubyObject reverse_each(ThreadContext context, Block block) {
        int len = this.realLength;
        while (len-- > 0) {
            block.yield(context, this.values[this.begin + len]);
            if (this.realLength >= len) continue;
            len = this.realLength;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectJoin(ThreadContext context, RubyArray tmp, IRubyObject sep) {
        Ruby runtime2 = this.getRuntime();
        if (runtime2.isInspecting(this)) {
            return tmp.join(context, sep);
        }
        try {
            runtime2.registerInspecting(this);
            RubyString rubyString = tmp.join(context, sep);
            return rubyString;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    public RubyString join(ThreadContext context, IRubyObject sep) {
        Ruby runtime2 = this.getRuntime();
        if (this.realLength == 0) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        boolean taint2 = this.isTaint() || sep.isTaint();
        long len = 1L;
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject value2;
            try {
                value2 = this.values[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                return runtime2.newString("");
            }
            IRubyObject tmp = value2.checkStringType();
            len += tmp.isNil() ? 10L : (long)((RubyString)tmp).getByteList().length();
        }
        RubyString strSep = null;
        if (!sep.isNil()) {
            strSep = sep.convertToString();
            sep = strSep;
            len += (long)(strSep.getByteList().length() * (this.realLength - 1));
        }
        ByteList buf = new ByteList((int)len);
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject tmp;
            try {
                tmp = this.values[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                return runtime2.newString("");
            }
            if (!(tmp instanceof RubyString)) {
                tmp = tmp instanceof RubyArray ? (runtime2.isInspecting(tmp) ? runtime2.newString("[...]") : this.inspectJoin(context, (RubyArray)tmp, sep)) : RubyString.objAsString(context, tmp);
            }
            if (i > this.begin && !sep.isNil()) {
                buf.append(strSep.getByteList());
            }
            buf.append(tmp.asString().getByteList());
            if (!tmp.isTaint()) continue;
            taint2 = true;
        }
        RubyString result = runtime2.newString(buf);
        if (taint2) {
            result.setTaint(true);
        }
        return result;
    }

    @JRubyMethod(name={"join"}, optional=1)
    public RubyString join_m(ThreadContext context, IRubyObject[] args2) {
        int argc = args2.length;
        IRubyObject sep = argc == 1 ? args2[0] : this.getRuntime().getGlobalVariables().get("$,");
        return this.join(context, sep);
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        if (this.getMetaClass() != this.getRuntime().getArray()) {
            RubyArray dup2 = new RubyArray(this.getRuntime(), this.getRuntime().isObjectSpaceEnabled());
            this.isShared = true;
            dup2.isShared = true;
            dup2.values = this.values;
            dup2.realLength = this.realLength;
            dup2.begin = this.begin;
            return dup2;
        }
        return this;
    }

    @JRubyMethod(name={"to_ary"})
    public IRubyObject to_ary() {
        return this;
    }

    public RubyArray convertToArray() {
        return this;
    }

    public IRubyObject checkArrayType() {
        return this;
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().getTrue();
        }
        if (!(obj instanceof RubyArray)) {
            if (!obj.respondsTo("to_ary")) {
                return this.getRuntime().getFalse();
            }
            if (RubyArray.equalInternal(context, obj.callMethod(context, "to_ary"), this)) {
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }
        RubyArray ary = (RubyArray)obj;
        if (this.realLength != ary.realLength) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime2 = this.getRuntime();
        for (long i = 0L; i < (long)this.realLength; ++i) {
            if (RubyArray.equalInternal(context, this.elt(i), ary.elt(i))) continue;
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public RubyBoolean eql_p(ThreadContext context, IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().getTrue();
        }
        if (!(obj instanceof RubyArray)) {
            return this.getRuntime().getFalse();
        }
        RubyArray ary = (RubyArray)obj;
        if (this.realLength != ary.realLength) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime2 = this.getRuntime();
        for (int i = 0; i < this.realLength; ++i) {
            if (RubyArray.eqlInternal(context, this.elt(i), ary.elt(i))) continue;
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    @JRubyMethod(name={"compact!"})
    public IRubyObject compact_bang() {
        this.modify();
        int p2 = 0;
        int t = 0;
        int end2 = p2 + this.realLength;
        while (t < end2) {
            if (this.values[t].isNil()) {
                ++t;
                continue;
            }
            this.values[p2++] = this.values[t++];
        }
        if (this.realLength == p2) {
            return this.getRuntime().getNil();
        }
        this.realloc(p2);
        this.realLength = p2;
        return this;
    }

    @JRubyMethod(name={"compact"})
    public IRubyObject compact() {
        RubyArray ary = this.aryDup();
        ary.compact_bang();
        return ary;
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p() {
        return this.realLength == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject rb_clear() {
        this.modifyCheck();
        if (this.isShared) {
            this.alloc(16);
            this.isShared = true;
        } else if (this.values.length > 32) {
            this.alloc(32);
        } else {
            int begin2 = this.begin;
            try {
                Arrays.fill(this.values, begin2, begin2 + this.realLength, this.getRuntime().getNil());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
        }
        this.begin = 0;
        this.realLength = 0;
        return this;
    }

    @JRubyMethod(name={"fill"}, optional=3, frame=true)
    public IRubyObject fill(ThreadContext context, IRubyObject[] args2, Block block) {
        block19: {
            int len;
            int beg;
            IRubyObject item;
            block20: {
                item = null;
                IRubyObject begObj = null;
                IRubyObject lenObj = null;
                int argc = args2.length;
                if (block.isGiven()) {
                    Arity.checkArgumentCount(this.getRuntime(), args2, 0, 2);
                    item = null;
                    begObj = argc > 0 ? args2[0] : null;
                    lenObj = argc > 1 ? args2[1] : null;
                    ++argc;
                } else {
                    Arity.checkArgumentCount(this.getRuntime(), args2, 1, 3);
                    item = args2[0];
                    begObj = argc > 1 ? args2[1] : null;
                    lenObj = argc > 2 ? args2[2] : null;
                }
                beg = 0;
                int end2 = 0;
                len = 0;
                switch (argc) {
                    case 1: {
                        beg = 0;
                        len = this.realLength;
                        break;
                    }
                    case 2: {
                        if (begObj instanceof RubyRange) {
                            long[] beglen = ((RubyRange)begObj).begLen(this.realLength, 1);
                            beg = (int)beglen[0];
                            len = (int)beglen[1];
                            break;
                        }
                    }
                    case 3: {
                        int n = beg = begObj.isNil() ? 0 : RubyNumeric.num2int(begObj);
                        if (beg < 0 && (beg = this.realLength + beg) < 0) {
                            beg = 0;
                        }
                        len = lenObj == null || lenObj.isNil() ? this.realLength - beg : RubyNumeric.num2int(lenObj);
                    }
                }
                this.modify();
                if (len < 0) {
                    return this;
                }
                if (len > Integer.MAX_VALUE - beg) {
                    throw this.getRuntime().newArgumentError("argument too big");
                }
                end2 = beg + len;
                if (end2 > this.realLength) {
                    if (end2 >= this.values.length) {
                        this.realloc(end2);
                    }
                    this.realLength = end2;
                }
                if (!block.isGiven()) break block20;
                Ruby runtime2 = this.getRuntime();
                for (int i = beg; i < end2; ++i) {
                    IRubyObject v = block.yield(context, runtime2.newFixnum(i));
                    if (i < this.realLength) {
                        try {
                            this.values[i] = v;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            this.concurrentModification();
                        }
                        continue;
                    }
                    break block19;
                }
                break block19;
            }
            if (len <= 0) break block19;
            try {
                Arrays.fill(this.values, beg, beg + len, item);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
        }
        return this;
    }

    @JRubyMethod(name={"index"}, required=1)
    public IRubyObject index(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = this.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (!RubyArray.equalInternal(context, this.values[i], obj)) continue;
            return runtime2.newFixnum(i - this.begin);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"rindex"}, required=1)
    public IRubyObject rindex(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = this.getRuntime();
        int i = this.realLength;
        while (i-- > 0) {
            if (i > this.realLength) {
                i = this.realLength;
                continue;
            }
            if (!RubyArray.equalInternal(context, this.values[this.begin + i], obj)) continue;
            return this.getRuntime().newFixnum(i);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"indexes", "indices"}, required=1, rest=true)
    public IRubyObject indexes(IRubyObject[] args2) {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Array#indexes is deprecated; use Array#values_at", "Array#indexes", "Array#values_at");
        RubyArray ary = new RubyArray(this.getRuntime(), args2.length);
        IRubyObject[] arefArgs = new IRubyObject[1];
        for (int i = 0; i < args2.length; ++i) {
            arefArgs[0] = args2[i];
            ary.append(this.aref(arefArgs));
        }
        return ary;
    }

    @JRubyMethod(name={"reverse!"})
    public IRubyObject reverse_bang() {
        this.modify();
        int realLength = this.realLength;
        IRubyObject[] values = this.values;
        try {
            if (realLength > 1) {
                int p1 = 0;
                int p2 = p1 + realLength - 1;
                while (p1 < p2) {
                    IRubyObject tmp = values[p1];
                    values[p1++] = values[p2];
                    values[p2--] = tmp;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return this;
    }

    @JRubyMethod(name={"reverse"})
    public IRubyObject reverse() {
        return this.aryDup().reverse_bang();
    }

    @JRubyMethod(name={"collect", "map"}, frame=true)
    public RubyArray collect(ThreadContext context, Block block) {
        Ruby runtime2 = this.getRuntime();
        if (!block.isGiven()) {
            return new RubyArray(this.getRuntime(), runtime2.getArray(), this);
        }
        RubyArray collect2 = new RubyArray(runtime2, this.realLength);
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            collect2.append(block.yield(context, this.values[i]));
        }
        return collect2;
    }

    @JRubyMethod(name={"collect!", "map!"}, frame=true)
    public RubyArray collect_bang(ThreadContext context, Block block) {
        this.modify();
        int len = this.realLength;
        for (int i = 0; i < len; ++i) {
            this.store(i, block.yield(context, this.values[this.begin + i]));
        }
        return this;
    }

    @JRubyMethod(name={"select"}, frame=true)
    public RubyArray select(ThreadContext context, Block block) {
        Ruby runtime2 = this.getRuntime();
        RubyArray result = new RubyArray(runtime2, this.realLength);
        if (this.isShared) {
            for (int i = this.begin; i < this.begin + this.realLength; ++i) {
                if (!block.yield(context, this.values[i]).isTrue()) continue;
                result.append(this.elt(i - this.begin));
            }
        } else {
            for (int i = 0; i < this.realLength; ++i) {
                if (!block.yield(context, this.values[i]).isTrue()) continue;
                result.append(this.elt(i));
            }
        }
        return result;
    }

    @JRubyMethod(name={"delete"}, required=1, frame=true)
    public IRubyObject delete(ThreadContext context, IRubyObject item, Block block) {
        int i2 = 0;
        Ruby runtime2 = this.getRuntime();
        for (int i1 = 0; i1 < this.realLength; ++i1) {
            IRubyObject e = this.values[this.begin + i1];
            if (RubyArray.equalInternal(context, e, item)) continue;
            if (i1 != i2) {
                this.store(i2, e);
            }
            ++i2;
        }
        if (this.realLength == i2) {
            if (block.isGiven()) {
                return block.yield(context, item);
            }
            return runtime2.getNil();
        }
        this.modify();
        int realLength = this.realLength;
        int begin2 = this.begin;
        Object[] values = this.values;
        if (realLength > i2) {
            try {
                Arrays.fill(values, begin2 + i2, begin2 + realLength, this.getRuntime().getNil());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
            this.realLength = i2;
            if (i2 << 1 < values.length && values.length > 16) {
                this.realloc(i2 << 1);
            }
        }
        return item;
    }

    private final IRubyObject delete_at(int pos2) {
        int len = this.realLength;
        if (pos2 >= len) {
            return this.getRuntime().getNil();
        }
        if (pos2 < 0) {
            pos2 += len;
        }
        if (pos2 < 0) {
            return this.getRuntime().getNil();
        }
        this.modify();
        IRubyObject obj = this.values[pos2];
        try {
            System.arraycopy(this.values, pos2 + 1, this.values, pos2, len - (pos2 + 1));
            this.values[this.realLength - 1] = this.getRuntime().getNil();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        --this.realLength;
        return obj;
    }

    @JRubyMethod(name={"delete_at"}, required=1)
    public IRubyObject delete_at(IRubyObject obj) {
        return this.delete_at((int)RubyNumeric.num2long(obj));
    }

    @JRubyMethod(name={"reject"}, frame=true)
    public IRubyObject reject(ThreadContext context, Block block) {
        RubyArray ary = this.aryDup();
        ary.reject_bang(context, block);
        return ary;
    }

    @JRubyMethod(name={"reject!"}, frame=true)
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        int i2 = 0;
        this.modify();
        for (int i1 = 0; i1 < this.realLength; ++i1) {
            IRubyObject v = this.values[i1];
            if (block.yield(context, v).isTrue()) continue;
            if (i1 != i2) {
                this.store(i2, v);
            }
            ++i2;
        }
        if (this.realLength == i2) {
            return this.getRuntime().getNil();
        }
        if (i2 < this.realLength) {
            try {
                Arrays.fill(this.values, i2, this.realLength, this.getRuntime().getNil());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
            this.realLength = i2;
        }
        return this;
    }

    @JRubyMethod(name={"delete_if"}, frame=true)
    public IRubyObject delete_if(ThreadContext context, Block block) {
        this.reject_bang(context, block);
        return this;
    }

    @JRubyMethod(name={"zip"}, optional=1, rest=true, frame=true)
    public IRubyObject zip(ThreadContext context, IRubyObject[] args2, Block block) {
        for (int i = 0; i < args2.length; ++i) {
            args2[i] = args2[i].convertToArray();
        }
        Ruby runtime2 = this.getRuntime();
        if (block.isGiven()) {
            for (int i = 0; i < this.realLength; ++i) {
                RubyArray tmp = new RubyArray(runtime2, args2.length + 1);
                tmp.append(this.elt(i));
                for (int j = 0; j < args2.length; ++j) {
                    tmp.append(((RubyArray)args2[j]).elt(i));
                }
                block.yield(context, tmp);
            }
            return runtime2.getNil();
        }
        int len = this.realLength;
        RubyArray result = new RubyArray(runtime2, len);
        for (int i = 0; i < len; ++i) {
            RubyArray tmp = new RubyArray(runtime2, args2.length + 1);
            tmp.append(this.elt(i));
            for (int j = 0; j < args2.length; ++j) {
                tmp.append(((RubyArray)args2[j]).elt(i));
            }
            result.append(tmp);
        }
        return result;
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject obj) {
        RubyArray ary2 = obj.convertToArray();
        int len = this.realLength;
        if (len > ary2.realLength) {
            len = ary2.realLength;
        }
        Ruby runtime2 = this.getRuntime();
        for (int i = 0; i < len; ++i) {
            IRubyObject v = this.elt(i).callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", ary2.elt(i));
            if (v instanceof RubyFixnum && ((RubyFixnum)v).getLongValue() == 0L) continue;
            return v;
        }
        len = this.realLength - ary2.realLength;
        if (len == 0) {
            return RubyFixnum.zero(runtime2);
        }
        if (len > 0) {
            return RubyFixnum.one(runtime2);
        }
        return RubyFixnum.minus_one(runtime2);
    }

    public IRubyObject slice_bang(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.slice_bang(args2[0]);
            }
            case 2: {
                return this.slice_bang(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(IRubyObject arg0) {
        if (arg0 instanceof RubyRange) {
            long[] beglen = ((RubyRange)arg0).begLen(this.realLength, 1);
            long pos2 = beglen[0];
            long len = beglen[1];
            if (pos2 < 0L) {
                pos2 = (long)this.realLength + pos2;
            }
            arg0 = this.subseq(pos2, len);
            this.splice(pos2, len, null);
            return arg0;
        }
        return this.delete_at((int)RubyNumeric.num2long(arg0));
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(IRubyObject arg0, IRubyObject arg1) {
        long pos2 = RubyNumeric.num2long(arg0);
        long len = RubyNumeric.num2long(arg1);
        if (pos2 < 0L) {
            pos2 = (long)this.realLength + pos2;
        }
        arg1 = this.subseq(pos2, len);
        this.splice(pos2, len, null);
        return arg1;
    }

    @JRubyMethod(name={"assoc"}, required=1)
    public IRubyObject assoc(ThreadContext context, IRubyObject key) {
        Ruby runtime2 = this.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject v = this.values[i];
            if (!(v instanceof RubyArray)) continue;
            RubyArray arr = (RubyArray)v;
            if (arr.realLength <= 0 || !RubyArray.equalInternal(context, arr.values[arr.begin], key)) continue;
            return arr;
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"rassoc"}, required=1)
    public IRubyObject rassoc(ThreadContext context, IRubyObject value2) {
        Ruby runtime2 = this.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject v = this.values[i];
            if (!(v instanceof RubyArray)) continue;
            RubyArray arr = (RubyArray)v;
            if (arr.realLength <= 1 || !RubyArray.equalInternal(context, arr.values[arr.begin + 1], value2)) continue;
            return arr;
        }
        return runtime2.getNil();
    }

    private final int flatten(ThreadContext context, int index2, RubyArray ary2, RubyArray memo) {
        int lim = index2 + ary2.realLength;
        IRubyObject id2 = ary2.id();
        if (memo.includes(context, id2)) {
            throw this.getRuntime().newArgumentError("tried to flatten recursive array");
        }
        memo.append(id2);
        this.splice(index2, 1L, ary2);
        for (int i = index2; i < lim; ++i) {
            IRubyObject tmp = this.elt(i).checkArrayType();
            if (tmp.isNil()) continue;
            int n = this.flatten(context, i, (RubyArray)tmp, memo);
            i += n;
            lim += n;
        }
        memo.pop();
        return lim - index2 - 1;
    }

    @JRubyMethod(name={"flatten!"})
    public IRubyObject flatten_bang(ThreadContext context) {
        RubyArray memo = null;
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject ary2 = this.values[this.begin + i];
            IRubyObject tmp = ary2.checkArrayType();
            if (tmp.isNil()) continue;
            if (memo == null) {
                memo = new RubyArray(this.getRuntime(), false);
                memo.values = this.reserve(16);
            }
            i += this.flatten(context, i, (RubyArray)tmp, memo);
        }
        if (memo == null) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context) {
        RubyArray ary = this.aryDup();
        ary.flatten_bang(context);
        return ary;
    }

    @JRubyMethod(name={"nitems"})
    public IRubyObject nitems() {
        int n = 0;
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (this.values[i].isNil()) continue;
            ++n;
        }
        return this.getRuntime().newFixnum(n);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject obj) {
        RubyArray y = obj.convertToArray();
        int len = this.realLength + y.realLength;
        RubyArray z = new RubyArray(this.getRuntime(), len);
        try {
            System.arraycopy(this.values, this.begin, z.values, 0, this.realLength);
            System.arraycopy(y.values, y.begin, z.values, this.realLength, y.realLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        z.realLength = len;
        return z;
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_times(ThreadContext context, IRubyObject times2) {
        IRubyObject tmp = times2.checkStringType();
        if (!tmp.isNil()) {
            return this.join(context, tmp);
        }
        long len = RubyNumeric.num2long(times2);
        if (len == 0L) {
            return new RubyArray(this.getRuntime(), this.getMetaClass(), 0);
        }
        if (len < 0L) {
            throw this.getRuntime().newArgumentError("negative argument");
        }
        if (Long.MAX_VALUE / len < (long)this.realLength) {
            throw this.getRuntime().newArgumentError("argument too big");
        }
        RubyArray ary2 = new RubyArray(this.getRuntime(), this.getMetaClass(), len *= (long)this.realLength);
        ary2.realLength = (int)len;
        try {
            int i = 0;
            while ((long)i < len) {
                System.arraycopy(this.values, this.begin, ary2.values, i, this.realLength);
                i += this.realLength;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        ary2.infectBy(this);
        return ary2;
    }

    private final RubyHash makeHash(RubyArray ary2) {
        int begin2;
        int i;
        RubyHash hash2 = new RubyHash(this.getRuntime(), false);
        for (i = begin2 = this.begin; i < begin2 + this.realLength; ++i) {
            hash2.fastASet(this.values[i], NEVER);
        }
        if (ary2 != null) {
            for (i = begin2 = ary2.begin; i < begin2 + ary2.realLength; ++i) {
                hash2.fastASet(ary2.values[i], NEVER);
            }
        }
        return hash2;
    }

    @JRubyMethod(name={"uniq!"})
    public IRubyObject uniq_bang() {
        RubyHash hash2 = this.makeHash(null);
        if (this.realLength == hash2.size()) {
            return this.getRuntime().getNil();
        }
        int j = 0;
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject v = this.elt(i);
            if (!hash2.fastDelete(v)) continue;
            this.store(j++, v);
        }
        this.realLength = j;
        return this;
    }

    @JRubyMethod(name={"uniq"})
    public IRubyObject uniq() {
        RubyArray ary = this.aryDup();
        ary.uniq_bang();
        return ary;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_diff(IRubyObject other) {
        int begin2;
        RubyHash hash2 = other.convertToArray().makeHash(null);
        RubyArray ary3 = new RubyArray(this.getRuntime());
        for (int i = begin2 = this.begin; i < begin2 + this.realLength; ++i) {
            if (hash2.fastARef(this.values[i]) != null) continue;
            ary3.append(this.elt(i - begin2));
        }
        return ary3;
    }

    @JRubyMethod(name={"&"}, required=1)
    public IRubyObject op_and(IRubyObject other) {
        RubyArray ary2 = other.convertToArray();
        RubyHash hash2 = ary2.makeHash(null);
        RubyArray ary3 = new RubyArray(this.getRuntime(), this.realLength < ary2.realLength ? (long)this.realLength : (long)ary2.realLength);
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject v = this.elt(i);
            if (!hash2.fastDelete(v)) continue;
            ary3.append(v);
        }
        return ary3;
    }

    @JRubyMethod(name={"|"}, required=1)
    public IRubyObject op_or(IRubyObject other) {
        IRubyObject v;
        int i;
        RubyArray ary2 = other.convertToArray();
        RubyHash set = this.makeHash(ary2);
        RubyArray ary3 = new RubyArray(this.getRuntime(), this.realLength + ary2.realLength);
        for (i = 0; i < this.realLength; ++i) {
            v = this.elt(i);
            if (!set.fastDelete(v)) continue;
            ary3.append(v);
        }
        for (i = 0; i < ary2.realLength; ++i) {
            v = ary2.elt(i);
            if (!set.fastDelete(v)) continue;
            ary3.append(v);
        }
        return ary3;
    }

    @JRubyMethod(name={"sort"}, frame=true)
    public RubyArray sort(Block block) {
        RubyArray ary = this.aryDup();
        ary.sort_bang(block);
        return ary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"sort!"}, frame=true)
    public RubyArray sort_bang(Block block) {
        this.modify();
        if (this.realLength > 1) {
            this.flags |= 0x200;
            try {
                if (block.isGiven()) {
                    Arrays.sort(this.values, 0, this.realLength, new BlockComparator(block));
                } else {
                    Arrays.sort(this.values, 0, this.realLength, new DefaultComparator());
                }
            }
            finally {
                this.flags &= 0xFFFFFDFF;
            }
        }
        return this;
    }

    public static void marshalTo(RubyArray array, MarshalStream output) throws IOException {
        output.registerLinkTarget(array);
        output.writeInt(array.getList().size());
        Iterator iter = array.getList().iterator();
        while (iter.hasNext()) {
            output.dumpObject((IRubyObject)iter.next());
        }
    }

    public static RubyArray unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyArray result = input.getRuntime().newArray();
        input.registerLinkTarget(result);
        int size2 = input.unmarshalInt();
        for (int i = 0; i < size2; ++i) {
            result.append(input.unmarshalObject());
        }
        return result;
    }

    @JRubyMethod(name={"pack"}, required=1)
    public RubyString pack(ThreadContext context, IRubyObject obj) {
        RubyString iFmt = RubyString.objAsString(context, obj);
        return Pack.pack(this.getRuntime(), this, iFmt.getByteList());
    }

    public Class getJavaClass() {
        return List.class;
    }

    public int size() {
        return this.realLength;
    }

    public boolean isEmpty() {
        return this.realLength == 0;
    }

    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.realLength];
        for (int i = this.begin; i < this.realLength; ++i) {
            array[i - this.begin] = JavaUtil.convertRubyToJava(this.values[i]);
        }
        return array;
    }

    public Object[] toArray(Object[] arg2) {
        Object[] array = arg2;
        if (array.length < this.realLength) {
            Class<?> type2 = array.getClass().getComponentType();
            array = (Object[])Array.newInstance(type2, this.realLength);
        }
        int length2 = this.realLength - this.begin;
        for (int i = 0; i < length2; ++i) {
            array[i] = JavaUtil.convertRubyToJava(this.values[i + this.begin]);
        }
        return array;
    }

    public boolean add(Object element) {
        this.append(JavaUtil.convertJavaToRuby(this.getRuntime(), element));
        return true;
    }

    public boolean remove(Object element) {
        IRubyObject deleted = this.delete(this.getRuntime().getCurrentContext(), JavaUtil.convertJavaToRuby(this.getRuntime(), element), Block.NULL_BLOCK);
        return !deleted.isNil();
    }

    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.indexOf(iter.next()) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return !c.isEmpty();
    }

    public boolean addAll(int index2, Collection c) {
        Iterator iter = c.iterator();
        int i = index2;
        while (iter.hasNext()) {
            this.add(i, iter.next());
            ++i;
        }
        return !c.isEmpty();
    }

    public boolean removeAll(Collection c) {
        boolean listChanged = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.next())) continue;
            listChanged = true;
        }
        return listChanged;
    }

    public boolean retainAll(Collection c) {
        boolean listChanged = false;
        for (Object element : this) {
            if (c.contains(element)) continue;
            this.remove(element);
            listChanged = true;
        }
        return listChanged;
    }

    public Object get(int index2) {
        return JavaUtil.convertRubyToJava(this.elt(index2), Object.class);
    }

    public Object set(int index2, Object element) {
        return this.store(index2, JavaUtil.convertJavaToRuby(this.getRuntime(), element));
    }

    public void add(int index2, Object element) {
        this.insert(new IRubyObject[]{RubyFixnum.newFixnum(this.getRuntime(), index2), JavaUtil.convertJavaToRuby(this.getRuntime(), element)});
    }

    public Object remove(int index2) {
        return JavaUtil.convertRubyToJava(this.delete_at(index2), Object.class);
    }

    public int indexOf(Object element) {
        int begin2 = this.begin;
        if (element != null) {
            IRubyObject convertedElement = JavaUtil.convertJavaToRuby(this.getRuntime(), element);
            for (int i = begin2; i < begin2 + this.realLength; ++i) {
                if (!convertedElement.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object element) {
        int begin2 = this.begin;
        if (element != null) {
            IRubyObject convertedElement = JavaUtil.convertJavaToRuby(this.getRuntime(), element);
            for (int i = begin2 + this.realLength - 1; i >= begin2; --i) {
                if (!convertedElement.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Iterator iterator() {
        return new RubyArrayConversionIterator();
    }

    public ListIterator listIterator() {
        return new RubyArrayConversionListIterator();
    }

    public ListIterator listIterator(int index2) {
        return new RubyArrayConversionListIterator(index2);
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        IRubyObject subList = this.subseq(fromIndex, toIndex - fromIndex + 1);
        return subList.isNil() ? null : (List)((Object)subList);
    }

    public void clear() {
        this.rb_clear();
    }

    final class RubyArrayConversionListIterator
    extends RubyArrayConversionIterator
    implements ListIterator {
        public RubyArrayConversionListIterator() {
        }

        public RubyArrayConversionListIterator(int index2) {
            this.index = index2;
        }

        public boolean hasPrevious() {
            return this.index >= 0;
        }

        public Object previous() {
            this.last = --this.index;
            return JavaUtil.convertRubyToJava(RubyArray.this.elt(this.index), Object.class);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void set(Object obj) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.store(this.last, JavaUtil.convertJavaToRuby(RubyArray.this.getRuntime(), obj));
        }

        public void add(Object obj) {
            RubyArray.this.insert(new IRubyObject[]{RubyFixnum.newFixnum(RubyArray.this.getRuntime(), this.index++), JavaUtil.convertJavaToRuby(RubyArray.this.getRuntime(), obj)});
            this.last = -1;
        }
    }

    public class RubyArrayConversionIterator
    implements Iterator {
        protected int index = 0;
        protected int last = -1;

        public boolean hasNext() {
            return this.index < RubyArray.this.realLength;
        }

        public Object next() {
            IRubyObject element = RubyArray.this.elt(this.index);
            this.last = this.index++;
            return JavaUtil.convertRubyToJava(element, Object.class);
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.delete_at(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }
    }

    static final class DefaultComparator
    implements Comparator {
        DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof RubyFixnum && o2 instanceof RubyFixnum) {
                return this.compareFixnums(o1, o2);
            }
            if (o1 instanceof RubyString && o2 instanceof RubyString) {
                return ((RubyString)o1).op_cmp((RubyString)o2);
            }
            return this.compareOthers((IRubyObject)o1, (IRubyObject)o2);
        }

        private int compareFixnums(Object o1, Object o2) {
            long b;
            long a = ((RubyFixnum)o1).getLongValue();
            if (a > (b = ((RubyFixnum)o2).getLongValue())) {
                return 1;
            }
            if (a < b) {
                return -1;
            }
            return 0;
        }

        private int compareOthers(IRubyObject o1, IRubyObject o2) {
            ThreadContext context = o1.getRuntime().getCurrentContext();
            IRubyObject ret = o1.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", o2);
            int n = RubyComparable.cmpint(context, ret, o1, o2);
            return n;
        }
    }

    final class BlockComparator
    implements Comparator {
        private Block block;

        public BlockComparator(Block block) {
            this.block = block;
        }

        public int compare(Object o1, Object o2) {
            ThreadContext context = RubyArray.this.getRuntime().getCurrentContext();
            IRubyObject obj1 = (IRubyObject)o1;
            IRubyObject obj2 = (IRubyObject)o2;
            IRubyObject ret = this.block.yield(context, RubyArray.this.getRuntime().newArray(obj1, obj2), null, null, true);
            int n = RubyComparable.cmpint(context, ret, obj1, obj2);
            return n;
        }
    }
}

