/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayNode
extends ListNode
implements ILiteralNode {
    private boolean lightweight = false;

    public ArrayNode(ISourcePosition position, Node firstNode) {
        super(position, NodeType.ARRAYNODE, firstNode);
        assert (firstNode != null) : "ArrayNode.first == null";
    }

    public ArrayNode(ISourcePosition position) {
        super(position, NodeType.ARRAYNODE);
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitArrayNode(this);
    }

    public void setLightweight(boolean lightweight) {
        this.lightweight = lightweight;
    }

    public boolean isLightweight() {
        return this.lightweight;
    }

    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        int size = this.size();
        IRubyObject[] array = new IRubyObject[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.get(i).interpret(runtime, context, self, aBlock);
        }
        if (this.lightweight) {
            return runtime.newArrayNoCopyLight(array);
        }
        return runtime.newArrayNoCopy(array);
    }
}

