/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhileNode
extends Node {
    private final Node conditionNode;
    private final Node bodyNode;
    private final boolean evaluateAtStart;
    public boolean containsNonlocalFlow = false;

    public WhileNode(ISourcePosition position, Node conditionNode, Node bodyNode) {
        this(position, conditionNode, bodyNode, true);
    }

    public WhileNode(ISourcePosition position, Node conditionNode, Node bodyNode, boolean evalAtStart) {
        super(position, NodeType.WHILENODE);
        this.conditionNode = conditionNode;
        this.bodyNode = bodyNode;
        this.evaluateAtStart = evalAtStart;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitWhileNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getConditionNode() {
        return this.conditionNode;
    }

    public boolean evaluateAtStart() {
        return this.evaluateAtStart;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.conditionNode, this.bodyNode);
    }
}

