/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelStream;

@JRubyClass(name={"Net::BufferedIO"})
public class NetProtocolBufferedIO {
    public static void create(Ruby runtime) {
        RubyModule mNet = runtime.getModule("Net");
        RubyClass cBufferedIO = (RubyClass)mNet.getConstant("BufferedIO");
        cBufferedIO.defineAnnotatedMethods(NetProtocolBufferedIO.class);
        RubyModule mNativeImpl = cBufferedIO.defineModuleUnder("NativeImplementation");
        mNativeImpl.defineAnnotatedMethods(NativeImpl.class);
    }

    @JRubyMethod(required=1)
    public static IRubyObject initialize(IRubyObject recv, IRubyObject io) {
        if (io instanceof RubyIO && ((RubyIO)io).getOpenFile().getMainStream() instanceof ChannelStream && ((ChannelStream)((RubyIO)io).getOpenFile().getMainStream()).getDescriptor().getChannel() instanceof SelectableChannel) {
            ((RubyObject)recv).extend(new IRubyObject[]{((RubyModule)recv.getRuntime().getModule("Net").getConstant("BufferedIO")).getConstant("NativeImplementation")});
            SelectableChannel sc = (SelectableChannel)((ChannelStream)((RubyIO)io).getOpenFile().getMainStream()).getDescriptor().getChannel();
            recv.dataWrapStruct(new NativeImpl(sc));
        }
        recv.getInstanceVariables().setInstanceVariable("@io", io);
        recv.getInstanceVariables().setInstanceVariable("@read_timeout", recv.getRuntime().newFixnum(60L));
        recv.getInstanceVariables().setInstanceVariable("@debug_output", recv.getRuntime().getNil());
        recv.getInstanceVariables().setInstanceVariable("@rbuf", recv.getRuntime().newString(""));
        return recv;
    }

    @JRubyModule(name={"Net::BufferedIO::NativeImplementation"})
    public static class NativeImpl {
        private SelectableChannel channel;

        public NativeImpl(SelectableChannel channel) {
            this.channel = channel;
        }

        @JRubyMethod
        public static IRubyObject rbuf_fill(IRubyObject recv) {
            RubyString buf = (RubyString)recv.getInstanceVariables().getInstanceVariable("@rbuf");
            RubyIO io = (RubyIO)recv.getInstanceVariables().getInstanceVariable("@io");
            int timeout = RubyNumeric.fix2int(recv.getInstanceVariables().getInstanceVariable("@read_timeout")) * 1000;
            NativeImpl nim = (NativeImpl)recv.dataGetStruct();
            Selector selector = null;
            try {
                selector = Selector.open();
                nim.channel.configureBlocking(false);
                SelectionKey key = nim.channel.register(selector, 1);
                int n = selector.select(timeout);
                if (n > 0) {
                    IRubyObject readItems = io.read(new IRubyObject[]{recv.getRuntime().newFixnum(16384L)});
                    RubyString rubyString = buf.concat(readItems);
                    return rubyString;
                }
                try {
                    RubyClass exc = (RubyClass)recv.getRuntime().getModule("Timeout").getConstant("Error");
                    throw new RaiseException(RubyException.newException(recv.getRuntime(), exc, "execution expired"), false);
                }
                catch (IOException exception) {
                    throw recv.getRuntime().newIOErrorFromException(exception);
                }
            }
            finally {
                if (selector != null) {
                    try {
                        selector.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }
}

