/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import jregex.Pattern;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.Opcodes;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.javasupport.util.CompilerHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.collections.SinglyLinkedList;

public class StandardASMCompiler
implements Compiler,
Opcodes {
    private static final CodegenUtils cg = CodegenUtils.cg;
    private static final String THREADCONTEXT = cg.p(ThreadContext.class);
    private static final String RUBY = cg.p(Ruby.class);
    private static final String IRUBYOBJECT = cg.p(IRubyObject.class);
    private static final String METHOD_SIGNATURE = cg.sig(IRubyObject.class, new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class});
    private static final String CLOSURE_SIGNATURE = cg.sig(IRubyObject.class, new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class});
    private static final int THREADCONTEXT_INDEX = 0;
    private static final int SELF_INDEX = 1;
    private static final int ARGS_INDEX = 2;
    private static final int CLOSURE_INDEX = 3;
    private static final int SCOPE_INDEX = 4;
    private static final int RUNTIME_INDEX = 5;
    private static final int VISIBILITY_INDEX = 6;
    private static final int LOCAL_VARS_INDEX = 7;
    private Stack SkinnyMethodAdapters = new Stack();
    private Stack arities = new Stack();
    private Stack scopeStarts = new Stack();
    private String classname;
    private String sourcename;
    private ClassWriter classWriter;
    ClassWriter currentMultiStub = null;
    int methodIndex = -1;
    int multiStubCount = -1;
    int innerIndex = -1;
    int lastLine = -1;
    boolean isCompilingClosure;
    private int constants = 0;

    public StandardASMCompiler(String classname, String sourcename) {
        this.classname = classname;
        this.sourcename = sourcename;
    }

    public StandardASMCompiler(Node node) {
        this.classname = "EVAL" + this.hashCode();
        this.sourcename = "EVAL" + this.hashCode();
    }

    public Class loadClass(JRubyClassLoader classLoader) throws ClassNotFoundException {
        classLoader.defineClass(cg.c(this.classname), this.classWriter.toByteArray());
        return classLoader.loadClass(cg.c(this.classname));
    }

    public void writeClass(File destination) throws IOException {
        this.writeClass(this.classname, destination, this.classWriter);
    }

    private void writeClass(String classname, File destination, ClassWriter writer) throws IOException {
        String fullname = classname + ".class";
        String filename = null;
        String path = null;
        if (fullname.lastIndexOf("/") == -1) {
            filename = fullname;
            path = "";
        } else {
            filename = fullname.substring(fullname.lastIndexOf("/") + 1);
            path = fullname.substring(0, fullname.lastIndexOf("/"));
        }
        File pathfile = new File(destination, path);
        pathfile.mkdirs();
        FileOutputStream out = new FileOutputStream(new File(pathfile, filename));
        out.write(writer.toByteArray());
    }

    public String getClassname() {
        return this.classname;
    }

    public String getSourcename() {
        return this.sourcename;
    }

    public ClassVisitor getClassVisitor() {
        return this.classWriter;
    }

    public SkinnyMethodAdapter getMethodAdapter() {
        return (SkinnyMethodAdapter)this.SkinnyMethodAdapters.peek();
    }

    public SkinnyMethodAdapter popMethodAdapter() {
        return (SkinnyMethodAdapter)this.SkinnyMethodAdapters.pop();
    }

    public void pushMethodAdapter(SkinnyMethodAdapter mv) {
        this.SkinnyMethodAdapters.push(mv);
    }

    public int getArity() {
        return (Integer)this.arities.peek();
    }

    public void pushArity(Arity arity) {
        this.arities.push(arity);
    }

    public Arity popArity() {
        return (Arity)this.arities.pop();
    }

    public void pushScopeStart(Label start) {
        this.scopeStarts.push(start);
    }

    public Label popScopeStart() {
        return (Label)this.scopeStarts.pop();
    }

    public void startScript() {
        this.classWriter = new ClassWriter(true);
        this.classWriter.visit(48, 33, this.classname, null, cg.p(Object.class), new String[]{cg.p(Script.class)});
        this.classWriter.visitSource(this.sourcename, null);
        this.createClassInit();
        this.createConstructor();
    }

    public void endScript() {
        String methodName = "__file__";
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "run", METHOD_SIGNATURE, null, null));
        mv.start();
        mv.aload(1);
        mv.aload(2);
        mv.aload(3);
        mv.aload(4);
        mv.invokestatic(this.classname, methodName, METHOD_SIGNATURE);
        mv.areturn();
        mv.end();
        mv = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(9, "main", cg.sig(Void.TYPE, cg.params(String[].class)), null, null));
        mv.start();
        mv.newobj(this.classname);
        mv.dup();
        mv.invokespecial(this.classname, "<init>", cg.sig(Void.TYPE));
        mv.invokestatic(cg.p(Ruby.class), "getDefaultInstance", cg.sig(Ruby.class));
        mv.dup();
        mv.invokevirtual(RUBY, "getCurrentContext", cg.sig(ThreadContext.class));
        mv.swap();
        mv.invokevirtual(RUBY, "getTopSelf", cg.sig(IRubyObject.class));
        mv.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
        mv.getstatic(cg.p(Block.class), "NULL_BLOCK", cg.ci(Block.class));
        mv.invokevirtual(this.classname, "run", METHOD_SIGNATURE);
        mv.voidreturn();
        mv.end();
    }

    private void createConstructor() {
        ClassVisitor cv = this.getClassVisitor();
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", cg.sig(Void.TYPE), null, null));
        mv.start();
        mv.aload(0);
        mv.invokespecial(cg.p(Object.class), "<init>", cg.sig(Void.TYPE));
        mv.voidreturn();
        mv.end();
    }

    private void createClassInit() {
        ClassVisitor cv = this.getClassVisitor();
        cv.visitField(26, "$isClassLoaded", cg.ci(Boolean.TYPE), null, Boolean.FALSE);
        cv.visitField(26, "$class", cg.ci(Class.class), null, null);
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(1, "<clinit>", cg.sig(Void.TYPE), null, null));
        mv.start();
        mv.getstatic(this.classname, "$isClassLoaded", cg.ci(Boolean.TYPE));
        Label doNotLoadClass = new Label();
        mv.ifne(doNotLoadClass);
        mv.ldc(Boolean.TRUE);
        mv.putstatic(this.classname, "$isClassLoaded", cg.ci(Boolean.TYPE));
        mv.ldc(cg.c(this.classname));
        mv.invokestatic(cg.p(Class.class), "forName", cg.sig(Class.class, cg.params(String.class)));
        mv.putstatic(this.classname, "$class", cg.ci(Class.class));
        mv.label(doNotLoadClass);
        mv.voidreturn();
        mv.end();
    }

    public Object beginMethod(String friendlyName, ClosureCallback args) {
        SkinnyMethodAdapter newMethod = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(9, friendlyName, METHOD_SIGNATURE, null, null));
        this.pushMethodAdapter(newMethod);
        newMethod.start();
        newMethod.aload(0);
        this.invokeThreadContext("getRuntime", cg.sig(Ruby.class));
        newMethod.astore(5);
        newMethod.getstatic(cg.p(Visibility.class), "PRIVATE", cg.ci(Visibility.class));
        newMethod.astore(6);
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
        newMethod.dup();
        newMethod.astore(7);
        newMethod.invokevirtual(cg.p(DynamicScope.class), "getValues", cg.sig(IRubyObject[].class));
        newMethod.astore(4);
        if (args != null) {
            args.compile(this);
        } else {
            this.pushArity(null);
        }
        Label start = new Label();
        newMethod.label(start);
        this.pushScopeStart(start);
        return newMethod;
    }

    public void endMethod(Object token) {
        assert (token instanceof SkinnyMethodAdapter);
        SkinnyMethodAdapter mv = (SkinnyMethodAdapter)token;
        mv.areturn();
        Label end = new Label();
        mv.label(end);
        mv.visitLocalVariable("lvars", cg.ci(IRubyObject[].class), null, this.popScopeStart(), end, 7);
        mv.end();
        this.popMethodAdapter();
        this.popArity();
    }

    public void lineNumber(ISourcePosition position) {
        this.lastLine = position.getEndLine();
        if (this.lastLine == this.lastLine) {
            return;
        }
        Label l = new Label();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.label(l);
        mv.visitLineNumber(position.getStartLine() + 1, l);
    }

    public void invokeAttrAssign(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        mv.dup();
        mv.arraylength();
        mv.iconst_1();
        mv.isub();
        mv.arrayload();
        mv.dup_x2();
        mv.pop();
        this.invokeDynamic(name, true, true, CallType.NORMAL, null, true);
        mv.pop();
    }

    public void invokeDynamic(String name, boolean hasReceiver, boolean hasArgs, CallType callType, ClosureCallback closureArg, boolean attrAssign) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        String callSig = cg.sig(IRubyObject.class, cg.params(IRubyObject.class, IRubyObject[].class, ThreadContext.class, String.class, IRubyObject.class, CallType.class, Block.class));
        String callSigIndexed = cg.sig(IRubyObject.class, cg.params(IRubyObject.class, IRubyObject[].class, ThreadContext.class, Byte.TYPE, String.class, IRubyObject.class, CallType.class, Block.class));
        int index = MethodIndex.getIndex(name);
        if (hasArgs) {
            if (!hasReceiver) {
                this.loadSelf();
                mv.swap();
            }
        } else if (hasReceiver) {
            mv.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
        } else {
            this.loadSelf();
            mv.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
        }
        this.loadThreadContext();
        if (index != 0) {
            mv.ldc(new Integer(index));
        }
        mv.ldc(name);
        this.loadSelf();
        mv.getstatic(cg.p(CallType.class), callType.toString(), cg.ci(CallType.class));
        if (closureArg == null) {
            mv.getstatic(cg.p(Block.class), "NULL_BLOCK", cg.ci(Block.class));
        } else {
            closureArg.compile(this);
        }
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label tryCatch = new Label();
        if (closureArg != null) {
            mv.label(tryBegin);
        }
        if (attrAssign) {
            if (index != 0) {
                this.invokeUtilityMethod("doAttrAssignIndexed", callSigIndexed);
            } else {
                this.invokeUtilityMethod("doAttrAssign", callSig);
            }
        } else if (index != 0) {
            this.invokeUtilityMethod("doInvokeDynamicIndexed", callSigIndexed);
        } else {
            this.invokeUtilityMethod("doInvokeDynamic", callSig);
        }
        if (closureArg != null) {
            mv.label(tryEnd);
            Label normalEnd = new Label();
            mv.go_to(normalEnd);
            mv.label(tryCatch);
            this.loadClosure();
            this.invokeUtilityMethod("handleJumpException", cg.sig(IRubyObject.class, cg.params(JumpException.class, Block.class)));
            mv.label(normalEnd);
        }
    }

    public void yield(boolean hasArgs) {
        this.loadClosure();
        SkinnyMethodAdapter method = this.getMethodAdapter();
        if (hasArgs) {
            method.swap();
            this.loadThreadContext();
            method.swap();
        } else {
            this.loadThreadContext();
            method.aconst_null();
        }
        method.aconst_null();
        method.aconst_null();
        method.ldc(Boolean.FALSE);
        method.invokevirtual(cg.p(Block.class), "yield", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyModule.class, Boolean.TYPE)));
    }

    private void invokeIRubyObject(String methodName, String signature) {
        this.getMethodAdapter().invokeinterface(IRUBYOBJECT, methodName, signature);
    }

    public void loadThreadContext() {
        this.getMethodAdapter().aload(0);
    }

    public void loadClosure() {
        this.loadThreadContext();
        this.invokeThreadContext("getFrameBlock", cg.sig(Block.class));
    }

    public void loadSelf() {
        this.getMethodAdapter().aload(1);
    }

    public void loadRuntime() {
        this.getMethodAdapter().aload(5);
    }

    public void loadVisibility() {
        this.getMethodAdapter().aload(6);
    }

    public void loadNil() {
        this.loadRuntime();
        this.invokeIRuby("getNil", cg.sig(IRubyObject.class));
    }

    public void loadSymbol(String symbol) {
        this.loadRuntime();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.ldc(symbol);
        this.invokeIRuby("newSymbol", cg.sig(RubySymbol.class, cg.params(String.class)));
    }

    public void loadObject() {
        this.loadRuntime();
        this.invokeIRuby("getObject", cg.sig(RubyClass.class, cg.params()));
    }

    public void consumeCurrentValue() {
        this.getMethodAdapter().pop();
    }

    public void duplicateCurrentValue() {
        this.getMethodAdapter().dup();
    }

    public void swapValues() {
        this.getMethodAdapter().swap();
    }

    public void retrieveSelf() {
        this.loadSelf();
    }

    public void retrieveSelfClass() {
        this.loadSelf();
        this.invokeIRubyObject("getMetaClass", cg.sig(RubyClass.class));
    }

    public void assignLocalVariable(int index) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        mv.aload(4);
        mv.swap();
        mv.ldc(new Integer(index));
        mv.swap();
        mv.arraystore();
    }

    public void assignLastLine() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
        mv.swap();
        mv.invokevirtual(cg.p(DynamicScope.class), "setLastLine", cg.sig(Void.TYPE, cg.params(IRubyObject.class)));
    }

    public void assignLocalVariableBlockArg(int argIndex, int varIndex) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.aload(7);
        mv.ldc(new Integer(varIndex));
        mv.aload(2);
        mv.ldc(new Integer(argIndex));
        mv.arrayload();
        mv.iconst_0();
        mv.invokevirtual(cg.p(DynamicScope.class), "setValue", cg.sig(Void.TYPE, cg.params(Integer.TYPE, IRubyObject.class, Integer.TYPE)));
    }

    public void retrieveLocalVariable(int index) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.aload(4);
        mv.ldc(new Integer(index));
        mv.arrayload();
        this.nullToNil();
    }

    public void retrieveLastLine() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
        mv.invokevirtual(cg.p(DynamicScope.class), "getLastLine", cg.sig(IRubyObject.class));
        this.nullToNil();
    }

    public void retrieveBackRef() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
        mv.invokevirtual(cg.p(DynamicScope.class), "getBackRef", cg.sig(IRubyObject.class));
        this.nullToNil();
    }

    public void assignLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.assignLocalVariable(index);
            return;
        }
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        mv.aload(7);
        mv.swap();
        mv.ldc(new Integer(index));
        mv.swap();
        mv.ldc(new Integer(depth));
        mv.invokevirtual(cg.p(DynamicScope.class), "setValue", cg.sig(Void.TYPE, cg.params(Integer.TYPE, IRubyObject.class, Integer.TYPE)));
    }

    public void assignLocalVariableBlockArg(int argIndex, int varIndex, int depth) {
        if (depth == 0) {
            this.assignLocalVariableBlockArg(argIndex, varIndex);
            return;
        }
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.aload(7);
        mv.ldc(new Integer(varIndex));
        mv.aload(2);
        mv.ldc(new Integer(argIndex));
        mv.arrayload();
        mv.ldc(new Integer(depth));
        mv.invokevirtual(cg.p(DynamicScope.class), "setValue", cg.sig(Void.TYPE, cg.params(Integer.TYPE, IRubyObject.class, Integer.TYPE)));
    }

    public void retrieveLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index);
            return;
        }
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.aload(7);
        mv.ldc(new Integer(index));
        mv.ldc(new Integer(depth));
        mv.invokevirtual(cg.p(DynamicScope.class), "getValue", cg.sig(IRubyObject.class, cg.params(Integer.TYPE, Integer.TYPE)));
        this.nullToNil();
    }

    public void assignConstantInCurrent(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadThreadContext();
        mv.ldc(name);
        mv.dup2_x1();
        mv.pop2();
        this.invokeThreadContext("setConstantInCurrent", cg.sig(IRubyObject.class, cg.params(String.class, IRubyObject.class)));
    }

    public void assignConstantInModule(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadThreadContext();
        mv.ldc(name);
        mv.swap2();
        this.invokeThreadContext("setConstantInCurrent", cg.sig(IRubyObject.class, cg.params(String.class, RubyModule.class, IRubyObject.class)));
    }

    public void assignConstantInObject(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        this.invokeIRuby("getObject", cg.sig(RubyClass.class, cg.params()));
        mv.swap();
        this.assignConstantInModule(name);
    }

    public void retrieveConstant(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadThreadContext();
        mv.ldc(name);
        this.invokeThreadContext("getConstant", cg.sig(IRubyObject.class, cg.params(String.class)));
    }

    public void retrieveClassVariable(String name) {
        this.loadThreadContext();
        this.loadRuntime();
        this.loadSelf();
        this.getMethodAdapter().ldc(name);
        this.invokeUtilityMethod("fetchClassVariable", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class)));
    }

    public void assignClassVariable(String name) {
        SkinnyMethodAdapter method = this.getMethodAdapter();
        this.loadThreadContext();
        method.swap();
        this.loadRuntime();
        method.swap();
        this.loadSelf();
        method.swap();
        this.getMethodAdapter().ldc(name);
        method.swap();
        this.invokeUtilityMethod("setClassVariable", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
    }

    private void loadScope(int depth) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.aload(4);
        mv.ldc(new Integer(depth - 1));
        mv.arrayload();
    }

    public void createNewFloat(double value) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.ldc(new Double(value));
        this.invokeIRuby("newFloat", cg.sig(RubyFloat.class, cg.params(Double.TYPE)));
    }

    public void createNewFixnum(long value) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.ldc(new Long(value));
        this.invokeIRuby("newFixnum", cg.sig(RubyFixnum.class, cg.params(Long.TYPE)));
    }

    public void createNewBignum(BigInteger value) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.ldc(value.toString());
        mv.invokestatic(cg.p(RubyBignum.class), "newBignum", cg.sig(RubyBignum.class, cg.params(Ruby.class, String.class)));
    }

    public void createNewString(ArrayCallback callback, int count) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        this.invokeIRuby("newString", cg.sig(RubyString.class, cg.params()));
        for (int i = 0; i < count; ++i) {
            callback.nextValue(this, null, i);
            mv.invokevirtual(cg.p(RubyString.class), "append", cg.sig(RubyString.class, cg.params(IRubyObject.class)));
        }
    }

    public void createNewString(ByteList value) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.ldc(value.toString());
        this.invokeIRuby("newString", cg.sig(RubyString.class, cg.params(String.class)));
    }

    public void createNewSymbol(String name) {
        this.loadRuntime();
        this.getMethodAdapter().ldc(name);
        this.invokeIRuby("newSymbol", cg.sig(RubySymbol.class, cg.params(String.class)));
    }

    public void createNewArray() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.swap();
        this.invokeIRuby("newArrayNoCopy", cg.sig(RubyArray.class, cg.params(IRubyObject[].class)));
    }

    public void createEmptyArray() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        this.invokeIRuby("newArray", cg.sig(RubyArray.class, cg.params()));
    }

    public void createObjectArray(Object[] sourceArray, ArrayCallback callback) {
        this.buildObjectArray(IRUBYOBJECT, sourceArray, callback);
    }

    public void createObjectArray(int elementCount) {
        SkinnyMethodAdapter method = this.getMethodAdapter();
        method.ldc(new Integer(elementCount));
        method.anewarray(cg.p(IRubyObject.class));
        for (int i = 0; i < elementCount; ++i) {
            method.dup_x1();
            method.dup_x1();
            method.pop();
            method.ldc(new Integer(elementCount - 1 - i));
            method.swap();
            method.arraystore();
        }
    }

    private void buildObjectArray(String type, Object[] sourceArray, ArrayCallback callback) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.ldc(new Integer(sourceArray.length));
        mv.anewarray(type);
        for (int i = 0; i < sourceArray.length; ++i) {
            mv.dup();
            mv.ldc(new Integer(i));
            callback.nextValue(this, sourceArray, i);
            mv.arraystore();
        }
    }

    public void createEmptyHash() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.invokestatic(cg.p(RubyHash.class), "newHash", cg.sig(RubyHash.class, cg.params(Ruby.class)));
    }

    public void createNewHash(Object elements, ArrayCallback callback, int keyCount) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.newobj(cg.p(HashMap.class));
        mv.dup();
        mv.invokespecial(cg.p(HashMap.class), "<init>", cg.sig(Void.TYPE));
        for (int i = 0; i < keyCount; ++i) {
            mv.dup();
            callback.nextValue(this, elements, i);
            mv.invokevirtual(cg.p(HashMap.class), "put", cg.sig(Object.class, cg.params(Object.class, Object.class)));
            mv.pop();
        }
        this.loadNil();
        mv.invokestatic(cg.p(RubyHash.class), "newHash", cg.sig(RubyHash.class, cg.params(Ruby.class, Map.class, IRubyObject.class)));
    }

    public void createNewRange(boolean isExclusive) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.dup_x2();
        mv.pop();
        mv.ldc(new Boolean(isExclusive));
        mv.invokestatic(cg.p(RubyRange.class), "newRange", cg.sig(RubyRange.class, cg.params(Ruby.class, IRubyObject.class, IRubyObject.class, Boolean.TYPE)));
    }

    private void isTrue() {
        this.invokeIRubyObject("isTrue", cg.sig(Boolean.TYPE));
    }

    public void performBooleanBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.isTrue();
        mv.ifeq(falseJmp);
        trueBranch.branch(this);
        mv.go_to(afterJmp);
        mv.label(falseJmp);
        falseBranch.branch(this);
        mv.label(afterJmp);
    }

    public void performLogicalAnd(BranchCallback longBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        this.isTrue();
        mv.ifeq(falseJmp);
        mv.pop();
        longBranch.branch(this);
        mv.label(falseJmp);
    }

    public void performLogicalOr(BranchCallback longBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        this.isTrue();
        mv.ifne(falseJmp);
        mv.pop();
        longBranch.branch(this);
        mv.label(falseJmp);
    }

    public void performBooleanLoop(BranchCallback condition, BranchCallback body, boolean checkFirst) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label tryCatch = new Label();
        mv.trycatch(tryBegin, tryEnd, tryCatch, cg.p(JumpException.class));
        mv.label(tryBegin);
        Label endJmp = new Label();
        if (checkFirst) {
            condition.branch(this);
            this.isTrue();
            mv.ifeq(endJmp);
        }
        Label topJmp = new Label();
        mv.label(topJmp);
        body.branch(this);
        mv.pop();
        condition.branch(this);
        this.isTrue();
        mv.ifne(topJmp);
        if (checkFirst) {
            mv.label(endJmp);
        }
        mv.label(tryEnd);
        Label normalBreak = new Label();
        mv.go_to(normalBreak);
        mv.label(tryCatch);
        mv.dup();
        mv.invokevirtual(cg.p(JumpException.class), "getJumpType", cg.sig(JumpException.JumpType.class));
        mv.invokevirtual(cg.p(JumpException.JumpType.class), "getTypeId", cg.sig(Integer.TYPE));
        Label tryDefault = new Label();
        Label breakLabel = new Label();
        mv.lookupswitch(tryDefault, new int[]{0}, new Label[]{breakLabel});
        mv.label(tryDefault);
        mv.athrow();
        mv.label(breakLabel);
        mv.dup();
        mv.invokevirtual(cg.p(JumpException.class), "getTarget", cg.sig(Object.class));
        this.loadClosure();
        Label notBlockBreak = new Label();
        mv.if_acmpne(notBlockBreak);
        mv.dup();
        mv.aconst_null();
        mv.invokevirtual(cg.p(JumpException.class), "setTarget", cg.sig(Void.TYPE, cg.params(Object.class)));
        mv.athrow();
        mv.label(notBlockBreak);
        mv.pop();
        mv.label(normalBreak);
        this.loadNil();
    }

    public void performReturn() {
        if (this.isCompilingClosure) {
            throw new NotCompilableException("Can't compile non-local return");
        }
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.areturn();
    }

    public void createNewClosure(StaticScope scope, int arity, ClosureCallback body, ClosureCallback args) {
        ClassVisitor cv = this.getClassVisitor();
        String closureMethodName = "closure" + ++this.innerIndex;
        String closureFieldName = "_" + closureMethodName;
        cv.visitField(10, closureFieldName, cg.ci(CompiledBlockCallback.class), null, null);
        SkinnyMethodAdapter method = new SkinnyMethodAdapter(cv.visitMethod(9, closureMethodName, CLOSURE_SIGNATURE, null, null));
        boolean previousIsCompilingClosure = this.isCompilingClosure;
        this.isCompilingClosure = true;
        this.pushMethodAdapter(method);
        method.start();
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
        method.dup();
        method.astore(7);
        method.invokevirtual(cg.p(DynamicScope.class), "getValues", cg.sig(IRubyObject[].class));
        method.astore(4);
        method.aload(0);
        this.invokeThreadContext("getRuntime", cg.sig(Ruby.class));
        method.astore(5);
        args.compile(this);
        Label start = new Label();
        method.label(start);
        body.compile(this);
        method.areturn();
        Label end = new Label();
        method.label(end);
        method.end();
        this.popMethodAdapter();
        this.isCompilingClosure = previousIsCompilingClosure;
        method = this.getMethodAdapter();
        method.getstatic(this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
        Label alreadyCreated = new Label();
        method.ifnonnull(alreadyCreated);
        this.getCallbackFactory();
        method.ldc(closureMethodName);
        method.invokevirtual(cg.p(CallbackFactory.class), "getBlockCallback", cg.sig(CompiledBlockCallback.class, cg.params(String.class)));
        method.putstatic(this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
        method.label(alreadyCreated);
        this.loadThreadContext();
        this.loadSelf();
        method.ldc(new Integer(arity));
        this.buildStaticScopeNames(method, scope);
        method.getstatic(this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
        this.invokeUtilityMethod("createBlock", cg.sig(CompiledBlock.class, cg.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, String[].class, CompiledBlockCallback.class)));
    }

    private void buildStaticScopeNames(SkinnyMethodAdapter method, StaticScope scope) {
        method.ldc(new Integer(scope.getNumberOfVariables()));
        method.anewarray(cg.p(String.class));
        for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
            method.dup();
            method.ldc(new Integer(i));
            method.ldc(scope.getVariables()[i]);
            method.arraystore();
        }
    }

    private void invokeUtilityMethod(String methodName, String signature) {
        this.getMethodAdapter().invokestatic(cg.p(CompilerHelpers.class), methodName, signature);
    }

    private void invokeThreadContext(String methodName, String signature) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.invokevirtual(THREADCONTEXT, methodName, signature);
    }

    private void invokeIRuby(String methodName, String signature) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.invokevirtual(RUBY, methodName, signature);
    }

    private void getCallbackFactory() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        this.getCompiledClass();
        mv.dup();
        mv.invokevirtual(cg.p(Class.class), "getClassLoader", cg.sig(ClassLoader.class));
        mv.invokestatic(cg.p(CallbackFactory.class), "createFactory", cg.sig(CallbackFactory.class, cg.params(Ruby.class, Class.class, ClassLoader.class)));
    }

    private void getCompiledClass() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.getstatic(this.classname, "$class", cg.ci(Class.class));
    }

    private void getRubyClass() {
        this.loadSelf();
        this.invokeIRubyObject("getMetaClass", cg.sig(RubyClass.class));
    }

    private void getCRef() {
        this.loadThreadContext();
        this.invokeThreadContext("peekCRef", cg.sig(SinglyLinkedList.class));
    }

    private void newTypeError(String error) {
        this.loadRuntime();
        this.getMethodAdapter().ldc(error);
        this.invokeIRuby("newTypeError", cg.sig(RaiseException.class, cg.params(String.class)));
    }

    private void getCurrentVisibility() {
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentVisibility", cg.sig(Visibility.class));
    }

    private void println() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        mv.getstatic(cg.p(System.class), "out", cg.ci(PrintStream.class));
        mv.swap();
        mv.invokevirtual(cg.p(PrintStream.class), "println", cg.sig(Void.TYPE, cg.params(Object.class)));
    }

    public void defineAlias(String newName, String oldName) {
        this.getRubyClass();
        this.getMethodAdapter().ldc(newName);
        this.getMethodAdapter().ldc(oldName);
        this.getMethodAdapter().invokevirtual(cg.p(RubyModule.class), "defineAlias", cg.sig(Void.TYPE, cg.params(String.class, String.class)));
        this.loadNil();
    }

    public void defineNewMethod(String name, StaticScope scope, ClosureCallback body, ClosureCallback args) {
        if (this.isCompilingClosure) {
            throw new NotCompilableException("Can't compile def within closure yet");
        }
        ++this.methodIndex;
        String methodName = cg.cleanJavaIdentifier(name) + "__" + this.methodIndex;
        this.beginMethod(methodName, args);
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        body.compile(this);
        this.endMethod(mv);
        mv = this.getMethodAdapter();
        this.loadThreadContext();
        this.loadVisibility();
        this.loadSelf();
        this.getCompiledClass();
        mv.ldc(name);
        mv.ldc(methodName);
        this.buildStaticScopeNames(mv, scope);
        mv.ldc(new Integer(0));
        this.invokeUtilityMethod("def", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, Visibility.class, IRubyObject.class, Class.class, String.class, String.class, String[].class, Integer.TYPE)));
    }

    public void processRequiredArgs(Arity arity, int totalArgs) {
        SkinnyMethodAdapter newMethod = this.getMethodAdapter();
        newMethod.ldc(new Integer(arity.getValue()));
        newMethod.invokestatic(cg.p(Arity.class), "createArity", cg.sig(Arity.class, cg.params(Integer.TYPE)));
        this.loadRuntime();
        newMethod.aload(2);
        newMethod.invokevirtual(cg.p(Arity.class), "checkArity", cg.sig(Void.TYPE, cg.params(Ruby.class, IRubyObject[].class)));
        if (!arity.isFixed()) {
            this.loadRuntime();
            newMethod.aload(2);
            newMethod.arraylength();
            newMethod.ldc(new Integer(totalArgs));
            this.invokeUtilityMethod("raiseArgumentError", cg.sig(Void.TYPE, cg.params(Ruby.class, Integer.TYPE, Integer.TYPE)));
        }
        Label noArgs = new Label();
        newMethod.aload(2);
        newMethod.ifnull(noArgs);
        newMethod.aload(2);
        newMethod.arraylength();
        newMethod.ifeq(noArgs);
        newMethod.aload(7);
        newMethod.aload(2);
        newMethod.dup();
        newMethod.arraylength();
        newMethod.invokevirtual(cg.p(DynamicScope.class), "setArgValues", cg.sig(Void.TYPE, cg.params(IRubyObject[].class, Integer.TYPE)));
        newMethod.label(noArgs);
        this.pushArity(arity);
    }

    public void assignOptionalArgs(Object object, int expectedArgsCount, int size, ArrayCallback optEval) {
        int i;
        SkinnyMethodAdapter newMethod = this.getMethodAdapter();
        newMethod.aload(2);
        newMethod.arraylength();
        Label defaultLabel = new Label();
        Label[] labels = new Label[size];
        for (i = 0; i < size; ++i) {
            labels[i] = new Label();
        }
        newMethod.tableswitch(expectedArgsCount, expectedArgsCount + size - 1, defaultLabel, labels);
        for (i = 0; i < size; ++i) {
            newMethod.label(labels[i]);
            optEval.nextValue(this, object, i);
            newMethod.pop();
        }
        newMethod.label(defaultLabel);
    }

    public void loadFalse() {
        this.loadRuntime();
        this.invokeIRuby("getFalse", cg.sig(RubyBoolean.class));
    }

    public void loadTrue() {
        this.loadRuntime();
        this.invokeIRuby("getTrue", cg.sig(RubyBoolean.class));
    }

    public void retrieveInstanceVariable(String name) {
        this.loadSelf();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.ldc(name);
        this.invokeIRubyObject("getInstanceVariable", cg.sig(IRubyObject.class, cg.params(String.class)));
        mv.dup();
        Label notNull = new Label();
        mv.ifnonnull(notNull);
        mv.pop();
        this.loadNil();
        mv.label(notNull);
    }

    public void assignInstanceVariable(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadSelf();
        mv.swap();
        mv.ldc(name);
        mv.swap();
        this.invokeIRubyObject("setInstanceVariable", cg.sig(IRubyObject.class, cg.params(String.class, IRubyObject.class)));
    }

    public void assignInstanceVariableBlockArg(int argIndex, String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadSelf();
        mv.ldc(name);
        mv.aload(2);
        mv.ldc(new Integer(argIndex));
        mv.arrayload();
        this.invokeIRubyObject("setInstanceVariable", cg.sig(IRubyObject.class, cg.params(String.class, IRubyObject.class)));
    }

    public void retrieveGlobalVariable(String name) {
        this.loadRuntime();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.invokeIRuby("getGlobalVariables", cg.sig(GlobalVariables.class));
        mv.ldc(name);
        mv.invokevirtual(cg.p(GlobalVariables.class), "get", cg.sig(IRubyObject.class, cg.params(String.class)));
    }

    public void assignGlobalVariable(String name) {
        this.loadRuntime();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.invokeIRuby("getGlobalVariables", cg.sig(GlobalVariables.class));
        mv.swap();
        mv.ldc(name);
        mv.swap();
        mv.invokevirtual(cg.p(GlobalVariables.class), "set", cg.sig(IRubyObject.class, cg.params(String.class, IRubyObject.class)));
    }

    public void assignGlobalVariableBlockArg(int argIndex, String name) {
        this.loadRuntime();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.invokeIRuby("getGlobalVariables", cg.sig(GlobalVariables.class));
        mv.ldc(name);
        mv.aload(2);
        mv.ldc(new Integer(argIndex));
        mv.arrayload();
        mv.invokevirtual(cg.p(GlobalVariables.class), "set", cg.sig(IRubyObject.class, cg.params(String.class, IRubyObject.class)));
    }

    public void negateCurrentValue() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.isTrue();
        Label isTrue = new Label();
        Label end = new Label();
        mv.ifne(isTrue);
        this.loadTrue();
        mv.go_to(end);
        mv.label(isTrue);
        this.loadFalse();
        mv.label(end);
    }

    public void splatCurrentValue() {
        SkinnyMethodAdapter method = this.getMethodAdapter();
        method.invokestatic(cg.p(EvaluationState.class), "splatValue", cg.sig(IRubyObject.class, cg.params(IRubyObject.class)));
    }

    public void singlifySplattedValue() {
        SkinnyMethodAdapter method = this.getMethodAdapter();
        method.invokestatic(cg.p(EvaluationState.class), "aValueSplat", cg.sig(IRubyObject.class, cg.params(IRubyObject.class)));
    }

    public void ensureRubyArray() {
        this.invokeUtilityMethod("ensureRubyArray", cg.sig(RubyArray.class, cg.params(IRubyObject.class)));
    }

    public void forEachInValueArray(int start, int count, Object source, ArrayCallback callback) {
        SkinnyMethodAdapter method = this.getMethodAdapter();
        Label noMoreArrayElements = new Label();
        while (start < count) {
            method.dup();
            method.invokevirtual(cg.p(RubyArray.class), "getLength", cg.sig(Integer.TYPE, cg.params()));
            method.ldc(new Integer(start));
            method.ifle(noMoreArrayElements);
            method.dup();
            method.ldc(new Integer(start));
            method.invokevirtual(cg.p(RubyArray.class), "entry", cg.sig(IRubyObject.class, cg.params(Long.TYPE)));
            callback.nextValue(this, source, start);
            ++start;
        }
        method.label(noMoreArrayElements);
    }

    public void loadInteger(int value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performGEBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performGTBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performLEBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performLTBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void loadRubyArraySize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void issueBreakEvent() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.newobj(cg.p(JumpException.class));
        mv.dup();
        mv.getstatic(cg.p(JumpException.JumpType.class), "BreakJump", cg.ci(JumpException.JumpType.class));
        mv.invokespecial(cg.p(JumpException.class), "<init>", cg.sig(Void.TYPE, cg.params(JumpException.JumpType.class)));
        mv.dup_x1();
        mv.swap();
        mv.invokevirtual(cg.p(JumpException.class), "setValue", cg.sig(Void.TYPE, cg.params(Object.class)));
        mv.athrow();
    }

    public void asString() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.invokeinterface(cg.p(IRubyObject.class), "asString", cg.sig(RubyString.class, cg.params()));
    }

    public void nthRef(int match) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.ldc(new Integer(match));
        this.loadThreadContext();
        this.invokeThreadContext("getBackref", cg.sig(IRubyObject.class, cg.params()));
        mv.invokestatic(cg.p(RubyRegexp.class), "nth_match", cg.sig(IRubyObject.class, cg.params(Integer.TYPE, IRubyObject.class)));
    }

    public void match() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.invokevirtual(cg.p(RubyRegexp.class), "match2", cg.sig(IRubyObject.class, cg.params()));
    }

    public void match2() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.invokevirtual(cg.p(RubyRegexp.class), "match", cg.sig(IRubyObject.class, cg.params(IRubyObject.class)));
    }

    public void match3() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        mv.visitTypeInsn(193, cg.p(RubyString.class));
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.invokevirtual(cg.p(RubyRegexp.class), "match", cg.sig(IRubyObject.class, cg.params(IRubyObject.class)));
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.swap();
        this.loadThreadContext();
        mv.swap();
        mv.ldc("=~");
        mv.swap();
        mv.invokeinterface(cg.p(IRubyObject.class), "callMethod", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, String.class, IRubyObject.class)));
        mv.visitLabel(l1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewConstant(String type, String name_prefix) {
        String realName;
        ClassVisitor cv = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            realName = name_prefix + this.constants++;
        }
        cv.visitField(10, realName, type, null, null).visitEnd();
        return realName;
    }

    public void createNewRegexp(ByteList value, int options, String lang) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        String name = this.getNewConstant(cg.ci(Pattern.class), "literal_re_");
        String name_flags = this.getNewConstant(cg.ci(Integer.TYPE), "literal_re_flags_");
        this.loadRuntime();
        mv.ldc(value.toString());
        mv.visitFieldInsn(178, this.classname, name, cg.ci(Pattern.class));
        mv.dup();
        Label alreadyCreated = new Label();
        mv.ifnonnull(alreadyCreated);
        mv.pop();
        mv.ldc(new Integer(options));
        this.invokeUtilityMethod("regexpLiteralFlags", cg.sig(Integer.TYPE, cg.params(Integer.TYPE)));
        mv.visitFieldInsn(179, this.classname, name_flags, cg.ci(Integer.TYPE));
        this.loadRuntime();
        mv.ldc(value.toString());
        mv.ldc(new Integer(options));
        this.invokeUtilityMethod("regexpLiteral", cg.sig(Pattern.class, cg.params(Ruby.class, String.class, Integer.TYPE)));
        mv.dup();
        mv.visitFieldInsn(179, this.classname, name, cg.ci(Pattern.class));
        mv.label(alreadyCreated);
        mv.visitFieldInsn(178, this.classname, name_flags, cg.ci(Integer.TYPE));
        if (null == lang) {
            mv.aconst_null();
        } else {
            mv.ldc(lang);
        }
        mv.invokestatic(cg.p(RubyRegexp.class), "newRegexp", cg.sig(RubyRegexp.class, cg.params(Ruby.class, String.class, Pattern.class, Integer.TYPE, String.class)));
    }

    public void defineClass(String name, StaticScope staticScope, ClosureCallback superCallback, ClosureCallback pathCallback, ClosureCallback bodyCallback) {
        ++this.methodIndex;
        String methodName = "rubyclass__" + cg.cleanJavaIdentifier(name) + "__" + this.methodIndex;
        this.beginMethod(methodName, null);
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.getstatic(cg.p(Visibility.class), "PUBLIC", cg.ci(Visibility.class));
        mv.astore(6);
        this.loadRuntime();
        superCallback.compile(this);
        this.invokeUtilityMethod("prepareSuperClass", cg.sig(RubyClass.class, cg.params(Ruby.class, IRubyObject.class)));
        this.loadThreadContext();
        pathCallback.compile(this);
        this.invokeUtilityMethod("prepareClassNamespace", cg.sig(RubyModule.class, cg.params(ThreadContext.class, IRubyObject.class)));
        mv.swap();
        mv.ldc(name);
        mv.swap();
        mv.invokevirtual(cg.p(RubyModule.class), "defineOrGetClassUnder", cg.sig(RubyClass.class, cg.params(String.class, RubyClass.class)));
        mv.dup();
        mv.astore(1);
        this.loadThreadContext();
        mv.swap();
        this.invokeThreadContext("preCompiledClass", cg.sig(Void.TYPE, cg.params(RubyModule.class)));
        bodyCallback.compile(this);
        this.loadThreadContext();
        this.invokeThreadContext("postCompiledClass", cg.sig(Void.TYPE, cg.params()));
        this.endMethod(mv);
        mv = this.getMethodAdapter();
        this.loadThreadContext();
        this.loadSelf();
        mv.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
        mv.getstatic(cg.p(Block.class), "NULL_BLOCK", cg.ci(Block.class));
        mv.invokestatic(this.classname, methodName, METHOD_SIGNATURE);
    }

    public void defineModule(String name, StaticScope staticScope, ClosureCallback pathCallback, ClosureCallback bodyCallback) {
        ++this.methodIndex;
        String methodName = "rubymodule__" + cg.cleanJavaIdentifier(name) + "__" + this.methodIndex;
        this.beginMethod(methodName, null);
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.getstatic(cg.p(Visibility.class), "PUBLIC", cg.ci(Visibility.class));
        mv.astore(6);
        this.loadThreadContext();
        pathCallback.compile(this);
        this.invokeUtilityMethod("prepareClassNamespace", cg.sig(RubyModule.class, cg.params(ThreadContext.class, IRubyObject.class)));
        mv.ldc(name);
        mv.invokevirtual(cg.p(RubyModule.class), "defineModuleUnder", cg.sig(RubyModule.class, cg.params(String.class)));
        mv.dup();
        mv.astore(1);
        this.loadThreadContext();
        mv.swap();
        this.invokeThreadContext("preCompiledClass", cg.sig(Void.TYPE, cg.params(RubyModule.class)));
        bodyCallback.compile(this);
        this.loadThreadContext();
        this.invokeThreadContext("postCompiledClass", cg.sig(Void.TYPE, cg.params()));
        this.endMethod(mv);
        mv = this.getMethodAdapter();
        this.loadThreadContext();
        this.loadSelf();
        mv.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
        mv.getstatic(cg.p(Block.class), "NULL_BLOCK", cg.ci(Block.class));
        mv.invokestatic(this.classname, methodName, METHOD_SIGNATURE);
    }

    public void pollThreadEvents() {
        this.loadThreadContext();
        this.invokeThreadContext("pollThreadEvents", cg.sig(Void.TYPE));
    }

    private void nullToNil() {
        this.loadRuntime();
        this.invokeUtilityMethod("nullToNil", cg.sig(IRubyObject.class, cg.params(IRubyObject.class, Ruby.class)));
    }
}

