/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import org.jruby.Profile;
import org.jruby.Ruby;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.CommandlineParser;
import org.jruby.util.JRubyFile;

public class RubyInstanceConfig {
    private InputStream input = System.in;
    private PrintStream output = System.out;
    private PrintStream error = System.err;
    private Profile profile = Profile.DEFAULT;
    private boolean objectSpaceEnabled = true;
    private String currentDirectory;
    private Map environment;
    private LoadServiceCreator creator = LoadServiceCreator.DEFAULT;

    public RubyInstanceConfig() {
        if (Ruby.isSecurityRestricted()) {
            this.currentDirectory = "/";
        } else {
            this.currentDirectory = JRubyFile.getFileProperty("user.dir");
            if (System.getProperty("jruby.objectspace.enabled") != null) {
                this.objectSpaceEnabled = Boolean.getBoolean("jruby.objectspace.enabled");
            }
        }
    }

    public LoadServiceCreator getLoadServiceCreator() {
        return this.creator;
    }

    public void setLoadServiceCreator(LoadServiceCreator creator) {
        this.creator = creator;
    }

    public LoadService createLoadService(Ruby runtime) {
        return this.creator.create(runtime);
    }

    public void updateWithCommandline(CommandlineParser cmdline) {
        this.objectSpaceEnabled = cmdline.isObjectSpaceEnabled();
    }

    public void setInput(InputStream newInput) {
        this.input = newInput;
    }

    public InputStream getInput() {
        return this.input;
    }

    public void setOutput(PrintStream newOutput) {
        this.output = newOutput;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setError(PrintStream newError) {
        this.error = newError;
    }

    public PrintStream getError() {
        return this.error;
    }

    public void setCurrentDirectory(String newCurrentDirectory) {
        this.currentDirectory = newCurrentDirectory;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setProfile(Profile newProfile) {
        this.profile = newProfile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setObjectSpaceEnabled(boolean newObjectSpaceEnabled) {
        this.objectSpaceEnabled = newObjectSpaceEnabled;
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public void setEnvironment(Map newEnvironment) {
        this.environment = newEnvironment;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public static interface LoadServiceCreator {
        public static final LoadServiceCreator DEFAULT = new LoadServiceCreator(){

            public LoadService create(Ruby runtime) {
                return new LoadService(runtime);
            }
        };

        public LoadService create(Ruby var1);
    }
}

