/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyBinding;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class SimpleInvocationMethod
extends DynamicMethod
implements Cloneable {
    private Arity arity;

    public SimpleInvocationMethod(RubyModule implementationClass, Arity arity, Visibility visibility) {
        super(implementationClass, visibility);
        this.arity = arity;
    }

    public void preMethod(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
    }

    public void postMethod(ThreadContext context) {
    }

    public IRubyObject internalCall(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        assert (false);
        return null;
    }

    private IRubyObject wrap(Ruby runtime, IRubyObject self, IRubyObject[] args) {
        try {
            return this.call(self, args);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (JumpException e) {
            throw e;
        }
        catch (ThreadKill e) {
            throw e;
        }
        catch (MainExitException e) {
            throw e;
        }
        catch (Exception e) {
            runtime.getJavaSupport().handleNativeException(e);
            return runtime.getNil();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, boolean noSuper, Block block) {
        Ruby runtime = context.getRuntime();
        this.arity.checkArity(runtime, args);
        if (runtime.getTraceFunction() != null) {
            ISourcePosition position = context.getPosition();
            RubyBinding binding = RubyBinding.newBinding(runtime);
            runtime.callTraceFunction(context, "c-call", position, binding, name, this.getImplementationClass());
            try {
                IRubyObject iRubyObject = this.wrap(runtime, self, args);
                return iRubyObject;
            }
            finally {
                runtime.callTraceFunction(context, "c-return", position, binding, name, this.getImplementationClass());
            }
        }
        return this.wrap(runtime, self, args);
    }

    public abstract IRubyObject call(IRubyObject var1, IRubyObject[] var2);

    public DynamicMethod dup() {
        try {
            return (SimpleInvocationMethod)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Arity getArity() {
        return this.arity;
    }
}

