/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubySystemExit
extends RubyException {
    IRubyObject status;
    private static ObjectAllocator SYSTEMEXIT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubySystemExit(runtime, klass);
        }
    };

    public static RubyClass createSystemExitClass(Ruby runtime, RubyClass exceptionClass) {
        RubyClass systemExitClass = runtime.defineClass("SystemExit", exceptionClass, SYSTEMEXIT_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubySystemExit.class);
        systemExitClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        systemExitClass.defineMethod("status", callbackFactory.getFastMethod("status"));
        systemExitClass.defineMethod("success?", callbackFactory.getFastMethod("success_p"));
        return systemExitClass;
    }

    public static RubySystemExit newInstance(Ruby runtime, int status) {
        RubyClass exc = runtime.getClass("SystemExit");
        IRubyObject[] exArgs = new IRubyObject[]{runtime.newFixnum(status), runtime.newString("exit")};
        return (RubySystemExit)exc.newInstance(exArgs, Block.NULL_BLOCK);
    }

    protected RubySystemExit(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass);
        this.status = runtime.getNil();
    }

    public IRubyObject initialize(IRubyObject[] args, Block block) {
        this.status = RubyFixnum.zero(this.getRuntime());
        if (args.length > 0 && args[0] instanceof RubyFixnum) {
            this.status = args[0];
            IRubyObject[] tmpArgs = new IRubyObject[args.length - 1];
            System.arraycopy(args, 1, tmpArgs, 0, tmpArgs.length);
            args = tmpArgs;
        }
        super.initialize(args, block);
        return this;
    }

    public IRubyObject status() {
        return this.status;
    }

    public IRubyObject success_p() {
        if (this.status.isNil()) {
            return this.getRuntime().getTrue();
        }
        if (this.status.equals(RubyFixnum.zero(this.getRuntime()))) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }
}

