/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.util.ByteList;
import org.jvyamlb.Emitter;
import org.jvyamlb.Resolver;
import org.jvyamlb.Serializer;
import org.jvyamlb.SerializerException;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.events.AliasEvent;
import org.jvyamlb.events.DocumentEndEvent;
import org.jvyamlb.events.DocumentStartEvent;
import org.jvyamlb.events.MappingEndEvent;
import org.jvyamlb.events.MappingStartEvent;
import org.jvyamlb.events.ScalarEvent;
import org.jvyamlb.events.SequenceEndEvent;
import org.jvyamlb.events.SequenceStartEvent;
import org.jvyamlb.events.StreamEndEvent;
import org.jvyamlb.events.StreamStartEvent;
import org.jvyamlb.nodes.CollectionNode;
import org.jvyamlb.nodes.LinkNode;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class SerializerImpl
implements Serializer {
    private Emitter emitter;
    private Resolver resolver;
    private YAMLConfig options;
    private boolean useExplicitStart;
    private boolean useExplicitEnd;
    private int[] useVersion;
    private boolean useTags;
    private String anchorTemplate;
    private Map serializedNodes;
    private Map anchors;
    private int lastAnchorId;
    private boolean closed;
    private boolean opened;

    public SerializerImpl(Emitter emitter, Resolver resolver, YAMLConfig opts) {
        this.emitter = emitter;
        this.resolver = resolver;
        this.options = opts;
        this.useExplicitStart = opts.explicitStart();
        this.useExplicitEnd = opts.explicitEnd();
        int[] version = new int[2];
        if (opts.useVersion()) {
            String v1 = opts.version();
            int index = v1.indexOf(46);
            version[0] = Integer.parseInt(v1.substring(0, index));
            version[1] = Integer.parseInt(v1.substring(index + 1));
        } else {
            version = null;
        }
        this.useVersion = version;
        this.useTags = opts.useHeader();
        this.anchorTemplate = opts.anchorFormat() == null ? "id{0,number,000}" : opts.anchorFormat();
        this.serializedNodes = new IdentityHashMap();
        this.anchors = new IdentityHashMap();
        this.lastAnchorId = 0;
        this.closed = false;
        this.opened = false;
    }

    protected boolean ignoreAnchor(Node node) {
        return false;
    }

    public void open() throws IOException {
        if (this.closed || this.opened) {
            if (this.closed) {
                throw new SerializerException("serializer is closed");
            }
            throw new SerializerException("serializer is already opened");
        }
        this.emitter.emit(new StreamStartEvent());
        this.opened = true;
    }

    public void close() throws IOException {
        if (!this.opened) {
            throw new SerializerException("serializer is not opened");
        }
        if (!this.closed) {
            this.emitter.emit(new StreamEndEvent());
            this.closed = true;
            this.opened = false;
        }
    }

    public void serialize(Node node) throws IOException {
        if (!this.closed && !this.opened) {
            throw new SerializerException("serializer is not opened");
        }
        if (this.closed) {
            throw new SerializerException("serializer is closed");
        }
        this.emitter.emit(new DocumentStartEvent(this.useExplicitStart, this.useVersion, null));
        this.anchorNode(node);
        this.serializeNode(node, null, null);
        this.emitter.emit(new DocumentEndEvent(this.useExplicitEnd));
        this.serializedNodes = new IdentityHashMap();
        this.anchors = new IdentityHashMap();
        this.lastAnchorId = 0;
    }

    private void anchorNode(Node node) {
        block6: {
            block7: {
                while (node instanceof LinkNode) {
                    node = ((LinkNode)node).getAnchor();
                }
                if (this.ignoreAnchor(node)) break block6;
                if (!this.anchors.containsKey(node)) break block7;
                String anchor = (String)this.anchors.get(node);
                if (null != anchor) break block6;
                anchor = this.generateAnchor(node);
                this.anchors.put(node, anchor);
                break block6;
            }
            this.anchors.put(node, null);
            if (node instanceof SequenceNode) {
                Iterator iter = ((List)node.getValue()).iterator();
                while (iter.hasNext()) {
                    this.anchorNode((Node)iter.next());
                }
            } else if (node instanceof MappingNode) {
                Map value = (Map)node.getValue();
                Iterator iter = value.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry me = iter.next();
                    this.anchorNode((Node)me.getKey());
                    this.anchorNode((Node)me.getValue());
                }
            }
        }
    }

    private String generateAnchor(Node node) {
        ++this.lastAnchorId;
        return new MessageFormat(this.anchorTemplate).format(new Object[]{new Integer(this.lastAnchorId)});
    }

    private void serializeNode(Node node, Node parent, Object index) throws IOException {
        while (node instanceof LinkNode) {
            node = ((LinkNode)node).getAnchor();
        }
        String tAlias = (String)this.anchors.get(node);
        if (this.serializedNodes.containsKey(node) && tAlias != null) {
            this.emitter.emit(new AliasEvent(tAlias));
        } else {
            this.serializedNodes.put(node, null);
            this.resolver.descendResolver(parent, index);
            if (node instanceof ScalarNode) {
                String detectedTag = this.resolver.resolve(ScalarNode.class, (ByteList)node.getValue(), new boolean[]{true, false});
                String defaultTag = this.resolver.resolve(ScalarNode.class, (ByteList)node.getValue(), new boolean[]{false, true});
                boolean[] implicit = new boolean[]{false, false};
                if (!this.options.explicitTypes()) {
                    implicit[0] = node.getTag().equals(detectedTag);
                    implicit[1] = node.getTag().equals(defaultTag);
                }
                this.emitter.emit(new ScalarEvent(tAlias, node.getTag(), implicit, (ByteList)node.getValue(), ((ScalarNode)node).getStyle()));
            } else if (node instanceof SequenceNode) {
                boolean implicit = !this.options.explicitTypes() && node.getTag().equals(this.resolver.resolve(SequenceNode.class, null, new boolean[]{true, true}));
                this.emitter.emit(new SequenceStartEvent(tAlias, node.getTag(), implicit, ((CollectionNode)node).getFlowStyle()));
                int ix = 0;
                Iterator iter = ((List)node.getValue()).iterator();
                while (iter.hasNext()) {
                    this.serializeNode((Node)iter.next(), node, new Integer(ix++));
                }
                this.emitter.emit(new SequenceEndEvent());
            } else if (node instanceof MappingNode) {
                boolean implicit = !this.options.explicitTypes() && node.getTag().equals(this.resolver.resolve(MappingNode.class, null, new boolean[]{true, true}));
                this.emitter.emit(new MappingStartEvent(tAlias, node.getTag(), implicit, ((CollectionNode)node).getFlowStyle()));
                Map value = (Map)node.getValue();
                Iterator iter = value.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Node key = (Node)entry.getKey();
                    Node val = (Node)entry.getValue();
                    this.serializeNode(key, node, null);
                    this.serializeNode(val, node, key);
                }
                this.emitter.emit(new MappingEndEvent());
            }
        }
    }
}

