/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.AbstractCallable;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CallBlock
extends Block {
    private Arity arity;
    private BlockCallback callback;
    private IRubyObject self;
    private RubyModule imClass;
    private ThreadContext tc;

    public CallBlock(IRubyObject self, RubyModule imClass, Arity arity, BlockCallback callback, ThreadContext ctx) {
        super(null, new CallMethod(callback), self, ctx.getCurrentFrame(), ctx.peekCRef(), Visibility.PUBLIC, ctx.getRubyClass(), ctx.getCurrentScope());
        this.arity = arity;
        this.callback = callback;
        this.self = self;
        this.imClass = imClass;
        this.tc = ctx;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        return this.callback.call(context, args, Block.NULL_BLOCK);
    }

    public Block cloneBlock() {
        return new CallBlock(this.self, this.imClass, this.arity, this.callback, this.tc);
    }

    public Arity arity() {
        return this.arity;
    }

    public static class CallMethod
    extends AbstractCallable {
        private BlockCallback callback;

        public CallMethod(BlockCallback callback) {
            this.callback = callback;
        }

        public IRubyObject call(ThreadContext context, IRubyObject receiver, IRubyObject[] args, Block block) {
            return this.callback.call(context, args, block);
        }

        public ICallable dup() {
            return new CallMethod(this.callback);
        }
    }
}

