/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyModule;
import org.jruby.ast.executable.ISeqPosition;
import org.jruby.ast.executable.YARVMachine;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public class YARVMethod
extends DynamicMethod {
    private SinglyLinkedList cref;
    private YARVMachine.InstructionSequence iseq;
    private StaticScope staticScope;
    private Arity arity;
    static final /* synthetic */ boolean $assertionsDisabled;

    public YARVMethod(RubyModule implementationClass, YARVMachine.InstructionSequence iseq, StaticScope staticScope, Visibility visibility, SinglyLinkedList cref) {
        super(implementationClass, visibility);
        boolean req;
        this.staticScope = staticScope;
        this.iseq = iseq;
        this.cref = cref;
        boolean opts = iseq.args_arg_opts > 0 || iseq.args_rest > 0;
        boolean bl = req = iseq.args_argc > 0;
        this.arity = !req && !opts ? Arity.noArguments() : (req && !opts ? Arity.fixed(iseq.args_argc) : (opts && !req ? Arity.optional() : Arity.required(iseq.args_argc)));
    }

    public void preMethod(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        context.preDefMethodInternalCall(clazz, name, self, args, this.arity.required(), block, noSuper, this.cref, this.staticScope, this);
    }

    public void postMethod(ThreadContext context) {
        context.postDefMethodInternalCall();
    }

    public IRubyObject internalCall(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        IRubyObject iRubyObject;
        block9: {
            if (!$assertionsDisabled && args == null) {
                throw new AssertionError();
            }
            Ruby runtime = context.getRuntime();
            RubyBinding binding = null;
            try {
                this.prepareArguments(context, runtime, args);
                this.getArity().checkArity(runtime, args);
                if (runtime.getTraceFunction() != null) {
                    binding = RubyBinding.newBindingForEval(runtime);
                    this.traceCall(context, runtime, binding, name);
                }
                DynamicScope sc = new DynamicScope(this.staticScope, null);
                for (int i = 0; i < args.length; ++i) {
                    sc.setValue(i, args[i], 0);
                }
                iRubyObject = YARVMachine.INSTANCE.exec(context, self, sc, this.iseq.body);
                Object var13_15 = null;
                if (binding == null) break block9;
            }
            catch (JumpException je) {
                block10: {
                    try {
                        if (je.getJumpType() != JumpException.JumpType.ReturnJump || je.getTarget() != this) break block10;
                        IRubyObject iRubyObject2 = (IRubyObject)je.getValue();
                        Object var13_16 = null;
                        if (binding != null) {
                            this.traceReturn(context, runtime, binding, name);
                        }
                        return iRubyObject2;
                    }
                    catch (Throwable throwable) {
                        block11: {
                            Object var13_17 = null;
                            if (binding == null) break block11;
                            this.traceReturn(context, runtime, binding, name);
                        }
                        throw throwable;
                    }
                }
                throw je;
            }
            this.traceReturn(context, runtime, binding, name);
        }
        return iRubyObject;
    }

    private void prepareArguments(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        boolean hasOptArgs;
        context.setPosition(new ISeqPosition(this.iseq));
        int expectedArgsCount = this.iseq.args_argc;
        int restArg = this.iseq.args_rest;
        boolean bl = hasOptArgs = this.iseq.args_arg_opts > 0;
        if (expectedArgsCount > args.length) {
            throw runtime.newArgumentError("Wrong # of arguments(" + args.length + " for " + expectedArgsCount + ")");
        }
        if (hasOptArgs || restArg != -1) {
            args = this.prepareOptOrRestArgs(context, runtime, args, expectedArgsCount, restArg, hasOptArgs);
        }
        context.setFrameArgs(args);
    }

    private IRubyObject[] prepareOptOrRestArgs(ThreadContext context, Ruby runtime, IRubyObject[] args, int expectedArgsCount, int restArg, boolean hasOptArgs) {
        int i;
        int opt;
        if (restArg == 0 && hasOptArgs && (opt = expectedArgsCount + this.iseq.args_arg_opts) < args.length) {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + opt + ")");
        }
        int count = expectedArgsCount + this.iseq.args_arg_opts + this.iseq.args_rest;
        ArrayList<IRubyObject> allArgs = new ArrayList<IRubyObject>();
        for (i = 0; i < count && i < args.length; ++i) {
            allArgs.add(args[i]);
        }
        if (restArg != 0) {
            for (i = expectedArgsCount; i < args.length; ++i) {
                allArgs.add(args[i]);
            }
            if (restArg >= 0) {
                RubyArray array = runtime.newArray(args.length - expectedArgsCount);
                for (int i2 = expectedArgsCount; i2 < args.length; ++i2) {
                    array.append(args[i2]);
                }
                context.getCurrentScope().setValue(restArg, array, 0);
            }
        }
        args = allArgs.toArray(new IRubyObject[allArgs.size()]);
        return args;
    }

    private void traceReturn(ThreadContext context, Ruby runtime, RubyBinding binding, String name) {
        if (runtime.getTraceFunction() == null) {
            return;
        }
        ISourcePosition position = context.getPreviousFramePosition();
        runtime.callTraceFunction(context, "return", position, binding, name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, RubyBinding binding, String name) {
        if (runtime.getTraceFunction() == null) {
            return;
        }
        ISourcePosition position = context.getPosition();
        runtime.callTraceFunction(context, "call", position, binding, name, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.arity;
    }

    public DynamicMethod dup() {
        return new YARVMethod(this.getImplementationClass(), this.iseq, this.staticScope, this.getVisibility(), this.cref);
    }

    static {
        $assertionsDisabled = !YARVMethod.class.desiredAssertionStatus();
    }
}

