/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.yarv;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.NotNode;
import org.jruby.ast.OptNNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.executable.YARVInstructions;
import org.jruby.ast.executable.YARVMachine;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.runtime.builtin.IRubyObject;

public class StandardYARVCompiler
implements NodeCompiler {
    private YARVMachine.InstructionSequence iseq;
    private Ruby runtime;
    private int last_line = -1;
    private LinkAnchor current_iseq;
    private String[] locals = new String[0];
    private static final int COMPILE_OK = 1;
    private static final int COMPILE_NG = 0;
    private int label_no = 0;

    private static void verify_list(String info, LinkAnchor anchor) {
        int flag = 0;
        LinkElement list = anchor.next;
        LinkElement plist = anchor;
        while (list != null) {
            if (plist != list.prev) {
                ++flag;
            }
            plist = list;
            list = list.next;
        }
        if (anchor.last != plist && anchor.last != null) {
            flag |= 0x70000;
        }
        if (flag != 0) {
            throw new RuntimeException("list verify error: " + Integer.toString(flag, 16) + " (" + info + ")");
        }
    }

    private Label NEW_LABEL(int l) {
        Label labelobj = new Label();
        labelobj.next = null;
        labelobj.label_no = this.label_no++;
        labelobj.sc_state = 0;
        labelobj.sp = -1;
        return labelobj;
    }

    private static void ADD_LABEL(LinkAnchor anchor, LinkElement elem) {
        StandardYARVCompiler.ADD_ELEM(anchor, elem);
    }

    private static void ADD_ELEM(LinkAnchor anchor, LinkElement elem) {
        elem.prev = anchor.last;
        anchor.last.next = elem;
        anchor.last = elem;
        StandardYARVCompiler.verify_list("add", anchor);
    }

    private static void INSERT_ELEM_PREV(LinkElement elem1, LinkElement elem2) {
        elem2.prev = elem1.prev;
        elem2.next = elem1;
        elem1.prev = elem2;
        if (elem2.prev != null) {
            elem2.prev.next = elem2;
        }
    }

    private static void REPLACE_ELEM(LinkElement elem1, LinkElement elem2) {
        elem2.prev = elem1.prev;
        elem2.next = elem1.next;
        if (elem1.prev != null) {
            elem1.prev.next = elem2;
        }
        if (elem1.next != null) {
            elem1.next.prev = elem2;
        }
    }

    private static void REMOVE_ELEM(LinkElement elem) {
        elem.prev.next = elem.next;
        if (elem.next != null) {
            elem.next.prev = elem.prev;
        }
    }

    private static LinkElement FIRST_ELEMENT(LinkAnchor anchor) {
        return anchor.next;
    }

    private static LinkElement POP_ELEMENT(LinkAnchor anchor) {
        LinkElement elem = anchor.last;
        anchor.last = anchor.last.prev;
        anchor.last.next = null;
        StandardYARVCompiler.verify_list("pop", anchor);
        return elem;
    }

    private static LinkElement SHIFT_ELEMENT(LinkAnchor anchor) {
        LinkElement elem = anchor.next;
        if (null != elem) {
            anchor.next = elem.next;
        }
        return elem;
    }

    private static int LIST_SIZE(LinkAnchor anchor) {
        LinkElement elem = anchor.next;
        int size = 0;
        while (elem != null) {
            ++size;
            elem = elem.next;
        }
        return size;
    }

    private static boolean LIST_SIZE_ZERO(LinkAnchor anchor) {
        return anchor.next == null;
    }

    private static void APPEND_LIST(LinkAnchor anc1, LinkAnchor anc2) {
        if (anc2.next != null) {
            anc1.last.next = anc2.next;
            anc2.next.prev = anc1.last;
            anc1.last = anc2.last;
        }
        StandardYARVCompiler.verify_list("append", anc1);
    }

    private static void INSERT_LIST(LinkAnchor anc1, LinkAnchor anc2) {
        if (anc2.next != null) {
            LinkElement first = anc1.next;
            anc1.next = anc2.next;
            anc1.next.prev = anc1;
            anc2.last.next = first;
            if (first != null) {
                first.prev = anc2.last;
            } else {
                anc1.last = anc2.last;
            }
        }
        StandardYARVCompiler.verify_list("append", anc1);
    }

    private static void ADD_SEQ(LinkAnchor seq1, LinkAnchor seq2) {
        StandardYARVCompiler.APPEND_LIST(seq1, seq2);
    }

    private int debug_compile(String msg, int v) {
        this.debugs(msg);
        return v;
    }

    private int COMPILE(LinkAnchor anchor, String desc, Node node) {
        return this.debug_compile("== " + desc, this.iseq_compile_each(anchor, node, false));
    }

    private int COMPILE(LinkAnchor anchor, String desc, Node node, boolean poped) {
        return this.debug_compile("== " + desc, this.iseq_compile_each(anchor, node, poped));
    }

    private int COMPILE_POPED(LinkAnchor anchor, String desc, Node node) {
        return this.debug_compile("== " + desc, this.iseq_compile_each(anchor, node, true));
    }

    private LinkAnchor DECL_ANCHOR() {
        LinkAnchor l = new LinkAnchor();
        l.last = l;
        return l;
    }

    public StandardYARVCompiler(Ruby runtime) {
        this.runtime = runtime;
    }

    private void debugs(String s) {
        System.err.println(s);
    }

    public void compile(Node node) {
        this.iseq_compile(null, node);
    }

    public void compile(Node node, Compiler context) {
        this.compile(node);
    }

    public void iseq_compile(IRubyObject self, Node narg) {
        LinkAnchor list_anchor = this.DECL_ANCHOR();
        Node node = narg;
        this.debugs("[compile step 1 (traverse each node)]");
        this.COMPILE(list_anchor, "top level node", node);
        this.ADD_INSN(list_anchor, this.last_line, 50);
        this.current_iseq = list_anchor;
    }

    private int nd_line(Node node) {
        if (node.getPosition() != null) {
            return node.getPosition().getEndLine();
        }
        return this.last_line;
    }

    private String nd_file(Node node) {
        if (node.getPosition() != null) {
            return node.getPosition().getFile();
        }
        return null;
    }

    private int iseq_compile_each(LinkAnchor ret, Node node, boolean poped) {
        if (node == null) {
            if (!poped) {
                this.debugs("NODE_NIL(implicit)");
                this.ADD_INSN(ret, 0, 15);
                return 1;
            }
            return 1;
        }
        this.last_line = this.nd_line(node);
        LinkAnchor recv = null;
        LinkAnchor args = null;
        block21: while (true) {
            switch (node.nodeId) {
                case 12: {
                    List l = ((BlockNode)node).childNodes();
                    int sz = l.size();
                    for (int i = 0; i < sz; ++i) {
                        boolean p = i + 1 != sz || poped;
                        this.COMPILE(ret, "BLOCK body", (Node)l.get(i), p);
                    }
                    break block21;
                }
                case 59: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block21;
                }
                case 101: {
                    this.locals = ((RootNode)node).getStaticScope().getAllNamesInScope();
                    node = ((RootNode)node).getBodyNode();
                    continue block21;
                }
                case 27: {
                    StandardYARVCompiler c = new StandardYARVCompiler(this.runtime);
                    c.compile(((DefnNode)node).getBodyNode());
                    YARVMachine.InstructionSequence iseqval = c.getInstructionSequence(((DefnNode)node).getName(), this.nd_file(node), "method");
                    ArrayList<String> argNames = new ArrayList<String>();
                    ListNode argsNode = ((DefnNode)node).getArgsNode().getArgs();
                    for (int i = 0; i < argsNode.size(); ++i) {
                        ArgumentNode argumentNode = (ArgumentNode)argsNode.get(i);
                        argNames.add(argumentNode.getName());
                    }
                    iseqval.args_argc = argNames.size();
                    String[] l1 = iseqval.locals;
                    String[] l2 = new String[l1.length + argNames.size()];
                    System.arraycopy(l1, 0, l2, argNames.size(), l1.length);
                    for (int i = 0; i < argNames.size(); ++i) {
                        l2[i] = (String)argNames.get(i);
                    }
                    iseqval.locals = l2;
                    this.ADD_INSN(ret, this.nd_line(node), 15);
                    this.ADD_INSN3(ret, this.nd_line(node), 40, ((DefnNode)node).getName(), iseqval, 0L);
                    if (poped) break block21;
                    this.ADD_INSN(ret, this.nd_line(node), 15);
                    break block21;
                }
                case 83: {
                    if (poped) break block21;
                    this.ADD_INSN1(ret, this.nd_line(node), 19, ((StrNode)node).getValue().toString());
                    break block21;
                }
                case 24: {
                    this.ADD_INSN(ret, this.nd_line(node), 15);
                    this.ADD_INSN1(ret, this.nd_line(node), 11, ((ConstNode)node).getName());
                    if (!poped) break block21;
                    this.ADD_INSN(ret, this.nd_line(node), 32);
                    break block21;
                }
                case 52: {
                    int idx = ((LocalAsgnNode)node).getIndex() - 2;
                    this.debugs("lvar: " + idx);
                    this.COMPILE(ret, "lvalue", ((LocalAsgnNode)node).getValueNode());
                    if (!poped) {
                        this.ADD_INSN(ret, this.nd_line(node), 33);
                    }
                    this.ADD_INSN1(ret, this.nd_line(node), 2, idx);
                    break block21;
                }
                case 53: {
                    if (poped) break block21;
                    int idx2 = ((LocalVarNode)node).getIndex() - 2;
                    this.debugs("idx: " + idx2);
                    this.ADD_INSN1(ret, this.nd_line(node), 1, idx2);
                    break block21;
                }
                case 46: {
                    LinkAnchor cond_seq = this.DECL_ANCHOR();
                    LinkAnchor then_seq = this.DECL_ANCHOR();
                    LinkAnchor else_seq = this.DECL_ANCHOR();
                    Label then_label = this.NEW_LABEL(this.nd_line(node));
                    Label else_label = this.NEW_LABEL(this.nd_line(node));
                    Label end_label = this.NEW_LABEL(this.nd_line(node));
                    this.compile_branch_condition(cond_seq, ((IfNode)node).getCondition(), then_label, else_label);
                    this.COMPILE(then_seq, "then", ((IfNode)node).getThenBody(), poped);
                    this.COMPILE(else_seq, "else", ((IfNode)node).getElseBody(), poped);
                    StandardYARVCompiler.ADD_SEQ(ret, cond_seq);
                    StandardYARVCompiler.ADD_LABEL(ret, then_label);
                    StandardYARVCompiler.ADD_SEQ(ret, then_seq);
                    this.ADD_INSNL(ret, this.nd_line(node), 53, end_label);
                    StandardYARVCompiler.ADD_LABEL(ret, else_label);
                    StandardYARVCompiler.ADD_SEQ(ret, else_seq);
                    StandardYARVCompiler.ADD_LABEL(ret, end_label);
                    break block21;
                }
                case 15: 
                case 38: 
                case 92: {
                    recv = this.DECL_ANCHOR();
                    args = this.DECL_ANCHOR();
                    if (node instanceof CallNode) {
                        this.COMPILE(recv, "recv", ((CallNode)node).getReceiverNode());
                    } else {
                        this.ADD_CALL_RECEIVER(recv, this.nd_line(node));
                    }
                    int argc = 0;
                    int flags = 0;
                    if (!(node instanceof VCallNode)) {
                        int[] argc_flags = this.setup_arg(args, (IArgumentNode)((Object)node));
                        argc = argc_flags[0];
                        flags = argc_flags[1];
                    } else {
                        argc = 0;
                    }
                    StandardYARVCompiler.ADD_SEQ(ret, recv);
                    StandardYARVCompiler.ADD_SEQ(ret, args);
                    switch (node.nodeId) {
                        case 92: {
                            flags |= 0x10;
                        }
                        case 38: {
                            flags |= 8;
                        }
                    }
                    this.ADD_SEND_R(ret, this.nd_line(node), ((INameNode)((Object)node)).getName(), argc, null, flags);
                    if (!poped) break block21;
                    this.ADD_INSN(ret, this.nd_line(node), 32);
                    break block21;
                }
                case 5: {
                    this.compile_array(ret, node, true);
                    if (!poped) break block21;
                    this.ADD_INSN(ret, this.nd_line(node), 32);
                    break block21;
                }
                case 97: {
                    if (poped) break block21;
                    this.ADD_INSN1(ret, this.nd_line(node), 23, 0L);
                    break block21;
                }
                case 45: {
                    LinkAnchor list = this.DECL_ANCHOR();
                    long size = 0L;
                    ListNode lnode = ((HashNode)node).getListNode();
                    if (((Node)lnode).childNodes().size() > 0) {
                        this.compile_array(list, lnode, false);
                        size = ((Insn)StandardYARVCompiler.POP_ELEMENT((LinkAnchor)list)).i.l_op0;
                        StandardYARVCompiler.ADD_SEQ(ret, list);
                    }
                    this.ADD_INSN1(ret, this.nd_line(node), 29, size);
                    if (!poped) break block21;
                    this.ADD_INSN(ret, this.nd_line(node), 32);
                    break block21;
                }
                case 39: {
                    FixnumNode iVisited = (FixnumNode)node;
                    if (poped) break block21;
                    this.ADD_INSN1(ret, this.nd_line(node), 18, iVisited.getFixnum(this.runtime));
                    break block21;
                }
                case 69: 
                case 90: 
                case 94: {
                    Label next_label = this.NEW_LABEL(this.nd_line(node));
                    Label redo_label = this.NEW_LABEL(this.nd_line(node));
                    Label break_label = this.NEW_LABEL(this.nd_line(node));
                    Label end_label = this.NEW_LABEL(this.nd_line(node));
                    if (node instanceof OptNNode) {
                        this.ADD_INSNL(ret, this.nd_line(node), 53, next_label);
                    }
                    StandardYARVCompiler.ADD_LABEL(ret, redo_label);
                    Node body = null;
                    if (node instanceof WhileNode) {
                        body = ((WhileNode)node).getBodyNode();
                    } else if (node instanceof UntilNode) {
                        body = ((UntilNode)node).getBodyNode();
                    } else if (node instanceof OptNNode) {
                        body = ((OptNNode)node).getBodyNode();
                    }
                    this.COMPILE_POPED(ret, "while body", body);
                    StandardYARVCompiler.ADD_LABEL(ret, next_label);
                    if (node instanceof WhileNode) {
                        this.compile_branch_condition(ret, ((WhileNode)node).getConditionNode(), redo_label, end_label);
                    } else if (node instanceof UntilNode) {
                        this.compile_branch_condition(ret, ((UntilNode)node).getConditionNode(), end_label, redo_label);
                    } else {
                        this.ADD_CALL_RECEIVER(ret, this.nd_line(node));
                        this.ADD_INSNL(ret, this.nd_line(node), 54, redo_label);
                    }
                    StandardYARVCompiler.ADD_LABEL(ret, end_label);
                    this.ADD_INSN(ret, this.nd_line(node), 15);
                    StandardYARVCompiler.ADD_LABEL(ret, break_label);
                    if (!poped) break block21;
                    this.ADD_INSN(ret, this.nd_line(node), 32);
                    break block21;
                }
                default: {
                    this.debugs(" ... doesn't handle node: " + node);
                    break block21;
                }
            }
            break;
        }
        return 1;
    }

    private int compile_branch_condition(LinkAnchor ret, Node cond, Label then_label, Label else_label) {
        switch (cond.nodeId) {
            case 63: {
                this.compile_branch_condition(ret, ((NotNode)cond).getConditionNode(), else_label, then_label);
                break;
            }
            case 1: {
                Label label = this.NEW_LABEL(this.nd_line(cond));
                this.compile_branch_condition(ret, ((AndNode)cond).getFirstNode(), label, else_label);
                StandardYARVCompiler.ADD_LABEL(ret, label);
                this.compile_branch_condition(ret, ((AndNode)cond).getSecondNode(), then_label, else_label);
                break;
            }
            case 70: {
                Label label = this.NEW_LABEL(this.nd_line(cond));
                this.compile_branch_condition(ret, ((OrNode)cond).getFirstNode(), then_label, label);
                StandardYARVCompiler.ADD_LABEL(ret, label);
                this.compile_branch_condition(ret, ((OrNode)cond).getSecondNode(), then_label, else_label);
                break;
            }
            case 83: 
            case 88: {
                this.ADD_INSNL(ret, this.nd_line(cond), 53, then_label);
                break;
            }
            case 37: 
            case 61: {
                this.ADD_INSNL(ret, this.nd_line(cond), 53, else_label);
                break;
            }
            default: {
                this.COMPILE(ret, "branch condition", cond);
                this.ADD_INSNL(ret, this.nd_line(cond), 55, else_label);
                this.ADD_INSNL(ret, this.nd_line(cond), 53, then_label);
            }
        }
        return 1;
    }

    private int compile_array(LinkAnchor ret, Node node_root, boolean opt_p) {
        Node node = node_root;
        int len = ((ArrayNode)node).size();
        int line = this.nd_line(node);
        boolean i = false;
        LinkAnchor anchor = this.DECL_ANCHOR();
        List c = node.childNodes();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            node = (Node)iter.next();
            if (opt_p && !(node instanceof ILiteralNode)) {
                opt_p = false;
            }
            this.COMPILE(anchor, "array element", node);
        }
        if (opt_p) {
            ArrayList<RubyFixnum> l = new ArrayList<RubyFixnum>();
            Iterator iter2 = c.iterator();
            block4: while (iter2.hasNext()) {
                node = (Node)iter2.next();
                switch (node.nodeId) {
                    case 39: {
                        l.add(((FixnumNode)node).getFixnum(this.runtime));
                        continue block4;
                    }
                }
                this.debugs(" ... doesn't handle array literal node: " + node);
            }
            this.ADD_INSN1(ret, this.nd_line(node_root), 24, this.runtime.newArray(l));
        } else {
            this.ADD_INSN1(anchor, line, 23, len);
            StandardYARVCompiler.APPEND_LIST(ret, anchor);
        }
        return len;
    }

    private int[] setup_arg(LinkAnchor args, IArgumentNode node) {
        int[] n = new int[]{0, 0};
        Node argn = node.getArgsNode();
        LinkAnchor arg_block = this.DECL_ANCHOR();
        LinkAnchor args_push = this.DECL_ANCHOR();
        if (argn != null) {
            switch (argn.nodeId) {
                case 81: {
                    break;
                }
                case 2: {
                    break;
                }
                case 103: {
                    break;
                }
                default: {
                    n[0] = this.compile_array(args, argn, false);
                    StandardYARVCompiler.POP_ELEMENT(args);
                }
            }
        }
        if (!StandardYARVCompiler.LIST_SIZE_ZERO(args_push)) {
            StandardYARVCompiler.ADD_SEQ(args, args_push);
        }
        return n;
    }

    private Insn new_insn(YARVMachine.Instruction i) {
        Insn n = new Insn();
        n.i = i;
        n.next = null;
        return n;
    }

    private void ADD_CALL_RECEIVER(LinkAnchor seq, int line) {
        this.ADD_INSN(seq, line, 15);
    }

    private void ADD_INSN(LinkAnchor seq, int line, int insn) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        this.debugs("ADD_INSN(" + line + ", " + YARVInstructions.name(insn) + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private void ADD_SEND_R(LinkAnchor seq, int line, String name, int argc, Object block, int flags) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(47);
        i.line_no = line;
        i.s_op0 = name;
        i.i_op1 = argc;
        i.i_op3 = flags;
        this.debugs("ADD_SEND_R(" + line + ", " + YARVInstructions.name(47) + ", " + name + ", " + argc + ", " + flags + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private void ADD_INSN1(LinkAnchor seq, int line, int insn, IRubyObject obj) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        i.o_op0 = obj;
        this.debugs("ADD_INSN1(" + line + ", " + YARVInstructions.name(insn) + ", " + obj + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private void ADD_INSN1(LinkAnchor seq, int line, int insn, long op) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        i.l_op0 = op;
        this.debugs("ADD_INSN1(" + line + ", " + YARVInstructions.name(insn) + ", " + op + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private void ADD_INSNL(LinkAnchor seq, int line, int insn, Label l) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        i._tmp = l;
        this.debugs("ADD_INSNL(" + line + ", " + YARVInstructions.name(insn) + ", " + l + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private void ADD_INSN1(LinkAnchor seq, int line, int insn, String obj) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        i.s_op0 = obj;
        this.debugs("ADD_INSN1(" + line + ", " + YARVInstructions.name(insn) + ", " + obj + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private void ADD_INSN3(LinkAnchor seq, int line, int insn, String name, YARVMachine.InstructionSequence iseq, long n) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        i.s_op0 = name;
        i.iseq_op = iseq;
        i.l_op0 = n;
        this.debugs("ADD_INSN3(" + line + ", " + YARVInstructions.name(insn) + ", " + name + ", " + iseq + ", " + n + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    public YARVMachine.InstructionSequence getInstructionSequence(String name, String filename, String level) {
        this.iseq = new YARVMachine.InstructionSequence(this.runtime, name, filename, level);
        ArrayList<YARVMachine.Instruction> l = new ArrayList<YARVMachine.Instruction>();
        LinkElement elm = this.current_iseq;
        IdentityHashMap<Insn, Object> jumps = new IdentityHashMap<Insn, Object>();
        IdentityHashMap<LinkAnchor, Integer> labels = new IdentityHashMap<LinkAnchor, Integer>();
        int real = 0;
        while (elm != null) {
            if (elm instanceof Insn) {
                Insn i = (Insn)elm;
                if (this.isJump(i.i.bytecode)) {
                    jumps.put(i, i.i._tmp);
                }
                l.add(i.i);
                ++real;
            } else if (elm instanceof Label) {
                labels.put((LinkAnchor)elm, new Integer(real + 1));
            }
            elm = elm.next;
        }
        Iterator iter = jumps.keySet().iterator();
        while (iter.hasNext()) {
            Insn k = (Insn)iter.next();
            k.i.l_op0 = (Integer)labels.get(jumps.get(k)) - 1;
            k.i._tmp = null;
        }
        this.debugs("instructions: " + l);
        this.iseq.body = l.toArray(new YARVMachine.Instruction[l.size()]);
        this.iseq.locals = this.locals;
        return this.iseq;
    }

    private boolean isJump(int i) {
        return i == 53 || i == 54 || i == 55 || i == 56 || i == 58;
    }

    private static class EnsureRange {
        Label begin;
        Label end;
        EnsureRange next;

        private EnsureRange() {
        }
    }

    private static class Insn
    extends LinkElement {
        YARVMachine.Instruction i;

        private Insn() {
        }
    }

    private static class Label
    extends LinkElement {
        int label_no;
        int position;
        int sc_state;
        int set;
        int sp;

        private Label() {
        }
    }

    private static class LinkAnchor
    extends LinkElement {
        LinkElement last;

        private LinkAnchor() {
        }
    }

    private static abstract class LinkElement {
        public LinkElement next;
        public LinkElement prev;

        private LinkElement() {
        }
    }
}

