/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubySymbol
extends RubyObject {
    private final String symbol;
    private final int id;
    public static final byte NIL_P_SWITCHVALUE = 1;
    public static final byte EQUALEQUAL_SWITCHVALUE = 2;
    public static final byte TO_S_SWITCHVALUE = 3;
    public static final byte TO_I_SWITCHVALUE = 4;
    public static final byte TO_SYM_SWITCHVALUE = 5;
    public static final byte HASH_SWITCHVALUE = 6;

    private RubySymbol(Ruby runtime, String symbol) {
        super(runtime, runtime.getClass("Symbol"));
        this.symbol = symbol;
        ++runtime.symbolLastId;
        this.id = runtime.symbolLastId;
    }

    public static RubyClass createSymbolClass(Ruby runtime) {
        RubyClass symbolClass = runtime.defineClass("Symbol", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubySymbol.class);
        RubyClass symbolMetaClass = symbolClass.getMetaClass();
        symbolClass.index = 8;
        symbolClass.defineFastMethod("==", callbackFactory.getFastMethod("equal", RubyKernel.IRUBY_OBJECT));
        symbolClass.defineFastMethod("freeze", callbackFactory.getFastMethod("freeze"));
        symbolClass.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        symbolClass.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        symbolClass.defineFastMethod("taint", callbackFactory.getFastMethod("taint"));
        symbolClass.defineFastMethod("to_i", callbackFactory.getFastMethod("to_i"));
        symbolClass.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        symbolClass.defineFastMethod("to_sym", callbackFactory.getFastMethod("to_sym"));
        symbolClass.defineAlias("id2name", "to_s");
        symbolClass.defineAlias("to_int", "to_i");
        symbolMetaClass.defineFastMethod("all_symbols", callbackFactory.getFastSingletonMethod("all_symbols"));
        symbolMetaClass.undefineMethod("new");
        return symbolClass;
    }

    public int getNativeTypeIndex() {
        return 8;
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        if (context.getRuntime().getTraceFunction() != null) {
            return super.callMethod(context, rubyclass, name, args, callType, block);
        }
        switch (this.getRuntime().getSelectorTable().table[rubyclass.index][methodIndex]) {
            case 1: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.nil_p();
            }
            case 2: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.equal(args[0]);
            }
            case 3: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_s();
            }
            case 4: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_i();
            }
            case 5: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_sym();
            }
            case 6: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.hash();
            }
        }
        return super.callMethod(context, rubyclass, name, args, callType, block);
    }

    public String asSymbol() {
        return this.symbol;
    }

    public final boolean eql(IRubyObject other) {
        return other == this;
    }

    public boolean isImmediate() {
        return true;
    }

    public static String getSymbol(Ruby runtime, long id) {
        RubySymbol result = runtime.getSymbolTable().lookup(id);
        if (result != null) {
            return result.symbol;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubySymbol newSymbol(Ruby runtime, String name) {
        RubySymbol result;
        Class clazz = RubySymbol.class;
        synchronized (clazz) {
            result = runtime.getSymbolTable().lookup(name);
            if (result == null) {
                result = new RubySymbol(runtime, name);
                runtime.getSymbolTable().store(result);
            }
        }
        return result;
    }

    public IRubyObject equal(IRubyObject other) {
        return RubyBoolean.newBoolean(this.getRuntime(), this == other);
    }

    public RubyFixnum to_i() {
        return this.getRuntime().newFixnum(this.id);
    }

    public IRubyObject inspect() {
        return this.getRuntime().newString(":" + (RubySymbol.isSymbolName(this.symbol) ? this.symbol : this.getRuntime().newString(this.symbol).dump().toString()));
    }

    public IRubyObject to_s() {
        return this.getRuntime().newString(this.symbol);
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        return other == this;
    }

    public IRubyObject to_sym() {
        return this;
    }

    public IRubyObject freeze() {
        return this;
    }

    public IRubyObject taint() {
        return this;
    }

    private static boolean isIdentStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentifier(String s) {
        if (s == null || s.length() <= 0) {
            return false;
        }
        if (!RubySymbol.isIdentStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (RubySymbol.isIdentChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecialGlobalName(String s) {
        if (s == null || s.length() <= 0) {
            return false;
        }
        int length = s.length();
        switch (s.charAt(0)) {
            case '!': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case ',': 
            case '.': 
            case '/': 
            case '0': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '`': 
            case '~': {
                return length == 1;
            }
            case '-': {
                return length == 1 || length == 2 && RubySymbol.isIdentChar(s.charAt(1));
            }
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSymbolName(String s) {
        char d;
        int last;
        if (s == null || s.length() < 1) {
            return false;
        }
        int length = s.length();
        char c = s.charAt(0);
        switch (c) {
            case '$': {
                return length > 1 && RubySymbol.isSpecialGlobalName(s.substring(1));
            }
            case '@': {
                int offset = 1;
                if (length >= 2 && s.charAt(1) == '@') {
                    ++offset;
                }
                return RubySymbol.isIdentifier(s.substring(offset));
            }
            case '<': {
                return length == 1 || length == 2 && (s.equals("<<") || s.equals("<=")) || length == 3 && s.equals("<=>");
            }
            case '>': {
                return length == 1 || length == 2 && (s.equals(">>") || s.equals(">="));
            }
            case '=': {
                return length == 2 && (s.equals("==") || s.equals("=~")) || length == 3 && s.equals("===");
            }
            case '*': {
                return length == 1 || length == 2 && s.equals("**");
            }
            case '+': {
                return length == 1 || length == 2 && s.equals("+@");
            }
            case '-': {
                return length == 1 || length == 2 && s.equals("-@");
            }
            case '%': 
            case '&': 
            case '/': 
            case '^': 
            case '`': 
            case '|': 
            case '~': {
                return length == 1;
            }
            case '[': {
                return s.equals("[]") || s.equals("[]=");
            }
        }
        if (!RubySymbol.isIdentStart(c)) {
            return false;
        }
        boolean localID = c >= 'a' && c <= 'z';
        for (last = 1; last < length && RubySymbol.isIdentChar(d = s.charAt(last)); ++last) {
        }
        if (last == length) {
            return true;
        }
        if (localID && last == length - 1) {
            d = s.charAt(last);
            return d == '!' || d == '?' || d == '=';
        }
        return false;
    }

    public static IRubyObject all_symbols(IRubyObject recv) {
        return recv.getRuntime().newArrayNoCopy(recv.getRuntime().getSymbolTable().all_symbols());
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol result = RubySymbol.newSymbol(input.getRuntime(), RubyString.byteListToString(input.unmarshalString()));
        input.registerLinkTarget(result);
        return result;
    }

    public static class SymbolTable {
        private Map table = new HashMap();

        public IRubyObject[] all_symbols() {
            int length = this.table.size();
            IRubyObject[] array = new IRubyObject[length];
            System.arraycopy(this.table.values().toArray(), 0, array, 0, length);
            return array;
        }

        public RubySymbol lookup(long symbolId) {
            Iterator iter = this.table.values().iterator();
            while (iter.hasNext()) {
                RubySymbol symbol = (RubySymbol)iter.next();
                if (symbol == null || (long)symbol.id != symbolId) continue;
                return symbol;
            }
            return null;
        }

        public RubySymbol lookup(String name) {
            return (RubySymbol)this.table.get(name);
        }

        public void store(RubySymbol symbol) {
            this.table.put(symbol.asSymbol(), symbol);
        }
    }
}

