/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.WeakIdentityHashMap;

public class ObjectSpace {
    private ReferenceQueue deadReferences = new ReferenceQueue();
    private WeakReferenceListNode top;
    private ReferenceQueue deadIdentityReferences = new ReferenceQueue();
    private final Map identities = new HashMap();
    private final Map identitiesByObject = new WeakIdentityHashMap();
    private long maxId = 4L;
    private Map finalizers = new HashMap();
    private Map weakRefs = new HashMap();
    private List finalizersToRun = new ArrayList();
    private Thread finalizerThread = new FinalizerThread();

    public ObjectSpace() {
        this.finalizerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long idOf(IRubyObject rubyObject) {
        Map map = this.identities;
        synchronized (map) {
            Long longId = (Long)this.identitiesByObject.get(rubyObject);
            if (longId == null) {
                longId = this.createId(rubyObject);
            }
            return longId;
        }
    }

    private Long createId(IRubyObject object) {
        this.cleanIdentities();
        this.maxId += 2L;
        Long longMaxId = new Long(this.maxId);
        this.identities.put(longMaxId, new IdReference(object, this.maxId, this.deadIdentityReferences));
        this.identitiesByObject.put(object, longMaxId);
        return longMaxId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject id2ref(long id) {
        Map map = this.identities;
        synchronized (map) {
            this.cleanIdentities();
            IdReference reference = (IdReference)this.identities.get(new Long(id));
            if (reference == null) {
                return null;
            }
            return (IRubyObject)reference.get();
        }
    }

    private void cleanIdentities() {
        IdReference ref;
        while ((ref = (IdReference)this.deadIdentityReferences.poll()) != null) {
            this.identities.remove(new Long(ref.id()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishFinalizers() {
        Iterator iter = this.finalizers.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Iterator iter2 = ((List)this.finalizers.get(key)).iterator();
            while (iter2.hasNext()) {
                ((FinalizerEntry)iter2.next())._finalize();
            }
        }
        List list = this.finalizersToRun;
        synchronized (list) {
            while (!this.finalizersToRun.isEmpty()) {
                this.finalizersToRun.notify();
                try {
                    this.finalizersToRun.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public synchronized void addFinalizer(IRubyObject obj, long id, RubyProc proc) {
        ArrayList<FinalizerEntry> fins = (ArrayList<FinalizerEntry>)this.finalizers.get(new Long(id));
        if (fins == null) {
            fins = new ArrayList<FinalizerEntry>();
            this.finalizers.put(new Long(id), fins);
        }
        fins.add(new FinalizerEntry(obj, id, proc));
    }

    public synchronized void removeFinalizers(long id) {
        this.finalizers.remove(new Long(id));
        List refl = (List)this.weakRefs.get(new Long(id));
        if (null != refl) {
            Iterator iter = refl.iterator();
            while (iter.hasNext()) {
                ((FinalizerWeakReferenceListNode)iter.next()).setRan();
            }
        }
        this.weakRefs.remove(new Long(id));
    }

    public synchronized void add(IRubyObject object) {
        this.cleanup();
        this.top = new WeakReferenceListNode(object, this.deadReferences, this.top);
    }

    public synchronized Iterator iterator(RubyModule rubyClass) {
        final ArrayList<WeakReferenceListNode> objList = new ArrayList<WeakReferenceListNode>();
        WeakReferenceListNode current = this.top;
        while (current != null) {
            IRubyObject obj = (IRubyObject)current.get();
            if (obj != null && obj.isKindOf(rubyClass)) {
                objList.add(current);
            }
            current = current.next;
        }
        return new Iterator(){
            private Iterator iter;
            {
                this.iter = objList.iterator();
            }

            public boolean hasNext() {
                throw new UnsupportedOperationException();
            }

            public Object next() {
                WeakReferenceListNode node;
                Object obj = null;
                while (this.iter.hasNext() && ((node = (WeakReferenceListNode)this.iter.next()) instanceof FinalizerWeakReferenceListNode || (obj = node.get()) == null)) {
                }
                return obj;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private synchronized void cleanup() {
        WeakReferenceListNode reference;
        while ((reference = (WeakReferenceListNode)this.deadReferences.poll()) != null) {
            reference.remove();
        }
    }

    private static class IdReference
    extends WeakReference {
        private final long id;

        public IdReference(IRubyObject object, long id, ReferenceQueue queue) {
            super(object, queue);
            this.id = id;
        }

        public long id() {
            return this.id;
        }
    }

    private class FinalizerWeakReferenceListNode
    extends WeakReferenceListNode {
        private FinalizerEntry entry;
        private boolean ran;

        public FinalizerWeakReferenceListNode(Object ref, ReferenceQueue queue, WeakReferenceListNode next, FinalizerEntry entry) {
            super(ref, queue, next);
            this.ran = false;
            this.entry = entry;
        }

        public void remove() {
            super.remove();
            if (!this.ran) {
                this.entry.finalize(this);
            }
        }

        public void setRan() {
            this.ran = true;
        }
    }

    private class WeakReferenceListNode
    extends WeakReference {
        public WeakReferenceListNode prev;
        public WeakReferenceListNode next;

        public WeakReferenceListNode(Object ref, ReferenceQueue queue, WeakReferenceListNode next) {
            super(ref, queue);
            this.next = next;
            if (next != null) {
                next.prev = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            ObjectSpace objectSpace = ObjectSpace.this;
            synchronized (objectSpace) {
                if (this.prev != null) {
                    this.prev.next = this.next;
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
            }
        }
    }

    private class FinalizerEntry
    implements Runnable {
        private long id;
        private RubyProc proc;
        private IRubyObject fid;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FinalizerEntry(IRubyObject obj, long id, RubyProc proc) {
            this.id = id;
            this.proc = proc;
            this.fid = proc.getRuntime().newFixnum(id);
            ObjectSpace objectSpace = ObjectSpace.this;
            synchronized (objectSpace) {
                FinalizerWeakReferenceListNode node = new FinalizerWeakReferenceListNode(obj, ObjectSpace.this.deadReferences, ObjectSpace.this.top, this);
                Long key = new Long(id);
                ArrayList<FinalizerWeakReferenceListNode> refl = (ArrayList<FinalizerWeakReferenceListNode>)ObjectSpace.this.weakRefs.get(key);
                if (null == refl) {
                    refl = new ArrayList<FinalizerWeakReferenceListNode>();
                    ObjectSpace.this.weakRefs.put(key, refl);
                }
                refl.add(node);
                ObjectSpace.this.top = node;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finalize(FinalizerWeakReferenceListNode obj) {
            ObjectSpace objectSpace = ObjectSpace.this;
            synchronized (objectSpace) {
                List refl = (List)ObjectSpace.this.weakRefs.get(new Long(this.id));
                refl.remove(obj);
                obj.setRan();
            }
            this._finalize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void _finalize() {
            List list = ObjectSpace.this.finalizersToRun;
            synchronized (list) {
                ObjectSpace.this.finalizersToRun.add(this);
                ObjectSpace.this.finalizersToRun.notifyAll();
            }
        }

        public void run() {
            this.proc.call(new IRubyObject[]{this.fid});
        }
    }

    private class FinalizerThread
    extends Thread {
        public FinalizerThread() {
            super("Ruby Finalizer Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        List list = ObjectSpace.this.finalizersToRun;
                        synchronized (list) {
                            while (ObjectSpace.this.finalizersToRun.isEmpty()) {
                                try {
                                    ObjectSpace.this.finalizersToRun.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            while (!ObjectSpace.this.finalizersToRun.isEmpty()) {
                                ((Runnable)ObjectSpace.this.finalizersToRun.remove(0)).run();
                            }
                            ObjectSpace.this.finalizersToRun.notify();
                        }
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

