/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.runtime.Constants;
import org.jruby.runtime.load.Library;
import org.jruby.util.NormalizedFile;

public class RbConfigLibrary
implements Library {
    public void load(Ruby runtime) {
        RubyModule configModule = runtime.defineModule("Config");
        RubyHash configHash = RubyHash.newHash(runtime);
        configModule.defineConstant("CONFIG", configHash);
        String[] versionParts = Constants.RUBY_VERSION.split("\\.");
        RbConfigLibrary.setConfig(configHash, "MAJOR", versionParts[0]);
        RbConfigLibrary.setConfig(configHash, "MINOR", versionParts[1]);
        RbConfigLibrary.setConfig(configHash, "TEENY", versionParts[2]);
        RbConfigLibrary.setConfig(configHash, "ruby_version", versionParts[0] + '.' + versionParts[1]);
        RbConfigLibrary.setConfig(configHash, "arch", "java");
        RbConfigLibrary.setConfig(configHash, "bindir", new NormalizedFile(runtime.getJRubyHome(), "bin").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "RUBY_INSTALL_NAME", this.jruby_script());
        RbConfigLibrary.setConfig(configHash, "ruby_install_name", this.jruby_script());
        RbConfigLibrary.setConfig(configHash, "SHELL", this.jruby_shell());
        RbConfigLibrary.setConfig(configHash, "prefix", new NormalizedFile(runtime.getJRubyHome()).getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "host_os", System.getProperty("os.name"));
        RbConfigLibrary.setConfig(configHash, "LIBRUBY", "jruby");
        RbConfigLibrary.setConfig(configHash, "LIBRUBY_SO", "jruby");
        RbConfigLibrary.setConfig(configHash, "target", "java");
        RbConfigLibrary.setConfig(configHash, "build", "java");
        RbConfigLibrary.setConfig(configHash, "host_vendor", System.getProperty("java.vendor"));
        RbConfigLibrary.setConfig(configHash, "host_cpu", System.getProperty("os.arch"));
        RbConfigLibrary.setConfig(configHash, "target_cpu", System.getProperty("os.arch"));
        String libdir = System.getProperty("jruby.lib");
        if (libdir == null) {
            libdir = new NormalizedFile(runtime.getJRubyHome(), "lib").getAbsolutePath();
        } else {
            try {
                libdir = new NormalizedFile(libdir).getCanonicalPath();
            }
            catch (IOException e) {
                libdir = new NormalizedFile(libdir).getAbsolutePath();
            }
        }
        RbConfigLibrary.setConfig(configHash, "libdir", libdir);
        RbConfigLibrary.setConfig(configHash, "rubylibdir", new NormalizedFile(libdir, "ruby/1.8").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sitedir", new NormalizedFile(libdir, "ruby/site_ruby").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sitelibdir", new NormalizedFile(libdir, "ruby/site_ruby/1.8").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sitearchdir", new NormalizedFile(libdir, "ruby/site_ruby/1.8/java").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "configure_args", "");
        RbConfigLibrary.setConfig(configHash, "datadir", new NormalizedFile(runtime.getJRubyHome(), "share").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "mandir", new NormalizedFile(runtime.getJRubyHome(), "man").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sysconfdir", new NormalizedFile(runtime.getJRubyHome(), "etc").getAbsolutePath());
        if (RbConfigLibrary.isWindows()) {
            RbConfigLibrary.setConfig(configHash, "EXEEXT", ".exe");
        } else {
            RbConfigLibrary.setConfig(configHash, "EXEEXT", "");
        }
    }

    private static void setConfig(RubyHash configHash, String key, String value) {
        Ruby runtime = configHash.getRuntime();
        configHash.aset(runtime.newString(key), runtime.newString(value));
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "").startsWith("Windows");
    }

    private String jruby_script() {
        return System.getProperty("jruby.script", RbConfigLibrary.isWindows() ? "jruby.bat" : "jruby").replace('\\', '/');
    }

    private String jruby_shell() {
        return System.getProperty("jruby.shell", RbConfigLibrary.isWindows() ? "cmd.exe" : "/bin/sh").replace('\\', '/');
    }
}

