/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.RubyNativeThread;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.collections.WeakHashSet;

public class ThreadService {
    private Ruby runtime;
    private ThreadContext mainContext;
    private ThreadLocal localContext;
    private ThreadGroup rubyThreadGroup;
    private Set rubyThreadList;
    private Thread mainThread;
    private RubyThread criticalThread;

    public ThreadService(Ruby runtime) {
        this.runtime = runtime;
        this.mainContext = new ThreadContext(runtime);
        this.localContext = new ThreadLocal();
        this.rubyThreadGroup = new ThreadGroup("Ruby Threads#" + runtime.hashCode());
        this.rubyThreadList = Collections.synchronizedSet(new WeakHashSet());
        this.mainThread = Thread.currentThread();
        this.localContext.set(this.mainContext);
        this.rubyThreadList.add(this.mainThread);
    }

    public void disposeCurrentThread() {
        this.localContext.set(null);
    }

    public ThreadContext getCurrentContext() {
        ThreadContext tc = (ThreadContext)this.localContext.get();
        if (tc == null) {
            tc = this.adoptCurrentThread();
        }
        return tc;
    }

    private ThreadContext adoptCurrentThread() {
        Thread current = Thread.currentThread();
        RubyThread.adopt(this.runtime.getClass("Thread"), current);
        return (ThreadContext)this.localContext.get();
    }

    public RubyThread getMainThread() {
        return this.mainContext.getThread();
    }

    public void setMainThread(RubyThread thread) {
        this.mainContext.setThread(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RubyThread[] getActiveRubyThreads() {
        Set set = this.rubyThreadList;
        synchronized (set) {
            ArrayList<RubyThread> rtList = new ArrayList<RubyThread>(this.rubyThreadList.size());
            Iterator iter = this.rubyThreadList.iterator();
            while (iter.hasNext()) {
                Thread t = (Thread)iter.next();
                if (!t.isAlive()) continue;
                RubyThread rt = this.getRubyThreadFromThread(t);
                rtList.add(rt);
            }
            RubyThread[] rubyThreads = new RubyThread[rtList.size()];
            rtList.toArray(rubyThreads);
            return rubyThreads;
        }
    }

    public ThreadGroup getRubyThreadGroup() {
        return this.rubyThreadGroup;
    }

    public synchronized void registerNewThread(RubyThread thread) {
        this.localContext.set(new ThreadContext(this.runtime));
        this.getCurrentContext().setThread(thread);
        this.rubyThreadList.add(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCritical(boolean critical) {
        RubyThread currentThread = this.getCurrentContext().getThread();
        if (this.criticalThread != null) {
            if (critical) {
                return;
            }
            if (this.criticalThread != currentThread) {
                return;
            }
            RubyThread rubyThread = this.criticalThread;
            synchronized (rubyThread) {
                RubyThread critThread = this.criticalThread;
                this.criticalThread = null;
                critThread.notifyAll();
            }
        } else {
            if (!critical) {
                return;
            }
            this.criticalThread = currentThread;
        }
    }

    private RubyThread getRubyThreadFromThread(Thread activeThread) {
        RubyThread rubyThread;
        if (activeThread instanceof RubyNativeThread) {
            RubyNativeThread rubyNativeThread = (RubyNativeThread)activeThread;
            rubyThread = rubyNativeThread.getRubyThread();
        } else {
            rubyThread = this.mainContext.getThread();
        }
        return rubyThread;
    }

    public RubyThread getCriticalThread() {
        return this.criticalThread;
    }
}

