/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyArgsFile
extends RubyObject {
    private IRubyObject currentFile = null;
    private int currentLineNumber;

    public RubyArgsFile(Ruby runtime) {
        super(runtime, runtime.getObject());
    }

    public void setCurrentLineNumber(int newLineNumber) {
        this.currentLineNumber = newLineNumber;
    }

    public void initArgsFile() {
        this.extendObject(this.getRuntime().getModule("Enumerable"));
        this.getRuntime().defineReadonlyVariable("$<", this);
        this.getRuntime().defineGlobalConstant("ARGF", this);
        CallbackFactory callbackFactory = this.getRuntime().callbackFactory(RubyArgsFile.class);
        this.getMetaClass().defineMethod("each", callbackFactory.getOptMethod("each_line"));
        this.getMetaClass().defineMethod("each_line", callbackFactory.getOptMethod("each_line"));
        this.getMetaClass().defineFastMethod("filename", callbackFactory.getFastMethod("filename"));
        this.getMetaClass().defineFastMethod("gets", callbackFactory.getFastOptMethod("gets"));
        this.getMetaClass().defineFastMethod("readline", callbackFactory.getFastOptMethod("readline"));
        this.getMetaClass().defineFastMethod("readlines", callbackFactory.getFastOptMethod("readlines"));
        this.getMetaClass().defineFastMethod("to_a", callbackFactory.getFastOptMethod("readlines"));
        this.getMetaClass().defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        this.getRuntime().defineReadonlyVariable("$FILENAME", this.getRuntime().newString("-"));
    }

    protected boolean nextArgsFile() {
        RubyArray args = (RubyArray)this.getRuntime().getGlobalVariables().get("$*");
        if (args.getLength() == 0) {
            if (this.currentFile == null) {
                this.currentFile = this.getRuntime().getGlobalVariables().get("$stdin");
                ((RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer("-"));
                this.currentLineNumber = 0;
                return true;
            }
            return false;
        }
        String filename = ((RubyString)args.shift()).toString();
        ((RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer(filename));
        this.currentFile = filename.equals("-") ? this.getRuntime().getGlobalVariables().get("$stdin") : new RubyFile(this.getRuntime(), filename);
        return true;
    }

    public IRubyObject internalGets(IRubyObject[] args) {
        if (this.currentFile == null && !this.nextArgsFile()) {
            return this.getRuntime().getNil();
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject line = this.currentFile.callMethod(context, "gets", args);
        while (line instanceof RubyNil) {
            this.currentFile.callMethod(context, "close");
            if (!this.nextArgsFile()) {
                this.currentFile = null;
                return line;
            }
            line = this.currentFile.callMethod(context, "gets", args);
        }
        ++this.currentLineNumber;
        this.getRuntime().getGlobalVariables().set("$.", this.getRuntime().newFixnum(this.currentLineNumber));
        return line;
    }

    public IRubyObject gets(IRubyObject[] args) {
        IRubyObject result = this.internalGets(args);
        if (!result.isNil()) {
            this.getRuntime().getCurrentContext().setLastline(result);
        }
        return result;
    }

    public IRubyObject readline(IRubyObject[] args) {
        IRubyObject line = this.gets(args);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    public RubyArray readlines(IRubyObject[] args) {
        IRubyObject line;
        IRubyObject[] separatorArgument;
        if (args.length > 0) {
            if (!args[0].isKindOf(this.getRuntime().getNilClass()) && !args[0].isKindOf(this.getRuntime().getString())) {
                throw this.getRuntime().newTypeError(args[0], this.getRuntime().getString());
            }
            separatorArgument = new IRubyObject[]{args[0]};
        } else {
            separatorArgument = IRubyObject.NULL_ARRAY;
        }
        RubyArray result = this.getRuntime().newArray();
        while (!(line = this.internalGets(separatorArgument)).isNil()) {
            result.append(line);
        }
        return result;
    }

    public IRubyObject each_line(IRubyObject[] args, Block block) {
        IRubyObject nextLine = this.internalGets(args);
        while (!nextLine.isNil()) {
            this.getRuntime().getCurrentContext().yield(nextLine, block);
            nextLine = this.internalGets(args);
        }
        return this;
    }

    public RubyString filename() {
        return (RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME");
    }

    public IRubyObject to_s() {
        return this.getRuntime().newString("ARGF");
    }
}

