/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.ArrayPatternNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2ConstNode;
import org.jruby.ast.Colon2ImplicitNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DefHolder;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FileNode;
import org.jruby.ast.FindPatternNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForwardingBlockArgNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.HashPatternNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IScopedNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.InvisibleNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LiteralValue;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2CaptureNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.NilRestArgNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.NumericNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnConstDeclNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PatternCaseNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueModNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhenOneArgNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.OperatorCallNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.RubyWarnings;
import org.jruby.ext.coverage.CoverageData;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.LexingCommon;
import org.jruby.lexer.yacc.LexContext;
import org.jruby.lexer.yacc.RubyLexer;
import org.jruby.lexer.yacc.StackState;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.parser.ArgsTailHolder;
import org.jruby.parser.ParserType;
import org.jruby.parser.ProductionState;
import org.jruby.parser.RubyParserResult;
import org.jruby.parser.ScopedParserState;
import org.jruby.parser.StaticScope;
import org.jruby.parser.YYDebug;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Signature;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;
import org.jruby.util.KeyValuePair;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.cli.Options;

public abstract class RubyParserBase {
    protected StaticScope currentScope;
    protected ScopedParserState scopedParserState;
    protected RubyLexer lexer;
    private boolean warnOnUnusedVariables;
    private RubyParserResult result;
    public boolean isNextBreak = false;
    public IRubyObject case_labels;
    private Set<ByteList> keyTable;
    private Set<ByteList> variableTable;
    private int maxNumParam = 0;
    private Node numParamCurrent = null;
    private Node numParamInner = null;
    private Node numParamOuter = null;
    private Ruby runtime;
    private DynamicScope existingScope;
    protected ParserType type;
    private int[] coverage = EMPTY_COVERAGE;
    private static final int[] EMPTY_COVERAGE = new int[0];
    private boolean frozenStringLiterals;
    public static final ByteList INTERNAL_ID = new ByteList(new byte[0], (Encoding)USASCIIEncoding.INSTANCE);
    public static ByteList NIL = new ByteList(new byte[]{110, 105, 108});
    public static final ByteList NOT = LexingCommon.BANG;

    public RubyParserBase(Ruby runtime2, LexerSource source2, DynamicScope scope, ParserType type2) {
        this.runtime = runtime2;
        this.lexer = new RubyLexer(this, source2, this.getWarnings());
        this.existingScope = scope;
        this.type = type2;
        this.result = new RubyParserResult();
        this.frozenStringLiterals = runtime2.getInstanceConfig().isFrozenStringLiteral();
    }

    public void reset() {
        this.lexer.getLexContext().reset();
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public void popCurrentScope() {
        if (!this.currentScope.isBlockScope()) {
            this.lexer.getCmdArgumentState().pop();
            this.lexer.getConditionState().pop();
        }
        if (this.warnOnUnusedVariables) {
            this.scopedParserState.warnUnusedVariables(this, this.currentScope.getFile());
        }
        this.currentScope = this.currentScope.getEnclosingScope();
        this.scopedParserState = this.scopedParserState.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.warnOnUnusedVariables = this.getWarnings().isVerbose();
        this.currentScope = this.getRuntime().getStaticScopeFactory().newBlockScope(this.currentScope, this.lexer.getFile());
        this.scopedParserState = new ScopedParserState(this.scopedParserState);
    }

    public void pushLocalScope() {
        this.warnOnUnusedVariables = this.getWarnings().isVerbose();
        this.currentScope = this.getRuntime().getStaticScopeFactory().newLocalScope(this.currentScope, this.lexer.getFile());
        this.scopedParserState = new ScopedParserState(this.scopedParserState, this.lexer.getCmdArgumentState().getStack(), this.lexer.getConditionState().getStack());
        this.lexer.getCmdArgumentState().push0();
        this.lexer.getConditionState().push0();
    }

    public Node numparam_push() {
        Node inner = this.numParamInner;
        if (this.numParamOuter == null) {
            this.numParamOuter = this.numParamCurrent;
        }
        this.numParamInner = null;
        this.numParamCurrent = null;
        return inner;
    }

    public void numparam_pop(Node previousInner) {
        if (previousInner != null) {
            this.numParamInner = previousInner;
        } else if (this.numParamCurrent != null) {
            this.numParamInner = this.numParamCurrent;
        }
        if (this.maxNumParam > 0) {
            this.numParamCurrent = this.numParamOuter;
            this.numParamOuter = null;
        } else {
            this.numParamCurrent = null;
        }
    }

    public ArgsNode args_with_numbered(ArgsNode args2, int paramCount) {
        if (paramCount > 0) {
            if (args2 == null) {
                ListNode pre = this.makePreNumArgs(paramCount);
                args2 = this.new_args(this.lexer.getRubySourceline(), pre, null, null, null, null);
            } else if (args2.getArgs().length == 0) {
                ListNode pre = this.makePreNumArgs(paramCount);
                args2 = this.new_args(this.lexer.getRubySourceline(), pre, null, null, null, null);
            }
        }
        return args2;
    }

    private ListNode makePreNumArgs(int paramCount) {
        ArrayNode list2 = new ArrayNode(this.lexer.getRubySourceline());
        for (int i2 = 1; i2 <= paramCount; ++i2) {
            RubySymbol name2 = this.symbolID(new ByteList(("_" + i2).getBytes()));
            list2.add(new ArgumentNode(this.lexer.getRubySourceline(), name2, this.getCurrentScope().addVariableThisScope(name2.idString())));
        }
        return list2;
    }

    public int resetMaxNumParam() {
        return this.restoreMaxNumParam(0);
    }

    public int restoreMaxNumParam(int maxNum) {
        int temp = this.maxNumParam;
        this.maxNumParam = maxNum;
        return temp;
    }

    public void ordinalMaxNumParam() {
        this.maxNumParam = -1;
    }

    public static Node arg_concat(Node node1, Node node2) {
        return node2 == null ? node1 : new ArgsCatNode(node1.getLine(), node1, node2);
    }

    public static Node arg_blk_pass(Node firstNode, BlockPassNode secondNode) {
        if (secondNode != null) {
            secondNode.setArgsNode(firstNode);
            return secondNode;
        }
        return firstNode;
    }

    public Node gettable2(Node node) {
        switch (node.getNodeType()) {
            case DASGNNODE: 
            case LOCALASGNNODE: {
                RubySymbol name2 = ((INameNode)((Object)node)).getName();
                String id2 = name2.idString();
                int slot = this.currentScope.isDefined(id2);
                if (this.currentScope.isBlockScope() && slot != -1) {
                    if (this.isNumParamId(id2) && this.isNumParamNested()) {
                        return null;
                    }
                    if (name2.getBytes().equals(this.lexer.getCurrentArg())) {
                        this.compile_error(RubyStringBuilder.str(this.getRuntime(), "circular argument reference - ", name2));
                    }
                    DVarNode newNode = new DVarNode(node.getLine(), slot, name2);
                    if (this.warnOnUnusedVariables && newNode instanceof IScopedNode) {
                        this.scopedParserState.markUsedVariable(name2, ((IScopedNode)((Object)node)).getDepth());
                    }
                    return newNode;
                }
                StaticScope.Type type2 = this.currentScope.getType();
                if (type2 == StaticScope.Type.LOCAL) {
                    if (name2.getBytes().equals(this.lexer.getCurrentArg())) {
                        this.compile_error(RubyStringBuilder.str(this.getRuntime(), "circular argument reference - ", name2));
                    }
                    LocalVarNode newNode = new LocalVarNode(node.getLine(), slot, name2);
                    if (this.warnOnUnusedVariables && newNode instanceof IScopedNode) {
                        this.scopedParserState.markUsedVariable(name2, ((IScopedNode)((Object)node)).getDepth());
                    }
                    return newNode;
                }
                if (type2 == StaticScope.Type.BLOCK && this.isNumParamId(id2) && this.numberedParam(id2)) {
                    if (this.isNumParamNested()) {
                        return null;
                    }
                    DVarNode newNode = new DVarNode(node.getLine(), slot, name2);
                    if (this.numParamCurrent == null) {
                        this.numParamCurrent = newNode;
                    }
                    return newNode;
                }
                if (this.currentScope.getType() != StaticScope.Type.BLOCK) {
                    this.numparam_name(name2.getBytes());
                }
                return new VCallNode(node.getLine(), name2);
            }
            case CONSTDECLNODE: {
                return new ConstNode(node.getLine(), ((INameNode)((Object)node)).getName());
            }
            case INSTASGNNODE: {
                return new InstVarNode(node.getLine(), ((INameNode)((Object)node)).getName());
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                return new ClassVarNode(node.getLine(), ((INameNode)((Object)node)).getName());
            }
            case GLOBALASGNNODE: {
                return new GlobalVarNode(node.getLine(), ((INameNode)((Object)node)).getName());
            }
        }
        this.getterIdentifierError(((INameNode)((Object)node)).getName());
        return null;
    }

    private boolean numberedParam(String id2) {
        int n = Integer.parseInt(id2.substring(1));
        if (this.scopedParserState.getEnclosingScope() == null) {
            return false;
        }
        if (this.maxNumParam == -1) {
            this.compile_error("ordinary parameter is defined");
            return false;
        }
        if (this.maxNumParam < n) {
            this.maxNumParam = n;
        }
        return true;
    }

    private boolean isNumParamNested() {
        if (this.numParamOuter == null && this.numParamInner == null) {
            return false;
        }
        Node used = this.numParamOuter != null ? this.numParamOuter : this.numParamInner;
        this.compile_error("numbered parameter is already used in\n" + this.lexer.getFile() + ":" + used.getLine() + ": " + (this.numParamOuter != null ? "outer" : "inner") + " block here");
        return true;
    }

    private boolean isNumParamId(String id2) {
        if (id2.length() != 2 || id2.charAt(0) != '_') {
            return false;
        }
        char one = id2.charAt(1);
        return one != '0' && Character.isDigit(one);
    }

    public void numparam_name(RubySymbol name2) {
        this.numparam_name(name2.getBytes());
    }

    public void numparam_name(ByteList name2) {
        String id2 = name2.toString();
        if (this.isNumParamId(id2)) {
            this.compile_error(id2 + " is reserved for numbered parameter");
        }
    }

    public Node declareIdentifier(ByteList byteName) {
        Node node;
        int slot;
        String id2;
        boolean isNumParam;
        RubySymbol name2 = this.symbolID(byteName);
        if (byteName.equals(this.lexer.getCurrentArg())) {
            this.compile_error(RubyStringBuilder.str(this.getRuntime(), "circular argument reference - ", name2));
        }
        if ((isNumParam = this.isNumParamId(id2 = name2.idString())) && this.numberedParam(id2)) {
            if (this.isNumParamNested()) {
                return null;
            }
            this.makePreNumArgs(Integer.parseInt(id2.substring(1)));
            slot = this.currentScope.addVariable(id2);
            Node node2 = node = this.currentScope.isBlockScope() ? new DVarNode(this.lexer.tokline, slot, name2) : new LocalVarNode(this.lexer.tokline, slot, name2);
            if (this.numParamCurrent == null) {
                this.numParamCurrent = node;
            }
        } else {
            node = this.currentScope.declare(this.lexer.tokline, name2);
            slot = this.currentScope.isDefined(id2);
        }
        if (this.warnOnUnusedVariables && node instanceof IScopedNode) {
            this.addOrMarkVariable(name2, slot);
        }
        return node;
    }

    public boolean isArgsInfoEmpty(ArgsNode argsNode) {
        return argsNode.isEmpty();
    }

    public AssignableNode assignableLabelOrIdentifier(ByteList byteName, Node value2) {
        RubySymbol name2 = this.symbolID(byteName);
        this.numparam_name(byteName);
        if (this.warnOnUnusedVariables) {
            this.addOrMarkVariable(name2, this.currentScope.isDefined(name2.idString()));
        }
        return this.currentScope.assign(this.lexer.getRubySourceline(), name2, this.makeNullNil(value2));
    }

    private void addOrMarkVariable(RubySymbol name2, int slot) {
        if (slot == -1) {
            this.scopedParserState.addDefinedVariable(name2, this.lexer.getRubySourceline());
        } else {
            this.scopedParserState.markUsedVariable(name2, slot >> 16);
        }
    }

    public AssignableNode assignableKeyword(ByteList name2, Node value2) {
        return this.currentScope.assignKeyword(this.lexer.getRubySourceline(), this.symbolID(name2), this.makeNullNil(value2));
    }

    protected void getterIdentifierError(RubySymbol identifier) {
        this.lexer.compile_error("identifier " + identifier + " is not valid to get");
    }

    public Node newline_node(Node node, int line) {
        if (node == null) {
            return null;
        }
        Node newNode = this.remove_begin(node);
        if (newNode != node) {
            line = newNode.getLine();
        }
        this.coverLine(line);
        node.setNewline();
        return node;
    }

    public Node addRootNode(Node topOfAST) {
        int line;
        CoverageData coverageData = this.finishCoverage(this.lexer.getFile(), this.lexer.lineno());
        if (this.result.getBeginNodes().isEmpty()) {
            if (topOfAST == null) {
                topOfAST = NilImplicitNode.NIL;
                line = this.lexer.getRubySourceline();
            } else {
                line = topOfAST.getLine();
            }
        } else {
            line = topOfAST != null ? topOfAST.getLine() : this.result.getBeginNodes().get(0).getLine();
            BlockNode newTopOfAST = new BlockNode(line);
            for (Node beginNode : this.result.getBeginNodes()) {
                this.appendToBlock(newTopOfAST, beginNode);
            }
            if (topOfAST != null) {
                newTopOfAST.add(topOfAST);
            }
            topOfAST = newTopOfAST;
        }
        int coverageMode = coverageData == null ? 0 : coverageData.getMode();
        return new RootNode(line, this.result.getScope(), topOfAST, this.lexer.getFile(), coverageMode);
    }

    public Node appendToBlock(Node head, Node tail) {
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        switch (head.getNodeType()) {
            case BIGNUMNODE: 
            case FIXNUMNODE: 
            case FLOATNODE: 
            case STRNODE: 
            case SELFNODE: 
            case TRUENODE: 
            case FALSENODE: 
            case NILNODE: {
                if (!(head instanceof InvisibleNode)) {
                    this.warning(IRubyWarnings.ID.MISCELLANEOUS, this.lexer.getFile(), tail.getLine(), "unused literal ignored");
                }
                return tail;
            }
        }
        if (!(head instanceof BlockNode)) {
            head = new BlockNode(head.getLine()).add(head);
        }
        if (this.getWarnings().isVerbose() && RubyParserBase.isBreakStatement(((ListNode)head).getLast()) && ((Boolean)Options.PARSER_WARN_NOT_REACHED.load()).booleanValue()) {
            this.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, this.lexer.getFile(), tail.getLine(), "statement not reached");
        }
        ((ListNode)head).addAll(tail);
        return head;
    }

    public AssignableNode assignableInCurr(ByteList nameBytes, Node value2) {
        RubySymbol name2 = this.symbolID(nameBytes);
        this.currentScope.addVariableThisScope(name2.idString());
        if (this.warnOnUnusedVariables) {
            this.scopedParserState.addDefinedVariable(name2, this.lexer.getRubySourceline());
        }
        return this.currentScope.assign(this.lexer.getRubySourceline(), name2, this.makeNullNil(value2));
    }

    public Node call_uni_op(Node firstNode, ByteList operator) {
        this.value_expr(firstNode);
        return new OperatorCallNode(firstNode.getLine(), firstNode, this.symbolID(operator), null, null, false);
    }

    public Node call_bin_op(Node firstNode, ByteList operator, Node secondNode) {
        return this.getOperatorCallNodeInner(firstNode, operator, secondNode);
    }

    public Node call_bin_op(Node firstNode, ByteList operator, Node secondNode, int defaultPosition) {
        firstNode = this.checkForNilNode(firstNode, defaultPosition);
        secondNode = this.checkForNilNode(secondNode, defaultPosition);
        return this.getOperatorCallNodeInner(firstNode, operator, secondNode);
    }

    private Node getOperatorCallNodeInner(Node firstNode, ByteList operator, Node secondNode) {
        this.value_expr(firstNode);
        this.value_expr(secondNode);
        return new OperatorCallNode(firstNode.getLine(), firstNode, this.symbolID(operator), new ArrayNode(secondNode.getLine(), secondNode), null, false);
    }

    public Node new_defined(long line, Node node) {
        return new DefinedNode((int)line, node);
    }

    public Node match_op(Node firstNode, Node secondNode) {
        if (firstNode instanceof DRegexpNode) {
            return new Match2Node(firstNode.getLine(), firstNode, secondNode);
        }
        if (firstNode instanceof RegexpNode) {
            List<Integer> locals = this.allocateNamedLocals((RegexpNode)firstNode);
            if (locals.size() > 0) {
                int[] primitiveLocals = new int[locals.size()];
                for (int i2 = 0; i2 < primitiveLocals.length; ++i2) {
                    primitiveLocals[i2] = locals.get(i2);
                }
                return new Match2CaptureNode(firstNode.getLine(), firstNode, secondNode, primitiveLocals);
            }
            return new Match2Node(firstNode.getLine(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpNode || secondNode instanceof RegexpNode) {
            return new Match3Node(firstNode.getLine(), firstNode, secondNode);
        }
        return this.call_bin_op(firstNode, CommonByteLists.EQUAL_TILDE, secondNode);
    }

    public Node aryset(Node receiver2, Node index2) {
        this.value_expr(receiver2);
        return this.new_attrassign(receiver2.getLine(), receiver2, CommonByteLists.ASET_METHOD, index2, false);
    }

    public Node attrset(Node receiver2, ByteList name2) {
        return this.attrset(receiver2, LexingCommon.DOT, name2);
    }

    public Node attrset(Node receiver2, ByteList callType, ByteList name2) {
        return this.new_attrassign(receiver2.getLine(), receiver2, name2.append(61), null, this.isLazy(callType));
    }

    public void backrefAssignError(Node node) {
        if (node instanceof NthRefNode) {
            String varName = "$" + ((NthRefNode)node).getMatchNumber();
            this.lexer.compile_error("Can't set variable " + varName + '.');
        } else if (node instanceof BackRefNode) {
            String varName = "$" + ((BackRefNode)node).getType();
            this.lexer.compile_error("Can't set variable " + varName + '.');
        }
    }

    private static Node arg_add(int line, Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return new ArrayNode(line, NilImplicitNode.NIL);
            }
            return new ArrayNode(node2.getLine(), node2);
        }
        if (node1 instanceof ArrayNode) {
            return ((ArrayNode)node1).add(node2);
        }
        return new ArgsPushNode(line, node1, node2);
    }

    public static Node node_assign(Node lhs, Node rhs) {
        if (lhs == null) {
            return null;
        }
        if (lhs instanceof AssignableNode) {
            ((AssignableNode)lhs).setValueNode(rhs);
        } else if (lhs instanceof IArgumentNode) {
            IArgumentNode invokableNode = (IArgumentNode)((Object)lhs);
            return invokableNode.setArgsNode(RubyParserBase.arg_add(lhs.getLine(), invokableNode.getArgsNode(), rhs));
        }
        return lhs;
    }

    public Node ret_args(Node node, int line) {
        if (node != null) {
            if (node instanceof BlockPassNode) {
                this.lexer.compile_error("block argument should not be given");
            } else if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
            } else if (node instanceof SplatNode) {
                node = this.newSValueNode(line, node);
            }
        }
        if (node == null) {
            node = NilImplicitNode.NIL;
        }
        return node;
    }

    private static boolean isBreakStatement(Node node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case BREAKNODE: 
            case NEXTNODE: 
            case REDONODE: 
            case RETRYNODE: 
            case RETURNNODE: {
                return true;
            }
        }
        return false;
    }

    public void warnUnlessEOption(IRubyWarnings.ID id2, Node node, String message2) {
        if (!this.isInline()) {
            this.warning(id2, this.lexer.getFile(), node.getLine(), message2);
        }
    }

    private boolean isInline() {
        return this.type == ParserType.INLINE;
    }

    boolean value_expr_check(Node node) {
        boolean void_node = false;
        if (node == null) {
            this.warn(this.lexer.getRubySourceline(), "empty expression");
        }
        block9: while (node != null) {
            switch (node.getNodeType()) {
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    return void_node ? void_node : true;
                }
                case PATTERNCASENODE: {
                    Node[] cases = ((PatternCaseNode)node).getCases();
                    if (cases != null && cases.length > 0 && cases[0] != null) {
                        return false;
                    }
                    return void_node ? void_node : true;
                }
                case BLOCKNODE: {
                    node = ((BlockNode)node).getLast();
                    continue block9;
                }
                case BEGINNODE: {
                    node = ((BeginNode)node).getBodyNode();
                    continue block9;
                }
                case IFNODE: {
                    if (((IfNode)node).getThenBody() == null) {
                        return false;
                    }
                    if (((IfNode)node).getElseBody() == null) {
                        return false;
                    }
                    boolean vn = this.value_expr_check(((IfNode)node).getThenBody());
                    if (!vn) {
                        return false;
                    }
                    if (!void_node) {
                        void_node = vn;
                    }
                    node = ((IfNode)node).getElseBody();
                    continue block9;
                }
                case ANDNODE: 
                case ORNODE: {
                    node = ((BinaryOperatorNode)((Object)node)).getFirstNode();
                    continue block9;
                }
                case DASGNNODE: 
                case LOCALASGNNODE: {
                    if (this.warnOnUnusedVariables) {
                        this.scopedParserState.markUsedVariable(((INameNode)((Object)node)).getName(), ((IScopedNode)((Object)node)).getDepth());
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public boolean value_expr(Node node) {
        boolean void_expr = this.value_expr_check(node);
        if (void_expr) {
            this.lexer.compile_error("void value expression");
        }
        return void_expr;
    }

    private void handleUselessWarn(Node node, String useless) {
        if (((Boolean)Options.PARSER_WARN_USELESSS_USE_OF.load()).booleanValue()) {
            this.warn(node.getLine(), "possibly useless use of " + useless + " in void context");
        }
    }

    public void void_expr(Node node) {
        if (!this.getWarnings().isVerbose()) {
            return;
        }
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case CALLNODE: {
                if (!(node instanceof OperatorCallNode)) {
                    return;
                }
                ByteList name2 = ((CallNode)node).getName().getBytes();
                int length2 = name2.realSize();
                if (length2 > 3) {
                    return;
                }
                if (length2 == 3) {
                    if (name2.charAt(0) == '<' || name2.charAt(1) == '=' || name2.charAt(2) == '>') {
                        this.handleUselessWarn(node, name2.toString());
                    }
                    return;
                }
                boolean isUseless = false;
                switch (name2.charAt(0)) {
                    case '+': 
                    case '-': {
                        if (length2 != 1 && name2.charAt(1) != '@') break;
                        isUseless = true;
                        break;
                    }
                    case '*': {
                        if (length2 != 1 && name2.charAt(1) != '*') break;
                        isUseless = true;
                        break;
                    }
                    case '%': 
                    case '&': 
                    case '/': 
                    case '^': 
                    case '|': {
                        if (length2 != 1) break;
                        isUseless = true;
                        break;
                    }
                    case '<': 
                    case '=': 
                    case '>': {
                        if (length2 != 1 && name2.charAt(1) != '=') break;
                        isUseless = true;
                        break;
                    }
                    case '!': {
                        if (length2 <= 1 || name2.charAt(1) != '=') break;
                        isUseless = true;
                    }
                }
                if (isUseless) {
                    this.handleUselessWarn(node, name2.toString());
                }
                return;
            }
            case BACKREFNODE: 
            case DVARNODE: 
            case GLOBALVARNODE: 
            case LOCALVARNODE: 
            case NTHREFNODE: 
            case CLASSVARNODE: 
            case INSTVARNODE: {
                this.handleUselessWarn(node, "a variable");
                return;
            }
            case CONSTNODE: {
                this.handleUselessWarn(node, "a constant");
                return;
            }
            case BIGNUMNODE: 
            case FIXNUMNODE: 
            case FLOATNODE: 
            case STRNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case DSYMBOLNODE: 
            case REGEXPNODE: 
            case SYMBOLNODE: {
                this.handleUselessWarn(node, "a literal");
                return;
            }
            case COLON2NODE: 
            case COLON3NODE: {
                this.handleUselessWarn(node, "::");
                return;
            }
            case DOTNODE: {
                this.handleUselessWarn(node, ((DotNode)node).isExclusive() ? "..." : "..");
                return;
            }
            case SELFNODE: {
                this.handleUselessWarn(node, "self");
                return;
            }
            case NILNODE: {
                this.handleUselessWarn(node, "nil");
                return;
            }
            case FALSENODE: {
                this.handleUselessWarn(node, "false");
                return;
            }
            case TRUENODE: {
                this.handleUselessWarn(node, "true");
                return;
            }
            case DEFINEDNODE: {
                this.handleUselessWarn(node, "defined?");
                return;
            }
        }
    }

    public Node gettable(ByteList id2) {
        int loc = this.lexer.getRubySourceline();
        if (id2.equals((Object)RubyLexer.Keyword.SELF)) {
            return new SelfNode(loc);
        }
        if (id2.equals(NIL)) {
            return new NilNode(loc);
        }
        if (id2.equals((Object)RubyLexer.Keyword.TRUE)) {
            return new TrueNode(loc);
        }
        if (id2.equals((Object)RubyLexer.Keyword.FALSE)) {
            return new FalseNode(loc);
        }
        if (id2.equals((Object)RubyLexer.Keyword.__FILE__)) {
            return new FileNode(loc, new ByteList(this.lexer.getFile().getBytes()));
        }
        if (id2.equals((Object)RubyLexer.Keyword.__LINE__)) {
            return new FixnumNode(loc, loc);
        }
        if (id2.equals((Object)RubyLexer.Keyword.__ENCODING__)) {
            return new EncodingNode(loc, this.lexer.getEncoding());
        }
        RubySymbol name2 = this.symbolID(id2);
        switch (RubyParserBase.id_type(id2)) {
            case Local: {
                String id22 = name2.idString();
                int slot = this.currentScope.isDefined(id22);
                if (this.currentScope.isBlockScope() && slot != -1) {
                    if (this.isNumParamId(id22) && this.isNumParamNested()) {
                        return null;
                    }
                    if (name2.getBytes().equals(this.lexer.getCurrentArg())) {
                        this.compile_error(RubyStringBuilder.str(this.getRuntime(), "circular argument reference - ", name2));
                    }
                    DVarNode newNode = new DVarNode(loc, slot, name2);
                    if (this.warnOnUnusedVariables && newNode instanceof IScopedNode) {
                        this.scopedParserState.markUsedVariable(name2, ((IScopedNode)newNode).getDepth());
                    }
                    return newNode;
                }
                StaticScope.Type type2 = this.currentScope.getType();
                if (type2 == StaticScope.Type.LOCAL && slot != -1) {
                    if (name2.getBytes().equals(this.lexer.getCurrentArg())) {
                        this.compile_error(RubyStringBuilder.str(this.getRuntime(), "circular argument reference - ", name2));
                    }
                    LocalVarNode newNode = new LocalVarNode(loc, slot, name2);
                    if (this.warnOnUnusedVariables && newNode instanceof IScopedNode) {
                        this.scopedParserState.markUsedVariable(name2, ((IScopedNode)newNode).getDepth());
                    }
                    return newNode;
                }
                if (type2 == StaticScope.Type.BLOCK && this.isNumParamId(id22) && this.numberedParam(id22)) {
                    if (this.isNumParamNested()) {
                        return null;
                    }
                    DVarNode newNode = new DVarNode(loc, slot, name2);
                    if (this.numParamCurrent == null) {
                        this.numParamCurrent = newNode;
                    }
                    return newNode;
                }
                if (this.currentScope.getType() != StaticScope.Type.BLOCK) {
                    this.numparam_name(id2);
                }
                return new VCallNode(loc, name2);
            }
            case Global: {
                return new GlobalVarNode(loc, name2);
            }
            case Instance: {
                return new InstVarNode(loc, name2);
            }
            case Constant: {
                return new ConstNode(loc, name2);
            }
            case Class: {
                return new ClassVarNode(loc, name2);
            }
        }
        this.compile_error("identifier " + id2 + " is not valid to get");
        return null;
    }

    public Node void_stmts(Node node) {
        if (!this.getWarnings().isVerbose() || !(node instanceof BlockNode)) {
            return node;
        }
        BlockNode blockNode = (BlockNode)node;
        int size2 = blockNode.size();
        for (int i2 = 0; i2 <= size2 - 2; ++i2) {
            this.void_expr(blockNode.get(i2));
        }
        return node;
    }

    private boolean checkAssignmentInCondition(Node node) {
        if (node instanceof MultipleAsgnNode || node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof GlobalAsgnNode || node instanceof InstAsgnNode) {
            Node valueNode = ((AssignableNode)node).getValueNode();
            if (RubyParserBase.isStaticContent(valueNode)) {
                this.warning(IRubyWarnings.ID.ASSIGNMENT_IN_CONDITIONAL, this.lexer.getFile(), valueNode.getLine(), "found `= literal' in conditional, should be ==");
            }
            return true;
        }
        return false;
    }

    private static boolean isStaticContent(Node node) {
        if (node instanceof HashNode) {
            HashNode hash2 = (HashNode)node;
            for (KeyValuePair<Node, Node> pair : hash2.getPairs()) {
                if (RubyParserBase.isStaticContent(pair.getKey()) && RubyParserBase.isStaticContent(pair.getValue())) continue;
                return false;
            }
            return true;
        }
        if (node instanceof ArrayNode) {
            ArrayNode array2 = (ArrayNode)node;
            int size2 = array2.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                if (RubyParserBase.isStaticContent(array2.get(i2))) continue;
                return false;
            }
            return true;
        }
        return node instanceof LiteralValue || node instanceof NilNode || node instanceof TrueNode || node instanceof FalseNode;
    }

    protected Node makeNullNil(Node node) {
        return node == null ? NilImplicitNode.NIL : node;
    }

    private Node cond0(Node node, ConditionType type2) {
        this.checkAssignmentInCondition(node);
        if (node == null) {
            return new NilNode(this.lexer.getRubySourceline());
        }
        switch (node.getNodeType()) {
            case STRNODE: 
            case DSTRNODE: 
            case EVSTRNODE: {
                this.switchByCondTypeWarn(type2, node.getLine(), "string ");
                break;
            }
            case DREGEXPNODE: {
                int line = node.getLine();
                if (!this.isInline()) {
                    this.switchByCondTypeWarning(type2, node.getLine(), "regex ");
                }
                return new Match2Node(line, node, new GlobalVarNode(line, this.symbolID(LexingCommon.DOLLAR_UNDERSCORE)));
            }
            case ANDNODE: {
                Node leftNode = this.cond0(((AndNode)node).getFirstNode(), ConditionType.IN_COND);
                Node rightNode = this.cond0(((AndNode)node).getSecondNode(), ConditionType.IN_COND);
                return new AndNode(node.getLine(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case ORNODE: {
                Node leftNode = this.cond0(((OrNode)node).getFirstNode(), ConditionType.IN_COND);
                Node rightNode = this.cond0(((OrNode)node).getSecondNode(), ConditionType.IN_COND);
                return new OrNode(node.getLine(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case DOTNODE: {
                DotNode dotNode = (DotNode)node;
                ByteList label2 = new ByteList(new byte[]{70, 76, 73, 80}, LexingCommon.USASCII_ENCODING);
                label2.append(Long.toString(node.hashCode()).getBytes());
                RubySymbol symbolID = this.symbolID(label2);
                Node begin2 = this.range_op(((DotNode)node).getBeginNode());
                Node end2 = this.range_op(((DotNode)node).getEndNode());
                return new FlipNode(node.getLine(), begin2, end2, dotNode.isExclusive(), this.currentScope.getLocalScope().addVariable(symbolID.idString()));
            }
            case DSYMBOLNODE: 
            case SYMBOLNODE: {
                this.switchByCondTypeWarning(type2, node.getLine(), "symbol ");
            }
            case REGEXPNODE: {
                if (((Boolean)Options.PARSER_WARN_REGEX_CONDITION.load()).booleanValue() && !this.isInline()) {
                    this.switchByCondTypeWarn(type2, node.getLine(), "regex ");
                }
                return new MatchNode(node.getLine(), node);
            }
            case FIXNUMNODE: {
                this.switchByCondTypeWarning(type2, node.getLine(), "");
            }
        }
        return node;
    }

    private void switchByCondTypeWarning(ConditionType type2, int line, String string2) {
        switch (type2) {
            case IN_COND: {
                this.warning(line, string2 + "literal in condition");
                break;
            }
            case IN_FF: {
                this.warning(line, string2 + "literal in flip-flop");
            }
        }
    }

    private void switchByCondTypeWarn(ConditionType type2, int line, String string2) {
        switch (type2) {
            case IN_COND: {
                this.warn(line, string2 + "literal in condition");
                break;
            }
            case IN_FF: {
                this.warn(line, string2 + "literal in flip-flop");
            }
        }
    }

    public Node cond(Node node) {
        return this.cond0(node, ConditionType.IN_COND);
    }

    public Node method_cond(Node node) {
        return this.cond0(node, ConditionType.IN_OP);
    }

    public Node new_if(int line, Node condition, Node thenNode, Node elseNode) {
        if (condition == null) {
            return elseNode;
        }
        condition = this.cond0(condition, ConditionType.IN_COND);
        return new IfNode(line, condition, thenNode, elseNode);
    }

    private Node range_op(Node node) {
        if (node == null) {
            return null;
        }
        this.value_expr(node);
        if (node instanceof FixnumNode) {
            this.warnUnlessEOption(IRubyWarnings.ID.LITERAL_IN_CONDITIONAL_RANGE, node, "integer literal in flip-flop");
            return this.call_bin_op(node, LexingCommon.EQ_EQ, new GlobalVarNode(node.getLine(), this.symbolID(LexingCommon.DOLLAR_DOT)));
        }
        return this.cond0(node, ConditionType.IN_FF);
    }

    public SValueNode newSValueNode(int line, Node node) {
        return new SValueNode(line, node);
    }

    public SplatNode newSplatNode(Node node) {
        int line = node instanceof NilImplicitNode ? this.lexer.getRubySourceline() : node.getLine();
        return new SplatNode(line, node);
    }

    public ArrayNode newArrayNode(int line, Node node) {
        line = (node = this.makeNullNil(node)) instanceof NilImplicitNode ? this.lexer.getRubySourceline() : node.getLine();
        return new ArrayNode(line, node);
    }

    public int position(Node one, Node two) {
        return one == null ? two.getLine() : one.getLine();
    }

    public Node logop(Node left2, ByteList op, Node right) {
        this.value_expr(left2);
        if (op == LexingCommon.AND_KEYWORD || op == LexingCommon.AMPERSAND_AMPERSAND) {
            if (left2 == null && right == null) {
                return new AndNode(this.lexer.getRubySourceline(), this.makeNullNil(left2), this.makeNullNil(right));
            }
            return new AndNode(this.position(left2, right), this.makeNullNil(left2), this.makeNullNil(right));
        }
        if (left2 == null && right == null) {
            return new OrNode(this.lexer.getRubySourceline(), this.makeNullNil(left2), this.makeNullNil(right));
        }
        return new OrNode(this.position(left2, right), this.makeNullNil(left2), this.makeNullNil(right));
    }

    public static CaseNode newCaseNode(int line, Node expression, Node firstWhenNode) {
        ArrayNode cases = new ArrayNode(firstWhenNode != null ? firstWhenNode.getLine() : line);
        CaseNode caseNode = new CaseNode(line, expression, cases);
        Node current2 = firstWhenNode;
        while (current2 != null) {
            if (current2 instanceof WhenOneArgNode) {
                cases.add(current2);
            } else if (current2 instanceof WhenNode) {
                RubyParserBase.simplifyMultipleArgumentWhenNodes((WhenNode)current2, cases);
            } else {
                caseNode.setElseNode(current2);
                break;
            }
            current2 = ((WhenNode)current2).getNextCase();
        }
        return caseNode;
    }

    public static PatternCaseNode newPatternCaseNode(int line, Node expression, Node firstWhenNode) {
        ArrayNode cases = new ArrayNode(firstWhenNode != null ? firstWhenNode.getLine() : line);
        PatternCaseNode caseNode = new PatternCaseNode(line, expression, cases);
        Node current2 = firstWhenNode;
        while (current2 != null) {
            if (!(current2 instanceof InNode)) {
                caseNode.setElseNode(current2);
                break;
            }
            cases.add(current2);
            current2 = ((InNode)current2).getNextCase();
        }
        return caseNode;
    }

    private static void simplifyMultipleArgumentWhenNodes(WhenNode sourceWhen, ArrayNode cases) {
        Node expressionNodes = sourceWhen.getExpressionNodes();
        if (expressionNodes instanceof SplatNode || expressionNodes instanceof ArgsCatNode) {
            cases.add(sourceWhen);
            return;
        }
        if (expressionNodes instanceof ListNode) {
            ListNode list2 = (ListNode)expressionNodes;
            int line = sourceWhen.getLine();
            Node bodyNode = sourceWhen.getBodyNode();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Node expression = list2.get(i2);
                if (expression instanceof SplatNode || expression instanceof ArgsCatNode) {
                    cases.add(new WhenNode(line, expression, bodyNode, null));
                    continue;
                }
                cases.add(new WhenOneArgNode(line, expression, bodyNode, null));
            }
        } else {
            cases.add(sourceWhen);
        }
    }

    public WhenNode newWhenNode(int line, Node expressionNodes, Node bodyNode, Node nextCase) {
        Node element;
        if (bodyNode == null) {
            bodyNode = NilImplicitNode.NIL;
        }
        if (expressionNodes instanceof SplatNode || expressionNodes instanceof ArgsCatNode || expressionNodes instanceof ArgsPushNode) {
            return new WhenNode(line, expressionNodes, bodyNode, nextCase);
        }
        ListNode list2 = (ListNode)expressionNodes;
        if (list2.size() == 1 && !((element = list2.get(0)) instanceof SplatNode)) {
            return new WhenOneArgNode(line, element, bodyNode, nextCase);
        }
        return new WhenNode(line, expressionNodes, bodyNode, nextCase);
    }

    public Node new_op_assign(AssignableNode receiverNode, ByteList operatorName, Node valueNode) {
        int line = receiverNode.getLine();
        if (operatorName == LexingCommon.OR_KEYWORD || operatorName == LexingCommon.OR_OR) {
            receiverNode.setValueNode(valueNode);
            return new OpAsgnOrNode(line, this.gettable2(receiverNode), receiverNode);
        }
        if (operatorName == LexingCommon.AND_KEYWORD || operatorName == LexingCommon.AMPERSAND_AMPERSAND) {
            receiverNode.setValueNode(valueNode);
            return new OpAsgnAndNode(line, this.gettable2(receiverNode), receiverNode);
        }
        receiverNode.setValueNode(this.call_bin_op(this.gettable2(receiverNode), operatorName, valueNode));
        receiverNode.setLine(line);
        return receiverNode;
    }

    public Node new_ary_op_assign(Node receiverNode, ByteList operatorName, Node argsNode, Node valueNode) {
        int line = this.lexer.tokline;
        Node blockNode = null;
        if (argsNode instanceof BlockPassNode) {
            blockNode = argsNode;
            argsNode = ((BlockPassNode)argsNode).getArgsNode();
        }
        OpElementAsgnNode newNode = new OpElementAsgnNode(line, receiverNode, this.symbolID(operatorName), argsNode, valueNode, blockNode);
        this.fixpos(newNode, receiverNode);
        return newNode;
    }

    public Node new_attr_op_assign(Node receiverNode, ByteList callType, Node valueNode, ByteList variableName, ByteList operatorName) {
        return new OpAsgnNode(receiverNode.getLine(), receiverNode, valueNode, this.symbolID(variableName), this.symbolID(operatorName), this.isLazy(callType));
    }

    public Node new_const_op_assign(int line, Node lhs, ByteList operatorName, Node rhs) {
        if (lhs != null) {
            return new OpAsgnConstDeclNode(line, lhs, this.symbolID(operatorName), rhs);
        }
        return new BeginNode(line, NilImplicitNode.NIL);
    }

    public Node new_bodystmt(Node head, RescueBodyNode rescue, Node rescueElse, Node ensure) {
        Node node = head;
        if (rescue != null) {
            node = new RescueNode(this.getPosition(head), head, rescue, rescueElse);
        } else if (rescueElse != null) {
            this.warn(this.lexer.tokline, "else without rescue is useless");
            node = this.appendToBlock(head, rescue);
        }
        if (ensure != null) {
            node = node != null ? new EnsureNode(this.getPosition(head), this.makeNullNil(node), ensure) : this.appendToBlock(ensure, NilImplicitNode.NIL);
        }
        this.fixpos(node, head);
        return node;
    }

    public RubySymbol symbolID(ByteList identifierValue) {
        if (RubyString.scanForCodeRange(identifierValue) == 48) {
            Ruby runtime2 = this.getRuntime();
            throw runtime2.newSyntaxError(RubyStringBuilder.str(runtime2, "invalid symbol in encoding " + this.lexer.getEncoding() + " :\"", RubyStringBuilder.inspectIdentifierByteList(runtime2, identifierValue), "\""));
        }
        return RubySymbol.newIDSymbol(this.getRuntime(), identifierValue);
    }

    public boolean isLazy(String callType) {
        return "&.".equals(callType);
    }

    public boolean isLazy(ByteList callType) {
        return callType == LexingCommon.AMPERSAND_DOT;
    }

    public Node new_attrassign(int line, Node receiver2, ByteList name2, Node argsNode, boolean isLazy) {
        Node blockNode = null;
        if (argsNode instanceof BlockPassNode) {
            blockNode = argsNode;
            argsNode = ((BlockPassNode)argsNode).getArgsNode();
        }
        return new AttrAssignNode(line, receiver2, this.symbolID(name2), argsNode, blockNode, isLazy);
    }

    public Node new_call(Node receiver2, ByteList callType, ByteList name2, Node argsNode, Node iter) {
        return this.new_call(receiver2, callType, name2, argsNode, iter, this.position(receiver2, argsNode));
    }

    public Node new_call(Node receiver2, ByteList callType, ByteList name2, Node argsNode, Node iter, int line) {
        if (argsNode instanceof BlockPassNode) {
            if (iter != null) {
                this.lexer.compile_error("both block arg and actual block given.");
            }
            BlockPassNode blockPass = (BlockPassNode)argsNode;
            return new CallNode(line, receiver2, this.symbolID(name2), blockPass.getArgsNode(), blockPass, this.isLazy(callType));
        }
        return new CallNode(line, receiver2, this.symbolID(name2), argsNode, iter, this.isLazy(callType));
    }

    public Node new_call(Node receiver2, ByteList name2, Node argsNode, Node iter) {
        return this.new_call(receiver2, LexingCommon.DOT, name2, argsNode, iter);
    }

    public Colon2Node new_colon2(int line, Node leftNode, ByteList name2) {
        if (leftNode == null) {
            return new Colon2ImplicitNode(line, this.symbolID(name2));
        }
        return new Colon2ConstNode(line, leftNode, this.symbolID(name2));
    }

    public Colon3Node new_colon3(int line, ByteList name2) {
        return new Colon3Node(line, this.symbolID(name2));
    }

    public void frobnicate_fcall_args(FCallNode fcall, Node args2, Node iter) {
        if (args2 instanceof BlockPassNode) {
            if (iter != null) {
                this.lexer.compile_error("both block arg and actual block given.");
            }
            BlockPassNode blockPass = (BlockPassNode)args2;
            args2 = blockPass.getArgsNode();
            iter = blockPass;
        }
        fcall.setArgsNode(args2);
        fcall.setIterNode(iter);
    }

    public void fixpos(Node node, Node orig) {
        if (node == null || orig == null) {
            return;
        }
        node.setLine(orig.getLine());
    }

    public Node new_fcall(ByteList operation) {
        return new FCallNode(this.lexer.tokline, this.symbolID(operation));
    }

    public Node new_super(int line, Node args2) {
        if (args2 instanceof BlockPassNode) {
            return new SuperNode(line, ((BlockPassNode)args2).getArgsNode(), args2);
        }
        return new SuperNode(line, args2);
    }

    public void initTopLocalVariables() {
        this.currentScope = this.getTopStaticScope(this.lexer.getFile());
        this.scopedParserState = new ScopedParserState(null);
        this.warnOnUnusedVariables = this.getWarnings().isVerbose() && !this.isEval() && !this.isInline();
    }

    boolean isEval() {
        return this.type == ParserType.EVAL;
    }

    public void finalizeDynamicScope() {
        this.getResult().setScope(this.finalizeDynamicScope(this.currentScope));
    }

    public RubyParserResult getResult() {
        return this.result;
    }

    public DStrNode createDStrNode(int line) {
        return new DStrNode(line, this.lexer.getEncoding());
    }

    public KeyValuePair<Node, Node> createKeyValue(Node key2, Node value2) {
        if (key2 instanceof StrNode) {
            ((StrNode)key2).setFrozen(true);
        }
        return new KeyValuePair<Node, Node>(key2, value2);
    }

    public Node asSymbol(int line, ByteList value2) {
        return new SymbolNode(line, this.symbolID(value2));
    }

    public Node asSymbol(int line, Node value2) {
        return value2 instanceof StrNode ? new SymbolNode(line, this.symbolID(((StrNode)value2).getValue())) : new DSymbolNode(line, (DStrNode)value2);
    }

    public Node literal_concat(Node head, Node tail) {
        if (head == null) {
            return tail;
        }
        if (tail == null) {
            return head;
        }
        if (head instanceof EvStrNode) {
            head = this.createDStrNode(head.getLine()).add(head);
        }
        if (this.lexer.getHeredocIndent() > 0) {
            if (head instanceof StrNode) {
                head = this.createDStrNode(head.getLine()).add(head);
                return this.list_append(head, tail);
            }
            if (head instanceof DStrNode) {
                return this.list_append(head, tail);
            }
        }
        if (tail instanceof StrNode) {
            if (head instanceof StrNode) {
                StrNode front = (StrNode)head;
                if (front.getValue().getRealSize() > 0) {
                    return new StrNode(head.getLine(), front, (StrNode)tail);
                }
                return tail;
            }
            head.setLine(head.getLine());
            return ((ListNode)head).add(tail);
        }
        if (tail instanceof DStrNode) {
            if (head instanceof StrNode) {
                DStrNode newDStr = new DStrNode(head.getLine(), ((DStrNode)tail).getEncoding());
                newDStr.add(head);
                newDStr.addAll(tail);
                return newDStr;
            }
            return ((ListNode)head).addAll(tail);
        }
        if (head instanceof StrNode) {
            head = ((StrNode)head).getValue().length() == 0 ? this.createDStrNode(head.getLine()) : this.createDStrNode(head.getLine()).add(head);
        }
        return ((DStrNode)head).add(tail);
    }

    public Node newRescueModNode(Node body, Node rescueBody) {
        if (rescueBody == null) {
            rescueBody = NilImplicitNode.NIL;
        }
        int line = this.getPosition(body);
        body = this.remove_begin(body);
        rescueBody = this.remove_begin(rescueBody);
        if (body instanceof OpElementAsgnNode) {
            OpElementAsgnNode original = (OpElementAsgnNode)body;
            return new OpElementAsgnNode(line, original.getReceiverNode(), original.getOperatorSymbolName(), original.getArgsNode(), new RescueModNode(line, original.getValueNode(), new RescueBodyNode(line, null, rescueBody, null)), original.getBlockNode());
        }
        return new RescueModNode(line, body, new RescueBodyNode(line, null, rescueBody, null));
    }

    public Node newEvStrNode(int line, Node node) {
        if (node instanceof StrNode || node instanceof EvStrNode) {
            return node;
        }
        return new EvStrNode(line, node);
    }

    public Node new_yield(int line, Node node) {
        if (node instanceof BlockPassNode) {
            this.lexer.compile_error("Block argument should not be given.");
        }
        return new YieldNode(line, node);
    }

    public NumericNode negateInteger(NumericNode integerNode) {
        if (integerNode instanceof FixnumNode) {
            FixnumNode fixnumNode = (FixnumNode)integerNode;
            fixnumNode.setValue(-fixnumNode.getValue());
            return fixnumNode;
        }
        if (integerNode instanceof BignumNode) {
            BignumNode bignumNode = (BignumNode)integerNode;
            BigInteger value2 = bignumNode.getValue().negate();
            if (value2.compareTo(RubyBignum.LONG_MIN) >= 0) {
                return new FixnumNode(bignumNode.getLine(), value2.longValue());
            }
            bignumNode.setValue(value2);
        }
        return integerNode;
    }

    public FloatNode negateFloat(FloatNode floatNode) {
        floatNode.setValue(-floatNode.getValue());
        return floatNode;
    }

    public ComplexNode negateComplexNode(ComplexNode complexNode) {
        complexNode.setNumber(this.negateNumeric(complexNode.getNumber()));
        return complexNode;
    }

    public RationalNode negateRational(RationalNode rationalNode) {
        return (RationalNode)rationalNode.negate();
    }

    private Node checkForNilNode(Node node, int defaultPosition) {
        return node == null ? new NilNode(defaultPosition) : node;
    }

    public ArgsNode new_args(int line, ListNode pre, ListNode optional, RestArgNode rest, ListNode post, ArgsTailHolder tail) {
        ArgsNode argsNode;
        if (tail == null) {
            argsNode = new ArgsNode(line, pre, optional, rest, post, null);
        } else {
            if (tail.getBlockArg() instanceof ForwardingBlockArgNode) {
                if (rest != null) {
                    this.yyerror("... after rest argument");
                    ArgsNode argsNode2 = new ArgsNode(line, null, null, null, null, tail.getKeywordArgs(), tail.getKeywordRestArgNode(), tail.getBlockArg());
                    this.getCurrentScope().setSignature(Signature.from(argsNode2));
                    return argsNode2;
                }
                int slot = this.getCurrentScope().addVariableThisScope(CommonByteLists.FWD_REST.toString());
                rest = new UnnamedRestArgNode(line, this.symbolID(CommonByteLists.FWD_REST), slot);
            }
            argsNode = new ArgsNode(line, pre, optional, rest, post, tail.getKeywordArgs(), tail.getKeywordRestArgNode(), tail.getBlockArg());
        }
        this.getCurrentScope().setSignature(Signature.from(argsNode));
        return argsNode;
    }

    public ArgsTailHolder new_args_tail(int line, ListNode keywordArg, ByteList keywordRestArgName, BlockArgNode blockArg) {
        if (keywordRestArgName == null) {
            return new ArgsTailHolder(line, keywordArg, null, blockArg);
        }
        RubySymbol restKwargsName = this.symbolID(keywordRestArgName);
        String id2 = restKwargsName.idString();
        int slot = this.currentScope.exists(id2);
        if (slot == -1) {
            slot = this.currentScope.addVariable(id2);
        }
        KeywordRestArgNode keywordRestArg = new KeywordRestArgNode(line, restKwargsName, slot);
        return new ArgsTailHolder(line, keywordArg, keywordRestArg, blockArg);
    }

    protected ArgsTailHolder new_args_tail(int line, ListNode keywordArg, ByteList keywordRestArgName, ByteList block) {
        BlockArgNode blockArg = null;
        if (block != null) {
            ArgumentNode var = this.arg_var(block);
            blockArg = block == CommonByteLists.FWD_BLOCK ? new ForwardingBlockArgNode(var) : new BlockArgNode(var);
        }
        return this.new_args_tail(line, keywordArg, keywordRestArgName, blockArg);
    }

    public Node remove_duplicate_keys(HashNode hash2) {
        HashMap<Node, KeyValuePair<Node, Node>> encounteredKeys = new HashMap<Node, KeyValuePair<Node, Node>>();
        for (KeyValuePair<Node, Node> pair : hash2.getPairs()) {
            Node key2 = pair.getKey();
            if (!(key2 instanceof LiteralValue)) continue;
            if (encounteredKeys.containsKey(key2)) {
                Ruby runtime2 = this.getRuntime();
                IRubyObject value2 = ((LiteralValue)((Object)key2)).literalValue(runtime2);
                this.warning(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.lexer.getFile(), hash2.getLine(), RubyStringBuilder.str(runtime2, "key ", value2.inspect(), " is duplicated and overwritten on line " + (key2.getLine() + 1)));
            }
            encounteredKeys.put(key2, pair);
        }
        return hash2;
    }

    public static Node newAlias(int line, Node newNode, Node oldNode) {
        return new AliasNode(line, newNode, oldNode);
    }

    public static Node newUndef(int line, Node nameNode) {
        return new UndefNode(line, nameNode);
    }

    public void yyerror(String message2) {
        this.lexer.compile_error(message2);
    }

    public void yyerror(String message2, ProductionState state2) {
        this.lexer.compile_error(message2, state2.start, state2.end);
    }

    public void yyerror(String message2, String[] expected, String found) {
        this.lexer.compile_error(message2 + ", unexpected " + found + "\n");
    }

    public int getPosition(Node start2) {
        return start2 != null ? start2.getLine() : this.lexer.getRubySourceline();
    }

    public void warn(String message2) {
        this.warn(this.src_line(), message2);
    }

    public void warn(int line, String message2) {
        this.getWarnings().warn(IRubyWarnings.ID.USELESS_EXPRESSION, this.lexer.getFile(), line + 1, message2);
    }

    public void warning(int line, String message2) {
        this.warning(IRubyWarnings.ID.USELESS_EXPRESSION, this.lexer.getFile(), line, message2);
    }

    public void warning(IRubyWarnings.ID id2, String file2, int line, String message2) {
        this.getWarnings().warn(id2, file2, line + 1, message2);
    }

    public static boolean is_local_id(ByteList name2) {
        return RubyLexer.isIdentifierChar(name2.charAt(0));
    }

    @Deprecated
    public boolean is_local_id(String name2) {
        return RubyLexer.isIdentifierChar(name2.charAt(0));
    }

    public ListNode list_append(Node list2, Node item) {
        if (list2 == null) {
            return new ArrayNode(item.getLine(), item);
        }
        if (!(list2 instanceof ListNode)) {
            return new ArrayNode(list2.getLine(), list2).add(item);
        }
        return ((ListNode)list2).add(item);
    }

    public Node new_bv(ByteList identifier) {
        if (!RubyParserBase.is_local_id(identifier)) {
            this.getterIdentifierError(this.symbolID(identifier));
        }
        this.shadowing_lvar(identifier);
        return this.arg_var(identifier);
    }

    public ArgumentNode arg_var(RubySymbol name2) {
        return this.arg_var(name2.getBytes());
    }

    public ArgumentNode arg_var(ByteList byteName) {
        int length2 = byteName.length();
        if (length2 > 0 && byteName.get(length2 - 1) == 58) {
            byteName.setRealSize(length2 - 1);
        }
        RubySymbol name2 = this.symbolID(byteName);
        this.numparam_name(byteName);
        if (this.warnOnUnusedVariables) {
            this.scopedParserState.addDefinedVariable(name2, this.lexer.getRubySourceline());
            this.scopedParserState.markUsedVariable(name2, 0);
        }
        return new ArgumentNode(this.lexer.getRubySourceline(), name2, this.getCurrentScope().addVariableThisScope(name2.idString()));
    }

    public ByteList formal_argument(ByteList identifier, Object _unused) {
        this.lexer.validateFormalIdentifier(identifier);
        return this.shadowing_lvar(identifier);
    }

    public static IDType id_type(ByteList identifier) {
        char first2 = identifier.charAt(0);
        if (Character.isUpperCase(first2)) {
            return IDType.Constant;
        }
        switch (first2) {
            case '@': {
                return identifier.charAt(1) == '@' ? IDType.Class : IDType.Instance;
            }
            case '$': {
                return IDType.Global;
            }
        }
        byte last2 = (byte)identifier.get(identifier.length() - 1);
        if (last2 == 61) {
            return IDType.AttrSet;
        }
        return IDType.Local;
    }

    public static boolean is_private_local_id(ByteList name2) {
        if (name2.realSize() == 1 && name2.charAt(0) == '_') {
            return true;
        }
        if (!RubyParserBase.is_local_id(name2)) {
            return false;
        }
        return name2.charAt(0) == '_';
    }

    public ByteList shadowing_lvar(ByteList nameBytes) {
        int slot;
        if (RubyParserBase.is_private_local_id(nameBytes)) {
            return nameBytes;
        }
        RubySymbol name2 = this.symbolID(nameBytes);
        String id2 = name2.idString();
        StaticScope current2 = this.getCurrentScope();
        if (current2.exists(id2) >= 0) {
            this.yyerror("duplicated argument name");
        }
        if (this.warnOnUnusedVariables && (slot = current2.isDefined(id2)) != -1) {
            this.scopedParserState.addDefinedVariable(name2, this.lexer.getRubySourceline());
            this.scopedParserState.markUsedVariable(name2, slot >> 16);
        }
        return nameBytes;
    }

    public ListNode list_concat(Node first2, Node second2) {
        if (first2 instanceof ListNode) {
            if (second2 instanceof ListNode) {
                return ((ListNode)first2).addAll((ListNode)second2);
            }
            return ((ListNode)first2).addAll(second2);
        }
        return new ArrayNode(first2.getLine(), first2).add(second2);
    }

    public Node splat_array(Node node) {
        if (node instanceof SplatNode) {
            node = ((SplatNode)node).getValue();
        }
        if (node instanceof ArrayNode) {
            return node;
        }
        return null;
    }

    public Node arg_append(Node node1, Node node2) {
        ArgsCatNode pushNode;
        Node body;
        if (node1 == null) {
            return new ArrayNode(node2.getLine(), node2);
        }
        if (node1 instanceof ListNode) {
            return ((ListNode)node1).add(node2);
        }
        if (node1 instanceof BlockPassNode) {
            return this.arg_append(((BlockPassNode)node1).getBodyNode(), node2);
        }
        if (node1 instanceof ArgsPushNode) {
            ArgsPushNode pushNode2 = (ArgsPushNode)node1;
            Node body2 = pushNode2.getSecondNode();
            return new ArgsCatNode(pushNode2.getLine(), pushNode2.getFirstNode(), new ArrayNode(body2.getLine(), body2).add(node2));
        }
        if (node1 instanceof ArgsCatNode && (body = (pushNode = (ArgsCatNode)node1).getSecondNode()) instanceof ListNode) {
            ((ListNode)body).add(node2);
            return node1;
        }
        return new ArgsPushNode(this.position(node1, node2), node1, node2);
    }

    private List<Integer> allocateNamedLocals(RegexpNode regexpNode) {
        RubyRegexp pattern = RubyRegexp.newRegexp(this.getRuntime(), regexpNode.getValue(), regexpNode.getOptions());
        pattern.setLiteral();
        String[] names2 = pattern.getNames();
        ArrayList<Integer> locals = new ArrayList<Integer>();
        StaticScope scope = this.getCurrentScope();
        Ruby runtime2 = this.getRuntime();
        for (String name2 : names2) {
            if (RubyLexer.getKeyword(name2) != null || Character.isUpperCase(name2.charAt(0))) continue;
            String id2 = runtime2.newSymbol(name2).idString();
            int slot = scope.isDefined(id2);
            if (slot >= 0) {
                locals.add(slot);
                continue;
            }
            int index2 = this.getCurrentScope().addVariableThisScope(id2);
            locals.add(index2);
            this.scopedParserState.growNamedCaptures(index2);
        }
        return locals;
    }

    public void compile_error(String message2) {
        String line = this.lexer.getCurrentLine();
        int pos2 = this.lexer.getRubySourceline();
        String errorMessage = this.lexer.getFile() + ":" + (pos2 + 1) + ": ";
        if (line != null && line.length() > 5) {
            boolean addNewline = message2 != null && !message2.endsWith("\n");
            message2 = message2 + (addNewline ? "\n" : "") + line;
        }
        throw this.getRuntime().newSyntaxError(errorMessage + message2);
    }

    public Node new_regexp(int line, Node contents, RegexpNode end2) {
        Ruby runtime2 = this.getRuntime();
        RegexpOptions options2 = end2.getOptions();
        Encoding encoding2 = this.lexer.getEncoding();
        if (contents == null) {
            ByteList newValue = ByteList.create("");
            if (encoding2 != null) {
                newValue.setEncoding(encoding2);
            }
            this.lexer.checkRegexpFragment(runtime2, newValue, options2);
            return new RegexpNode(line, newValue, options2.withoutOnce());
        }
        if (contents instanceof StrNode) {
            ByteList meat = (ByteList)((StrNode)contents).getValue().clone();
            this.lexer.checkRegexpFragment(runtime2, meat, options2);
            this.lexer.checkRegexpSyntax(runtime2, meat, options2.withoutOnce());
            return new RegexpNode(contents.getLine(), meat, options2.withoutOnce());
        }
        if (contents instanceof DStrNode) {
            DStrNode dStrNode = (DStrNode)contents;
            for (int i2 = 0; i2 < dStrNode.size(); ++i2) {
                Node fragment = dStrNode.get(i2);
                if (!(fragment instanceof StrNode)) continue;
                ByteList frag = ((StrNode)fragment).getValue();
                this.lexer.checkRegexpFragment(runtime2, frag, options2);
            }
            DRegexpNode dRegexpNode = new DRegexpNode(line, options2, encoding2);
            dRegexpNode.add(new StrNode(contents.getLine(), this.createMaster(options2)));
            dRegexpNode.addAll(dStrNode);
            return dRegexpNode;
        }
        ByteList master = this.createMaster(options2);
        this.lexer.checkRegexpFragment(runtime2, master, options2);
        encoding2 = master.getEncoding();
        DRegexpNode node = new DRegexpNode(line, options2, encoding2);
        node.add(new StrNode(contents.getLine(), master));
        node.add(contents);
        return node;
    }

    private ByteList createMaster(RegexpOptions options2) {
        Encoding encoding2 = options2.setup(this.getRuntime());
        return new ByteList(ByteList.NULL_ARRAY, encoding2);
    }

    public static int associateEncoding(ByteList buffer, Encoding newEncoding, int codeRange) {
        Encoding bufferEncoding = buffer.getEncoding();
        if (newEncoding == bufferEncoding) {
            return codeRange;
        }
        buffer.setEncoding(newEncoding);
        if (codeRange != 16 || !newEncoding.isAsciiCompatible()) {
            return 0;
        }
        return codeRange;
    }

    public NumericNode negateNumeric(NumericNode node) {
        switch (node.getNodeType()) {
            case BIGNUMNODE: 
            case FIXNUMNODE: {
                return this.negateInteger(node);
            }
            case COMPLEXNODE: {
                return this.negateComplexNode((ComplexNode)node);
            }
            case FLOATNODE: {
                return this.negateFloat((FloatNode)node);
            }
            case RATIONALNODE: {
                return this.negateRational((RationalNode)node);
            }
        }
        this.yyerror("Invalid or unimplemented numeric to negate: " + node.toString());
        return null;
    }

    @Deprecated
    public String internalId() {
        return INTERNAL_ID.toString();
    }

    public Set<ByteList> push_pvtbl() {
        Set<ByteList> currentTable = this.variableTable;
        this.variableTable = new HashSet<ByteList>();
        return currentTable;
    }

    public void pop_pvtbl(Set<ByteList> table) {
        this.variableTable = table;
    }

    public Set<ByteList> push_pktbl() {
        Set<ByteList> currentTable = this.keyTable;
        this.keyTable = new HashSet<ByteList>();
        return currentTable;
    }

    public void pop_pktbl(Set<ByteList> table) {
        this.keyTable = table;
    }

    public Node newIn(int line, Node expression, Node body, Node nextCase) {
        return new InNode(line, expression, body, nextCase);
    }

    public void endless_method_name(DefHolder name2) {
    }

    public Node reduce_nodes(Node body) {
        return body;
    }

    public void restore_defun(DefHolder holder) {
        this.lexer.getLexContext().restore(holder);
        this.lexer.setCurrentArg(holder.current_arg);
    }

    public ArrayPatternNode new_array_pattern(int line, Node constant, Node preArg, ArrayPatternNode arrayPattern) {
        arrayPattern.setConstant(constant);
        if (preArg != null) {
            ListNode preArgs = new ListNode(line, preArg);
            ListNode arrayPatternPreArgs = arrayPattern.getPreArgs();
            arrayPattern.setPreArgs(arrayPatternPreArgs != null ? this.list_concat(preArgs, arrayPatternPreArgs) : preArgs);
        }
        return arrayPattern;
    }

    public HashPatternNode new_hash_pattern(Node constant, HashPatternNode hashPatternNode) {
        hashPatternNode.setConstant(constant);
        return hashPatternNode;
    }

    public HashNode none() {
        return null;
    }

    public HashPatternNode new_hash_pattern_tail(int line, HashNode keywordArgs, ByteList keywordRestArg) {
        Node restArg = keywordRestArg == LexingCommon.KWNOREST ? new NilRestArgNode(line) : (keywordRestArg == LexingCommon.STAR_STAR ? new StarNode(this.lexer.getRubySourceline()) : (keywordRestArg != null ? this.assignableLabelOrIdentifier(keywordRestArg, null) : null));
        return new HashPatternNode(line, restArg, keywordArgs == null ? new HashNode(line) : keywordArgs);
    }

    public void warn_experimental(int line, String message2) {
        ((RubyWarnings)this.getWarnings()).warnExperimental(this.lexer.getFile(), line, message2);
    }

    public Node rescued_expr(int line, Node arg2, Node rescue) {
        return new RescueNode(line, arg2, new RescueBodyNode(line, null, this.remove_begin(rescue), null), null);
    }

    public ArrayPatternNode new_array_pattern_tail(int line, ListNode preArgs, boolean hasRest, ByteList restArg, ListNode postArgs) {
        return new ArrayPatternNode(line, preArgs, hasRest ? (restArg != null ? this.assignableLabelOrIdentifier(restArg, null) : new StarNode(this.lexer.getRubySourceline())) : null, postArgs);
    }

    public void error_duplicate_pattern_key(ByteList key2) {
        if (this.keyTable == null) {
            this.keyTable = new HashSet<ByteList>();
        }
        if (this.keyTable.contains(key2)) {
            this.yyerror("duplicated key name");
        }
        this.keyTable.add(key2);
    }

    public void error_duplicate_pattern_variable(ByteList variable) {
        if (RubyParserBase.is_private_local_id(variable)) {
            return;
        }
        if (this.variableTable.contains(variable)) {
            this.yyerror("duplicated variable name");
        }
        this.variableTable.add(variable);
    }

    public Node new_find_pattern(Node constant, FindPatternNode findPattern) {
        findPattern.setConstant(constant);
        return findPattern;
    }

    public Node new_find_pattern_tail(int line, ByteList preRestArg, ListNode postArgs, ByteList postRestArg) {
        return new FindPatternNode(line, preRestArg != null ? this.assignableLabelOrIdentifier(preRestArg, null) : new StarNode(this.lexer.getRubySourceline()), postArgs, postRestArg != null ? this.assignableLabelOrIdentifier(postRestArg, null) : new StarNode(this.lexer.getRubySourceline()));
    }

    public boolean local_id(ByteList value2) {
        return this.currentScope.isDefined(this.symbolID(value2).idString()) >= 0;
    }

    public boolean check_forwarding_args() {
        if (this.local_id(CommonByteLists.FWD_ALL)) {
            return true;
        }
        this.compile_error("unexpected ...");
        return false;
    }

    public void add_forwarding_args() {
        this.arg_var(CommonByteLists.FWD_REST);
        this.arg_var(CommonByteLists.FWD_KWREST);
        this.arg_var(CommonByteLists.FWD_BLOCK);
        this.arg_var(CommonByteLists.FWD_ALL);
    }

    public Node new_args_forward_call(int line, Node leadingArgs) {
        RubySymbol splatName = this.symbolID(CommonByteLists.FWD_REST);
        int splatLoc = this.getCurrentScope().isDefined(splatName.idString());
        SplatNode splatNode = new SplatNode(line, new LocalVarNode(line, splatLoc, splatName));
        RubySymbol kwRestName = this.symbolID(CommonByteLists.FWD_KWREST);
        int kwRestLoc = this.getCurrentScope().isDefined(kwRestName.idString());
        LocalVarNode restNode = new LocalVarNode(line, kwRestLoc, kwRestName);
        RubySymbol blockName = this.symbolID(CommonByteLists.FWD_BLOCK);
        int blockLoc = this.getCurrentScope().isDefined(blockName.idString());
        BlockPassNode block = new BlockPassNode(line, new LocalVarNode(line, blockLoc, blockName));
        Node args2 = leadingArgs != null ? this.rest_arg_append(leadingArgs, splatNode) : splatNode;
        args2 = this.arg_append(args2, new HashNode(line, new KeyValuePair<Object, LocalVarNode>(null, restNode)));
        return RubyParserBase.arg_blk_pass(args2, block);
    }

    public void check_literal_when(Node one) {
    }

    public Node last_arg_append(Node args2, Node lastArg) {
        Node n1 = this.splat_array(args2);
        return n1 == null ? this.arg_append(args2, lastArg) : this.list_append(n1, lastArg);
    }

    public Node rest_arg_append(Node args2, Node restArg) {
        Node n1;
        if (restArg instanceof ListNode && (n1 = this.splat_array(args2)) != null) {
            return this.list_concat(n1, restArg);
        }
        return RubyParserBase.arg_concat(args2, restArg);
    }

    public Node remove_begin(Node node) {
        Node body;
        while (node instanceof BeginNode && (body = ((BeginNode)node).getBodyNode()) != null) {
            node = body;
        }
        return node;
    }

    public void nd_set_first_loc(Node node, int line) {
    }

    public RubyParserResult parse() throws IOException {
        this.yyparse(this.lexer, this.runtime.getInstanceConfig().isDebug() ? new YYDebug() : null);
        return this.result;
    }

    protected abstract Object yyparse(RubyLexer var1, Object var2) throws IOException;

    protected LexContext getLexContext() {
        return this.lexer.getLexContext();
    }

    protected int src_line() {
        return this.lexer.getRubySourceline();
    }

    protected int getHeredocIndent() {
        return this.lexer.getHeredocIndent();
    }

    protected void setHeredocIndent(int value2) {
        this.lexer.setHeredocIndent(value2);
    }

    protected int getBraceNest() {
        return this.lexer.getBraceNest();
    }

    protected void setBraceNest(int value2) {
        this.lexer.setBraceNest(value2);
    }

    protected int getState() {
        return this.lexer.getState();
    }

    protected void setState(int value2) {
        this.lexer.setState(value2);
    }

    protected Encoding getEncoding() {
        return this.lexer.getEncoding();
    }

    protected void setCommandStart(boolean value2) {
        this.lexer.commandStart = value2;
    }

    protected ByteList getCurrentArg() {
        return this.lexer.getCurrentArg();
    }

    protected void setCurrentArg(RubySymbol value2) {
        this.lexer.setCurrentArg(value2 == null ? null : value2.getBytes());
    }

    protected StrNode createStr(ByteList buffer, int flags2) {
        return this.lexer.createStr(buffer, flags2);
    }

    protected StackState getCmdArgumentState() {
        return this.lexer.getCmdArgumentState();
    }

    protected StackState getConditionState() {
        return this.lexer.getConditionState();
    }

    protected int getLeftParenBegin() {
        return this.lexer.getLeftParenBegin();
    }

    protected int getParenNest() {
        return this.lexer.getParenNest();
    }

    protected ByteList extractByteList(Object value2) {
        if (value2 instanceof ByteList) {
            return (ByteList)value2;
        }
        if (value2 instanceof RubyString) {
            return ((RubyString)value2).getByteList();
        }
        if (value2 instanceof RubySymbol) {
            return ((RubySymbol)value2).getBytes();
        }
        throw new RuntimeException("Got unexpected object: " + value2);
    }

    protected void setLeftParenBegin(int value2) {
        this.lexer.setLeftParenBegin(value2);
    }

    protected String getFile() {
        return this.lexer.getFile();
    }

    protected void heredoc_dedent(Node node) {
        this.lexer.heredoc_dedent(node);
    }

    protected StrTerm getStrTerm() {
        return this.lexer.getStrTerm();
    }

    protected void setStrTerm(StrTerm value2) {
        this.lexer.setStrTerm(value2);
    }

    protected void setHeredocLineIndent(int indent) {
        this.lexer.setHeredocLineIndent(indent);
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public Node nil() {
        return NilImplicitNode.NIL;
    }

    public RubySymbol get_id(ByteList id2) {
        return this.symbolID(id2);
    }

    public IRubyWarnings getWarnings() {
        return this.runtime.getWarnings();
    }

    public boolean isEndSeen() {
        return this.lexer.isEndSeen();
    }

    public boolean isFrozenStringLiteral() {
        return this.frozenStringLiterals;
    }

    public void setFrozenStringLiteral(boolean b2) {
        this.frozenStringLiterals = b2;
    }

    public DynamicScope finalizeDynamicScope(StaticScope staticScope) {
        if (this.existingScope != null && this.type != ParserType.NORMAL) {
            this.existingScope.growIfNeeded();
            return this.existingScope;
        }
        return DynamicScope.newDynamicScope(staticScope, this.existingScope);
    }

    public StaticScope getTopStaticScope(String file2) {
        return this.existingScope != null ? this.existingScope.getStaticScope() : this.runtime.getStaticScopeFactory().newLocalScope(null, file2);
    }

    public boolean isCoverageEnabled() {
        return !this.isEval() && this.getRuntime().getCoverageData().isCoverageEnabled();
    }

    public void coverLine(int i2) {
        if (i2 < 0) {
            return;
        }
        if (this.isCoverageEnabled()) {
            this.growCoverageLines(i2);
            this.coverage[i2] = 0;
        }
    }

    public void growCoverageLines(int i2) {
        if (this.coverage == null) {
            this.coverage = new int[i2 + 1];
        } else if (this.coverage.length <= i2) {
            int[] newCoverage = new int[i2 + 1];
            Arrays.fill(newCoverage, -1);
            System.arraycopy(this.coverage, 0, newCoverage, 0, this.coverage.length);
            this.coverage = newCoverage;
        }
    }

    public CoverageData finishCoverage(String file2, int lines2) {
        if (!this.isCoverageEnabled()) {
            return null;
        }
        this.growCoverageLines(lines2);
        CoverageData data2 = this.runtime.getCoverageData();
        data2.prepareCoverage(file2, this.coverage);
        return data2;
    }

    public static enum IDType {
        Local,
        Global,
        Instance,
        AttrSet,
        Constant,
        Class;

    }

    static enum ConditionType {
        IN_OP,
        IN_COND,
        IN_FF;

    }
}

