/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.codegen.MultiClassLoader;
import org.jruby.java.codegen.RealClassGenerator;
import org.jruby.java.codegen.Reified;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.ReifiedJavaProxy;
import org.jruby.javasupport.util.JavaClassConfiguration;
import org.jruby.lexer.yacc.SimpleSourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.ivars.VariableAccessorField;
import org.jruby.runtime.ivars.VariableTableManager;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.util.ArraySupport;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.Loader;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.collections.ConcurrentWeakHashMap;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

@JRubyClass(name={"Class"}, parent="Module")
public class RubyClass
extends RubyModule {
    private static final Logger LOG = LoggerFactory.getLogger(RubyClass.class);
    public static final ObjectAllocator CLASS_ALLOCATOR = (runtime2, klass) -> {
        RubyClass clazz = new RubyClass(runtime2);
        clazz.allocator = ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR;
        return clazz;
    };
    protected static final ObjectMarshal DEFAULT_OBJECT_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            IRubyObject object = (IRubyObject)obj;
            marshalStream.registerLinkTarget(object);
            marshalStream.dumpVariables(object.getVariableList());
        }

        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            IRubyObject result2 = type2.allocate();
            unmarshalStream.registerLinkTarget(result2);
            unmarshalStream.defaultVariablesUnmarshal(result2);
            return result2;
        }
    };
    private static final boolean DEBUG_REIFY = false;
    private static final PositionAware defaultSimplePosition = new SimpleSourcePosition("<jruby-internal-reified>", 0);
    protected final Ruby runtime;
    private ObjectAllocator allocator;
    protected ObjectMarshal marshal;
    private volatile Map<RubyClass, Object> subclasses;
    public static final int CS_IDX_INITIALIZE = 0;
    private final CallSite[] baseCallSites = new CallSite[CS_NAMES.length];
    private CallSite[] extraCallSites;
    private Class<? extends Reified> reifiedClass;
    private Boolean reifiedClassJava;
    private JavaClassConfiguration javaClassConfiguration;
    private MarshalTuple cachedDumpMarshal;
    private CacheEntry cachedLoad;
    private final RubyClass realClass;
    private final VariableTableManager variableTableManager;

    public static void createClassClass(Ruby runtime2, RubyClass classClass) {
        classClass.setClassIndex(ClassIndex.CLASS);
        classClass.setReifiedClass(RubyClass.class);
        classClass.kindOf = new RubyModule.JavaClassKindOf(RubyClass.class);
        classClass.undefineMethod("module_function");
        classClass.undefineMethod("append_features");
        classClass.undefineMethod("prepend_features");
        classClass.undefineMethod("extend_object");
        classClass.undefineMethod("refine");
        classClass.defineAnnotatedMethods(RubyClass.class);
        runtime2.setBaseNewMethod(classClass.searchMethod("new"));
    }

    public ObjectAllocator getAllocator() {
        return this.allocator;
    }

    public void setAllocator(ObjectAllocator allocator) {
        this.allocator = allocator;
    }

    public void setClassAllocator(Class<?> cls) {
        this.allocator = (runtime2, klazz) -> {
            try {
                RubyBasicObject object = (RubyBasicObject)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                object.setMetaClass(klazz);
                return object;
            }
            catch (InstantiationException | InvocationTargetException ie) {
                throw runtime2.newTypeError("could not allocate " + cls + " with default constructor:\n" + ie);
            }
            catch (IllegalAccessException | NoSuchMethodException iae) {
                throw runtime2.newSecurityError("could not allocate " + cls + " due to inaccessible default constructor:\n" + iae);
            }
        };
        this.reifiedClass = cls;
    }

    public void setRubyClassAllocator(Class<? extends IRubyObject> clazz) {
        try {
            Constructor<? extends IRubyObject> constructor2 = clazz.getConstructor(Ruby.class, RubyClass.class);
            this.allocator = (runtime2, klazz) -> {
                try {
                    return (IRubyObject)constructor2.newInstance(runtime2, klazz);
                }
                catch (InvocationTargetException ite) {
                    throw runtime2.newTypeError("could not allocate " + clazz + " with (Ruby, RubyClass) constructor:\n" + ite);
                }
                catch (InstantiationException ie) {
                    throw runtime2.newTypeError("could not allocate " + clazz + " with (Ruby, RubyClass) constructor:\n" + ie);
                }
                catch (IllegalAccessException iae) {
                    throw runtime2.newSecurityError("could not allocate " + clazz + " due to inaccessible (Ruby, RubyClass) constructor:\n" + iae);
                }
            };
            this.reifiedClass = clazz;
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    public void setRubyStaticAllocator(Class<?> clazz) {
        try {
            Method method2 = clazz.getDeclaredMethod("__allocate__", Ruby.class, RubyClass.class);
            this.allocator = (runtime2, klazz) -> {
                try {
                    return (IRubyObject)method2.invoke(null, runtime2, klazz);
                }
                catch (InvocationTargetException ite) {
                    throw runtime2.newTypeError("could not allocate " + clazz + " with (Ruby, RubyClass) constructor:\n" + ite);
                }
                catch (IllegalAccessException iae) {
                    throw runtime2.newSecurityError("could not allocate " + clazz + " due to inaccessible (Ruby, RubyClass) constructor:\n" + iae);
                }
            };
            this.reifiedClass = clazz;
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    @JRubyMethod(name={"allocate"})
    public IRubyObject allocate() {
        if (this.superClass == null && this != this.runtime.getBasicObject()) {
            throw this.runtime.newTypeError("can't instantiate uninitialized class");
        }
        IRubyObject obj = this.allocator.allocate(this.runtime, this);
        if (RubyClass.getMetaClass(obj).getRealClass() != this.getRealClass()) {
            throw this.runtime.newTypeError("wrong instance allocation");
        }
        return obj;
    }

    public CallSite getBaseCallSite(int idx) {
        return this.baseCallSites[idx];
    }

    public CallSite[] getBaseCallSites() {
        return this.baseCallSites;
    }

    public CallSite[] getExtraCallSites() {
        return this.extraCallSites;
    }

    public VariableTableManager getVariableTableManager() {
        return this.variableTableManager;
    }

    public boolean hasObjectID() {
        return this.variableTableManager.hasObjectID();
    }

    public Map<String, VariableAccessor> getVariableAccessorsForRead() {
        return this.variableTableManager.getVariableAccessorsForRead();
    }

    public VariableAccessor getVariableAccessorForWrite(String name2) {
        return this.variableTableManager.getVariableAccessorForWrite(name2);
    }

    public VariableAccessor getVariableAccessorForRead(String name2) {
        VariableAccessor accessor = this.getVariableAccessorsForRead().get(name2);
        if (accessor == null) {
            accessor = VariableAccessor.DUMMY_ACCESSOR;
        }
        return accessor;
    }

    public VariableAccessor getFFIHandleAccessorForRead() {
        return this.variableTableManager.getFFIHandleAccessorForRead();
    }

    public VariableAccessor getFFIHandleAccessorForWrite() {
        return this.variableTableManager.getFFIHandleAccessorForWrite();
    }

    public VariableAccessor getObjectGroupAccessorForRead() {
        return this.variableTableManager.getObjectGroupAccessorForRead();
    }

    public VariableAccessor getObjectGroupAccessorForWrite() {
        return this.variableTableManager.getObjectGroupAccessorForWrite();
    }

    public int getVariableTableSize() {
        return this.variableTableManager.getVariableTableSize();
    }

    public int getVariableTableSizeWithExtras() {
        return this.variableTableManager.getVariableTableSizeWithExtras();
    }

    public String[] getVariableNames() {
        return this.variableTableManager.getVariableNames();
    }

    public Map<String, VariableAccessor> getVariableTableCopy() {
        return new HashMap<String, VariableAccessor>(this.getVariableAccessorsForRead());
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.CLASS;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public static RubyClass createBootstrapClass(Ruby runtime2, String name2, RubyClass superClass, ObjectAllocator allocator) {
        RubyClass obj;
        if (superClass == null) {
            obj = new RubyClass(runtime2);
            obj.marshal = DEFAULT_OBJECT_MARSHAL;
        } else {
            obj = new RubyClass(runtime2, superClass);
        }
        obj.setAllocator(allocator);
        obj.setBaseName(name2);
        return obj;
    }

    protected RubyClass(Ruby runtime2, RubyClass superClass, boolean objectSpace) {
        super(runtime2, runtime2.getClassClass(), objectSpace);
        for (int i2 = 0; i2 < this.baseCallSites.length; ++i2) {
            this.baseCallSites[i2] = MethodIndex.getFunctionalCallSite(CS_NAMES.fromOrdinal((int)i2).id);
        }
        this.cachedDumpMarshal = MarshalTuple.NULL_TUPLE;
        this.cachedLoad = CacheEntry.NULL_CACHE;
        this.runtime = runtime2;
        if (superClass == null) {
            this.realClass = null;
            this.variableTableManager = new VariableTableManager(this);
        } else {
            this.realClass = superClass.realClass;
            this.variableTableManager = this.realClass != null ? this.realClass.variableTableManager : new VariableTableManager(this);
        }
        this.setSuperClass(superClass);
    }

    protected RubyClass(Ruby runtime2) {
        super(runtime2, runtime2.getClassClass());
        for (int i2 = 0; i2 < this.baseCallSites.length; ++i2) {
            this.baseCallSites[i2] = MethodIndex.getFunctionalCallSite(CS_NAMES.fromOrdinal((int)i2).id);
        }
        this.cachedDumpMarshal = MarshalTuple.NULL_TUPLE;
        this.cachedLoad = CacheEntry.NULL_CACHE;
        this.runtime = runtime2;
        this.realClass = this;
        this.variableTableManager = new VariableTableManager(this);
        this.setClassIndex(ClassIndex.CLASS);
    }

    protected RubyClass(Ruby runtime2, RubyClass superClazz) {
        this(runtime2);
        this.setSuperClass(superClazz);
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.allocator = superClazz.allocator;
        this.infectBy(this.superClass);
    }

    protected RubyClass(Ruby runtime2, RubyClass superClazz, CallSite[] extraCallSites) {
        this(runtime2);
        this.setSuperClass(superClazz);
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.extraCallSites = extraCallSites;
        this.infectBy(this.superClass);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass) {
        if (superClass == runtime2.getClassClass()) {
            throw runtime2.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime2.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime2, superClass);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, CallSite[] extraCallSites) {
        if (superClass == runtime2.getClassClass()) {
            throw runtime2.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime2.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime2, superClass, extraCallSites);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, String name2, ObjectAllocator allocator, RubyModule parent, boolean setParent) {
        RubyClass clazz = RubyClass.newClass(runtime2, superClass);
        clazz.setBaseName(name2);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name2, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, String name2, ObjectAllocator allocator, RubyModule parent, boolean setParent, CallSite[] extraCallSites) {
        RubyClass clazz = RubyClass.newClass(runtime2, superClass, extraCallSites);
        clazz.setBaseName(name2);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name2, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    RubyClass toSingletonClass(RubyBasicObject target) {
        return target.makeMetaClass(this);
    }

    static boolean notVisibleAndNotMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return !method2.isCallableFrom(caller2, callType) && !name2.equals("method_missing");
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, Block block) {
        return this.finvokeWithRefinements(context, self2, null, name2, block);
    }

    public IRubyObject finvokeWithRefinements(ThreadContext context, IRubyObject self2, StaticScope staticScope, String name2, Block block) {
        CacheEntry entry = this.searchWithRefinements(name2, staticScope);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        return this.finvokeWithRefinements(context, self2, null, name2, args2, block);
    }

    public IRubyObject finvokeWithRefinements(ThreadContext context, IRubyObject self2, StaticScope staticScope, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithRefinements(name2, staticScope);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, Block block) {
        return this.finvokeWithRefinements(context, self2, null, name2, arg2, block);
    }

    public IRubyObject finvokeWithRefinements(ThreadContext context, IRubyObject self2, StaticScope staticScope, String name2, IRubyObject arg2, Block block) {
        CacheEntry entry = this.searchWithRefinements(name2, staticScope);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.finvokeWithRefinements(context, self2, null, name2, arg0, arg1, block);
    }

    public IRubyObject finvokeWithRefinements(ThreadContext context, IRubyObject self2, StaticScope staticScope, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        CacheEntry entry = this.searchWithRefinements(name2, staticScope);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.finvokeWithRefinements(context, self2, null, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject finvokeWithRefinements(ThreadContext context, IRubyObject self2, StaticScope staticScope, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        CacheEntry entry = this.searchWithRefinements(name2, staticScope);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2);
    }

    public IRubyObject invokePublic(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2) || method2.getVisibility() != Visibility.PUBLIC) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2);
    }

    public final IRubyObject finvokeChecked(ThreadContext context, IRubyObject self2, String name2) {
        return this.checkFuncallDefault(context, self2, name2, IRubyObject.NULL_ARRAY);
    }

    public final IRubyObject finvokeChecked(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites) {
        return this.checkFuncallDefault(context, self2, sites);
    }

    public final IRubyObject finvokeChecked(ThreadContext context, IRubyObject self2, String name2, IRubyObject ... args2) {
        return this.checkFuncallDefault(context, self2, name2, args2);
    }

    public final IRubyObject finvokeChecked(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites, IRubyObject ... args2) {
        return this.checkFuncallDefault(context, self2, sites, args2);
    }

    private IRubyObject checkFuncallDefault(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2) {
        RubyClass klass = this;
        if (!RubyClass.checkFuncallRespondTo(context, klass, self2, name2)) {
            return null;
        }
        DynamicMethod method2 = this.searchMethod(name2);
        if (!RubyClass.checkFuncallCallable(context, method2, CallType.FUNCTIONAL, self2)) {
            return RubyClass.checkFuncallMissing(context, klass, self2, name2, args2);
        }
        return method2.call(context, self2, (RubyModule)klass, name2, args2);
    }

    private IRubyObject checkFuncallDefault(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites, IRubyObject[] args2) {
        RubyClass klass = this;
        if (!RubyClass.checkFuncallRespondTo(context, klass, self2, sites.respond_to_X)) {
            return null;
        }
        CacheEntry entry = sites.site.retrieveCache(klass);
        DynamicMethod method2 = entry.method;
        if (!RubyClass.checkFuncallCallable(context, method2, CallType.FUNCTIONAL, self2)) {
            return RubyClass.checkFuncallMissing(context, klass, self2, sites.methodName, sites.respond_to_missing, sites.method_missing, args2);
        }
        return method2.call(context, self2, entry.sourceModule, sites.methodName, args2);
    }

    private IRubyObject checkFuncallDefault(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites) {
        RubyClass klass = this;
        if (!RubyClass.checkFuncallRespondTo(context, klass, self2, sites.respond_to_X)) {
            return null;
        }
        CacheEntry entry = sites.site.retrieveCache(klass);
        DynamicMethod method2 = entry.method;
        if (!RubyClass.checkFuncallCallable(context, method2, CallType.FUNCTIONAL, self2)) {
            return RubyClass.checkFuncallMissing(context, klass, self2, sites.methodName, sites.respond_to_missing, sites.method_missing, new IRubyObject[0]);
        }
        return method2.call(context, self2, entry.sourceModule, sites.methodName);
    }

    private static IRubyObject checkFuncallExec(ThreadContext context, IRubyObject self2, String name2, IRubyObject ... args2) {
        return self2.callMethod(context, "method_missing", ArraySupport.newCopy(context.runtime.newSymbol(name2), args2));
    }

    private static IRubyObject checkFuncallExec(ThreadContext context, IRubyObject self2, String name2, CallSite methodMissingSite, IRubyObject ... args2) {
        return methodMissingSite.call(context, self2, self2, ArraySupport.newCopy(context.runtime.newSymbol(name2), args2));
    }

    private static IRubyObject checkFuncallFailed(ThreadContext context, IRubyObject self2, String name2, RubyClass expClass, IRubyObject ... args2) {
        if (self2.respondsTo(name2)) {
            throw context.runtime.newRaiseException(expClass, name2);
        }
        return null;
    }

    private static boolean checkFuncallRespondTo(ThreadContext context, RubyClass klass, IRubyObject recv2, String mid) {
        CacheEntry entry = klass.searchWithCache("respond_to?");
        DynamicMethod me = entry.method;
        if (me == null || me.isUndefined() || me.isBuiltin()) {
            return true;
        }
        return me.callRespondTo(context, recv2, "respond_to?", entry.sourceModule, context.runtime.newSymbol(mid));
    }

    private static boolean checkFuncallRespondTo(ThreadContext context, RubyClass klass, IRubyObject recv2, RespondToCallSite respondToSite) {
        Ruby runtime2 = context.runtime;
        DynamicMethod me = respondToSite.retrieveCache((RubyClass)klass).method;
        if (me.isUndefined() || me.isBuiltin()) {
            return true;
        }
        int required = me.getSignature().required();
        if (required > 2) {
            throw runtime2.newArgumentError("respond_to? must accept 1 or 2 arguments (requires " + required + ")");
        }
        if (required == 1) {
            return respondToSite.respondsTo(context, recv2, recv2);
        }
        return respondToSite.respondsTo(context, recv2, recv2, true);
    }

    static boolean checkFuncallCallable(ThreadContext context, DynamicMethod method2, CallType callType, IRubyObject self2) {
        return RubyClass.rbMethodCallStatus(context, method2, callType, self2);
    }

    private static boolean rbMethodCallStatus(ThreadContext context, DynamicMethod method2, CallType callType, IRubyObject self2) {
        return !method2.isUndefined() && method2.isCallableFrom(self2, callType);
    }

    private static IRubyObject checkFuncallMissing(ThreadContext context, RubyClass klass, IRubyObject self2, String method2, IRubyObject ... args2) {
        Ruby runtime2 = context.runtime;
        CacheEntry entry = klass.searchWithCache("respond_to_missing?");
        DynamicMethod me = entry.method;
        if (!(me.isUndefined() || me.isBuiltin() || me.callRespondTo(context, self2, "respond_to_missing?", entry.sourceModule, runtime2.newSymbol(method2)))) {
            return null;
        }
        if (klass.isMethodBuiltin("method_missing")) {
            return null;
        }
        IRubyObject $ex = context.getErrorInfo();
        try {
            return RubyClass.checkFuncallExec(context, self2, method2, args2);
        }
        catch (RaiseException e) {
            context.setErrorInfo($ex);
            return RubyClass.checkFuncallFailed(context, self2, method2, runtime2.getNoMethodError(), args2);
        }
    }

    private static IRubyObject checkFuncallMissing(ThreadContext context, RubyClass klass, IRubyObject self2, String method2, CachingCallSite respondToMissingSite, CachingCallSite methodMissingSite, IRubyObject ... args2) {
        Ruby runtime2 = context.runtime;
        CacheEntry entry = respondToMissingSite.retrieveCache(klass);
        DynamicMethod me = entry.method;
        if (!(me.isUndefined() || me.isBuiltin() || me.callRespondTo(context, self2, "respond_to_missing?", entry.sourceModule, runtime2.newSymbol(method2)))) {
            return null;
        }
        if (methodMissingSite.retrieveCache((RubyClass)klass).method.isBuiltin()) {
            return null;
        }
        IRubyObject $ex = context.getErrorInfo();
        try {
            return RubyClass.checkFuncallExec(context, self2, method2, methodMissingSite, args2);
        }
        catch (RaiseException e) {
            context.setErrorInfo($ex);
            return RubyClass.checkFuncallFailed(context, self2, method2, runtime2.getNoMethodError(), args2);
        }
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, args2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpReifiedClass(String dumpDir, String javaPath, byte[] classBytes) {
        if (dumpDir != null) {
            if (dumpDir.length() == 0) {
                dumpDir = ".";
            }
            FileOutputStream classStream = null;
            try {
                File classFile = new File(dumpDir, javaPath + ".class");
                classFile.getParentFile().mkdirs();
                classStream = new FileOutputStream(classFile);
                classStream.write(classBytes);
            }
            catch (IOException io2) {
                this.runtime.getWarnings().warn("unable to dump class file: " + io2.getMessage());
            }
            finally {
                if (classStream != null) {
                    try {
                        classStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void generateMethodAnnotations(Map<Class<?>, Map<String, Object>> methodAnnos, SkinnyMethodAdapter m, List<Map<Class<?>, Map<String, Object>>> parameterAnnos) {
        if (methodAnnos != null && methodAnnos.size() != 0) {
            for (Map.Entry<Class<?>, Map<String, Object>> entry : methodAnnos.entrySet()) {
                m.visitAnnotationWithFields(CodegenUtils.ci(entry.getKey()), true, entry.getValue());
            }
        }
        if (parameterAnnos != null && parameterAnnos.size() != 0) {
            for (int i2 = 0; i2 < parameterAnnos.size(); ++i2) {
                Map<Class<?>, Map<String, Object>> annos = parameterAnnos.get(i2);
                if (annos == null || annos.size() == 0) continue;
                for (Map.Entry<Class<?>, Map<String, Object>> entry : annos.entrySet()) {
                    m.visitParameterAnnotationWithFields(i2, CodegenUtils.ci(entry.getKey()), true, entry.getValue());
                }
            }
        }
    }

    private static boolean shouldCallMethodMissing(DynamicMethod method2) {
        return method2.isUndefined();
    }

    private static boolean shouldCallMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return method2.isUndefined() || RubyClass.notVisibleAndNotMethodMissing(method2, name2, caller2, callType);
    }

    public IRubyObject invokeInherited(ThreadContext context, IRubyObject self2, IRubyObject subclass) {
        CacheEntry entry = this.metaClass.searchWithCache("inherited");
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), "inherited", CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, "inherited", subclass, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"new"})
    public IRubyObject newInstance(ThreadContext context, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, block);
        return obj;
    }

    @JRubyMethod(name={"new"})
    public IRubyObject newInstance(ThreadContext context, IRubyObject arg0, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, arg0, block);
        return obj;
    }

    @JRubyMethod(name={"new"})
    public IRubyObject newInstance(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, arg0, arg1, block);
        return obj;
    }

    @JRubyMethod(name={"new"})
    public IRubyObject newInstance(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, arg0, arg1, arg2, block);
        return obj;
    }

    @JRubyMethod(name={"new"}, rest=true)
    public IRubyObject newInstance(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, args2, block);
        return obj;
    }

    @Override
    public IRubyObject initialize(ThreadContext context, Block block) {
        return this.initialize19(context, block);
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject superObject, Block block) {
        return this.initialize19(context, superObject, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, Block block) {
        this.checkNotInitialized();
        return this.initializeCommon(context, this.runtime.getObject(), block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, IRubyObject superObject, Block block) {
        this.checkNotInitialized();
        RubyClass.checkInheritable(superObject);
        return this.initializeCommon(context, (RubyClass)superObject, block);
    }

    private RubyClass initializeCommon(ThreadContext context, RubyClass superClazz, Block block) {
        this.setSuperClass(superClazz);
        this.allocator = superClazz.allocator;
        this.makeMetaClass(superClazz.getMetaClass());
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.inherit(superClazz);
        super.initialize(context, block);
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        this.checkNotInitialized();
        if (original instanceof MetaClass) {
            throw this.runtime.newTypeError("can't copy singleton class");
        }
        super.initialize_copy(original);
        RubyClass originalClazz = (RubyClass)original;
        this.allocator = originalClazz.allocator;
        JavaClassConfiguration javaClassConfiguration = this.javaClassConfiguration = originalClazz.javaClassConfiguration == null ? null : originalClazz.javaClassConfiguration.clone();
        if (originalClazz.getJavaProxy() && originalClazz.reifiedClass != null && !Reified.class.isAssignableFrom(originalClazz.reifiedClass)) {
            this.reifiedClass = originalClazz.reifiedClass;
            this.reifiedClassJava = originalClazz.reifiedClassJava;
        }
        return this;
    }

    protected void setModuleSuperClass(RubyClass superClass) {
        if (this.superClass != null) {
            this.superClass.removeSubclass(this);
        }
        superClass.addSubclass(this);
        this.setSuperClass(superClass);
    }

    public final Collection<RubyClass> subclasses() {
        return this.subclasses(false);
    }

    public Collection<RubyClass> subclasses(boolean includeDescendants) {
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 != null) {
            ArrayList<RubyClass> mine = new ArrayList<RubyClass>();
            this.subclassesInner(mine, includeDescendants);
            return mine;
        }
        return Collections.EMPTY_LIST;
    }

    private void subclassesInner(Collection<RubyClass> mine, boolean includeDescendants) {
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 != null) {
            Set<RubyClass> keys2 = subclasses2.keySet();
            mine.addAll(keys2);
            if (includeDescendants) {
                for (RubyClass klass : keys2) {
                    klass.subclassesInner(mine, includeDescendants);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubclass(RubyClass subclass) {
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 == null) {
            RubyClass rubyClass = this;
            synchronized (rubyClass) {
                subclasses2 = this.subclasses;
                if (subclasses2 == null) {
                    this.subclasses = subclasses2 = new ConcurrentWeakHashMap<RubyClass, Object>(4, 0.75f, 1);
                }
            }
        }
        subclasses2.put(subclass, NEVER);
    }

    public void removeSubclass(RubyClass subclass) {
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 == null) {
            return;
        }
        subclasses2.remove(subclass);
    }

    public void replaceSubclass(RubyClass subclass, RubyClass newSubclass) {
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 == null) {
            return;
        }
        subclasses2.remove(subclass);
        subclasses2.put(newSubclass, NEVER);
    }

    @Override
    public void becomeSynchronized() {
        super.becomeSynchronized();
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 != null) {
            for (RubyClass subclass : subclasses2.keySet()) {
                subclass.becomeSynchronized();
            }
        }
    }

    @Override
    public void invalidateCacheDescendants() {
        super.invalidateCacheDescendants();
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 != null) {
            for (RubyClass subclass : subclasses2.keySet()) {
                subclass.invalidateCacheDescendants();
            }
        }
    }

    public void addInvalidatorsAndFlush(List<Invalidator> invalidators) {
        Map<RubyClass, Object> subclasses2;
        invalidators.add(this.methodInvalidator);
        if (!this.runtime.isBootingCore()) {
            this.cachedMethods.clear();
        }
        if ((subclasses2 = this.subclasses) == null || subclasses2.isEmpty()) {
            return;
        }
        for (RubyClass subclass : subclasses2.keySet()) {
            subclass.addInvalidatorsAndFlush(invalidators);
        }
    }

    public final Ruby getClassRuntime() {
        return this.runtime;
    }

    public final RubyClass getRealClass() {
        return this.realClass;
    }

    @Override
    public RubyModule getRealModule() {
        return this.getRealClass();
    }

    @JRubyMethod(name={"inherited"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject inherited(ThreadContext context, IRubyObject arg2) {
        return context.nil;
    }

    public void inherit(RubyClass superClazz) {
        if (superClazz == null) {
            superClazz = this.runtime.getObject();
        }
        if (this.runtime.getNil() != null) {
            superClazz.invokeInherited(this.runtime.getCurrentContext(), superClazz, this);
        }
    }

    @JRubyMethod(name={"superclass"})
    public IRubyObject superclass(ThreadContext context) {
        RubyClass superClazz = this.superClass;
        if (superClazz == null) {
            if (this.metaClass == this.runtime.getBasicObject().metaClass) {
                return context.nil;
            }
            throw this.runtime.newTypeError("uninitialized class");
        }
        while (superClazz != null && (superClazz.isIncluded() || superClazz.isPrepended())) {
            superClazz = superClazz.superClass;
        }
        return superClazz != null ? superClazz : context.nil;
    }

    private void checkNotInitialized() {
        if (this.superClass != null || this == this.runtime.getBasicObject()) {
            throw this.runtime.newTypeError("already initialized class");
        }
    }

    public static void checkInheritable(IRubyObject superClass) {
        if (!(superClass instanceof RubyClass)) {
            throw superClass.getRuntime().newTypeError("superclass must be a Class (" + superClass.getMetaClass() + " given)");
        }
        if (((RubyClass)superClass).isSingleton()) {
            throw superClass.getRuntime().newTypeError("can't make subclass of virtual class");
        }
        if (superClass == superClass.getRuntime().getClassClass()) {
            throw superClass.getRuntime().newTypeError("can't make subclass of Class");
        }
    }

    public final ObjectMarshal getMarshal() {
        return this.marshal;
    }

    public final void setMarshal(ObjectMarshal marshal) {
        this.marshal = marshal;
    }

    public final void marshal(Object obj, MarshalStream marshalStream) throws IOException {
        this.getMarshal().marshalTo(this.runtime, obj, this, marshalStream);
    }

    public final Object unmarshal(UnmarshalStream unmarshalStream) throws IOException {
        return this.getMarshal().unmarshalFrom(this.runtime, this, unmarshalStream);
    }

    public static void marshalTo(RubyClass clazz, MarshalStream output) throws IOException {
        output.registerLinkTarget(clazz);
        output.writeString(MarshalStream.getPathFromClass(clazz));
    }

    public static RubyClass unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        RubyClass result2 = UnmarshalStream.getClassFromPath(input.getRuntime(), name2);
        input.registerLinkTarget(result2);
        return result2;
    }

    public boolean isReifiable(boolean[] java2) {
        RubyClass realSuper;
        if (this.reifiedClass != null) {
            return false;
        }
        if (this.superClass == null || (realSuper = this.superClass.getRealClass()) == null) {
            return false;
        }
        Class<? extends Reified> reifiedSuper = realSuper.reifiedClass;
        if (reifiedSuper != null) {
            boolean result2;
            boolean bl = result2 = reifiedSuper == RubyObject.class || reifiedSuper == RubyBasicObject.class || Reified.class.isAssignableFrom(reifiedSuper);
            if (!result2 || ReifiedJavaProxy.class.isAssignableFrom(reifiedSuper)) {
                java2[0] = true;
            }
            return true;
        }
        return realSuper.isReifiable(java2);
    }

    public void reifyWithAncestors() {
        this.reifyWithAncestors(null, true);
    }

    public void reifyWithAncestors(String classDumpDir) {
        this.reifyWithAncestors(classDumpDir, true);
    }

    public void reifyWithAncestors(boolean useChildLoader) {
        this.reifyWithAncestors(null, useChildLoader);
    }

    public void reifyWithAncestors(String classDumpDir, boolean useChildLoader) {
        boolean[] box = new boolean[]{false};
        if (this.isReifiable(box)) {
            RubyClass realSuper = this.getSuperClass().getRealClass();
            if (realSuper.reifiedClass == null) {
                realSuper.reifyWithAncestors(classDumpDir, useChildLoader);
            }
            this.reify(classDumpDir, useChildLoader);
        }
    }

    public final void reify() {
        this.reify(null, true);
    }

    public final void reify(String classDumpDir) {
        this.reify(classDumpDir, true);
    }

    public final void reify(boolean useChildLoader) {
        this.reify(null, useChildLoader);
    }

    public synchronized void reify(String classDumpDir, boolean useChildLoader) {
        ClassLoader parentCL;
        boolean[] java_box = new boolean[]{false};
        if (!this.isReifiable(java_box)) {
            return;
        }
        boolean concreteExt = java_box[0];
        String name2 = this.getBaseName() != null ? this.getName() : "Class_0x" + Integer.toHexString(System.identityHashCode(this));
        String javaName = "rubyobj." + StringSupport.replaceAll(name2, "::", ".");
        String javaPath = "rubyobj/" + StringSupport.replaceAll(name2, "::", "/");
        Class<? extends Reified> parentReified = this.superClass.getRealClass().getReifiedClass();
        if (parentReified == null) {
            throw this.getClassRuntime().newTypeError(this.getName() + "'s parent class is not yet reified");
        }
        Class reifiedParent = RubyObject.class;
        if (this.superClass.reifiedClass != null) {
            reifiedParent = this.superClass.reifiedClass;
        }
        MethodReificator reifier = concreteExt ? new ConcreteJavaReifier(parentReified, javaName, javaPath) : new MethodReificator(reifiedParent, javaName, javaPath, null, javaPath);
        byte[] classBytes = reifier.reify();
        if (parentReified.getClassLoader() instanceof OneShotClassLoader) {
            parentCL = (OneShotClassLoader)parentReified.getClassLoader();
        } else if (useChildLoader) {
            MultiClassLoader parentLoader = new MultiClassLoader(this.runtime.getJRubyClassLoader());
            for (Loader cLoader : this.runtime.getInstanceConfig().getExtraLoaders()) {
                parentLoader.addClassLoader(cLoader.getClassLoader());
            }
            parentCL = new OneShotClassLoader(parentLoader);
        } else {
            parentCL = this.runtime.getJRubyClassLoader();
        }
        boolean nearEnd = false;
        try {
            Class<?> result2 = parentCL.defineClass(javaName, classBytes);
            this.dumpReifiedClass(classDumpDir, javaPath, classBytes);
            Field rt = result2.getDeclaredField("ruby");
            rt.setAccessible(true);
            if (rt.get(null) != this.runtime) {
                throw new RuntimeException("No ruby field set!");
            }
            if (concreteExt) {
                this.setInstanceVariable("@java_class", Java.wrapJavaObject(this.runtime, result2));
                JavaProxy.setJavaClass(this, result2);
                this.reifiedClassJava = Boolean.TRUE;
            } else {
                this.setRubyClassAllocator(result2);
                this.reifiedClassJava = Boolean.FALSE;
            }
            this.reifiedClass = result2;
            nearEnd = true;
            JavaProxyClass.ensureStaticIntConsumed();
            if (this.javaClassConfiguration.requestedStorageVariables != null) {
                this.javaClassConfiguration.requestedStorageVariables.forEach(this.variableTableManager::requestFieldStorage);
            }
            return;
        }
        catch (LinkageError error2) {
            JavaProxyClass.addStaticInitLookup(null);
            String msg = error2.getMessage();
            if (msg != null && msg.contains("duplicate class definition for name")) {
                this.logReifyException(error2, false);
            } else {
                this.logReifyException(error2, true);
            }
        }
        catch (Exception ex) {
            if (nearEnd) {
                throw (RuntimeException)ex;
            }
            JavaProxyClass.addStaticInitLookup(null);
            this.logReifyException(ex, true);
        }
        if (this.superClass.reifiedClass != null) {
            this.reifiedClass = this.superClass.reifiedClass;
            this.allocator = this.superClass.allocator;
        }
    }

    public PositionAware getPositionOrDefault(DynamicMethod method2) {
        if (method2 instanceof PositionAware) {
            PositionAware pos2 = (PositionAware)((Object)method2);
            return new SimpleSourcePosition(pos2.getFile(), pos2.getLine() + 1);
        }
        return defaultSimplePosition;
    }

    private boolean isVarArgsSignature(String method2, Class[] methodSignature) {
        return methodSignature.length > 1 && methodSignature[methodSignature.length - 1].isArray();
    }

    private void logReifyException(Throwable failure, boolean error2) {
        if (RubyInstanceConfig.REIFY_LOG_ERRORS) {
            if (error2) {
                LOG.error("failed to reify class " + this.getName() + " due to: ", failure);
            } else {
                LOG.info("failed to reify class " + this.getName() + " due to: ", failure);
            }
        }
    }

    public void setReifiedClass(Class<? extends IRubyObject> reifiedClass) {
        this.reifiedClass = reifiedClass;
    }

    public Class<? extends Reified> getReifiedClass() {
        return this.reifiedClass;
    }

    public Class<? extends IRubyObject> getReifiedRubyClass() {
        if (this.reifiedClassJava == Boolean.TRUE) {
            throw this.runtime.newTypeError("Attempted to get a Ruby class for a Java class");
        }
        return this.reifiedClass;
    }

    public Class<? extends ReifiedJavaProxy> getReifiedJavaClass() {
        if (this.reifiedClassJava == Boolean.FALSE) {
            throw this.runtime.newTypeError("Attempted to get a Java class for a Ruby class");
        }
        return this.reifiedClass;
    }

    public Boolean getIsReifiedExtendedJavaClass() {
        return this.reifiedClassJava;
    }

    public static Class<?> nearestReifiedClass(RubyClass klass) {
        RubyClass current2 = klass;
        do {
            Class<? extends Reified> reified;
            if ((reified = current2.getReifiedClass()) == null) continue;
            return reified;
        } while ((current2 = current2.getSuperClass()) != null);
        return null;
    }

    public Map<String, List<Map<Class<?>, Map<String, Object>>>> getParameterAnnotations() {
        if (this.javaClassConfiguration == null || this.getClassConfig().parameterAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.javaClassConfiguration.parameterAnnotations;
    }

    public synchronized void addParameterAnnotation(String method2, int i2, Class<?> annoClass, Map<String, Object> value2) {
        List<Map<Class<?>, Map<String, Object>>> paramList;
        if (this.getClassConfig().parameterAnnotations == null) {
            this.javaClassConfiguration.parameterAnnotations = new HashMap(8);
        }
        if ((paramList = this.javaClassConfiguration.parameterAnnotations.get(method2)) == null) {
            paramList = new ArrayList(i2 + 1);
            this.javaClassConfiguration.parameterAnnotations.put(method2, paramList);
        }
        if (paramList.size() < i2 + 1) {
            for (int j = paramList.size(); j < i2 + 1; ++j) {
                paramList.add(null);
            }
        }
        if (annoClass != null && value2 != null) {
            Map<Class<?>, Map<String, Object>> annos = paramList.get(i2);
            if (annos == null) {
                annos = new LinkedHashMap(4);
                paramList.set(i2, annos);
            }
            annos.put(annoClass, value2);
        } else {
            paramList.set(i2, null);
        }
    }

    public Map<String, Map<Class<?>, Map<String, Object>>> getMethodAnnotations() {
        if (this.javaClassConfiguration == null || this.getClassConfig().methodAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.javaClassConfiguration.methodAnnotations;
    }

    public Map<String, Map<Class<?>, Map<String, Object>>> getFieldAnnotations() {
        if (this.javaClassConfiguration == null || this.getClassConfig().fieldAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.javaClassConfiguration.fieldAnnotations;
    }

    public synchronized void addMethodAnnotation(String methodName, Class<?> annotation2, Map fields2) {
        Map<Class<?>, Map<String, Object>> annos;
        if (this.getClassConfig().methodAnnotations == null) {
            this.javaClassConfiguration.methodAnnotations = new HashMap(8);
        }
        if ((annos = this.javaClassConfiguration.methodAnnotations.get(methodName)) == null) {
            annos = new LinkedHashMap(4);
            this.javaClassConfiguration.methodAnnotations.put(methodName, annos);
        }
        annos.put(annotation2, fields2);
    }

    public synchronized void addFieldAnnotation(String fieldName, Class<?> annotation2, Map fields2) {
        Map<Class<?>, Map<String, Object>> annos;
        if (this.getClassConfig().fieldAnnotations == null) {
            this.javaClassConfiguration.fieldAnnotations = new HashMap(8);
        }
        if ((annos = this.javaClassConfiguration.fieldAnnotations.get(fieldName)) == null) {
            annos = new LinkedHashMap(4);
            this.javaClassConfiguration.fieldAnnotations.put(fieldName, annos);
        }
        annos.put(annotation2, fields2);
    }

    public Map<String, Class<?>[]> getMethodSignatures() {
        if (this.javaClassConfiguration == null || this.getClassConfig().methodSignatures == null) {
            return Collections.EMPTY_MAP;
        }
        return this.javaClassConfiguration.methodSignatures.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Class[])((List)e.getValue()).get(0)));
    }

    public Map<String, List<Class<?>[]>> getAllMethodSignatures() {
        if (this.javaClassConfiguration == null || this.getClassConfig().methodSignatures == null) {
            return Collections.EMPTY_MAP;
        }
        return this.javaClassConfiguration.methodSignatures;
    }

    public Map<String, Class<?>> getFieldSignatures() {
        if (this.javaClassConfiguration == null || this.getClassConfig().fieldSignatures == null) {
            return Collections.EMPTY_MAP;
        }
        return this.javaClassConfiguration.fieldSignatures;
    }

    public synchronized void addMethodSignature(String methodName, Class<?>[] types) {
        List<Class<?>[]> annos;
        if (this.getClassConfig().methodSignatures == null) {
            this.javaClassConfiguration.methodSignatures = new HashMap<String, List<Class<?>[]>>(16);
        }
        if ((annos = this.javaClassConfiguration.methodSignatures.get(methodName)) == null) {
            annos = new ArrayList<Class<?>[]>(4);
            this.javaClassConfiguration.methodSignatures.put(methodName, annos);
        }
        annos.add(types);
    }

    public synchronized void addFieldSignature(String fieldName, Class<?> type2) {
        if (this.getClassConfig().fieldSignatures == null) {
            this.javaClassConfiguration.fieldSignatures = new LinkedHashMap(8);
        }
        this.javaClassConfiguration.fieldSignatures.put(fieldName, type2);
    }

    public Map<Class<?>, Map<String, Object>> getClassAnnotations() {
        if (this.javaClassConfiguration == null || this.getClassConfig().classAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.javaClassConfiguration.classAnnotations;
    }

    public synchronized void addClassAnnotation(Class<?> annotation2, Map fields2) {
        if (this.getClassConfig().classAnnotations == null) {
            this.javaClassConfiguration.classAnnotations = new LinkedHashMap(4);
        }
        this.javaClassConfiguration.classAnnotations.put(annotation2, fields2);
    }

    public synchronized JavaClassConfiguration getClassConfig() {
        if (this.javaClassConfiguration == null) {
            this.javaClassConfiguration = new JavaClassConfiguration();
        }
        return this.javaClassConfiguration;
    }

    public synchronized void setClassConfig(JavaClassConfiguration jcc) {
        this.javaClassConfiguration = jcc;
    }

    @Override
    public <T> T toJava(Class<T> target) {
        if (target == Class.class) {
            ThreadContext context;
            Class<?> javaClass;
            if (this.reifiedClass == null) {
                this.reifyWithAncestors();
            }
            if ((javaClass = JavaClass.getJavaClassIfProxy(context = this.runtime.getCurrentContext(), this)) != null) {
                return (T)javaClass;
            }
            Class<?> reifiedClass = RubyClass.nearestReifiedClass(this);
            if (reifiedClass != null) {
                return target.cast(reifiedClass);
            }
        }
        if (target.isAssignableFrom(RubyClass.class)) {
            return target.cast(this);
        }
        return this.defaultToJava(target);
    }

    public void smartDump(MarshalStream stream, IRubyObject target) throws IOException {
        MarshalTuple tuple = this.cachedDumpMarshal;
        if (tuple.generation != this.generation) {
            CacheEntry entry = this.searchWithCache("respond_to?");
            DynamicMethod method2 = entry.method;
            if (!method2.equals(this.runtime.getRespondToMethod()) && !method2.isUndefined()) {
                tuple = this.cachedDumpMarshal = new MarshalTuple(null, MarshalType.DEFAULT_SLOW, this.generation);
            } else {
                entry = this.searchWithCache("marshal_dump");
                if (!entry.method.isUndefined()) {
                    tuple = this.cachedDumpMarshal = new MarshalTuple(entry, MarshalType.NEW_USER, this.generation);
                } else {
                    entry = this.searchWithCache("_dump");
                    tuple = !entry.method.isUndefined() ? (this.cachedDumpMarshal = new MarshalTuple(entry, MarshalType.OLD_USER, this.generation)) : (this.cachedDumpMarshal = new MarshalTuple(null, MarshalType.DEFAULT, this.generation));
                }
            }
        }
        tuple.dump(stream, target);
    }

    public IRubyObject smartLoadNewUser(IRubyObject target, IRubyObject data2) {
        ThreadContext context = this.runtime.getCurrentContext();
        CacheEntry cache = this.cachedLoad;
        if (cache.token == this.generation) {
            cache.method.call(context, target, cache.sourceModule, "marshal_load", data2);
            return target;
        }
        cache = this.searchWithCache("respond_to?");
        DynamicMethod method2 = cache.method;
        if (!method2.equals(this.runtime.getRespondToMethod()) && !method2.isUndefined()) {
            if (method2.call(context, target, cache.sourceModule, "respond_to?", this.runtime.newSymbol("marshal_load")).isTrue()) {
                target.callMethod(context, "marshal_load", data2);
                return target;
            }
            throw this.runtime.newTypeError(RubyStringBuilder.str(this.runtime, "class ", RubyStringBuilder.types(this.runtime, (RubyModule)this), " needs to have method `marshal_load'"));
        }
        cache = this.searchWithCache("marshal_load");
        if (!cache.method.isUndefined()) {
            this.cachedLoad = cache;
            cache.method.call(context, target, cache.sourceModule, "marshal_load", data2);
            return target;
        }
        target.callMethod(context, "marshal_load", data2);
        return target;
    }

    public IRubyObject smartLoadOldUser(IRubyObject data2) {
        ThreadContext context = this.runtime.getCurrentContext();
        CacheEntry cache = this.getSingletonClass().cachedLoad;
        if (cache.token == this.getSingletonClass().generation) {
            return cache.method.call(context, (IRubyObject)this, cache.sourceModule, "_load", data2);
        }
        cache = this.getSingletonClass().searchWithCache("respond_to?");
        DynamicMethod method2 = cache.method;
        if (!method2.equals(this.runtime.getRespondToMethod()) && !method2.isUndefined()) {
            if (method2.call(context, (IRubyObject)this, cache.sourceModule, "respond_to?", this.runtime.newSymbol("_load")).isTrue()) {
                return this.callMethod(context, "_load", data2);
            }
            throw this.runtime.newTypeError(RubyStringBuilder.str(this.runtime, "class ", RubyStringBuilder.types(this.runtime, (RubyModule)this), " needs to have method `_load'"));
        }
        cache = this.getSingletonClass().searchWithCache("_load");
        if (!cache.method.isUndefined()) {
            this.getSingletonClass().cachedLoad = cache;
            return cache.method.call(context, (IRubyObject)this, cache.sourceModule, "_load", data2);
        }
        throw this.runtime.newTypeError(RubyStringBuilder.str(this.runtime, "class ", RubyStringBuilder.types(this.runtime, (RubyModule)this), " needs to have method `_load'"));
    }

    @Deprecated
    public IRubyObject invoke(ThreadContext context, IRubyObject self2, int methodIndex, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return this.invoke(context, self2, name2, args2, callType, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, CallType callType, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, CallType callType, Block block) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, CallType callType, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, CallType callType) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, CallType callType) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, args2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, CallType callType) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2);
    }

    @Deprecated
    public VariableAccessorField getObjectIdAccessorField() {
        return this.variableTableManager.getObjectIdAccessorField();
    }

    @Deprecated
    public VariableAccessorField getFFIHandleAccessorField() {
        return this.variableTableManager.getFFIHandleAccessorField();
    }

    @Deprecated
    public VariableAccessorField getObjectGroupAccessorField() {
        return this.variableTableManager.getObjectGroupAccessorField();
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, block);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg2, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2, block);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject[] args2) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, args2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (RubyClass.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2);
    }

    public static enum CS_NAMES {
        INITIALIZE("initialize");

        private static final CS_NAMES[] VALUES;
        public static final int length;
        public final String id;

        private CS_NAMES(String id2) {
            this.id = id2;
        }

        public static CS_NAMES fromOrdinal(int ordinal2) {
            if (ordinal2 < 0 || ordinal2 >= VALUES.length) {
                throw new RuntimeException("invalid rest: " + ordinal2);
            }
            return VALUES[ordinal2];
        }

        static {
            VALUES = CS_NAMES.values();
            length = VALUES.length;
        }
    }

    private static class MarshalTuple {
        public static final MarshalTuple NULL_TUPLE = new MarshalTuple(null, null, 0);
        public final CacheEntry entry;
        public final MarshalType type;
        public final int generation;

        public MarshalTuple(CacheEntry entry, MarshalType type2, int generation) {
            this.entry = entry;
            this.type = type2;
            this.generation = generation;
        }

        public void dump(MarshalStream stream, IRubyObject object) throws IOException {
            switch (this.type) {
                case DEFAULT: {
                    stream.writeDirectly(object);
                    return;
                }
                case NEW_USER: {
                    stream.userNewMarshal(object, this.entry);
                    return;
                }
                case OLD_USER: {
                    stream.userMarshal(object, this.entry);
                    return;
                }
                case DEFAULT_SLOW: {
                    if (object.respondsTo("marshal_dump")) {
                        stream.userNewMarshal(object);
                    } else if (object.respondsTo("_dump")) {
                        stream.userMarshal(object);
                    } else {
                        stream.writeDirectly(object);
                    }
                    return;
                }
            }
        }
    }

    private static enum MarshalType {
        DEFAULT,
        NEW_USER,
        OLD_USER,
        DEFAULT_SLOW,
        NEW_USER_SLOW,
        USER_SLOW;

    }

    public class ConcreteJavaReifier
    extends MethodReificator {
        public static final String RUBY_OBJECT_FIELD = "this$rubyObject";
        protected static final String RUBY_PROXY_CLASS_FIELD = "this$rubyProxyClass";
        public static final String RUBY_CTOR_CACHE_FIELD = "this$rubyCtorCache";
        JavaConstructor[] savedSuperCtors;
        Map<String, List<String>> supers;

        ConcreteJavaReifier(Class<?> reifiedParent, String javaName, String javaPath) {
            super(reifiedParent, javaName, javaPath, CodegenUtils.ci(ConcreteJavaProxy.class), CodegenUtils.p(ConcreteJavaProxy.class));
            this.savedSuperCtors = null;
            this.supers = new HashMap<String, List<String>>();
        }

        @Override
        public void customReify() {
            super.customReify();
            this.defineInterfaceMethods();
        }

        @Override
        protected void loadRubyObject(SkinnyMethodAdapter m) {
            m.aload(0);
            m.getfield(this.javaPath, RUBY_OBJECT_FIELD, this.rubyName);
        }

        @Override
        public byte[] reify() {
            this.cw.visitField(4114, RUBY_OBJECT_FIELD, this.rubyName, null, null);
            this.cw.visitField(4122, RUBY_PROXY_CLASS_FIELD, CodegenUtils.ci(JavaProxyClass.class), null, null);
            this.cw.visitField(4122, RUBY_CTOR_CACHE_FIELD, CodegenUtils.ci(Java.JCtorCache.class), null, null);
            return super.reify();
        }

        @Override
        protected boolean isRubyObject() {
            return false;
        }

        @Override
        protected Object[] getExtraClinitInfo() {
            return new Object[]{RubyClass.this.runtime, RubyClass.this, this.savedSuperCtors};
        }

        @Override
        protected void extraClinitLookup(SkinnyMethodAdapter m) {
            m.newobj(CodegenUtils.p(Java.JCtorCache.class));
            m.dup_x1();
            m.swap();
            m.pushInt(2);
            m.aaload();
            m.checkcast(CodegenUtils.p(JavaConstructor[].class));
            m.invokespecial(CodegenUtils.p(Java.JCtorCache.class), "<init>", CodegenUtils.sig(Void.TYPE, JavaConstructor[].class));
            m.putstatic(this.javaPath, RUBY_CTOR_CACHE_FIELD, CodegenUtils.ci(Java.JCtorCache.class));
            m.getstatic(this.javaPath, "ruby", CodegenUtils.ci(Ruby.class));
            m.getstatic(this.javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
            m.ldc(Type.getType((String)("L" + this.javaPath + ";")));
            m.iconst_1();
            m.invokestatic(CodegenUtils.p(JavaProxyClass.class), "setProxyClassReified", CodegenUtils.sig(JavaProxyClass.class, Ruby.class, RubyClass.class, Class.class, Boolean.TYPE));
            m.dup();
            m.putstatic(this.javaPath, RUBY_PROXY_CLASS_FIELD, CodegenUtils.ci(JavaProxyClass.class));
            this.supers.forEach((name2, sigs) -> {
                for (String sig : sigs) {
                    m.dup();
                    m.ldc(name2);
                    m.ldc(sig);
                    m.iconst_1();
                    m.invokevirtual(CodegenUtils.p(JavaProxyClass.class), "initMethod", CodegenUtils.sig(Void.TYPE, String.class, String.class, Boolean.TYPE));
                }
            });
            m.pop();
        }

        @Override
        protected void generateSuperBridges(String javaMethodName, Class<?>[] methodSignature) {
            Object[] args2 = new Class[methodSignature.length - 1];
            ArraySupport.copy(methodSignature, 1, args2, 0, methodSignature.length - 1);
            Method supr = this.findTarget(this.reifiedParent, javaMethodName, methodSignature[0], (Class<?>[])args2);
            if (supr == null) {
                return;
            }
            SkinnyMethodAdapter m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 4161, JavaProxyClass.generateSuperName(this.javaName, javaMethodName), CodegenUtils.sig(methodSignature), null, null);
            GeneratorAdapter ga = RealClassGenerator.makeGenerator(m);
            ga.loadThis();
            ga.loadArgs();
            m.invokespecial(CodegenUtils.p(this.reifiedParent), javaMethodName, CodegenUtils.sig(methodSignature));
            ga.returnValue();
            ga.endMethod();
            if (!this.supers.containsKey(javaMethodName)) {
                this.supers.put(javaMethodName, new ArrayList());
            }
            this.supers.get(javaMethodName).add(CodegenUtils.sig(methodSignature));
        }

        private Method findTarget(Class<?> clz, String javaMethodName, Class<?> returns, Class<?>[] params2) {
            for (Method method2 : clz.getDeclaredMethods()) {
                int mod;
                if (!method2.getName().equals(javaMethodName) || !Modifier.isPublic(mod = method2.getModifiers()) && !Modifier.isProtected(mod) || Modifier.isAbstract(mod) || Modifier.isFinal(mod) || !method2.getReturnType().equals(returns) || !Arrays.equals(method2.getParameterTypes(), params2)) continue;
                return method2;
            }
            if (clz.getSuperclass() != null) {
                return this.findTarget(clz.getSuperclass(), javaMethodName, returns, params2);
            }
            return null;
        }

        @Override
        protected Collection<Class<?>[]> searchInheritedSignatures(String id2, Signature arity2) {
            HashMap<String, Class<?>[]> types = new HashMap<String, Class<?>[]>();
            this.searchClassMethods(this.reifiedParent, arity2, id2, types);
            for (Class intf : Java.getInterfacesFromRubyClass(RubyClass.this)) {
                this.searchClassMethods(intf, arity2, id2, types);
            }
            if (types.isEmpty()) {
                this.searchClassMethods(this.reifiedParent, null, id2, types);
                for (Class intf : Java.getInterfacesFromRubyClass(RubyClass.this)) {
                    this.searchClassMethods(intf, null, id2, types);
                }
            }
            if (types.isEmpty()) {
                types.put("", null);
            }
            return types.values();
        }

        @Override
        protected void reifyConstructors() {
            ArrayList<JavaConstructor> savedCtorsList;
            Optional<Object> zeroArg = Optional.empty();
            ArrayList candidates = new ArrayList();
            for (Constructor<?> constructor2 : this.reifiedParent.getDeclaredConstructors()) {
                int mod = constructor2.getModifiers();
                if (!Modifier.isPublic(mod) && !Modifier.isProtected(mod)) continue;
                candidates.add(constructor2);
                if (constructor2.getParameterCount() != 0) continue;
                zeroArg = Optional.of(constructor2);
            }
            boolean isNestedRuby = ReifiedJavaProxy.class.isAssignableFrom(this.reifiedParent);
            DynamicMethod methodEntry = RubyClass.this.searchMethod(this.jcc.javaCtorMethodName);
            PositionAware position = RubyClass.this.getPositionOrDefault(methodEntry);
            this.cw.visitSource(position.getFile(), null);
            int superpos = ConcreteJavaProxy.findSuperLine(RubyClass.this.runtime, methodEntry, position.getLine());
            HashSet<String> generatedCtors = new HashSet<String>();
            if (candidates.size() > 0) {
                savedCtorsList = new ArrayList<JavaConstructor>(candidates.size());
                for (Constructor constructor2 : candidates) {
                    savedCtorsList.add(new JavaConstructor(RubyClass.this.runtime, constructor2));
                }
            } else {
                throw RubyClass.this.runtime.newTypeError("class " + this.reifiedParent.getName() + " doesn't have a public or protected constructor");
            }
            this.savedSuperCtors = savedCtorsList.toArray(new JavaConstructor[savedCtorsList.size()]);
            if (zeroArg.isPresent() && !this.jcc.allCtors) {
                if (!isNestedRuby) {
                    generatedCtors.add(RealClassGenerator.makeConcreteConstructorProxy(this.cw, position, true, this, new Class[0], isNestedRuby));
                }
                if (this.jcc.javaConstructable) {
                    generatedCtors.add(RealClassGenerator.makeConcreteConstructorProxy(this.cw, position, false, this, new Class[0], isNestedRuby));
                }
            }
            if (this.jcc.allCtors && !isNestedRuby) {
                for (Constructor constructor3 : candidates) {
                    if (this.jcc.rubyConstructable) {
                        generatedCtors.add(RealClassGenerator.makeConcreteConstructorProxy(this.cw, position, true, this, constructor3.getParameterTypes(), false));
                    }
                    if (!this.jcc.javaConstructable) continue;
                    generatedCtors.add(RealClassGenerator.makeConcreteConstructorProxy(this.cw, position, false, this, constructor3.getParameterTypes(), false));
                }
            }
            if (this.jcc.extraCtors != null && this.jcc.extraCtors.size() > 0) {
                for (Class[] classArray : this.jcc.extraCtors) {
                    if (this.jcc.rubyConstructable && !generatedCtors.contains(CodegenUtils.sig(Void.TYPE, this.join(classArray, new Class[]{Ruby.class, RubyClass.class})))) {
                        generatedCtors.add(RealClassGenerator.makeConcreteConstructorProxy(this.cw, position, true, this, classArray, isNestedRuby));
                    }
                    if (!this.jcc.javaConstructable || generatedCtors.contains(CodegenUtils.sig(Void.TYPE, classArray))) continue;
                    generatedCtors.add(RealClassGenerator.makeConcreteConstructorProxy(this.cw, position, false, this, classArray, isNestedRuby));
                }
            }
            if (this.jcc.IroCtors) {
                RealClassGenerator.makeConcreteConstructorIROProxy(this.cw, position, this);
            } else if (generatedCtors.size() == 0) {
                throw RubyClass.this.runtime.newTypeError("class " + this.rubyName + " doesn't have any exposed java constructors");
            }
            RealClassGenerator.makeConcreteConstructorSwitch(this.cw, position, superpos, isNestedRuby, this, this.savedSuperCtors);
        }

        @Override
        protected void generateObjectBarrier(SkinnyMethodAdapter m) {
            m.aload(0);
            m.getfield(this.javaPath, RUBY_OBJECT_FIELD, this.rubyName);
            m.aload(0);
            m.invokevirtual(this.rubyPath, "ensureThis", CodegenUtils.sig(Void.TYPE, Object.class));
        }

        private void defineInterfaceMethods() {
            SkinnyMethodAdapter m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 4097, "___jruby$rubyObject", CodegenUtils.sig(IRubyObject.class, new Class[0]), null, null);
            m.aload(0);
            m.getfield(this.javaPath, RUBY_OBJECT_FIELD, this.rubyName);
            m.areturn();
            m.end();
            m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 4097, "___jruby$proxyClass", CodegenUtils.sig(JavaProxyClass.class, new Class[0]), null, null);
            m.getstatic(this.javaPath, RUBY_PROXY_CLASS_FIELD, CodegenUtils.ci(JavaProxyClass.class));
            m.areturn();
            m.end();
        }
    }

    private class MethodReificator
    extends BaseReificator {
        MethodReificator(Class<?> reifiedParent, String javaName, String javaPath, String rubyName, String rubyPath) {
            super(reifiedParent, javaName, javaPath, rubyName, rubyPath);
        }

        @Override
        public void customReify() {
            this.addClassAnnotations();
            this.defineFields();
            HashSet<String> instanceMethods = new HashSet<String>(RubyClass.this.getMethods().size());
            this.defineInstanceMethods(instanceMethods);
            this.defineClassMethods(instanceMethods);
        }

        private void addClassAnnotations() {
            if (this.jcc.classAnnotations != null && !this.jcc.classAnnotations.isEmpty()) {
                for (Map.Entry<Class<?>, Map<String, Object>> entry : this.jcc.classAnnotations.entrySet()) {
                    Class<?> annoType = entry.getKey();
                    Map<String, Object> fields2 = entry.getValue();
                    AnnotationVisitor av = this.cw.visitAnnotation(CodegenUtils.ci(annoType), true);
                    CodegenUtils.visitAnnotationFields(av, fields2);
                    av.visitEnd();
                }
            }
        }

        private void defineFields() {
            for (Map.Entry<String, Class<?>> fieldSignature : RubyClass.this.getFieldSignatures().entrySet()) {
                String fieldName = fieldSignature.getKey();
                Class<?> type2 = fieldSignature.getValue();
                Map<Class<?>, Map<String, Object>> fieldAnnos = RubyClass.this.getFieldAnnotations().get(fieldName);
                FieldVisitor fieldVisitor = this.cw.visitField(1, fieldName, CodegenUtils.ci(type2), null, null);
                if (fieldAnnos == null) continue;
                for (Map.Entry<Class<?>, Map<String, Object>> fieldAnno : fieldAnnos.entrySet()) {
                    Class<?> annoType = fieldAnno.getKey();
                    AnnotationVisitor av = fieldVisitor.visitAnnotation(CodegenUtils.ci(annoType), true);
                    CodegenUtils.visitAnnotationFields(av, fieldAnno.getValue());
                }
                fieldVisitor.visitEnd();
            }
        }

        private void defineClassMethods(Set<String> instanceMethods) {
            for (Map.Entry<String, DynamicMethod> methodEntry : RubyClass.this.getMetaClass().getMethods().entrySet()) {
                SkinnyMethodAdapter m;
                String signature;
                String id2 = methodEntry.getKey();
                if (this.jcc.getExcluded().contains(id2)) continue;
                String javaMethodName = JavaNameMangler.mangleMethodName(id2);
                PositionAware position = RubyClass.this.getPositionOrDefault(methodEntry.getValue());
                if (position.getLine() > 1) {
                    this.cw.visitSource(position.getFile(), null);
                }
                Map<Class<?>, Map<String, Object>> methodAnnos = RubyClass.this.getMetaClass().getMethodAnnotations().get(id2);
                List<Map<Class<?>, Map<String, Object>>> parameterAnnos = RubyClass.this.getMetaClass().getParameterAnnotations().get(id2);
                Class<?>[] methodSignature = RubyClass.this.getMetaClass().getMethodSignatures().get(id2);
                if (methodSignature == null) {
                    if (!this.jcc.allClassMethods) continue;
                    Signature sig = methodEntry.getValue().getSignature();
                    if (sig.isNoArguments()) {
                        signature = CodegenUtils.sig(IRubyObject.class, new Class[0]);
                        if (instanceMethods.contains(javaMethodName + signature)) continue;
                        m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 9, javaMethodName, signature, null, null);
                        m.line(position.getLine());
                        RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                        m.getstatic(this.javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
                        m.ldc(id2);
                        m.invokevirtual("org/jruby/RubyClass", "callMethod", CodegenUtils.sig(IRubyObject.class, String.class));
                    } else {
                        signature = CodegenUtils.sig(IRubyObject.class, IRubyObject[].class);
                        if (instanceMethods.contains(javaMethodName + signature)) continue;
                        m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 137, javaMethodName, signature, null, null);
                        m.line(position.getLine());
                        RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                        m.getstatic(this.javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
                        m.ldc(id2);
                        m.aload(0);
                        m.invokevirtual("org/jruby/RubyClass", "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                    }
                    m.areturn();
                } else {
                    int baseIndex;
                    Class[] params2 = new Class[methodSignature.length - 1];
                    System.arraycopy(methodSignature, 1, params2, 0, params2.length);
                    int rubyIndex = baseIndex = RealClassGenerator.calcBaseIndex(params2, 0);
                    signature = CodegenUtils.sig(methodSignature[0], params2);
                    if (instanceMethods.contains(javaMethodName + signature)) continue;
                    m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 137, javaMethodName, signature, null, null);
                    m.line(position.getLine());
                    RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                    m.getstatic(this.javaPath, "ruby", CodegenUtils.ci(Ruby.class));
                    m.astore(rubyIndex);
                    m.getstatic(this.javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
                    m.ldc(id2);
                    RealClassGenerator.coerceArgumentsToRuby(m, params2, rubyIndex);
                    m.invokevirtual("org/jruby/RubyClass", "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                    RealClassGenerator.coerceResultAndReturn(m, methodSignature[0]);
                }
                m.end();
            }
        }

        protected void defineInstanceMethods(Set<String> instanceMethods) {
            HashSet<String> defined = new HashSet<String>();
            for (Map.Entry<String, DynamicMethod> methodEntry : RubyClass.this.getMethods().entrySet()) {
                Class<?>[] methodSignature;
                String id2 = methodEntry.getKey();
                String callid = this.jcc.renamedMethods.getOrDefault(id2, id2);
                if (defined.contains(id2) || this.jcc.getExcluded().contains(id2)) continue;
                defined.add(callid);
                DynamicMethod method2 = methodEntry.getValue();
                if (id2 != callid) {
                    method2 = RubyClass.this.searchMethod(callid);
                }
                Signature arity2 = method2.getSignature();
                PositionAware position = RubyClass.this.getPositionOrDefault(methodEntry.getValue());
                if (position.getLine() > 1) {
                    this.cw.visitSource(position.getFile(), null);
                }
                if ((methodSignature = RubyClass.this.getMethodSignatures().get(callid)) == null) {
                    for (Class<?>[] sig : this.searchInheritedSignatures(id2, arity2)) {
                        String signature = this.defineInstanceMethod(id2, callid, arity2, position, sig);
                        if (signature == null) continue;
                        instanceMethods.add(signature);
                    }
                    continue;
                }
                String signature = this.defineInstanceMethod(id2, callid, arity2, position, methodSignature);
                if (signature == null) continue;
                instanceMethods.add(signature);
            }
        }

        protected String defineInstanceMethod(String id2, String callid, Signature sig, PositionAware position, Class<?>[] methodSignature) {
            SkinnyMethodAdapter m;
            String signature;
            String javaMethodName = JavaNameMangler.mangleMethodName(id2);
            Map<Class<?>, Map<String, Object>> methodAnnos = RubyClass.this.getMethodAnnotations().get(callid);
            List<Map<Class<?>, Map<String, Object>>> parameterAnnos = RubyClass.this.getParameterAnnotations().get(callid);
            if (methodSignature == null) {
                if (!this.jcc.allMethods) {
                    return null;
                }
                if (sig.isFixed()) {
                    switch (sig.required()) {
                        case 0: {
                            signature = CodegenUtils.sig(IRubyObject.class, new Class[0]);
                            m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 1, javaMethodName, signature, null, null);
                            m.line(position.getLine());
                            RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                            this.generateObjectBarrier(m);
                            this.loadRubyObject(m);
                            m.ldc(callid);
                            this.rubycall(m, CodegenUtils.sig(IRubyObject.class, String.class));
                            break;
                        }
                        case 1: {
                            signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class);
                            m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 1, javaMethodName, signature, null, null);
                            m.line(position.getLine());
                            RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                            this.generateObjectBarrier(m);
                            this.loadRubyObject(m);
                            m.ldc(callid);
                            m.aload(1);
                            this.rubycall(m, CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject.class));
                            break;
                        }
                        default: {
                            int paramCount = sig.required();
                            Object[] params2 = new Class[paramCount];
                            Arrays.fill(params2, IRubyObject.class);
                            signature = CodegenUtils.sig(IRubyObject.class, (Class[])params2);
                            m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 1, javaMethodName, signature, null, null);
                            m.line(position.getLine());
                            RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                            this.generateObjectBarrier(m);
                            this.loadRubyObject(m);
                            m.ldc(callid);
                            m.pushInt(paramCount);
                            m.anewarray(CodegenUtils.p(IRubyObject.class));
                            for (int i2 = 1; i2 <= paramCount; ++i2) {
                                m.dup();
                                m.pushInt(i2 - 1);
                                m.aload(i2);
                                m.aastore();
                            }
                            this.rubycall(m, CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                            break;
                        }
                    }
                } else {
                    signature = CodegenUtils.sig(IRubyObject.class, IRubyObject[].class);
                    m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 129, javaMethodName, signature, null, null);
                    m.line(position.getLine());
                    RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                    this.generateObjectBarrier(m);
                    this.loadRubyObject(m);
                    m.ldc(callid);
                    m.aload(1);
                    this.rubycall(m, CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                }
                m.areturn();
            } else {
                int baseIndex;
                Object[] params3 = new Class[methodSignature.length - 1];
                ArraySupport.copy(methodSignature, 1, params3, 0, params3.length);
                int rubyIndex = baseIndex = RealClassGenerator.calcBaseIndex((Class[])params3, 1);
                signature = CodegenUtils.sig(methodSignature[0], (Class[])params3);
                int mod = 1;
                if (RubyClass.this.isVarArgsSignature(callid, methodSignature)) {
                    mod |= 0x80;
                }
                m = new SkinnyMethodAdapter((ClassVisitor)this.cw, mod, javaMethodName, signature, null, null);
                m.line(position.getLine());
                RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                this.generateObjectBarrier(m);
                m.getstatic(this.javaPath, "ruby", CodegenUtils.ci(Ruby.class));
                m.astore(rubyIndex);
                this.loadRubyObject(m);
                m.ldc(callid);
                RealClassGenerator.coerceArgumentsToRuby(m, (Class[])params3, rubyIndex);
                this.rubycall(m, CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                RealClassGenerator.coerceResultAndReturn(m, methodSignature[0]);
                if (!this.isRubyObject()) {
                    this.generateSuperBridges(javaMethodName, methodSignature);
                }
            }
            m.end();
            return javaMethodName + signature;
        }

        protected void generateSuperBridges(String javaMethodName, Class<?>[] methodSignature) {
        }

        @Override
        public void reifyClinit(SkinnyMethodAdapter m) {
            m.pushInt(1);
            m.ldc(JavaProxyClass.addStaticInitLookup(this.getExtraClinitInfo()));
            m.invokestatic(CodegenUtils.p(JavaProxyClass.class), "getStaticInitLookup", CodegenUtils.sig(Object[].class, Integer.TYPE));
            m.dup_x1();
            m.dup_x2();
            m.pushInt(0);
            m.aaload();
            m.checkcast(CodegenUtils.p(Ruby.class));
            m.putstatic(this.javaPath, "ruby", CodegenUtils.ci(Ruby.class));
            m.aaload();
            m.checkcast(CodegenUtils.p(RubyClass.class));
            m.putstatic(this.javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
            this.extraClinitLookup(m);
        }

        protected Object[] getExtraClinitInfo() {
            return new Object[]{RubyClass.this.runtime, RubyClass.this};
        }

        protected void extraClinitLookup(SkinnyMethodAdapter m) {
            m.pop();
        }

        protected Collection<Class<?>[]> searchInheritedSignatures(String id2, Signature arity2) {
            HashMap<String, Class<?>[]> types = new HashMap<String, Class<?>[]>();
            for (Class intf : Java.getInterfacesFromRubyClass(RubyClass.this)) {
                this.searchClassMethods(intf, arity2, id2, types);
            }
            if (types.isEmpty()) {
                types.put("", null);
            }
            return types.values();
        }

        protected Collection<Class<?>[]> searchClassMethods(Class<?> clz, Signature arity2, String id2, HashMap<String, Class<?>[]> options2) {
            if (clz.getSuperclass() != null) {
                this.searchClassMethods(clz.getSuperclass(), arity2, id2, options2);
            }
            for (Class<?> clazz : clz.getInterfaces()) {
                this.searchClassMethods(clazz, arity2, id2, options2);
            }
            for (GenericDeclaration genericDeclaration : clz.getDeclaredMethods()) {
                int mod;
                if (!((Method)genericDeclaration).getName().equals(id2) || !Modifier.isPublic(mod = ((Method)genericDeclaration).getModifiers()) && !Modifier.isProtected(mod) || Modifier.isFinal(mod) || arity2 != null && (arity2.isFixed() ? arity2.required() != ((Method)genericDeclaration).getParameterCount() : arity2.required() > ((Method)genericDeclaration).getParameterCount())) continue;
                Class[] types = this.join(new Class[]{((Method)genericDeclaration).getReturnType()}, ((Method)genericDeclaration).getParameterTypes());
                options2.put(CodegenUtils.sig(types), types);
            }
            return options2.values();
        }

        protected void generateObjectBarrier(SkinnyMethodAdapter m) {
        }
    }

    private abstract class BaseReificator
    implements Reificator {
        public final Class<?> reifiedParent;
        protected final String javaName;
        public final String javaPath;
        public final String rubyName;
        public final String rubyPath;
        protected final JavaClassConfiguration jcc;
        protected final ClassWriter cw;
        public static final String RUBY_FIELD = "ruby";
        public static final String RUBY_CLASS_FIELD = "rubyClass";

        BaseReificator(Class<?> reifiedParent, String javaName, String javaPath, String rubyName, String rubyPath) {
            this.reifiedParent = reifiedParent;
            this.javaName = javaName;
            this.javaPath = javaPath;
            this.rubyName = rubyName;
            this.rubyPath = rubyPath;
            this.jcc = RubyClass.this.getClassConfig();
            this.cw = new ClassWriter(3);
            this.cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, javaPath, null, CodegenUtils.p(reifiedParent), this.interfaces());
            this.cw.visitSource("generated:Reificator@" + this.getClass().getName(), null);
        }

        @Override
        public byte[] reify() {
            this.cw.visitField(4122, RUBY_FIELD, CodegenUtils.ci(Ruby.class), null, null);
            this.cw.visitField(4122, RUBY_CLASS_FIELD, CodegenUtils.ci(RubyClass.class), null, null);
            this.reifyConstructors();
            this.customReify();
            SkinnyMethodAdapter m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 9, "<clinit>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
            m.start();
            this.reifyClinit(m);
            m.voidreturn();
            m.end();
            this.cw.visitEnd();
            return this.cw.toByteArray();
        }

        public abstract void reifyClinit(SkinnyMethodAdapter var1);

        public abstract void customReify();

        private String[] interfaces() {
            Class[] interfaces2 = Java.getInterfacesFromRubyClass(RubyClass.this);
            String[] interfaceNames = new String[interfaces2.length + 1];
            interfaceNames[0] = CodegenUtils.p(this.isRubyObject() ? Reified.class : ReifiedJavaProxy.class);
            for (int i2 = 0; i2 < interfaces2.length; ++i2) {
                interfaceNames[i2 + 1] = CodegenUtils.p(interfaces2[i2]);
            }
            return interfaceNames;
        }

        protected boolean isRubyObject() {
            return true;
        }

        protected void loadRubyObject(SkinnyMethodAdapter m) {
            m.aload(0);
        }

        public void rubycall(SkinnyMethodAdapter m, String signature) {
            m.invokevirtual(this.rubyPath, "callMethod", signature);
        }

        protected void reifyConstructors() {
            SkinnyMethodAdapter m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 1, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), null, null);
            m.aload(0);
            m.aload(1);
            m.aload(2);
            this.allocAndInitialize(m, false);
            if (this.jcc.javaConstructable) {
                m = new SkinnyMethodAdapter((ClassVisitor)this.cw, 1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
                m.aload(0);
                m.getstatic(this.javaPath, RUBY_FIELD, CodegenUtils.ci(Ruby.class));
                m.getstatic(this.javaPath, RUBY_CLASS_FIELD, CodegenUtils.ci(RubyClass.class));
                this.allocAndInitialize(m, true);
            }
        }

        protected void allocAndInitialize(SkinnyMethodAdapter m, boolean initIfAllowed) {
            m.invokespecial(CodegenUtils.p(this.reifiedParent), "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
            if (this.jcc.callInitialize && initIfAllowed) {
                m.aload(0);
                m.ldc(this.jcc.javaCtorMethodName);
                this.rubycall(m, CodegenUtils.sig(IRubyObject.class, String.class));
            }
            m.voidreturn();
            m.end();
        }

        public Class[] join(Class[] base, Class ... extra) {
            Object[] more = ArraySupport.newCopy(base, base.length + extra.length);
            ArraySupport.copy(extra, more, base.length, extra.length);
            return more;
        }
    }

    static interface Reificator {
        public byte[] reify();
    }
}

