/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.log;

import java.lang.reflect.Constructor;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.StandardErrorLogger;

public class LoggerFactory {
    static final String LOGGER_CLASS = (String)Options.LOGGER_CLASS.load();
    static final String BACKUP_LOGGER_CLASS = "org.jruby.util.log.StandardErrorLogger";
    static final Constructor<? extends Logger> LOGGER = LoggerFactory.resolveLoggerConstructor(LOGGER_CLASS, Class.class, true);
    static final Constructor<? extends Logger> LOGGER_OLD = LOGGER == null ? LoggerFactory.resolveLoggerConstructor(LOGGER_CLASS, String.class, false) : LoggerFactory.resolveLoggerConstructor(LOGGER_CLASS, String.class, true);

    static Constructor<? extends Logger> resolveLoggerConstructor(String className, Class<?> paramType, boolean allowNoSuchMethod) {
        Constructor<?> loggerCtor;
        Object param = paramType == String.class ? LoggerFactory.class.getSimpleName() : LoggerFactory.class;
        try {
            Class<?> klass = Class.forName(className);
            loggerCtor = klass.getDeclaredConstructor(paramType);
            loggerCtor.newInstance(param);
        }
        catch (Exception ex) {
            if (allowNoSuchMethod && ex instanceof NoSuchMethodException) {
                return null;
            }
            try {
                Class<?> klass = Class.forName(BACKUP_LOGGER_CLASS);
                loggerCtor = klass.getDeclaredConstructor(paramType);
                Logger log3 = (Logger)loggerCtor.newInstance(param);
                log3.info("failed to create logger \"" + className + "\", using \"org.jruby.util.log.StandardErrorLogger\"", new Object[0]);
            }
            catch (Exception e2) {
                throw new IllegalStateException("unable to instantiate any logger", ex);
            }
        }
        return loggerCtor;
    }

    public static Logger getLogger(Class<?> loggerClass) {
        if (LOGGER == null) {
            return LoggerFactory.getLogger(loggerClass.getName());
        }
        try {
            return LOGGER.newInstance(loggerClass);
        }
        catch (Exception ex) {
            return LoggerFactory.getLoggerFallback(loggerClass, ex);
        }
    }

    @Deprecated(since="9.4-")
    public static Logger getLogger(String loggerName) {
        try {
            return LOGGER_OLD.newInstance(loggerName);
        }
        catch (Exception ex) {
            return LoggerFactory.getLoggerFallback(loggerName, ex);
        }
    }

    private static Logger getLoggerFallback(String loggerName, Exception ex) {
        Throwable rootCause = ex;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        if (rootCause instanceof SecurityException) {
            return new StandardErrorLogger(loggerName);
        }
        throw new IllegalStateException("unable to instantiate logger", ex);
    }

    private static Logger getLoggerFallback(Class loggerClass, Exception ex) {
        Throwable rootCause = ex;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        if (rootCause instanceof SecurityException) {
            return new StandardErrorLogger(loggerClass);
        }
        throw new IllegalStateException("unable to instantiate logger", ex);
    }
}

