/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.Ptr;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingError;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvResult;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscoderDB;
import org.jcodings.transcode.Transcoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyConverter;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyMethod;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.API;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.exceptions.EncodingError;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.CodeRangeSupport;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

public class EncodingUtils {
    public static final int ECONV_DEFAULT_NEWLINE_DECORATOR = Platform.IS_WINDOWS ? 4096 : 0;
    public static final int DEFAULT_TEXTMODE = Platform.IS_WINDOWS ? 4096 : 0;
    public static final int TEXTMODE_NEWLINE_DECORATOR_ON_WRITE = Platform.IS_WINDOWS ? 4096 : 0;
    private static final byte[] NULL_BYTE_ARRAY = ByteList.NULL_ARRAY;
    public static final ResizeFunction strTranscodingResize = new ResizeFunction(){

        @Override
        public int resize(ByteList destination, int len, int new_len) {
            destination.setRealSize(len);
            destination.ensure(new_len);
            return destination.getBegin();
        }
    };
    private static final AbstractTranscodeFallback HASH_FALLBACK = new AbstractTranscodeFallback(){

        @Override
        protected IRubyObject innerCall(ThreadContext context, IRubyObject fallback, IRubyObject c) {
            return ((RubyHash)fallback).op_aref(context, c);
        }
    };
    private static final AbstractTranscodeFallback PROC_FALLBACK = new AbstractTranscodeFallback(){

        @Override
        protected IRubyObject innerCall(ThreadContext context, IRubyObject fallback, IRubyObject c) {
            return ((RubyProc)fallback).call(context, c);
        }
    };
    private static final AbstractTranscodeFallback METHOD_FALLBACK = new AbstractTranscodeFallback(){

        @Override
        protected IRubyObject innerCall(ThreadContext context, IRubyObject fallback, IRubyObject c) {
            return fallback.callMethod(context, "call", c);
        }
    };
    private static final AbstractTranscodeFallback AREF_FALLBACK = new AbstractTranscodeFallback(){

        @Override
        protected IRubyObject innerCall(ThreadContext context, IRubyObject fallback, IRubyObject c) {
            return fallback.callMethod(context, "[]", c);
        }
    };
    private static final Encoding UTF16Dummy = ((EncodingDB.Entry)EncodingDB.getEncodings().get("UTF-16".getBytes())).getEncoding();
    private static final Encoding UTF32Dummy = ((EncodingDB.Entry)EncodingDB.getEncodings().get("UTF-32".getBytes())).getEncoding();

    public static Encoding rbToEncoding(ThreadContext context, IRubyObject enc) {
        if (enc instanceof RubyEncoding) {
            return ((RubyEncoding)enc).getEncoding();
        }
        return EncodingUtils.toEncoding(context, enc);
    }

    public static Encoding toEncoding(ThreadContext context, IRubyObject enc) {
        RubyString encStr = enc.convertToString();
        if (!encStr.getEncoding().isAsciiCompatible()) {
            throw Error.argumentError(context, "invalid encoding name (non ASCII)");
        }
        Encoding idx = Access.encodingService(context).getEncodingFromObject(encStr);
        return idx;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject[] openArgsToArgs(Ruby runtime2, IRubyObject firstElement, RubyHash options2) {
        return EncodingUtils.openArgsToArgs(runtime2.getCurrentContext(), firstElement, options2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject[] openArgsToArgs(ThreadContext context, IRubyObject firstElement, RubyHash options2) {
        IRubyObject value2 = EncodingUtils.hashARef(context, options2, "open_args");
        if (value2.isNil()) {
            return new IRubyObject[]{firstElement, options2};
        }
        RubyArray array2 = value2.convertToArray();
        Object[] openArgs = new IRubyObject[array2.size()];
        value2.convertToArray().toArray(openArgs);
        IRubyObject[] args2 = new IRubyObject[openArgs.length + 1];
        args2[0] = firstElement;
        System.arraycopy(openArgs, 0, args2, 1, openArgs.length);
        return args2;
    }

    @Deprecated(since="10.0.0.0")
    public static void extractBinmode(Ruby runtime2, IRubyObject optionsArg, int[] fmode_p) {
        EncodingUtils.extractBinmode(runtime2.getCurrentContext(), optionsArg, fmode_p);
    }

    public static void extractBinmode(ThreadContext context, IRubyObject optionsArg, int[] fmode_p) {
        boolean binOption;
        int fmodeMask = 0;
        IRubyObject textMode = EncodingUtils.hashARef(context, optionsArg, "textmode");
        IRubyObject binMode = EncodingUtils.hashARef(context, optionsArg, "binmode");
        boolean textKwarg = !textMode.isNil();
        boolean textOption = (fmode_p[0] & 0x1000) != 0;
        boolean binKwarg = !binMode.isNil();
        boolean bl = binOption = (fmode_p[0] & 4) != 0;
        if ((textKwarg || textOption) && (binKwarg || binOption)) {
            throw Error.argumentError(context, "both textmode and binmode specified");
        }
        if (textKwarg) {
            if (textOption) {
                throw Error.argumentError(context, "textmode specified twice");
            }
            if (textMode.isTrue()) {
                fmodeMask |= 0x1000;
            }
        }
        if (binKwarg) {
            if (binOption) {
                throw Error.argumentError(context, "binmode specified twice");
            }
            if (binMode.isTrue()) {
                fmodeMask |= 4;
            }
        }
        fmode_p[0] = fmode_p[0] | fmodeMask;
    }

    private static IRubyObject hashARef(ThreadContext context, IRubyObject hash2, String symbol) {
        if (hash2 == null || !(hash2 instanceof RubyHash)) {
            return context.nil;
        }
        IRubyObject value2 = ((RubyHash)hash2).fastARef(Convert.asSymbol(context, symbol));
        return value2 == null ? context.nil : value2;
    }

    public static Encoding ascii8bitEncoding(Ruby runtime2) {
        return runtime2.getEncodingService().getAscii8bitEncoding();
    }

    @Deprecated(since="10.0.0.0")
    public static Object vmodeVperm(IRubyObject vmode, IRubyObject vperm) {
        return new API.ModeAndPermission(vmode, vperm);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject vmode(Object vmodeVperm) {
        return ((API.ModeAndPermission)vmodeVperm).mode;
    }

    @Deprecated(since="10.0.0.0")
    public static void vmode(Object vmodeVperm, IRubyObject vmode) {
        ((API.ModeAndPermission)vmodeVperm).mode = vmode;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject vperm(Object vmodeVperm) {
        return ((API.ModeAndPermission)vmodeVperm).permission;
    }

    @Deprecated(since="10.0.0.0")
    public static void vperm(Object vmodeVperm, IRubyObject vperm) {
        ((API.ModeAndPermission)vmodeVperm).permission = vperm;
    }

    public static IRubyObject vmode(API.ModeAndPermission vmodeVperm) {
        return vmodeVperm.mode;
    }

    public static void vmode(API.ModeAndPermission vmodeVperm, IRubyObject vmode) {
        vmodeVperm.mode = vmode;
    }

    public static IRubyObject vperm(API.ModeAndPermission vmodeVperm) {
        return vmodeVperm.permission;
    }

    public static void vperm(API.ModeAndPermission vmodeVperm, IRubyObject vperm) {
        vmodeVperm.permission = vperm;
    }

    public static final int MODE_BTMODE(int fmode, int a, int b2, int c) {
        if ((fmode & 4) != 0) {
            return b2;
        }
        if ((fmode & 0x1000) != 0) {
            return c;
        }
        return a;
    }

    public static int SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(Encoding enc2, int ecflags) {
        if (enc2 != null && (ecflags & ECONV_DEFAULT_NEWLINE_DECORATOR) != 0) {
            return ecflags | 0x100;
        }
        return ecflags;
    }

    @Deprecated(since="10.0.0.0")
    public static void extractModeEncoding(ThreadContext context, IOEncodable ioEncodable, Object vmodeAndVperm_p, IRubyObject options2, int[] oflags_p, int[] fmode_p) {
        EncodingUtils.extractModeEncoding(context, ioEncodable, (API.ModeAndPermission)vmodeAndVperm_p, options2, oflags_p, fmode_p);
    }

    public static void extractModeEncoding(ThreadContext context, IOEncodable ioEncodable, API.ModeAndPermission vmodeAndVperm_p, IRubyObject options2, int[] oflags_p, int[] fmode_p) {
        int ecflags;
        IRubyObject[] ecopts_p;
        block20: {
            IRubyObject extraFlags;
            IRubyObject v;
            Ruby runtime2 = context.runtime;
            ecopts_p = new IRubyObject[]{context.nil};
            boolean hasEnc = false;
            boolean hasVmode = false;
            EncodingUtils.ioExtIntToEncs(context, ioEncodable, null, null, 0);
            while (true) {
                if (EncodingUtils.vmode(vmodeAndVperm_p) == null || EncodingUtils.vmode(vmodeAndVperm_p).isNil()) {
                    fmode_p[0] = 1;
                    oflags_p[0] = ModeFlags.RDONLY;
                } else {
                    IRubyObject intmode = Convert.checkToInteger(context, EncodingUtils.vmode(vmodeAndVperm_p));
                    if (!intmode.isNil()) {
                        EncodingUtils.vmode(vmodeAndVperm_p, intmode);
                        oflags_p[0] = ((RubyInteger)intmode).asInt(context);
                        fmode_p[0] = ModeFlags.getOpenFileFlagsFor(oflags_p[0]);
                    } else {
                        String p2 = EncodingUtils.vmode(vmodeAndVperm_p).convertToString().asJavaString();
                        fmode_p[0] = OpenFile.ioModestrFmode(context, p2);
                        oflags_p[0] = OpenFile.ioFmodeOflags(fmode_p[0]);
                        int colonSplit = p2.indexOf(":");
                        if (colonSplit != -1) {
                            hasEnc = true;
                            EncodingUtils.parseModeEncoding(context, ioEncodable, p2.substring(colonSplit + 1), fmode_p);
                        } else {
                            Encoding e = (fmode_p[0] & 4) != 0 ? EncodingUtils.ascii8bitEncoding(runtime2) : null;
                            EncodingUtils.ioExtIntToEncs(context, ioEncodable, e, null, fmode_p[0]);
                        }
                    }
                }
                if (options2 == null || options2.isNil()) {
                    int n = ecflags = (fmode_p[0] & 1) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], ECONV_DEFAULT_NEWLINE_DECORATOR, 0, 256) : 0;
                    if (TEXTMODE_NEWLINE_DECORATOR_ON_WRITE != 0) {
                        ecflags |= (fmode_p[0] & 2) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], TEXTMODE_NEWLINE_DECORATOR_ON_WRITE, 0, TEXTMODE_NEWLINE_DECORATOR_ON_WRITE) : 0;
                    }
                    ecflags = EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(ioEncodable.getEnc2(), ecflags);
                    ecopts_p[0] = context.nil;
                    break block20;
                }
                if (hasVmode || (v = ((RubyHash)options2).op_aref(context, Convert.asSymbol(context, "mode"))).isNil()) break;
                if (EncodingUtils.vmode(vmodeAndVperm_p) != null && !EncodingUtils.vmode(vmodeAndVperm_p).isNil()) {
                    throw Error.argumentError(context, "mode specified twice");
                }
                hasVmode = true;
                EncodingUtils.vmode(vmodeAndVperm_p, v);
            }
            v = ((RubyHash)options2).op_aref(context, Convert.asSymbol(context, "flags"));
            if (!v.isNil()) {
                v = v.convertToInteger();
                oflags_p[0] = oflags_p[0] | Convert.toInt(context, v);
                EncodingUtils.vmode(vmodeAndVperm_p, (IRubyObject)Convert.asFixnum(context, oflags_p[0]));
                fmode_p[0] = ModeFlags.getOpenFileFlagsFor(oflags_p[0]);
            }
            EncodingUtils.extractBinmode(context, options2, fmode_p);
            if ((fmode_p[0] & 4) != 0) {
                oflags_p[0] = oflags_p[0] | ModeFlags.BINARY;
                if (!hasEnc) {
                    EncodingUtils.ioExtIntToEncs(context, ioEncodable, EncodingUtils.ascii8bitEncoding(runtime2), null, fmode_p[0]);
                }
            } else if (DEFAULT_TEXTMODE != 0 && (EncodingUtils.vmode(vmodeAndVperm_p) == null || EncodingUtils.vmode(vmodeAndVperm_p).isNil())) {
                fmode_p[0] = fmode_p[0] | DEFAULT_TEXTMODE;
            }
            if (!(v = EncodingUtils.hashARef(context, options2, "perm")).isNil()) {
                if (EncodingUtils.vperm(vmodeAndVperm_p) != null && !EncodingUtils.vperm(vmodeAndVperm_p).isNil()) {
                    throw Error.argumentError(context, "perm specified twice");
                }
                EncodingUtils.vperm(vmodeAndVperm_p, v);
            }
            if (!(extraFlags = EncodingUtils.hashARef(context, options2, "flags")).isNil()) {
                oflags_p[0] = oflags_p[0] | Convert.toInt(context, extraFlags);
            }
            int n = ecflags = (fmode_p[0] & 1) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], ECONV_DEFAULT_NEWLINE_DECORATOR, 0, 256) : 0;
            if (TEXTMODE_NEWLINE_DECORATOR_ON_WRITE != -1) {
                ecflags |= (fmode_p[0] & 2) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], TEXTMODE_NEWLINE_DECORATOR_ON_WRITE, 0, TEXTMODE_NEWLINE_DECORATOR_ON_WRITE) : 0;
            }
            if (EncodingUtils.ioExtractEncodingOption(context, ioEncodable, options2, fmode_p) && hasEnc) {
                throw Error.argumentError(context, "encoding specified twice");
            }
            ecflags = EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(ioEncodable.getEnc2(), ecflags);
            ecflags = EncodingUtils.econvPrepareOptions(context, options2, ecopts_p, ecflags);
        }
        EncodingUtils.validateEncodingBinmode(context, fmode_p, ecflags, ioEncodable);
        ioEncodable.setEcflags(ecflags);
        ioEncodable.setEcopts(ecopts_p[0]);
    }

    public static boolean ioExtractEncodingOption(ThreadContext context, IOEncodable ioEncodable, IRubyObject options2, int[] fmode_p) {
        IRubyObject tmp;
        IRubyObject encoding2 = context.nil;
        IRubyObject extenc = null;
        IRubyObject intenc = null;
        boolean extracted = false;
        Encoding extencoding = null;
        Object intencoding = null;
        if (options2 != null && !options2.isNil()) {
            IRubyObject internalOpt;
            IRubyObject externalOpt;
            RubyHash opts = (RubyHash)options2;
            IRubyObject encodingOpt = opts.op_aref(context, Convert.asSymbol(context, "encoding"));
            if (!encodingOpt.isNil()) {
                encoding2 = encodingOpt;
            }
            if (!(externalOpt = opts.op_aref(context, Convert.asSymbol(context, "external_encoding"))).isNil()) {
                extenc = externalOpt;
            }
            if (!(internalOpt = opts.op_aref(context, Convert.asSymbol(context, "internal_encoding"))).isNil()) {
                intenc = internalOpt;
            }
        }
        if (!(extenc == null && intenc == null || encoding2.isNil())) {
            Warn.warn(context, "Ignoring encoding parameter '" + String.valueOf(encoding2) + "': " + (extenc == null ? "internal" : "external") + "_encoding is used");
            encoding2 = context.nil;
        }
        if (extenc != null && !extenc.isNil()) {
            extencoding = EncodingUtils.rbToEncoding(context, extenc);
        }
        if (intenc != null) {
            String p2;
            intencoding = intenc.isNil() ? null : (!(tmp = intenc.checkStringType()).isNil() ? ((p2 = tmp.toString()).equals("-") ? null : EncodingUtils.rbToEncoding(context, intenc)) : EncodingUtils.rbToEncoding(context, intenc));
            if (extencoding == intencoding) {
                intencoding = null;
            }
        }
        if (!encoding2.isNil()) {
            extracted = true;
            tmp = encoding2.checkStringType();
            if (!tmp.isNil()) {
                EncodingUtils.parseModeEncoding(context, ioEncodable, tmp.asJavaString(), fmode_p);
            } else {
                EncodingUtils.ioExtIntToEncs(context, ioEncodable, EncodingUtils.rbToEncoding(context, encoding2), null, 0);
            }
        } else if (extenc != null || intenc != null) {
            extracted = true;
            EncodingUtils.ioExtIntToEncs(context, ioEncodable, extencoding, intencoding, 0);
        }
        return extracted;
    }

    public static RubyString newExternalStringWithEncoding(Ruby runtime2, String string2, Encoding encoding2) {
        if (string2 == null) {
            return RubyString.newEmptyString(runtime2, encoding2);
        }
        if (encoding2 == ASCIIEncoding.INSTANCE || encoding2 == USASCIIEncoding.INSTANCE && StringSupport.searchNonAscii(string2) != -1) {
            return RubyString.newBinaryString(runtime2, string2);
        }
        Encoding internalEncoding = runtime2.getDefaultInternalEncoding();
        if (internalEncoding == null || encoding2 == internalEncoding) {
            return RubyString.newString(runtime2, string2, encoding2);
        }
        if (encoding2 == ASCIIEncoding.INSTANCE || encoding2 == USASCIIEncoding.INSTANCE || encoding2.isAsciiCompatible() && StringSupport.searchNonAscii(string2) == -1) {
            return RubyString.newString(runtime2, string2, internalEncoding);
        }
        RubyString convertedString = RubyString.newEmptyString(runtime2, internalEncoding);
        try {
            ByteList other = RubyString.encodeBytelist((CharSequence)string2, encoding2);
            convertedString.catWithCodeRange(other, 0);
        }
        catch (EncodingError.CompatibilityError ce) {
            return RubyString.newString(runtime2, string2, encoding2);
        }
        return convertedString;
    }

    public static RubyString newExternalStringWithEncoding(Ruby runtime2, ByteList bytelist, Encoding encoding2) {
        if (bytelist == null) {
            return RubyString.newEmptyString(runtime2, encoding2);
        }
        if (encoding2 == ASCIIEncoding.INSTANCE || encoding2 == USASCIIEncoding.INSTANCE && StringSupport.searchNonAscii(bytelist) != -1) {
            return RubyString.newBinaryString(runtime2, bytelist);
        }
        Encoding internalEncoding = runtime2.getDefaultInternalEncoding();
        if (internalEncoding == null || encoding2 == internalEncoding) {
            return RubyString.newString(runtime2, bytelist, encoding2);
        }
        if (encoding2 == ASCIIEncoding.INSTANCE || encoding2 == USASCIIEncoding.INSTANCE || encoding2.isAsciiCompatible() && StringSupport.searchNonAscii(bytelist) == -1) {
            return RubyString.newString(runtime2, bytelist, internalEncoding);
        }
        RubyString convertedString = RubyString.newEmptyString(runtime2, internalEncoding);
        try {
            ByteList other = RubyString.encodeBytelist(bytelist, encoding2);
            convertedString.catWithCodeRange(other, 0);
        }
        catch (EncodingError.CompatibilityError ce) {
            return RubyString.newString(runtime2, bytelist, encoding2);
        }
        return convertedString;
    }

    public static void ioExtIntToEncs(ThreadContext context, IOEncodable encodable, Encoding external, Encoding internal, int fmode) {
        boolean defaultExternal = false;
        if (external == null) {
            external = context.runtime.getDefaultExternalEncoding();
            defaultExternal = true;
        }
        if (external == EncodingUtils.ascii8bitEncoding(context.runtime)) {
            internal = null;
        } else if (internal == null) {
            internal = context.runtime.getDefaultInternalEncoding();
        }
        if (internal == null || (fmode & 0x100000) == 0 && internal == external) {
            encodable.setEnc((Encoding)(defaultExternal && internal != external ? null : external));
            encodable.setEnc2(null);
        } else {
            encodable.setEnc(internal);
            encodable.setEnc2(external);
        }
    }

    public static void parseModeEncoding(ThreadContext context, IOEncodable ioEncodable, String option, int[] fmode_p) {
        Encoding extEnc;
        Encoding idx;
        List<String> encs;
        String estr;
        EncodingService service = Access.encodingService(context);
        if (fmode_p == null) {
            fmode_p = new int[]{0};
        }
        String string2 = estr = (encs = StringSupport.split(option, ':', 2)).size() == 2 ? encs.get(0) : option;
        if (estr.toLowerCase().startsWith("bom|")) {
            if ((estr = estr.substring(4)).toLowerCase().startsWith("utf-")) {
                fmode_p[0] = fmode_p[0] | 0x100000;
                ioEncodable.setBOM(true);
            } else {
                Warn.warn(context, "BOM with non-UTF encoding " + estr + " is nonsense");
                fmode_p[0] = fmode_p[0] & 0xFFEFFFFF;
            }
        }
        if ((idx = service.findEncodingNoError(new ByteList(estr.getBytes(), false))) == null) {
            Warn.warn(context, "Unsupported encoding " + estr + " ignored");
            extEnc = null;
        } else {
            extEnc = idx;
        }
        Encoding intEnc = null;
        if (encs.size() == 2) {
            String istr = encs.get(1);
            if (istr.equals("-")) {
                intEnc = null;
            } else {
                idx = service.getEncodingFromString(istr);
                if (idx == null) {
                    Warn.warn(context, "ignoring internal encoding " + String.valueOf(idx) + ": it is identical to external encoding " + String.valueOf(idx));
                    intEnc = null;
                } else {
                    intEnc = idx;
                }
            }
        }
        EncodingUtils.ioExtIntToEncs(context, ioEncodable, extEnc, intEnc, fmode_p[0]);
    }

    public static ByteList econvStrConvert(ThreadContext context, EConv ec, ByteList src, int flags2) {
        return EncodingUtils.econvSubstrAppend(context, ec, src, null, flags2);
    }

    public static ByteList econvByteConvert(ThreadContext context, EConv ec, byte[] bytes2, int start2, int length2, int flags2) {
        return EncodingUtils.econvAppend(context, ec, bytes2, start2, length2, new ByteList(length2, ec.destinationEncoding), flags2);
    }

    public static ByteList econvSubstrAppend(ThreadContext context, EConv ec, ByteList src, ByteList dst, int flags2) {
        return EncodingUtils.econvAppend(context, ec, src, dst, flags2);
    }

    public static ByteList econvAppend(ThreadContext context, EConv ec, ByteList sByteList, ByteList dst, int flags2) {
        int len = sByteList.getRealSize();
        if (dst == null) {
            dst = new ByteList(len, ec.destinationEncoding);
        }
        return EncodingUtils.econvAppend(context, ec, sByteList.unsafeBytes(), sByteList.begin(), len, dst, flags2);
    }

    public static ByteList econvAppend(ThreadContext context, EConv ec, byte[] bytes2, int start2, int length2, ByteList dst, int flags2) {
        EConvResult res;
        Ptr sp = new Ptr(0);
        int ss = start2;
        Ptr dp = new Ptr(0);
        int maxOutput = ec.lastTranscoding != null ? ec.lastTranscoding.transcoder.maxOutput : 1;
        do {
            int dlen = dst.getRealSize();
            if (dst.getUnsafeBytes().length - dst.getBegin() - dlen < length2 + maxOutput) {
                long newCapa = dlen + length2 + maxOutput;
                if (Integer.MAX_VALUE < newCapa) {
                    throw Error.argumentError(context, "too long string");
                }
                dst.ensure((int)newCapa);
                dst.setRealSize(dlen);
            }
            sp.p = ss;
            int se = sp.p + length2;
            byte[] dBytes = dst.getUnsafeBytes();
            int ds = dst.getBegin();
            int de = dBytes.length;
            dp.p = ds += dlen;
            res = ec.convert(bytes2, sp, se, dBytes, dp, de, flags2);
            length2 -= sp.p - ss;
            ss = sp.p;
            dst.setRealSize(dlen + (dp.p - ds));
            EncodingUtils.econvCheckError(context, ec);
        } while (res == EConvResult.DestinationBufferFull);
        return dst;
    }

    public static void econvCheckError(ThreadContext context, EConv ec) {
        RaiseException re = EncodingUtils.makeEconvException(context, ec);
        if (re != null) {
            throw re;
        }
    }

    public static int econvPrepareOpts(ThreadContext context, IRubyObject opthash, IRubyObject[] opts) {
        return EncodingUtils.econvPrepareOptions(context, opthash, opts, 0);
    }

    public static int econvPrepareOptions(ThreadContext context, IRubyObject opthash, IRubyObject[] opts, int ecflags) {
        RubySymbol fallbackSymbol;
        IRubyObject newhash = context.nil;
        if (opthash.isNil()) {
            opts[0] = context.nil;
            return ecflags;
        }
        RubyHash optHash2 = (RubyHash)opthash;
        ecflags = EncodingUtils.econvOpts(context, opthash, ecflags);
        RubySymbol replaceSymbol = Convert.asSymbol(context, "replace");
        IRubyObject v = optHash2.op_aref(context, replaceSymbol);
        if (!v.isNil()) {
            RubyString v_str = v.convertToString();
            if (v_str.scanForCodeRange() == 48) {
                throw Error.argumentError(context, "replacement string is broken: " + String.valueOf(v_str));
            }
            v = v_str.newFrozen();
            newhash = Create.newHash(context);
            ((RubyHash)newhash).op_aset(context, replaceSymbol, v);
        }
        if (!(v = optHash2.op_aref(context, fallbackSymbol = Convert.asSymbol(context, "fallback"))).isNil()) {
            boolean condition;
            IRubyObject h = TypeConverter.checkHashType(context.runtime, v);
            if (h.isNil()) {
                condition = v instanceof RubyProc || v instanceof RubyMethod || v.respondsTo("[]");
            } else {
                v = h;
                condition = true;
            }
            if (condition) {
                if (newhash.isNil()) {
                    newhash = Create.newHash(context);
                }
                ((RubyHash)newhash).op_aset(context, fallbackSymbol, v);
            }
        }
        if (!newhash.isNil()) {
            newhash.setFrozen(true);
        }
        opts[0] = newhash;
        return ecflags;
    }

    public static int econvOpts(ThreadContext context, IRubyObject opt, int ecflags) {
        IRubyObject v = ((RubyHash)opt).op_aref(context, Convert.asSymbol(context, "invalid"));
        if (!v.isNil()) {
            if (!v.toString().equals("replace")) {
                throw Error.argumentError(context, "unknown value for invalid character option");
            }
            ecflags |= 2;
        }
        if (!(v = ((RubyHash)opt).op_aref(context, Convert.asSymbol(context, "undef"))).isNil()) {
            if (!v.toString().equals("replace")) {
                throw Error.argumentError(context, "unknown value for undefined character option");
            }
            ecflags |= 0x20;
        }
        if (!(v = ((RubyHash)opt).op_aref(context, Convert.asSymbol(context, "replace"))).isNil() && (ecflags & 2) == 0) {
            ecflags |= 0x20;
        }
        if (!(v = ((RubyHash)opt).op_aref(context, Convert.asSymbol(context, "xml"))).isNil()) {
            if (v.toString().equals("text")) {
                ecflags |= 0x8030;
            } else if (v.toString().equals("attr")) {
                ecflags |= 0x110030;
            } else {
                throw Error.argumentError(context, "unexpected value for xml option: " + String.valueOf(v));
            }
        }
        if (!(v = ((RubyHash)opt).op_aref(context, Convert.asSymbol(context, "newline"))).isNil()) {
            ecflags &= 0xFFFF80FF;
            if (v.toString().equals("universal")) {
                ecflags |= 0x100;
            } else if (v.toString().equals("crlf")) {
                ecflags |= 0x1000;
            } else if (v.toString().equals("cr")) {
                ecflags |= 0x2000;
            } else if (v.toString().equals("lf")) {
                ecflags |= 0x4000;
            } else {
                if (v instanceof RubySymbol) {
                    RubySymbol sym = (RubySymbol)v;
                    throw Error.argumentError(context, "unexpected value for newline option: " + sym.to_s(context).toString());
                }
                throw Error.argumentError(context, "unexpected value for newline option");
            }
        }
        int setflags = 0;
        boolean newlineflag = false;
        v = ((RubyHash)opt).op_aref(context, Convert.asSymbol(context, "universal_newline"));
        if (v.isTrue()) {
            setflags |= 0x100;
        }
        newlineflag |= !v.isNil();
        v = ((RubyHash)opt).op_aref(context, Convert.asSymbol(context, "crlf_newline"));
        if (v.isTrue()) {
            setflags |= 0x1000;
        }
        newlineflag |= !v.isNil();
        v = ((RubyHash)opt).op_aref(context, Convert.asSymbol(context, "cr_newline"));
        if (v.isTrue()) {
            setflags |= 0x2000;
        }
        newlineflag |= !v.isNil();
        v = ((RubyHash)opt).op_aref(context, Convert.asSymbol(context, "lf_newline"));
        if (v.isTrue()) {
            setflags |= 0x4000;
        }
        if (newlineflag |= !v.isNil()) {
            ecflags &= 0xFFFF80FF;
            ecflags |= setflags;
        }
        return ecflags;
    }

    public static EConv econvOpenOpts(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags, IRubyObject opthash) {
        IRubyObject replacement2;
        block7: {
            RubyHash hash2;
            block9: {
                block8: {
                    block6: {
                        if (opthash != null && !opthash.isNil()) break block6;
                        replacement2 = context.nil;
                        break block7;
                    }
                    if (!(opthash instanceof RubyHash)) break block8;
                    hash2 = (RubyHash)opthash;
                    if (opthash.isFrozen()) break block9;
                }
                throw Error.runtimeError(context, "bug: EncodingUtils.econvOpenOpts called with invalid opthash");
            }
            replacement2 = hash2.op_aref(context, Convert.asSymbol(context, "replace"));
        }
        EConv ec = TranscoderDB.open((byte[])sourceEncoding, (byte[])destinationEncoding, (int)ecflags);
        if (ec == null) {
            return ec;
        }
        if (!replacement2.isNil()) {
            RubyString replStr = (RubyString)replacement2;
            ByteList replBL = replStr.getByteList();
            ec.makeReplacement();
            int ret = ec.setReplacement(replBL.getUnsafeBytes(), replBL.getBegin(), replBL.getRealSize(), replBL.getEncoding().getName());
            if (ret == -1) {
                ec.close();
                return null;
            }
        }
        return ec;
    }

    public static RaiseException econvOpenExc(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags) {
        String message2 = EncodingUtils.econvDescription(context, sourceEncoding, destinationEncoding, ecflags, "code converter not found (") + ")";
        return context.runtime.newConverterNotFoundError(message2);
    }

    public static String econvDescription(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags, String message2) {
        return message2 + new String(sourceEncoding) + " to " + new String(destinationEncoding);
    }

    public static Encoding econvAsciicompatEncoding(Encoding enc) {
        return RubyConverter.NONASCII_TO_ASCII.get(enc);
    }

    public static boolean encAsciicompat(Encoding enc) {
        return EncodingUtils.encMbminlen(enc) == 1 && !EncodingUtils.encDummy(enc);
    }

    public static int encAscget(byte[] pBytes, int p2, int e, int[] len, Encoding enc) {
        if (e <= p2) {
            return -1;
        }
        if (EncodingUtils.encAsciicompat(enc)) {
            int c = pBytes[p2] & 0xFF;
            if (!Encoding.isAscii((byte)((byte)c))) {
                return -1;
            }
            if (len != null) {
                len[0] = 1;
            }
            return c;
        }
        int l = StringSupport.preciseLength(enc, pBytes, p2, e);
        if (!StringSupport.MBCLEN_CHARFOUND_P(l)) {
            return -1;
        }
        int c = enc.mbcToCode(pBytes, p2, e);
        if (!Encoding.isAscii((int)c)) {
            return -1;
        }
        if (len != null) {
            len[0] = l;
        }
        return c;
    }

    public static int encMbminlen(Encoding encoding2) {
        return encoding2.minLength();
    }

    public static boolean encDummy(Encoding enc) {
        return enc.isDummy();
    }

    public static Encoding encGet(ThreadContext context, IRubyObject obj) {
        if (obj instanceof EncodingCapable) {
            return ((EncodingCapable)((Object)obj)).getEncoding();
        }
        return context.runtime.getDefaultInternalEncoding();
    }

    public static boolean encodingEqual(byte[] enc1, byte[] enc2) {
        return ByteList.memcmp(enc1, 0, enc1.length, enc2, 0, enc2.length) == 0;
    }

    public static Encoding encArg(ThreadContext context, IRubyObject encval, byte[][] name_p, Encoding[] enc_p) {
        Encoding enc = EncodingUtils.toEncodingIndex(context, encval);
        name_p[0] = enc == null ? encval.convertToString().getBytes() : enc.getName();
        enc_p[0] = enc;
        return enc_p[0];
    }

    public static Encoding toEncodingIndex(ThreadContext context, IRubyObject enc) {
        if (enc instanceof RubyEncoding) {
            RubyEncoding encoding2 = (RubyEncoding)enc;
            return encoding2.getEncoding();
        }
        if ((enc = enc.checkStringType()).isNil()) {
            return null;
        }
        if (!((RubyString)enc).getEncoding().isAsciiCompatible()) {
            return null;
        }
        return Access.encodingService(context).getEncodingFromObjectNoError(enc);
    }

    public static RubyString encodedDup(ThreadContext context, RubyString str, Encoding encindex, RubyString newstr) {
        if (encindex == null) {
            return (RubyString)str.dup();
        }
        if (newstr == str) {
            newstr = (RubyString)str.dup();
        } else {
            newstr.setMetaClass(str.getMetaClass());
        }
        newstr.modifyAndClearCodeRange();
        return EncodingUtils.strEncodeAssociate(newstr, encindex);
    }

    public static RubyString strEncodeAssociate(RubyString str, Encoding encidx) {
        EncodingUtils.encAssociateIndex(str, encidx);
        if (EncodingUtils.encAsciicompat(encidx)) {
            str.scanForCodeRange();
        } else {
            str.setCodeRange(32);
        }
        return str;
    }

    public static IRubyObject encAssociateIndex(IRubyObject obj, Encoding encidx) {
        ((RubyBasicObject)obj).checkFrozen();
        if (encidx == null) {
            encidx = ASCIIEncoding.INSTANCE;
        }
        if (((EncodingCapable)((Object)obj)).getEncoding() == encidx) {
            return obj;
        }
        if (obj instanceof RubyString && !CodeRangeSupport.isCodeRangeAsciiOnly((RubyString)obj) || EncodingUtils.encAsciicompat(encidx)) {
            ((RubyString)obj).clearCodeRange();
        }
        ((EncodingCapable)((Object)obj)).setEncoding(encidx);
        return obj;
    }

    public static IRubyObject strEncode(ThreadContext context, RubyString str) {
        return EncodingUtils.strTranscode(context, str, EncodingUtils::encodedDup);
    }

    public static IRubyObject strEncode(ThreadContext context, RubyString str, IRubyObject toEncoding) {
        return EncodingUtils.strTranscode(context, toEncoding, str, EncodingUtils::encodedDup);
    }

    public static IRubyObject strEncode(ThreadContext context, RubyString str, IRubyObject toEncoding, IRubyObject forcedEncoding) {
        return EncodingUtils.strTranscode(context, toEncoding, forcedEncoding, str, EncodingUtils::encodedDup);
    }

    public static IRubyObject strEncode(ThreadContext context, RubyString str, IRubyObject toEncoding, IRubyObject forcedEncoding, IRubyObject opts) {
        return EncodingUtils.strTranscode(context, toEncoding, forcedEncoding, opts, str, EncodingUtils::encodedDup);
    }

    public static IRubyObject rbStrEncode(ThreadContext context, IRubyObject str, IRubyObject to, int ecflags, IRubyObject ecopt) {
        return EncodingUtils.strTranscode1(context, to, (RubyString)str, ecflags, ecopt, EncodingUtils::encodedDup);
    }

    public static ByteList rbByteEncode(ThreadContext context, byte[] bytes2, int start2, int length2, Encoding encoding2, int cr, Encoding to, int ecflags, IRubyObject ecopt) {
        byte[] sname = encoding2.getName();
        byte[] dname = to.getName();
        if (EncodingUtils.noDecorators(ecflags)) {
            if (EncodingUtils.is7BitCompat(cr, encoding2, to)) {
                return null;
            }
            if (EncodingUtils.encodingEqual(sname, dname)) {
                return null;
            }
        } else if (EncodingUtils.encodingEqual(sname, dname)) {
            sname = NULL_BYTE_ARRAY;
            dname = NULL_BYTE_ARRAY;
        }
        int slen = length2;
        int blen = slen + 30;
        ByteList dest = new ByteList(blen, to);
        Ptr fromPos = new Ptr(start2);
        int destBegin = dest.getBegin();
        EncodingUtils.transcodeLoop(context, bytes2, fromPos, dest.unsafeBytes(), new Ptr(destBegin), start2 + slen, destBegin + blen, dest, strTranscodingResize, sname, dname, ecflags, ecopt);
        if (fromPos.p != start2 + slen) {
            throw Error.argumentError(context, "not fully converted, " + (slen - fromPos.p) + " bytes left");
        }
        dest.setEncoding(to);
        return dest;
    }

    protected static boolean noDecorators(int ecflags) {
        return (ecflags & 0x11FF00) == 0;
    }

    public static IRubyObject strTranscode(ThreadContext context, RubyString str, TranscodeResult result2) {
        return EncodingUtils.strTranscode0(context, str, 0, context.nil, result2);
    }

    public static IRubyObject strTranscode(ThreadContext context, IRubyObject toEncoding, RubyString str, TranscodeResult result2) {
        return EncodingUtils.strTranscode1(context, toEncoding, str, 0, context.nil, result2);
    }

    public static IRubyObject strTranscode(ThreadContext context, IRubyObject toEncoding, IRubyObject forcedEncoding, RubyString str, TranscodeResult result2) {
        return EncodingUtils.strTranscode2(context, toEncoding, forcedEncoding, str, 0, context.nil, result2);
    }

    public static IRubyObject strTranscode(ThreadContext context, IRubyObject toEncoding, IRubyObject forcedEncoding, IRubyObject opts, RubyString str, TranscodeResult result2) {
        IRubyObject tmp = TypeConverter.checkHashType(context.runtime, opts);
        if (tmp.isNil()) {
            throw Error.argumentError(context, 3, 0, 2);
        }
        IRubyObject[] ecopts_p = new IRubyObject[]{context.nil};
        int ecflags = EncodingUtils.econvPrepareOpts(context, tmp, ecopts_p);
        return EncodingUtils.strTranscode2(context, toEncoding, forcedEncoding, str, ecflags, ecopts_p[0], result2);
    }

    private static IRubyObject strTranscode0(ThreadContext context, RubyString str, int ecflags, IRubyObject ecopts, TranscodeResult result2) {
        IRubyObject toEncoding = Access.encodingService(context).getDefaultInternal();
        if (toEncoding == null || toEncoding.isNil()) {
            if (ecflags == 0) {
                return result2.apply(context, str, null, str);
            }
            toEncoding = EncodingUtils.objEncoding(context, str);
        }
        boolean explicitlyInvalidReplace = (ecflags & 0xF) != 0;
        return EncodingUtils.strTranscode(context, toEncoding, context.nil, str, ecflags |= 0x22, ecopts, result2, explicitlyInvalidReplace);
    }

    private static IRubyObject strTranscode1(ThreadContext context, IRubyObject toEncoding, RubyString str, int ecflags, IRubyObject ecopts, TranscodeResult result2) {
        IRubyObject tmp = TypeConverter.checkHashType(context.runtime, toEncoding);
        if (!tmp.isNil()) {
            IRubyObject[] ecopts_p = new IRubyObject[]{context.nil};
            ecflags = EncodingUtils.econvPrepareOpts(context, tmp, ecopts_p);
            return EncodingUtils.strTranscode0(context, str, ecflags, ecopts_p[0], result2);
        }
        return EncodingUtils.strTranscode(context, toEncoding, context.nil, str, ecflags, ecopts, result2, true);
    }

    private static IRubyObject strTranscode2(ThreadContext context, IRubyObject toEncoding, IRubyObject forceEncoding, RubyString str, int ecflags, IRubyObject ecopts, TranscodeResult result2) {
        IRubyObject tmp = TypeConverter.checkHashType(context.runtime, forceEncoding);
        if (!tmp.isNil()) {
            IRubyObject[] ecopts_p = new IRubyObject[]{context.nil};
            ecflags = EncodingUtils.econvPrepareOpts(context, tmp, ecopts_p);
            return EncodingUtils.strTranscode1(context, toEncoding, str, ecflags, ecopts_p[0], result2);
        }
        return EncodingUtils.strTranscode(context, toEncoding, forceEncoding, str, ecflags, ecopts, result2, true);
    }

    private static RubyString strTranscode(ThreadContext context, IRubyObject toEncoding, IRubyObject forceEncoding, RubyString str, int ecflags, IRubyObject ecopts, TranscodeResult result2, boolean explicitlyInvalidReplace) {
        ByteList sp;
        byte[] sname;
        Encoding denc = EncodingUtils.toEncodingIndex(context, toEncoding);
        byte[] dname = denc == null ? toEncoding.convertToString().getBytes() : denc.getName();
        Encoding senc = forceEncoding.isNil() ? EncodingUtils.encGet(context, str) : EncodingUtils.toEncodingIndex(context, forceEncoding);
        byte[] byArray = sname = senc == null ? forceEncoding.convertToString().getBytes() : senc.getName();
        if (EncodingUtils.noDecorators(ecflags)) {
            if (senc != null && senc == denc) {
                return EncodingUtils.strTranscodeScrub(context, forceEncoding, str, ecflags, ecopts, result2, explicitlyInvalidReplace, denc, senc);
            }
            if (EncodingUtils.is7BitCompat(str, denc, senc)) {
                return result2.apply(context, str, denc, str);
            }
            if (EncodingUtils.encodingEqual(sname, dname)) {
                if (forceEncoding.isNil()) {
                    denc = null;
                }
                return result2.apply(context, str, denc, str);
            }
        } else if (EncodingUtils.encodingEqual(sname, dname)) {
            sname = NULL_BYTE_ARRAY;
            dname = NULL_BYTE_ARRAY;
        }
        ByteList fromp = sp = str.getByteList();
        int slen = str.size();
        int blen = slen + 30;
        RubyString dest = RubyString.newStringLight(context.runtime, blen);
        ByteList destp = dest.getByteList();
        byte[] frompBytes = fromp.unsafeBytes();
        byte[] destpBytes = destp.unsafeBytes();
        Ptr frompPos = new Ptr(fromp.getBegin());
        Ptr destpPos = new Ptr(destp.getBegin());
        EncodingUtils.transcodeLoop(context, frompBytes, frompPos, destpBytes, destpPos, frompPos.p + slen, destpPos.p + blen, destp, strTranscodingResize, sname, dname, ecflags, ecopts);
        if (frompPos.p != sp.begin() + slen) {
            throw Error.argumentError(context, "not fully converted, " + (slen - frompPos.p) + " bytes left");
        }
        if (denc == null) {
            denc = EncodingUtils.defineDummyEncoding(context, dname);
        }
        return result2.apply(context, str, denc, dest);
    }

    private static boolean is7BitCompat(RubyString str, Encoding denc, Encoding senc) {
        return senc != null && denc != null && senc.isAsciiCompatible() && denc.isAsciiCompatible() && str.scanForCodeRange() == 16;
    }

    private static boolean is7BitCompat(int cr, Encoding denc, Encoding senc) {
        return senc != null && denc != null && senc.isAsciiCompatible() && denc.isAsciiCompatible() && cr == 16;
    }

    private static RubyString strTranscodeScrub(ThreadContext context, IRubyObject forceEncoding, RubyString str, int ecflags, IRubyObject ecopts, TranscodeResult result2, boolean explicitlyInvalidReplace, Encoding denc, Encoding senc) {
        RubyString dest = str;
        if ((ecflags & 0xF) != 0 && explicitlyInvalidReplace) {
            IRubyObject scrubbed;
            IRubyObject rep = context.nil;
            if (!ecopts.isNil()) {
                rep = ((RubyHash)ecopts).op_aref(context, Convert.asSymbol(context, "replace"));
            }
            if (!(scrubbed = str.encStrScrub(context, senc, rep, Block.NULL_BLOCK)).isNil()) {
                dest = (RubyString)scrubbed;
            }
        } else if (forceEncoding.isNil()) {
            denc = null;
        }
        return result2.apply(context, str, denc, dest);
    }

    public static IRubyObject objEncoding(ThreadContext context, IRubyObject obj) {
        Encoding enc = EncodingUtils.encGet(context, obj);
        if (enc == null) {
            throw Error.typeError(context, "unknown encoding");
        }
        return Access.encodingService(context).convertEncodingToRubyEncoding(enc);
    }

    public static Encoding strTranscodeEncArgs(ThreadContext context, IRubyObject str, IRubyObject arg1, IRubyObject arg2, byte[][] sname_p, Encoding[] senc_p, byte[][] dname_p, Encoding[] denc_p) {
        Encoding dencindex = EncodingUtils.encArg(context, arg1, dname_p, denc_p);
        if (arg2.isNil()) {
            senc_p[0] = EncodingUtils.encGet(context, str);
            sname_p[0] = senc_p[0].getName();
        } else {
            EncodingUtils.encArg(context, arg2, sname_p, senc_p);
        }
        return dencindex;
    }

    public static boolean encRegistered(byte[] name2) {
        return EncodingDB.getEncodings().get(name2) != null;
    }

    public static void encCheckDuplication(ThreadContext context, byte[] name2) {
        if (EncodingUtils.encRegistered(name2)) {
            throw Error.argumentError(context, "encoding " + new String(name2) + " is already registered");
        }
    }

    public static Encoding encReplicate(ThreadContext context, byte[] name2, Encoding encoding2) {
        EncodingUtils.encCheckDuplication(context, name2);
        EncodingDB.replicate((String)new String(name2), (String)new String(encoding2.getName()));
        return ((EncodingDB.Entry)EncodingDB.getEncodings().get(name2)).getEncoding();
    }

    public static Encoding defineDummyEncoding(ThreadContext context, byte[] name2) {
        Encoding dummy = EncodingUtils.encReplicate(context, name2, EncodingUtils.ascii8bitEncoding(context.runtime));
        return dummy;
    }

    public static boolean DECORATOR_P(byte[] sname, byte[] dname) {
        return sname == null || sname.length == 0 || sname[0] == 0;
    }

    public static ByteList strConvEncOpts(ThreadContext context, ByteList str, Encoding fromEncoding, Encoding toEncoding, int ecflags, IRubyObject ecopts) {
        return EncodingUtils.strConvEncOpts(context, Create.newString(context, str), fromEncoding, toEncoding, ecflags, ecopts).getByteList();
    }

    public static RubyString strConvEncOpts(ThreadContext context, RubyString str, Encoding fromEncoding, Encoding toEncoding, int ecflags, IRubyObject ecopts) {
        if (toEncoding == null) {
            return str;
        }
        if (fromEncoding == null) {
            fromEncoding = str.getEncoding();
        }
        if (fromEncoding == toEncoding) {
            return str;
        }
        if (toEncoding.isAsciiCompatible() && str.isAsciiOnly() || toEncoding == ASCIIEncoding.INSTANCE) {
            if (str.getEncoding() != toEncoding) {
                str = (RubyString)str.dup();
                str.setEncoding(toEncoding);
            }
            return str;
        }
        ByteList strByteList = str.getByteList();
        int len = strByteList.getRealSize();
        ByteList newStr = new ByteList(len);
        int olen = len;
        EConv ec = EncodingUtils.econvOpenOpts(context, fromEncoding.getName(), toEncoding.getName(), ecflags, ecopts);
        if (ec == null) {
            return str;
        }
        byte[] sbytes = strByteList.getUnsafeBytes();
        Ptr sp = new Ptr(strByteList.getBegin());
        int start2 = sp.p;
        Ptr dp = new Ptr(0);
        int convertedOutput = 0;
        byte[] destbytes = newStr.getUnsafeBytes();
        int dest = newStr.begin();
        dp.p = dest + convertedOutput;
        EConvResult ret = ec.convert(sbytes, sp, start2 + len, destbytes, dp, dest + olen, 0);
        while (ret == EConvResult.DestinationBufferFull) {
            int convertedInput = sp.p - start2;
            int rest = len - convertedInput;
            convertedOutput = dp.p - dest;
            newStr.setRealSize(convertedOutput);
            rest = convertedInput != 0 && convertedOutput != 0 && rest < Integer.MAX_VALUE / convertedOutput ? rest * convertedOutput / convertedInput : olen;
            newStr.ensure(olen += rest < 2 ? 2 : rest);
            destbytes = newStr.getUnsafeBytes();
            dest = newStr.begin();
            dp.p = dest + convertedOutput;
            ret = ec.convert(sbytes, sp, start2 + len, destbytes, dp, dest + olen, 0);
        }
        ec.close();
        switch (ret) {
            case Finished: {
                len = dp.p;
                newStr.setRealSize(len);
                newStr.setEncoding(toEncoding);
                return Create.newString(context, newStr);
            }
        }
        return str;
    }

    public static RubyString strConvEnc(ThreadContext context, RubyString value2, Encoding fromEncoding, Encoding toEncoding) {
        return EncodingUtils.strConvEncOpts(context, value2, fromEncoding, toEncoding, 0, context.nil);
    }

    public static ByteList strConvEnc(ThreadContext context, ByteList value2, Encoding fromEncoding, Encoding toEncoding) {
        return EncodingUtils.strConvEncOpts(context, value2, fromEncoding, toEncoding, 0, context.nil);
    }

    public static RubyString setStrBuf(Ruby runtime2, IRubyObject obj, int len) {
        RubyString str;
        if (obj == null || obj.isNil()) {
            str = RubyString.newStringLight(runtime2, len);
        } else {
            str = obj.convertToString();
            int clen = str.size();
            if (clen >= len) {
                str.modifyAndClearCodeRange();
                return str;
            }
            str.modifyExpand(len);
        }
        return str;
    }

    public static List<String> encodingNames(byte[] name2, int p2, int end2) {
        ASCIIEncoding enc = ASCIIEncoding.INSTANCE;
        int s2 = p2;
        int code = name2[s2] & 0xFF;
        if (enc.isDigit(code)) {
            return Collections.EMPTY_LIST;
        }
        boolean hasUpper = false;
        boolean hasLower = false;
        if (enc.isUpper(code)) {
            hasUpper = true;
            while (++s2 < end2 && (enc.isAlnum(name2[s2] & 0xFF) || name2[s2] == 95)) {
                if (!enc.isLower(name2[s2] & 0xFF)) continue;
                hasLower = true;
            }
        }
        ArrayList<String> names2 = new ArrayList<String>(4);
        boolean isValid = false;
        if (s2 >= end2) {
            isValid = true;
            names2.add(new String(name2, p2, end2));
        }
        if (!isValid || hasLower) {
            if (!hasLower || !hasUpper) {
                do {
                    if (enc.isLower(code = name2[s2] & 0xFF)) {
                        hasLower = true;
                    }
                    if (!enc.isUpper(code)) continue;
                    hasUpper = true;
                } while (++s2 < end2 && (!hasLower || !hasUpper));
            }
            byte[] constName = new byte[end2 - p2];
            System.arraycopy(name2, p2, constName, 0, end2 - p2);
            s2 = 0;
            code = constName[s2] & 0xFF;
            if (!isValid) {
                if (enc.isLower(code)) {
                    constName[s2] = AsciiTables.ToUpperCaseTable[code];
                }
                while (s2 < constName.length) {
                    if (!enc.isAlnum(constName[s2] & 0xFF)) {
                        constName[s2] = 95;
                    }
                    ++s2;
                }
                if (hasUpper) {
                    names2.add(new String(constName, 0, constName.length));
                }
            }
            if (hasLower) {
                for (s2 = 0; s2 < constName.length; ++s2) {
                    code = constName[s2] & 0xFF;
                    if (!enc.isLower(code)) continue;
                    constName[s2] = AsciiTables.ToUpperCaseTable[code];
                }
                names2.add(new String(constName, 0, constName.length));
            }
        }
        return names2;
    }

    public static void transcodeLoop(ThreadContext context, byte[] inBytes, Ptr inPos, byte[] outBytes, Ptr outPos, int inStop, int _outStop, ByteList destination, ResizeFunction resizeFunction, byte[] sname, byte[] dname, int ecflags, IRubyObject ecopts) {
        boolean success;
        IRubyObject fallback = context.nil;
        AbstractTranscodeFallback fallbackFunc = null;
        EConv ec = EncodingUtils.econvOpenOpts(context, sname, dname, ecflags, ecopts);
        if (ec == null) {
            throw EncodingUtils.econvOpenExc(context, sname, dname, ecflags);
        }
        if (!ecopts.isNil() && ecopts instanceof RubyHash && !(fallback = ((RubyHash)ecopts).op_aref(context, Convert.asSymbol(context, "fallback"))).isNil()) {
            fallbackFunc = fallback instanceof RubyHash ? HASH_FALLBACK : (fallback instanceof RubyProc ? PROC_FALLBACK : (fallback instanceof RubyMethod ? METHOD_FALLBACK : AREF_FALLBACK));
        }
        if (!(success = EncodingUtils.transcodeLoop(ec, fallbackFunc, context, fallback, inBytes, inPos, outBytes, outPos, inStop, _outStop, destination, resizeFunction))) {
            RaiseException re = EncodingUtils.makeEconvException(context, ec);
            ec.close();
            throw re;
        }
    }

    public static ByteList transcodeString(String string2, Encoding toEncoding, int ecflags) {
        ByteList destination;
        int inStop;
        Ptr outPos;
        int outStop;
        byte[] outBytes;
        Ptr inPos;
        byte[] inBytes;
        Encoding encoding2 = EncodingUtils.getUTF16ForPlatform();
        EConv ec = TranscoderDB.open((byte[])encoding2.getName(), (byte[])toEncoding.getName(), (int)ecflags);
        boolean success = EncodingUtils.transcodeLoop(ec, null, null, null, inBytes = string2.getBytes(EncodingUtils.charsetForEncoding(encoding2)), inPos = new Ptr(0), outBytes = new byte[outStop = (int)((double)inBytes.length / 1.5 + 1.0)], outPos = new Ptr(0), inStop = inBytes.length, outStop, destination = new ByteList(outBytes, toEncoding, false), strTranscodingResize);
        if (!success) {
            // empty if block
        }
        return destination;
    }

    public static Encoding getUTF16ForPlatform() {
        Object encoding2 = Platform.BYTE_ORDER == 1234 ? UTF16LEEncoding.INSTANCE : UTF16BEEncoding.INSTANCE;
        return encoding2;
    }

    public static <Data> boolean transcodeLoop(EConv ec, TranscodeFallback<Data> fallbackFunc, ThreadContext context, Data fallbackData, byte[] inBytes, Ptr inPos, byte[] outBytes, Ptr outPos, int inStop, int outStop, ByteList destination, ResizeFunction resizeFunction) {
        Ptr outstopPos = new Ptr(outStop);
        Transcoding lastTC = ec.lastTranscoding;
        int maxOutput = lastTC != null ? lastTC.transcoder.maxOutput : 1;
        Ptr outStart = new Ptr(outPos.p);
        while (true) {
            EConvResult ret = ec.convert(inBytes, inPos, inStop, outBytes, outPos, outstopPos.p, 0);
            if (fallbackFunc != null && ret == EConvResult.UndefinedConversion && fallbackFunc.call(context, fallbackData, ec)) continue;
            if (ret == EConvResult.InvalidByteSequence || ret == EConvResult.IncompleteInput || ret == EConvResult.UndefinedConversion) {
                RaiseException exc = EncodingUtils.makeEconvException(context, ec);
                ec.close();
                destination.setRealSize(outPos.p);
                throw exc;
            }
            if (ret != EConvResult.DestinationBufferFull) break;
            EncodingUtils.moreOutputBuffer(destination, resizeFunction, maxOutput, outStart, outPos, outstopPos);
            outBytes = destination.getUnsafeBytes();
        }
        ec.close();
        destination.setRealSize(outPos.p);
        return true;
    }

    @Deprecated(since="10.0.0.0")
    public static RaiseException makeEconvException(Ruby runtime2, EConv ec) {
        return EncodingUtils.makeEconvException(runtime2.getCurrentContext(), ec);
    }

    public static RaiseException makeEconvException(ThreadContext context, EConv ec) {
        EConvResult result2 = ec.lastError.getResult();
        if (result2 == EConvResult.InvalidByteSequence || result2 == EConvResult.IncompleteInput) {
            byte[] errBytes = ec.lastError.getErrorBytes();
            int errBytesP = ec.lastError.getErrorBytesP();
            int errorLen = ec.lastError.getErrorBytesLength();
            RubyString bytes2 = Create.newString(context, new ByteList(errBytes, errBytesP, errorLen - errBytesP));
            RubyString dumped = (RubyString)bytes2.dump(context);
            int readagainLen = ec.lastError.getReadAgainLength();
            IRubyObject bytes22 = context.nil;
            StringBuilder mesg = new StringBuilder();
            if (result2 == EConvResult.IncompleteInput) {
                mesg.append("incomplete ").append(dumped).append(" on ").append(new String(ec.lastError.getSource()));
            } else if (readagainLen != 0) {
                bytes22 = Create.newString(context, new ByteList(errBytes, errorLen + errBytesP, ec.lastError.getReadAgainLength()));
                IRubyObject dumped2 = ((RubyString)bytes22).dump(context);
                mesg.append(dumped).append(" followed by ").append(dumped2).append(" on ").append(new String(ec.lastError.getSource()));
            } else {
                mesg.append(dumped).append(" on ").append(new String(ec.lastError.getSource()));
            }
            RaiseException exc = context.runtime.newInvalidByteSequenceError(mesg.toString());
            exc.getException().setInternalVariable("error_bytes", bytes2);
            exc.getException().setInternalVariable("readagain_bytes", bytes22);
            exc.getException().setInternalVariable("incomplete_input", Convert.asBoolean(context, result2 == EConvResult.IncompleteInput));
            return EncodingUtils.makeEConvExceptionSetEncs(context, exc, ec);
        }
        if (result2 == EConvResult.UndefinedConversion) {
            int codepoint;
            byte[] errBytes = ec.lastError.getErrorBytes();
            int errBytesP = ec.lastError.getErrorBytesP();
            int errorLen = ec.lastError.getErrorBytesLength();
            byte[] errSource = ec.lastError.getSource();
            RubyString bytes3 = Create.newString(context, new ByteList(errBytes, errBytesP, errorLen - errBytesP));
            String charRepresentation = Arrays.equals(errSource, "UTF-8".getBytes()) ? ((codepoint = StringSupport.preciseCodePoint((Encoding)UTF8Encoding.INSTANCE, errBytes, errBytesP, errBytesP + errorLen)) >= 0 ? String.format("U+%04X", codepoint) : ((RubyString)bytes3.dump(context)).toString()) : ((RubyString)bytes3.dump(context)).toString();
            StringBuilder mesg = new StringBuilder();
            if (Arrays.equals(errSource, ec.source) && Arrays.equals(ec.lastError.getDestination(), ec.destination)) {
                mesg.append(charRepresentation).append(" from ").append(new String(errSource)).append(" to ").append(new String(ec.lastError.getDestination()));
            } else {
                mesg.append(charRepresentation).append(" to ").append(new String(ec.lastError.getDestination())).append(" in conversion from ").append(new String(ec.source));
                for (int i2 = 0; i2 < ec.numTranscoders; ++i2) {
                    mesg.append(" to ").append(new String(ec.elements[i2].transcoding.transcoder.getDestination()));
                }
            }
            RaiseException exc = context.runtime.newUndefinedConversionError(mesg.toString());
            EncodingDB.Entry entry = Access.encodingService(context).findEncodingOrAliasEntry(errSource);
            if (entry != null) {
                bytes3.setEncoding(entry.getEncoding());
                exc.getException().setInternalVariable("error_char", bytes3);
            }
            return EncodingUtils.makeEConvExceptionSetEncs(context, exc, ec);
        }
        return null;
    }

    private static RaiseException makeEConvExceptionSetEncs(ThreadContext context, RaiseException exc, EConv ec) {
        exc.getException().setInternalVariable("source_encoding_name", Create.newString(context, ec.lastError.getSource()));
        exc.getException().setInternalVariable("destination_encoding_name", Create.newString(context, ec.lastError.getDestination()));
        EncodingService encodingService = Access.encodingService(context);
        EncodingDB.Entry entry = encodingService.findEncodingOrAliasEntry(ec.lastError.getSource());
        if (entry != null) {
            exc.getException().setInternalVariable("source_encoding", encodingService.convertEncodingToRubyEncoding(entry.getEncoding()));
        }
        if ((entry = encodingService.findEncodingOrAliasEntry(ec.lastError.getDestination())) != null) {
            exc.getException().setInternalVariable("destination_encoding", encodingService.convertEncodingToRubyEncoding(entry.getEncoding()));
        }
        return exc;
    }

    static void moreOutputBuffer(ByteList destination, ResizeFunction resizeDestination, int maxOutput, Ptr outStart, Ptr outPos, Ptr outStop) {
        int len = outPos.p - outStart.p;
        int newLen = (len + maxOutput) * 2;
        outStart.p = resizeDestination.resize(destination, len, newLen);
        outPos.p = outStart.p + len;
        outStop.p = outStart.p + newLen;
    }

    public static Encoding ioSetEncodingByBOM(ThreadContext context, RubyIO io2) {
        Encoding bomEncoding = EncodingUtils.ioStripBOM(context, io2);
        if (bomEncoding != null) {
            RubyEncoding theBom = Access.encodingService(context).getEncoding(bomEncoding);
            IRubyObject theInternal = io2.internal_encoding(context);
            io2.setEncoding(context, theBom, theInternal, context.nil);
        } else {
            io2.setEnc2(null);
        }
        return bomEncoding;
    }

    public static Encoding ioStripBOM(ThreadContext context, RubyIO io2) {
        if ((io2.getOpenFile().getMode() & 1) == 0) {
            return null;
        }
        IRubyObject b1Arg = io2.getbyte(context);
        if (b1Arg.isNil()) {
            return null;
        }
        RubyFixnum b1 = (RubyFixnum)b1Arg;
        switch ((int)b1.getValue()) {
            case 239: {
                IRubyObject b3;
                IRubyObject b2 = io2.getbyte(context);
                if (b2.isNil()) break;
                if (((RubyFixnum)b2).getValue() == 187L && !(b3 = io2.getbyte(context)).isNil()) {
                    if (((RubyFixnum)b3).getValue() == 191L) {
                        return UTF8Encoding.INSTANCE;
                    }
                    io2.ungetbyte(context, b3);
                }
                io2.ungetbyte(context, b2);
                break;
            }
            case 254: {
                IRubyObject b2 = io2.getbyte(context);
                if (b2.isNil()) break;
                if (((RubyFixnum)b2).asLong(context) == 255L) {
                    return UTF16BEEncoding.INSTANCE;
                }
                io2.ungetbyte(context, b2);
                break;
            }
            case 255: {
                IRubyObject b2 = io2.getbyte(context);
                if (b2.isNil()) break;
                if (((RubyFixnum)b2).asLong(context) == 254L) {
                    IRubyObject b4;
                    RubyFixnum b3fix;
                    IRubyObject b3 = io2.getbyte(context);
                    if (b3 instanceof RubyFixnum && (b3fix = (RubyFixnum)b3).asLong(context) == 0L && !(b4 = io2.getbyte(context)).isNil()) {
                        if (((RubyFixnum)b4).getValue() == 0L) {
                            return UTF32LEEncoding.INSTANCE;
                        }
                    } else {
                        io2.ungetbyte(context, b3);
                        return UTF16LEEncoding.INSTANCE;
                    }
                    io2.ungetbyte(context, b4);
                    io2.ungetbyte(context, b3);
                }
                io2.ungetbyte(context, b2);
                break;
            }
            case 0: {
                IRubyObject b3;
                IRubyObject b2 = io2.getbyte(context);
                if (b2.isNil()) break;
                if (((RubyFixnum)b2).getValue() == 0L && !(b3 = io2.getbyte(context)).isNil()) {
                    IRubyObject b4;
                    if (((RubyFixnum)b3).getValue() == 254L && !(b4 = io2.getbyte(context)).isNil()) {
                        if (((RubyFixnum)b4).getValue() == 255L) {
                            return UTF32BEEncoding.INSTANCE;
                        }
                        io2.ungetbyte(context, b4);
                    }
                    io2.ungetbyte(context, b3);
                }
                io2.ungetbyte(context, b2);
            }
        }
        io2.ungetbyte(context, b1);
        return null;
    }

    public static void validateEncodingBinmode(ThreadContext context, int[] fmode_p, int ecflags, IOEncodable ioEncodable) {
        int fmode = fmode_p[0];
        if ((fmode & 1) != 0 && ioEncodable.getEnc2() == null && (fmode & 4) == 0 && !(ioEncodable.getEnc() != null ? ioEncodable.getEnc() : context.runtime.getDefaultExternalEncoding()).isAsciiCompatible()) {
            throw Error.argumentError(context, "ASCII incompatible encoding needs binmode");
        }
        if ((fmode & 4) != 0 && (ecflags & 0x7F00) != 0) {
            throw Error.argumentError(context, "newline decorator with binary mode");
        }
        if ((fmode & 4) == 0 && (DEFAULT_TEXTMODE != 0 || (ecflags & 0x7F00) != 0)) {
            fmode_p[0] = fmode |= 0x1000;
        } else if (DEFAULT_TEXTMODE == 0 && (ecflags & 0x7F00) == 0) {
            fmode_p[0] = fmode &= 0xFFFFEFFF;
        }
    }

    public static void rbEncSetDefaultExternal(ThreadContext context, IRubyObject encoding2) {
        if (encoding2.isNil()) {
            throw Error.argumentError(context, "default external can not be nil");
        }
        EncodingUtils.encSetDefaultEncoding(context, context.runtime.getDefaultExternalEncoding(), encoding2, "external", (ctx, enc) -> ctx.runtime.setDefaultExternalEncoding((Encoding)enc));
    }

    public static void rbEncSetDefaultInternal(ThreadContext context, IRubyObject encoding2) {
        EncodingUtils.encSetDefaultEncoding(context, context.runtime.getDefaultInternalEncoding(), encoding2, "internal", (ctx, enc) -> ctx.runtime.setDefaultInternalEncoding((Encoding)enc));
    }

    static boolean encSetDefaultEncoding(ThreadContext context, Encoding defaultEncoding, IRubyObject encoding2, String name2, BiConsumer<ThreadContext, Encoding> setter) {
        boolean overridden = false;
        if (defaultEncoding != null) {
            overridden = true;
        }
        if (encoding2.isNil()) {
            setter.accept(context, null);
        } else {
            setter.accept(context, EncodingUtils.rbToEncoding(context, encoding2));
        }
        if (name2.equals("external")) {
            context.runtime.setDefaultFilesystemEncoding(EncodingUtils.rbToEncoding(context, encoding2));
        }
        return overridden;
    }

    public static Encoding defaultExternalEncoding(Ruby runtime2) {
        if (runtime2.getDefaultExternalEncoding() != null) {
            return runtime2.getDefaultExternalEncoding();
        }
        return runtime2.getEncodingService().getLocaleEncoding();
    }

    public static void rbStrBufCat(Ruby runtime2, RubyString str, ByteList ptr) {
        if (ptr.length() == 0) {
            return;
        }
        EncodingUtils.strBufCat(runtime2, str, ptr);
    }

    public static void rbStrBufCat(Ruby runtime2, ByteListHolder str, byte[] ptrBytes, int ptr, int len) {
        if (len == 0) {
            return;
        }
        EncodingUtils.strBufCat(runtime2, str, ptrBytes, ptr, len);
    }

    public static void rbStrBufCat(Ruby runtime2, ByteList str, byte[] ptrBytes, int ptr, int len) {
        if (len == 0) {
            return;
        }
        EncodingUtils.strBufCat(str, ptrBytes, ptr, len);
    }

    public static void strBufCat(Ruby runtime2, RubyString str, ByteList ptr) {
        EncodingUtils.strBufCat(runtime2, str, ptr.getUnsafeBytes(), ptr.getBegin(), ptr.getRealSize());
    }

    public static void strBufCat(Ruby runtime2, ByteListHolder str, byte[] ptrBytes, int ptr, int len) {
        str.modify();
        EncodingUtils.strBufCat(str.getByteList(), ptrBytes, ptr, len);
    }

    public static void strBufCat(ByteList str, byte[] ptrBytes, int ptr, int len) {
        int off = -1;
        if (len == 0) {
            return;
        }
        int total2 = str.getRealSize() + len;
        str.ensure(total2);
        str.append(ptrBytes, ptr, len);
    }

    public static void encStrBufCat(Ruby runtime2, RubyString str, ByteList ptr, Encoding enc) {
        EncodingUtils.encCrStrBufCat(runtime2, str, ptr.getUnsafeBytes(), ptr.getBegin(), ptr.getRealSize(), enc, 0);
    }

    public static void encStrBufCat(Ruby runtime2, RubyString str, ByteList ptr) {
        EncodingUtils.encCrStrBufCat(runtime2, str, ptr.getUnsafeBytes(), ptr.getBegin(), ptr.getRealSize(), ptr.getEncoding(), 0);
    }

    public static void encStrBufCat(Ruby runtime2, RubyString str, byte[] ptrBytes) {
        EncodingUtils.encCrStrBufCat(runtime2, str, ptrBytes, 0, ptrBytes.length, (Encoding)USASCIIEncoding.INSTANCE, 0);
    }

    public static void encStrBufCat(Ruby runtime2, RubyString str, byte[] ptrBytes, Encoding enc) {
        EncodingUtils.encCrStrBufCat(runtime2, str, ptrBytes, 0, ptrBytes.length, enc, 0);
    }

    public static void encStrBufCat(Ruby runtime2, RubyString str, byte[] ptrBytes, int ptr, int len, Encoding enc) {
        EncodingUtils.encCrStrBufCat(runtime2, str, ptrBytes, ptr, len, enc, 0);
    }

    public static void encStrBufCat(Ruby runtime2, RubyString str, CharSequence cseq) {
        byte[] utf8 = RubyEncoding.encodeUTF8(cseq.toString());
        EncodingUtils.encCrStrBufCat(runtime2, str, utf8, 0, utf8.length, (Encoding)UTF8Encoding.INSTANCE, 0);
    }

    public static int encCrStrBufCat(Ruby runtime2, CodeRangeable str, ByteList ptr, Encoding ptrEnc, int ptr_cr) {
        return EncodingUtils.encCrStrBufCat(runtime2, str, ptr.getUnsafeBytes(), ptr.getBegin(), ptr.getRealSize(), ptrEnc, ptr_cr);
    }

    public static int encCrStrBufCat(Ruby runtime2, CodeRangeable str, byte[] ptrBytes, int ptr, int len, Encoding ptrEnc, int ptr_cr) {
        int res_cr;
        Encoding resEnc;
        int str_cr;
        Encoding strEnc = str.getByteList().getEncoding();
        boolean incompatible = false;
        int n = str_cr = str.getByteList().getRealSize() > 0 ? str.getCodeRange() : 16;
        if (strEnc == ptrEnc) {
            if (str_cr == 0) {
                ptr_cr = 0;
            } else if (ptr_cr == 0) {
                ptr_cr = StringSupport.codeRangeScan(ptrEnc, ptrBytes, ptr, len);
            }
        } else {
            if (!EncodingUtils.encAsciicompat(strEnc) || !EncodingUtils.encAsciicompat(ptrEnc)) {
                if (len == 0) {
                    return ptr_cr;
                }
                if (str.getByteList().getRealSize() == 0) {
                    EncodingUtils.strBufCat(runtime2, str, ptrBytes, ptr, len);
                    str.getByteList().setEncoding(ptrEnc);
                    str.setCodeRange(ptr_cr);
                    return ptr_cr;
                }
                incompatible = true;
            }
            if (!incompatible) {
                if (ptr_cr == 0) {
                    ptr_cr = StringSupport.codeRangeScan(ptrEnc, ptrBytes, ptr, len);
                }
                if (str_cr == 0 && (strEnc == ASCIIEncoding.INSTANCE || ptr_cr != 16)) {
                    str_cr = str.scanForCodeRange();
                }
            }
        }
        if (incompatible || strEnc != ptrEnc && str_cr != 16 && ptr_cr != 16) {
            throw runtime2.newEncodingCompatibilityError("incompatible encodings: " + String.valueOf(strEnc) + " and " + String.valueOf(ptrEnc));
        }
        if (str_cr == 0) {
            resEnc = strEnc;
            res_cr = 0;
        } else if (str_cr == 16) {
            if (ptr_cr == 16) {
                resEnc = strEnc;
                res_cr = 16;
            } else {
                resEnc = ptrEnc;
                res_cr = ptr_cr;
            }
        } else if (str_cr == 32) {
            resEnc = strEnc;
            res_cr = ptr_cr == 16 || ptr_cr == 32 ? str_cr : ptr_cr;
        } else {
            resEnc = strEnc;
            res_cr = str_cr;
            if (0 < len) {
                res_cr = 0;
            }
        }
        EncodingUtils.strBufCat(runtime2, str, ptrBytes, ptr, len);
        str.getByteList().setEncoding(resEnc);
        str.setCodeRange(res_cr);
        return ptr_cr;
    }

    public static void econvArgs(ThreadContext context, IRubyObject[] args2, byte[][] encNames, Encoding[] encs, int[] ecflags_p, IRubyObject[] ecopts_p) {
        IRubyObject snamev = context.nil;
        IRubyObject dnamev = context.nil;
        IRubyObject flags2 = context.nil;
        IRubyObject opt = context.nil;
        switch (args2.length) {
            case 3: {
                flags2 = args2[2];
            }
            case 2: {
                dnamev = args2[1];
            }
            case 1: {
                snamev = args2[0];
            }
        }
        IRubyObject tmp = TypeConverter.checkHashType(context.runtime, flags2);
        if (!tmp.isNil()) {
            opt = tmp;
            flags2 = context.nil;
        }
        if (!flags2.isNil()) {
            if (!opt.isNil()) {
                throw Error.argumentError(context, args2.length, 3);
            }
            ecflags_p[0] = Convert.toInt(context, flags2);
            ecopts_p[0] = context.nil;
        } else if (!opt.isNil()) {
            ecflags_p[0] = EncodingUtils.econvPrepareOpts(context, opt, ecopts_p);
        } else {
            ecflags_p[0] = 0;
            ecopts_p[0] = context.nil;
        }
        EncodingService encodingService = Access.encodingService(context);
        encs[0] = encodingService.getEncodingFromObjectNoError(snamev);
        if (encs[0] == null) {
            snamev = snamev.convertToString();
        }
        encs[1] = encodingService.getEncodingFromObjectNoError(dnamev);
        if (encs[1] == null) {
            dnamev = dnamev.convertToString();
        }
        encNames[0] = encs[0] != null ? encs[0].getName() : ((RubyString)snamev).getBytes();
        encNames[1] = encs[1] != null ? encs[1].getName() : ((RubyString)dnamev).getBytes();
    }

    public static EConv econvInitByConvpath(ThreadContext context, IRubyObject convpathArg, byte[][] encNames, Encoding[] encs) {
        final EConv ec = TranscoderDB.alloc((int)convpathArg.convertToArray().size());
        IRubyObject[] sname_v = new IRubyObject[]{context.nil};
        IRubyObject[] dname_v = new IRubyObject[]{context.nil};
        byte[][] sname = new byte[][]{null};
        byte[][] dname = new byte[][]{null};
        Encoding[] senc = new Encoding[]{null};
        Encoding[] denc = new Encoding[]{null};
        boolean first2 = true;
        RubyArray convpath2 = (RubyArray)convpathArg;
        for (int i2 = 0; i2 < convpath2.size(); ++i2) {
            Object elt = convpath2.eltOk(i2);
            IRubyObject pair = elt.checkArrayType();
            if (!pair.isNil()) {
                if (((RubyArray)pair).size() != 2) {
                    throw Error.argumentError(context, "not a 2-element array in convpath");
                }
                sname_v[0] = ((RubyArray)pair).eltOk(0L);
                EncodingUtils.encArg(context, sname_v[0], sname, senc);
                dname_v[0] = ((RubyArray)pair).eltOk(1L);
                EncodingUtils.encArg(context, dname_v[0], dname, denc);
            } else {
                sname[0] = NULL_BYTE_ARRAY;
                dname[0] = elt.convertToString().getBytes();
            }
            if (EncodingUtils.DECORATOR_P(sname[0], dname[0])) {
                boolean ret = ec.addConverter(sname[0], dname[0], ec.numTranscoders);
                if (ret) continue;
                throw Error.argumentError(context, "decoration failed: " + new String(dname[0]));
            }
            int j = ec.numTranscoders;
            final int[] arg2 = new int[]{j, 0};
            int ret = TranscoderDB.searchPath((byte[])sname[0], (byte[])dname[0], (TranscoderDB.SearchPathCallback)new TranscoderDB.SearchPathCallback(){

                public void call(byte[] source2, byte[] destination, int depth) {
                    if (arg2[1] == -1) {
                        return;
                    }
                    arg2[1] = ec.addConverter(source2, destination, arg2[0]) ? 0 : -1;
                }
            });
            if (ret == -1 || arg2[1] == -1) {
                throw Error.argumentError(context, "adding conversion failed: " + new String(sname[0]) + " to " + new String(dname[0]));
            }
            if (first2) {
                first2 = false;
                encs[0] = senc[0];
                encNames[0] = ec.elements[j].transcoding.transcoder.getSource();
            }
            encs[1] = denc[0];
            encNames[1] = ec.elements[ec.numTranscoders - 1].transcoding.transcoder.getDestination();
        }
        if (first2) {
            encs[0] = null;
            encs[1] = null;
            encNames[0] = NULL_BYTE_ARRAY;
            encNames[1] = NULL_BYTE_ARRAY;
        }
        ec.source = encNames[0];
        ec.destination = encNames[0];
        return ec;
    }

    public static int decorateConvpath(ThreadContext context, IRubyObject convpath2, int ecflags) {
        int n;
        byte[][] decorators = new byte[32][];
        int num_decorators = TranscoderDB.decoratorNames((int)ecflags, (byte[][])decorators);
        if (num_decorators == -1) {
            return -1;
        }
        int len = n = ((RubyArray)convpath2).size();
        if (n != 0) {
            Object pair = ((RubyArray)convpath2).eltOk(n - 1);
            if (pair instanceof RubyArray) {
                byte[] dname;
                RubyArray ary = (RubyArray)pair;
                EncodingService encodingService = Access.encodingService(context);
                byte[] sname = encodingService.getEncodingFromObject((IRubyObject)ary.eltOk(0L)).getName();
                TranscoderDB.Entry entry = TranscoderDB.getEntry((byte[])sname, (byte[])(dname = encodingService.getEncodingFromObject((IRubyObject)ary.eltOk(1L)).getName()));
                Transcoder tr2 = entry.getTranscoder();
                if (tr2 == null) {
                    return -1;
                }
                if (!EncodingUtils.DECORATOR_P(tr2.getSource(), tr2.getDestination()) && tr2.compatibility.isEncoder()) {
                    --n;
                    ((RubyArray)convpath2).store(len + num_decorators - 1, (IRubyObject)pair);
                }
            } else {
                ((RubyArray)convpath2).store(len + num_decorators - 1, (IRubyObject)pair);
            }
        }
        for (int i2 = 0; i2 < num_decorators; ++i2) {
            ((RubyArray)convpath2).store(n + i2, Create.newString(context, decorators[i2]));
        }
        return 0;
    }

    public static RubyString ioEncStr(Ruby runtime2, RubyString str, OpenFile fptr) {
        str.setEncoding(fptr.readEncoding(runtime2));
        return str;
    }

    public static IRubyObject ioEncStr(Ruby runtime2, IRubyObject str, OpenFile fptr) {
        return EncodingUtils.ioEncStr(runtime2, (RubyString)str, fptr);
    }

    public static RubyString encUintChr(ThreadContext context, int code, Encoding enc) {
        long i2 = (long)code & 0xFFFFFFFFL;
        int n = EncodingUtils.encCodelen(context, code, enc);
        switch (n) {
            case -400: {
                throw Error.rangeError(context, "invalid codepoint 0x" + Long.toHexString(i2) + " in " + String.valueOf(enc));
            }
            case -401: 
            case 0: {
                throw Error.rangeError(context, i2 + " out of char range");
            }
        }
        ByteList strBytes = new ByteList(n);
        strBytes.setEncoding(enc);
        strBytes.length(n);
        byte[] bytes2 = strBytes.unsafeBytes();
        int begin2 = strBytes.begin();
        int end2 = strBytes.realSize();
        EncodingUtils.encMbcput(context, code, bytes2, begin2, enc);
        if (StringSupport.preciseLength(enc, bytes2, begin2, end2) != n) {
            throw Error.rangeError(context, "invalid codepoint 0x" + Long.toHexString(i2) + " in " + String.valueOf(enc));
        }
        return Create.newString(context, strBytes);
    }

    public static int encMbcput(int c, byte[] buf, int p2, Encoding enc) {
        int len = enc.codeToMbc(c, buf, p2);
        if (len < 0) {
            throw new EncodingException(EncodingError.fromCode((int)len));
        }
        return len;
    }

    public static int encMbcput(ThreadContext context, int c, byte[] buf, int p2, Encoding enc) {
        int len = enc.codeToMbc(c, buf, p2);
        if (len < 0) {
            switch (len) {
                case -400: {
                    throw Error.rangeError(context, "invalid codepoint 0x" + Long.toHexString((long)c & 0xFFFFFFFFL) + " in " + String.valueOf(enc));
                }
                case -401: {
                    throw Error.rangeError(context, ((long)c & 0xFFFFFFFFL) + " out of char range");
                }
            }
            throw context.runtime.newEncodingError(EncodingError.fromCode((int)len).getMessage());
        }
        return len;
    }

    public static int encCodepointLength(byte[] pBytes, int p2, int e, int[] len_p, Encoding enc) {
        if (e <= p2) {
            throw new IllegalArgumentException("empty string");
        }
        int r = StringSupport.preciseLength(enc, pBytes, p2, e);
        if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
            throw new IllegalArgumentException("invalid byte sequence in " + String.valueOf(enc));
        }
        if (len_p != null) {
            len_p[0] = StringSupport.MBCLEN_CHARFOUND_LEN(r);
        }
        return StringSupport.codePoint(enc, pBytes, p2, e);
    }

    @Deprecated(since="10.0.0.0")
    public static int encCodepointLength(Ruby runtime2, byte[] pBytes, int p2, int e, int[] len_p, Encoding enc) {
        return EncodingUtils.encCodepointLength(runtime2.getCurrentContext(), pBytes, p2, e, len_p, enc);
    }

    public static int encCodepointLength(ThreadContext context, byte[] pBytes, int p2, int e, int[] len_p, Encoding enc) {
        try {
            return EncodingUtils.encCodepointLength(pBytes, p2, e, len_p, enc);
        }
        catch (IllegalArgumentException ex) {
            throw Error.argumentError(context, ex.getMessage());
        }
    }

    public static IRubyObject strCompatAndValid(ThreadContext context, IRubyObject _str, Encoding enc) {
        RubyString str = _str.convertToString();
        int cr = str.scanForCodeRange();
        if (cr == 48) {
            throw Error.argumentError(context, "replacement must be valid byte sequence '" + String.valueOf(str) + "'");
        }
        Encoding e = EncodingUtils.STR_ENC_GET(str);
        if (cr == 16 ? enc.minLength() != 1 : enc != e) {
            throw context.runtime.newEncodingCompatibilityError("incompatible character encodings: " + String.valueOf(enc) + " and " + String.valueOf(e));
        }
        return str;
    }

    public static Encoding getEncoding(ByteList str) {
        return EncodingUtils.getActualEncoding(str.getEncoding(), str);
    }

    public static Encoding getActualEncoding(Encoding enc, ByteList byteList) {
        return EncodingUtils.getActualEncoding(enc, byteList.getUnsafeBytes(), byteList.begin(), byteList.begin() + byteList.realSize());
    }

    public static Encoding getActualEncoding(Encoding enc, byte[] bytes2, int p2, int end2) {
        if (enc.isDummy() && enc instanceof UnicodeEncoding) {
            if (enc == UTF16Dummy && end2 - p2 >= 2) {
                int c0 = bytes2[p2] & 0xFF;
                int c1 = bytes2[p2 + 1] & 0xFF;
                if (c0 == 254 && c1 == 255) {
                    return UTF16BEEncoding.INSTANCE;
                }
                if (c0 == 255 && c1 == 254) {
                    return UTF16LEEncoding.INSTANCE;
                }
                return ASCIIEncoding.INSTANCE;
            }
            if (enc == UTF32Dummy && end2 - p2 >= 4) {
                int c0 = bytes2[p2] & 0xFF;
                int c1 = bytes2[p2 + 1] & 0xFF;
                int c2 = bytes2[p2 + 2] & 0xFF;
                int c3 = bytes2[p2 + 3] & 0xFF;
                if (c0 == 0 && c1 == 0 && c2 == 254 && c3 == 255) {
                    return UTF32BEEncoding.INSTANCE;
                }
                if (c3 == 0 && c2 == 0 && c1 == 254 && c0 == 255) {
                    return UTF32LEEncoding.INSTANCE;
                }
                return ASCIIEncoding.INSTANCE;
            }
        }
        return enc;
    }

    public static Encoding STR_ENC_GET(ByteListHolder str) {
        return EncodingUtils.getEncoding(str.getByteList());
    }

    @Deprecated(since="10.0.0.0")
    public static RubyString rbStrEscape(Ruby runtime2, RubyString str) {
        return (RubyString)RubyString.rbStrEscape(runtime2.getCurrentContext(), str);
    }

    public static boolean isPrint(int c) {
        return 32 <= c && c <= 126;
    }

    public static int rbStrBufCatEscapedChar(RubyString result2, long c, boolean unicode_p) {
        byte[] buf = unicode_p ? (c < 127L && c > 31L ? String.format("%c", Character.valueOf((char)c)).getBytes() : (c < 65536L ? String.format("\\u%04X", c).getBytes() : String.format("\\u{%X}", c).getBytes())) : (c < 256L ? String.format("\\x{%02X}", c).getBytes() : String.format("\\x{%X}", c &= 0xFFFFFFFFFFFFFFFFL).getBytes());
        result2.cat(buf);
        return buf.length;
    }

    public static Charset charsetForEncoding(Encoding enc) throws UnsupportedCharsetException {
        Charset charset = enc.getCharset();
        if (charset == null) {
            charset = Charset.forName(enc.toString());
        }
        return charset;
    }

    public static int encCodelen(ThreadContext context, int c, Encoding enc) {
        int n = enc.codeToMbcLength(c);
        if (n == 0) {
            throw Error.argumentError(context, "invalid codepoint 0x" + Long.toHexString((long)c & 0xFFFFFFFFL) + " in " + String.valueOf(enc));
        }
        return n;
    }

    public static Encoding rbAscii8bitAppendableEncodingIndex(ThreadContext context, Encoding enc, int code) {
        if (enc == ASCIIEncoding.INSTANCE || enc == USASCIIEncoding.INSTANCE) {
            if (code > 255) {
                throw Error.rangeError(context, code + " out of char range");
            }
            if (enc == USASCIIEncoding.INSTANCE && code > 127) {
                return ASCIIEncoding.INSTANCE;
            }
            return enc;
        }
        return null;
    }

    @Deprecated(since="9.2.0.0")
    public static Encoding ioStripBOM(RubyIO io2) {
        return EncodingUtils.ioStripBOM(io2.getRuntime().getCurrentContext(), io2);
    }

    @Deprecated(since="9.4.6.0")
    public static Encoding strTranscode0(ThreadContext context, int argc, IRubyObject[] args2, IRubyObject[] self_p, int ecflags, IRubyObject ecopts) {
        Encoding[] enc_p = new Encoding[]{null};
        TranscodeResult result2 = (ctx, str, enc, newStr) -> {
            enc_p[0] = enc;
            self_p[0] = newStr;
            return newStr;
        };
        return switch (argc) {
            case 0 -> {
                EncodingUtils.strTranscode0(context, (RubyString)self_p[0], ecflags, ecopts, result2);
                yield enc_p[0];
            }
            case 1 -> {
                EncodingUtils.strTranscode1(context, args2[0], (RubyString)self_p[0], ecflags, ecopts, result2);
                yield enc_p[0];
            }
            case 2 -> {
                EncodingUtils.strTranscode2(context, args2[0], args2[1], (RubyString)self_p[0], ecflags, ecopts, result2);
                yield enc_p[0];
            }
            default -> throw Error.argumentError(context, args2.length, 2);
        };
    }

    @Deprecated(since="9.4.6.0")
    public static Encoding strTranscode(ThreadContext context, IRubyObject[] args2, IRubyObject[] self_p) {
        Encoding[] enc_p = new Encoding[]{null};
        TranscodeResult result2 = (ctx, str, enc, newStr) -> {
            enc_p[0] = enc;
            self_p[0] = newStr;
            return newStr;
        };
        EncodingUtils.strTranscode(context, args2, (RubyString)self_p[0], result2);
        return enc_p[0];
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject strEncode(ThreadContext context, IRubyObject str, IRubyObject ... args2) {
        return EncodingUtils.strTranscode(context, args2, (RubyString)str, EncodingUtils::encodedDup);
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject encodedDup(ThreadContext context, IRubyObject newstr, IRubyObject str, Encoding encindex) {
        return EncodingUtils.encodedDup(context, (RubyString)newstr, encindex, (RubyString)str);
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject strEncodeAssociate(ThreadContext context, IRubyObject str, Encoding encidx) {
        return EncodingUtils.strEncodeAssociate((RubyString)str, encidx);
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject strTranscode(ThreadContext context, IRubyObject[] args2, RubyString str, TranscodeResult result2) {
        return switch (args2.length) {
            case 0 -> EncodingUtils.strTranscode(context, str, result2);
            case 1 -> EncodingUtils.strTranscode(context, args2[0], str, result2);
            case 2 -> EncodingUtils.strTranscode(context, args2[0], args2[1], str, result2);
            case 3 -> EncodingUtils.strTranscode(context, args2[0], args2[1], args2[2], str, result2);
            default -> throw Error.argumentError(context, args2.length, 2);
        };
    }

    public static interface TranscodeResult {
        public RubyString apply(ThreadContext var1, RubyString var2, Encoding var3, RubyString var4);
    }

    public static interface ResizeFunction {
        public int resize(ByteList var1, int var2, int var3);
    }

    private static abstract class AbstractTranscodeFallback
    implements TranscodeFallback<IRubyObject> {
        private AbstractTranscodeFallback() {
        }

        @Override
        public boolean call(ThreadContext context, IRubyObject fallback, EConv ec) {
            IRubyObject rep = RubyString.newStringNoCopy(context.runtime, new ByteList(ec.lastError.getErrorBytes(), ec.lastError.getErrorBytesP(), ec.lastError.getErrorBytesLength(), Access.encodingService(context).findEncodingOrAliasEntry(ec.lastError.getSource()).getEncoding(), false));
            if (!(rep = this.innerCall(context, fallback, rep)).isNil()) {
                rep = rep.convertToString();
                Encoding repEnc = ((RubyString)rep).getEncoding();
                ByteList repByteList = ((RubyString)rep).getByteList();
                int ret = ec.insertOutput(repByteList.getUnsafeBytes(), repByteList.begin(), repByteList.getRealSize(), repEnc.getName());
                if (ret == -1) {
                    throw Error.argumentError(context, "too big fallback string");
                }
                return true;
            }
            return false;
        }

        protected abstract IRubyObject innerCall(ThreadContext var1, IRubyObject var2, IRubyObject var3);
    }

    public static interface TranscodeFallback<Data> {
        public boolean call(ThreadContext var1, Data var2, EConv var3);
    }
}

