/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.EUCJPEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.specific.Windows_31JEncoding;

public enum KCode {
    NIL(null, (Encoding)ASCIIEncoding.INSTANCE, 0),
    NONE("NONE", (Encoding)ASCIIEncoding.INSTANCE, 0),
    UTF8("UTF8", (Encoding)UTF8Encoding.INSTANCE, 64),
    SJIS("SJIS", (Encoding)Windows_31JEncoding.INSTANCE, 48),
    EUC("EUC", (Encoding)EUCJPEncoding.INSTANCE, 32);

    private final String kcode;
    private final Encoding encoding;
    private final int code;

    private KCode(String kcode, Encoding encoding2, int code) {
        this.kcode = kcode;
        this.encoding = encoding2;
        this.code = code;
    }

    public static KCode create(String lang) {
        if (lang == null) {
            return NIL;
        }
        if (lang.length() == 0) {
            return NONE;
        }
        switch (lang.charAt(0)) {
            case 'E': 
            case 'e': {
                return EUC;
            }
            case 'S': 
            case 's': {
                return SJIS;
            }
            case 'U': 
            case 'u': {
                return UTF8;
            }
            case 'A': 
            case 'N': 
            case 'a': 
            case 'n': {
                return NONE;
            }
        }
        return NIL;
    }

    public String getKCode() {
        return this.kcode;
    }

    public int bits() {
        return this.code;
    }

    public static KCode fromBits(int bits) {
        if ((bits & 0x40) != 0) {
            return UTF8;
        }
        if ((bits & 0x30) == 48) {
            return SJIS;
        }
        if ((bits & 0x20) != 0) {
            return EUC;
        }
        return NONE;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return this.name();
    }
}

