/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyNil;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Handle;

public class LiteralValueBootstrap {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final Handle CONTEXT_VALUE_HANDLE = new Handle(6, CodegenUtils.p(LiteralValueBootstrap.class), "contextValue", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    public static final Handle CONTEXT_VALUE_STRING_HANDLE = new Handle(6, CodegenUtils.p(LiteralValueBootstrap.class), "contextValueString", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class), false);
    private static final MethodHandle RUNTIME_HANDLE = Binder.from(Ruby.class, ThreadContext.class, (Class[])new Class[]{MutableCallSite.class}).invokeStaticQuiet(LOOKUP, LiteralValueBootstrap.class, "runtime");
    private static final MethodHandle NIL_HANDLE = Binder.from(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{MutableCallSite.class}).invokeStaticQuiet(LOOKUP, LiteralValueBootstrap.class, "nil");
    private static final MethodHandle TRUE_HANDLE = Binder.from(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{MutableCallSite.class}).invokeStaticQuiet(LOOKUP, LiteralValueBootstrap.class, "True");
    private static final MethodHandle FALSE_HANDLE = Binder.from(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{MutableCallSite.class}).invokeStaticQuiet(LOOKUP, LiteralValueBootstrap.class, "False");
    private static final MethodHandle RUBY_ENCODING_HANDLE = Binder.from(RubyEncoding.class, ThreadContext.class, (Class[])new Class[]{MutableCallSite.class, String.class}).invokeStaticQuiet(LOOKUP, LiteralValueBootstrap.class, "rubyEncoding");
    private static final MethodHandle ENCODING_HANDLE = Binder.from(Encoding.class, ThreadContext.class, (Class[])new Class[]{MutableCallSite.class, String.class}).invokeStaticQuiet(LOOKUP, LiteralValueBootstrap.class, "encoding");

    public static CallSite contextValue(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MutableCallSite site = new MutableCallSite(type2);
        site.setTarget(Binder.from((MethodType)type2).append(new Object[]{site}).invoke(switch (name2) {
            case "runtime" -> RUNTIME_HANDLE;
            case "nil" -> NIL_HANDLE;
            case "True" -> TRUE_HANDLE;
            case "False" -> FALSE_HANDLE;
            case "rubyEncoding" -> RUBY_ENCODING_HANDLE;
            case "encoding" -> ENCODING_HANDLE;
            default -> throw new RuntimeException("BUG: invalid context value " + name2);
        }));
        return site;
    }

    public static CallSite contextValueString(MethodHandles.Lookup lookup, String name2, MethodType type2, String str) {
        MutableCallSite site = new MutableCallSite(type2);
        site.setTarget(Binder.from((MethodType)type2).append(new Object[]{site, str}).invoke(switch (name2) {
            case "rubyEncoding" -> RUBY_ENCODING_HANDLE;
            case "encoding" -> ENCODING_HANDLE;
            default -> throw new RuntimeException("BUG: invalid context value " + name2);
        }));
        return site;
    }

    public static IRubyObject nil(ThreadContext context, MutableCallSite site) {
        RubyNil nil = (RubyNil)context.nil;
        MethodHandle constant = (MethodHandle)nil.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.nil);
        }
        site.setTarget(constant);
        return nil;
    }

    public static IRubyObject True(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.tru.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.tru);
        }
        site.setTarget(constant);
        return context.tru;
    }

    public static IRubyObject False(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.fals.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.fals);
        }
        site.setTarget(constant);
        return context.fals;
    }

    public static Ruby runtime(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.runtime.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(Ruby.class, context.runtime);
        }
        site.setTarget(constant);
        return context.runtime;
    }

    public static RubyEncoding rubyEncoding(ThreadContext context, MutableCallSite site, String name2) {
        RubyEncoding rubyEncoding = IRRuntimeHelpers.retrieveEncoding(context, name2);
        MethodHandle constant = (MethodHandle)rubyEncoding.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(RubyEncoding.class, rubyEncoding);
        }
        site.setTarget(constant);
        return rubyEncoding;
    }

    public static Encoding encoding(ThreadContext context, MutableCallSite site, String name2) {
        Encoding encoding2 = IRRuntimeHelpers.retrieveJCodingsEncoding(context, name2);
        MethodHandle constant = MethodHandles.constant(Encoding.class, encoding2);
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(Encoding.class, encoding2);
        }
        site.setTarget(constant);
        return encoding2;
    }
}

