/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import org.jruby.RubyArray;
import org.jruby.ir.targets.BranchCompiler;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.indy.CheckArityBootstrap;
import org.jruby.ir.targets.indy.IsNilSite;
import org.jruby.ir.targets.indy.IsTrueSite;
import org.jruby.ir.targets.simple.NormalBranchCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Label;

public class IndyBranchCompiler
implements BranchCompiler {
    private final IRBytecodeAdapter compiler;
    private final BranchCompiler normalCompiler;

    public IndyBranchCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
        this.normalCompiler = new NormalBranchCompiler(compiler);
    }

    @Override
    public void branchIfNil(Label label2) {
        this.compiler.adapter.invokedynamic("isNil", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class), IsNilSite.IS_NIL_BOOTSTRAP_HANDLE, new Object[0]);
        this.compiler.adapter.iftrue(label2);
    }

    @Override
    public void branchIfTruthy(Label label2) {
        this.compiler.adapter.invokedynamic("isTrue", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class), IsTrueSite.IS_TRUE_BOOTSTRAP_HANDLE, new Object[0]);
        this.compiler.adapter.iftrue(label2);
    }

    @Override
    public void bfalse(Label label2) {
        this.normalCompiler.bfalse(label2);
    }

    @Override
    public void btrue(Label label2) {
        this.normalCompiler.btrue(label2);
    }

    @Override
    public void checkArgsArity(Runnable args2, int required, int opt, boolean rest) {
        this.compiler.loadContext();
        args2.run();
        this.compiler.adapter.invokedynamic("checkArrayArity", CodegenUtils.sig(Void.TYPE, ThreadContext.class, RubyArray.class), CheckArityBootstrap.CHECK_ARRAY_ARITY_BOOTSTRAP, required, opt, rest ? 1 : 0);
    }

    @Override
    public void checkArity(int required, int opt, boolean rest, int restKey) {
        this.compiler.adapter.invokedynamic("checkArity", CodegenUtils.sig(Void.TYPE, ThreadContext.class, StaticScope.class, Object[].class, Object.class, Block.class), CheckArityBootstrap.CHECK_ARITY, required, opt, rest ? 1 : 0, restKey);
    }

    @Override
    public void checkAritySpecificArgs(int required, int opt, boolean rest, int restKey) {
        this.compiler.adapter.invokedynamic("checkArity", CodegenUtils.sig(Void.TYPE, ThreadContext.class, StaticScope.class, Object[].class, Block.class), CheckArityBootstrap.CHECK_ARITY_SPECIFIC_ARGS, required, opt, rest ? 1 : 0, restKey);
    }
}

