/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jruby.dirgra.DirectedGraph;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.ExplicitVertexID;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.JumpTargetInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.MultiBranchInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.ExceptionRegion;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class CFG {
    private static final Logger LOG = LoggerFactory.getLogger(CFG.class);
    private final IRScope scope;
    private final Map<Label, BasicBlock> bbMap;
    private final Map<BasicBlock, BasicBlock> rescuerMap;
    private BasicBlock entryBB;
    private BasicBlock exitBB;
    List<BasicBlock> returnBBs = new ArrayList<BasicBlock>(1);
    private BasicBlock globalEnsureBB;
    private final DirectedGraph<BasicBlock, EdgeType> graph;
    private int nextBBId;
    LinkedList<BasicBlock> postOrderList;

    public CFG(IRScope scope) {
        this.scope = scope;
        this.graph = new DirectedGraph();
        this.bbMap = new HashMap<Label, BasicBlock>(4);
        this.rescuerMap = new HashMap<BasicBlock, BasicBlock>(4);
        this.nextBBId = 0;
        this.exitBB = null;
        this.entryBB = null;
        this.globalEnsureBB = null;
        this.postOrderList = null;
    }

    public int getNextBBID() {
        ++this.nextBBId;
        return this.nextBBId;
    }

    public IRManager getManager() {
        return this.scope.getManager();
    }

    public int getMaxNodeID() {
        return this.nextBBId;
    }

    public boolean bbIsProtected(BasicBlock b2) {
        return this.getRescuerBBFor(b2) != null;
    }

    public BasicBlock getBBForLabel(Label label2) {
        return this.bbMap.get(label2);
    }

    public BasicBlock getEntryBB() {
        return this.entryBB;
    }

    public BasicBlock getExitBB() {
        return this.exitBB;
    }

    public BasicBlock getGlobalEnsureBB() {
        return this.globalEnsureBB;
    }

    public LinkedList<BasicBlock> postOrderList() {
        if (this.postOrderList == null) {
            this.postOrderList = this.buildPostOrderList();
        }
        return this.postOrderList;
    }

    public Iterator<BasicBlock> getPostOrderTraverser() {
        return this.postOrderList().iterator();
    }

    public Iterator<BasicBlock> getReversePostOrderTraverser() {
        return this.postOrderList().descendingIterator();
    }

    public IRScope getScope() {
        return this.scope;
    }

    public int size() {
        return this.graph.size();
    }

    public Collection<BasicBlock> getBasicBlocks() {
        return this.graph.allData();
    }

    public Collection<BasicBlock> getSortedBasicBlocks() {
        return this.graph.getInorderData();
    }

    public void addEdge(BasicBlock source2, BasicBlock destination, EdgeType type2) {
        this.graph.findOrCreateVertexFor((ExplicitVertexID)source2).addEdgeTo((ExplicitVertexID)destination, (Object)type2);
    }

    public int inDegree(BasicBlock b2) {
        return this.graph.findVertexFor((ExplicitVertexID)b2).inDegree();
    }

    public int outDegree(BasicBlock b2) {
        return this.graph.findVertexFor((ExplicitVertexID)b2).outDegree();
    }

    public Iterable<BasicBlock> getIncomingSources(BasicBlock block) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getIncomingSourcesData();
    }

    public Iterable<Edge<BasicBlock, EdgeType>> getIncomingEdges(BasicBlock block) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getIncomingEdges();
    }

    public BasicBlock getIncomingSourceOfType(BasicBlock block, EdgeType type2) {
        return (BasicBlock)this.graph.findVertexFor((ExplicitVertexID)block).getIncomingSourceDataOfType((Object)type2);
    }

    public BasicBlock getOutgoingDestinationOfType(BasicBlock block, EdgeType type2) {
        return (BasicBlock)this.graph.findVertexFor((ExplicitVertexID)block).getOutgoingDestinationDataOfType((Object)type2);
    }

    public Iterable<BasicBlock> getOutgoingDestinations(BasicBlock block) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getOutgoingDestinationsData();
    }

    public Iterable<BasicBlock> getOutgoingDestinationsOfType(BasicBlock block, EdgeType type2) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getOutgoingDestinationsDataOfType((Object)type2);
    }

    public Iterable<BasicBlock> getOutgoingDestinationsNotOfType(BasicBlock block, EdgeType type2) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getOutgoingDestinationsDataNotOfType((Object)type2);
    }

    public Collection<Edge<BasicBlock, EdgeType>> getOutgoingEdges(BasicBlock block) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getOutgoingEdges();
    }

    public BasicBlock getRescuerBBFor(BasicBlock block) {
        return this.rescuerMap.get(block);
    }

    public void addGlobalEnsureBB(BasicBlock geb) {
        assert (this.globalEnsureBB == null) : "CFG for scope " + String.valueOf(this.getScope()) + " already has a global ensure block.";
        this.addBasicBlock(geb);
        this.addEdge(geb, this.getExitBB(), EdgeType.EXIT);
        for (BasicBlock b2 : this.getBasicBlocks()) {
            if (b2 == geb || this.bbIsProtected(b2) || b2 == this.getEntryBB()) continue;
            this.addEdge(b2, geb, EdgeType.EXCEPTION);
            this.setRescuerBB(b2, geb);
        }
        this.globalEnsureBB = geb;
    }

    public void setRescuerBB(BasicBlock block, BasicBlock rescuerBlock) {
        this.rescuerMap.put(block, rescuerBlock);
    }

    public DirectedGraph<BasicBlock, EdgeType> build(Instr[] instrs) {
        BasicBlock firstBB;
        HashMap<Label, List<BasicBlock>> forwardRefs = new HashMap<Label, List<BasicBlock>>();
        ArrayList<BasicBlock> exceptionBBs = new ArrayList<BasicBlock>(1);
        Stack<ExceptionRegion> nestedExceptionRegions = new Stack<ExceptionRegion>();
        ArrayList<ExceptionRegion> allExceptionRegions = new ArrayList<ExceptionRegion>(1);
        this.entryBB = this.createBB(nestedExceptionRegions);
        BasicBlock currBB = firstBB = this.createBB(nestedExceptionRegions);
        boolean bbEnded = false;
        boolean nextBBIsFallThrough = true;
        for (Instr i2 : instrs) {
            Operation iop = i2.getOperation();
            if (iop == Operation.LABEL) {
                Label l = ((LabelInstr)i2).getLabel();
                newBB = this.createBB(l, nestedExceptionRegions);
                if (nextBBIsFallThrough) {
                    this.graph.addEdge((ExplicitVertexID)currBB, (ExplicitVertexID)newBB, (Object)EdgeType.FALL_THROUGH);
                }
                currBB = newBB;
                bbEnded = false;
                nextBBIsFallThrough = true;
                List frefs = (List)forwardRefs.get(l);
                if (frefs != null) {
                    for (BasicBlock b2 : frefs) {
                        this.graph.addEdge((ExplicitVertexID)b2, (ExplicitVertexID)newBB, (Object)EdgeType.REGULAR);
                    }
                }
            } else if (bbEnded && iop != Operation.EXC_REGION_END) {
                newBB = this.createBB(nestedExceptionRegions);
                if (nextBBIsFallThrough) {
                    this.graph.addEdge((ExplicitVertexID)currBB, (ExplicitVertexID)newBB, (Object)EdgeType.FALL_THROUGH);
                }
                currBB = newBB;
                bbEnded = false;
                nextBBIsFallThrough = true;
            }
            if (i2 instanceof ExceptionRegionStartMarkerInstr) {
                ExceptionRegionStartMarkerInstr ersmi = (ExceptionRegionStartMarkerInstr)i2;
                ExceptionRegion rr = new ExceptionRegion(ersmi.getFirstRescueBlockLabel(), currBB);
                rr.addBB(currBB);
                allExceptionRegions.add(rr);
                if (!nestedExceptionRegions.empty()) {
                    nestedExceptionRegions.peek().addNestedRegion(rr);
                }
                nestedExceptionRegions.push(rr);
                continue;
            }
            if (i2 instanceof ExceptionRegionEndMarkerInstr) {
                nestedExceptionRegions.pop().setEndBB(currBB);
                continue;
            }
            if (iop.endsBasicBlock()) {
                bbEnded = true;
                currBB.addInstr(i2);
                Label tgt = null;
                nextBBIsFallThrough = false;
                if (i2 instanceof BranchInstr) {
                    tgt = ((BranchInstr)i2).getJumpTarget();
                    nextBBIsFallThrough = true;
                } else if (i2 instanceof MultiBranchInstr) {
                    Label[] tgts;
                    for (Label l : tgts = ((MultiBranchInstr)i2).getJumpTargets()) {
                        this.addEdge(currBB, l, forwardRefs);
                    }
                } else if (i2 instanceof JumpInstr) {
                    tgt = ((JumpInstr)i2).getJumpTarget();
                } else if (iop.isReturn()) {
                    this.returnBBs.add(currBB);
                } else if (i2 instanceof ThrowExceptionInstr) {
                    exceptionBBs.add(currBB);
                } else {
                    throw new RuntimeException("Unhandled case in CFG builder for basic block ending instr: " + String.valueOf(i2));
                }
                if (tgt == null) continue;
                this.addEdge(currBB, tgt, forwardRefs);
                continue;
            }
            if (iop == Operation.LABEL) continue;
            currBB.addInstr(i2);
        }
        for (ExceptionRegion rr : allExceptionRegions) {
            Label rescueLabel = rr.getFirstRescueBlockLabel();
            if (Label.UNRESCUED_REGION_LABEL.equals(rescueLabel)) continue;
            BasicBlock firstRescueBB = this.bbMap.get(rescueLabel);
            firstRescueBB.markRescueEntryBB();
            for (BasicBlock b3 : rr.getExclusiveBBs()) {
                if (!b3.canRaiseExceptions()) continue;
                this.setRescuerBB(b3, firstRescueBB);
                this.graph.addEdge((ExplicitVertexID)b3, (ExplicitVertexID)firstRescueBB, (Object)EdgeType.EXCEPTION);
            }
        }
        this.buildExitBasicBlock(nestedExceptionRegions, firstBB, this.returnBBs, exceptionBBs, nextBBIsFallThrough, currBB, this.entryBB);
        this.optimize();
        return this.graph;
    }

    public void fixupEdges(BasicBlock bb) {
        block4: {
            Instr lastInstr = bb.getLastInstr();
            if (lastInstr instanceof BranchInstr) break block4;
            if (bb.getLastInstr() instanceof JumpTargetInstr) {
                for (Edge<BasicBlock, EdgeType> edge : this.getOutgoingEdges(bb)) {
                    if (edge.getType() != EdgeType.FALL_THROUGH) continue;
                    this.graph.removeEdge(edge);
                }
            } else {
                for (Edge<BasicBlock, EdgeType> edge : this.getOutgoingEdges(bb)) {
                    if (edge.getType() != EdgeType.REGULAR) continue;
                    this.graph.removeEdge(edge);
                }
            }
        }
    }

    private void addEdge(BasicBlock src, Label targetLabel, Map<Label, List<BasicBlock>> forwardRefs) {
        BasicBlock target2 = this.bbMap.get(targetLabel);
        if (target2 != null) {
            this.graph.addEdge((ExplicitVertexID)src, (ExplicitVertexID)target2, (Object)EdgeType.REGULAR);
            return;
        }
        List forwardReferences = forwardRefs.computeIfAbsent(targetLabel, k -> new ArrayList(1));
        forwardReferences.add(src);
    }

    private BasicBlock buildExitBasicBlock(Stack<ExceptionRegion> nestedExceptionRegions, BasicBlock firstBB, List<BasicBlock> returnBBs, List<BasicBlock> exceptionBBs, boolean nextIsFallThrough, BasicBlock currBB, BasicBlock entryBB) {
        this.exitBB = this.createBB(nestedExceptionRegions);
        this.graph.addEdge((ExplicitVertexID)entryBB, (ExplicitVertexID)this.exitBB, (Object)EdgeType.EXIT);
        this.graph.addEdge((ExplicitVertexID)entryBB, (ExplicitVertexID)firstBB, (Object)EdgeType.FALL_THROUGH);
        for (BasicBlock rb : returnBBs) {
            this.graph.addEdge((ExplicitVertexID)rb, (ExplicitVertexID)this.exitBB, (Object)EdgeType.EXIT);
        }
        for (BasicBlock rb : exceptionBBs) {
            this.graph.addEdge((ExplicitVertexID)rb, (ExplicitVertexID)this.exitBB, (Object)EdgeType.EXIT);
        }
        if (nextIsFallThrough) {
            this.graph.addEdge((ExplicitVertexID)currBB, (ExplicitVertexID)this.exitBB, (Object)EdgeType.EXIT);
        }
        return this.exitBB;
    }

    private BasicBlock createBB(Label label2, Stack<ExceptionRegion> nestedExceptionRegions) {
        BasicBlock basicBlock = new BasicBlock(this, label2);
        this.addBasicBlock(basicBlock);
        if (label2.isGlobalEnsureBlockLabel()) {
            this.globalEnsureBB = basicBlock;
        }
        if (!nestedExceptionRegions.empty()) {
            nestedExceptionRegions.peek().addBB(basicBlock);
        }
        return basicBlock;
    }

    private BasicBlock createBB(Stack<ExceptionRegion> nestedExceptionRegions) {
        return this.createBB(this.scope.getNewLabel(), nestedExceptionRegions);
    }

    public void addBasicBlock(BasicBlock bb) {
        this.graph.findOrCreateVertexFor((ExplicitVertexID)bb);
        this.bbMap.put(bb.getLabel(), bb);
        this.postOrderList = null;
    }

    public void removeAllOutgoingEdgesForBB(BasicBlock b2) {
        this.graph.findVertexFor((ExplicitVertexID)b2).removeAllOutgoingEdges();
    }

    private void deleteOrphanedBlocks(DirectedGraph<BasicBlock, EdgeType> graph) {
        LinkedList<BasicBlock> worklist = new LinkedList<BasicBlock>();
        HashSet<BasicBlock> living = new HashSet<BasicBlock>();
        worklist.add(this.entryBB);
        living.add(this.entryBB);
        while (!worklist.isEmpty()) {
            BasicBlock current2 = (BasicBlock)worklist.remove();
            for (BasicBlock bb : graph.findVertexFor((ExplicitVertexID)current2).getOutgoingDestinationsData()) {
                if (living.contains(bb)) continue;
                worklist.add(bb);
                living.add(bb);
            }
        }
        HashSet<BasicBlock> dead = new HashSet<BasicBlock>();
        for (BasicBlock bb : graph.allData()) {
            if (living.contains(bb)) continue;
            dead.add(bb);
        }
        for (BasicBlock bb : dead) {
            this.removeBB(bb);
            this.removeNestedScopesFromBB(bb);
        }
    }

    private boolean mergeBBs(BasicBlock a, BasicBlock b2) {
        BasicBlock bR;
        BasicBlock aR = this.getRescuerBBFor(a);
        if (aR == (bR = this.getRescuerBBFor(b2)) || a.isEmpty() || b2.isEmpty()) {
            Instr lastInstr = a.getLastInstr();
            if (lastInstr instanceof JumpInstr) {
                a.removeInstr(lastInstr);
            }
            a.swallowBB(b2);
            this.removeEdge(a, b2);
            for (Edge<BasicBlock, EdgeType> e : this.getOutgoingEdges(b2)) {
                this.addEdge(a, (BasicBlock)e.getDestination().getData(), (EdgeType)((Object)e.getType()));
            }
            for (Edge<BasicBlock, EdgeType> e : this.getIncomingEdges(b2)) {
                BasicBlock fixupBB = (BasicBlock)e.getSource().getData();
                this.removeEdge(fixupBB, b2);
                this.addEdge(fixupBB, a, (EdgeType)((Object)e.getType()));
                Instr fixupLastInstr = fixupBB.getLastInstr();
                if (!(fixupLastInstr instanceof JumpTargetInstr)) continue;
                ((JumpTargetInstr)((Object)fixupLastInstr)).setJumpTarget(a.getLabel());
            }
            this.removeBB(b2);
            if (aR == null && bR != null) {
                this.setRescuerBB(a, bR);
            }
            return true;
        }
        return false;
    }

    public void removeBB(BasicBlock b2) {
        if (b2 == this.globalEnsureBB) {
            this.globalEnsureBB = null;
        }
        this.graph.removeVertexFor((ExplicitVertexID)b2);
        this.bbMap.remove(b2.getLabel());
        this.rescuerMap.remove(b2);
        this.returnBBs.remove(b2);
    }

    private void removeNestedScopesFromBB(BasicBlock bb) {
        block0: for (Instr instr : bb.getInstrs()) {
            for (Operand oper : instr.getOperands()) {
                if (!(oper instanceof WrappedIRClosure)) continue;
                this.scope.removeClosure(((WrappedIRClosure)oper).getClosure());
                continue block0;
            }
        }
    }

    public void collapseStraightLineBBs() {
        ArrayList<BasicBlock> cfgBBs = new ArrayList<BasicBlock>(this.getBasicBlocks());
        HashSet<BasicBlock> mergedBBs = new HashSet<BasicBlock>();
        for (BasicBlock b2 : cfgBBs) {
            if (mergedBBs.contains(b2) || this.outDegree(b2) != 1) continue;
            for (Edge<BasicBlock, EdgeType> e : this.getOutgoingEdges(b2)) {
                BasicBlock outB = (BasicBlock)e.getDestination().getData();
                if (e.getType() == EdgeType.EXCEPTION || this.inDegree(outB) != 1 && !b2.isEmpty() || !this.mergeBBs(b2, outB)) continue;
                mergedBBs.add(outB);
            }
        }
    }

    public void optimize() {
        ArrayList<Edge<BasicBlock, EdgeType>> toRemove = new ArrayList<Edge<BasicBlock, EdgeType>>();
        for (BasicBlock basicBlock : this.returnBBs) {
            Operand rv;
            List<Instr> rbInstrs = basicBlock.getInstrs();
            Instr first2 = rbInstrs.get(0);
            if (!(first2 instanceof ReturnInstr) || !((rv = ((ReturnInstr)first2).getReturnValue()) instanceof Variable)) continue;
            for (Edge<BasicBlock, EdgeType> e : this.getIncomingEdges(basicBlock)) {
                BasicBlock srcBB = (BasicBlock)e.getSource().getData();
                List<Instr> srcInstrs = srcBB.getInstrs();
                int n = srcInstrs.size();
                if (n == 0) continue;
                Instr jump = null;
                Instr last2 = srcInstrs.get(n - 1);
                if (last2 instanceof JumpInstr && n > 2) {
                    jump = last2;
                    last2 = srcInstrs.get(n - 2);
                }
                if (!(last2 instanceof CopyInstr) || !((CopyInstr)last2).getResult().equals(rv)) continue;
                srcInstrs.set(n - 1, new ReturnInstr(((CopyInstr)last2).getSource()));
                toRemove.add(e);
                this.addEdge(srcBB, this.exitBB, EdgeType.EXIT);
                if (jump == null) continue;
                srcInstrs.remove(jump);
            }
        }
        for (Edge edge : toRemove) {
            this.graph.removeEdge(edge);
        }
        this.deleteOrphanedBlocks(this.graph);
        this.collapseStraightLineBBs();
    }

    public String toStringGraph() {
        return this.graph.toString();
    }

    public String toStringInstrs() {
        StringBuilder buf = new StringBuilder();
        for (BasicBlock b2 : this.getSortedBasicBlocks()) {
            buf.append(b2.toStringInstrs());
        }
        buf.append("\n\n------ Rescue block map ------\n");
        ArrayList<BasicBlock> e = new ArrayList<BasicBlock>(this.rescuerMap.keySet());
        Collections.sort(e);
        for (BasicBlock bb : e) {
            buf.append("BB ").append(bb.getID()).append(" --> BB ").append(this.rescuerMap.get(bb).getID()).append("\n");
        }
        return buf.toString();
    }

    public void removeEdge(BasicBlock a, BasicBlock b2) {
        this.graph.removeEdge((ExplicitVertexID)a, (ExplicitVertexID)b2);
    }

    private LinkedList<BasicBlock> buildPostOrderList() {
        BasicBlock root = this.getEntryBB();
        LinkedList<BasicBlock> list2 = new LinkedList<BasicBlock>();
        Stack<BasicBlock> stack = new Stack<BasicBlock>();
        boolean[] visited = new boolean[1 + this.getMaxNodeID()];
        stack.push(root);
        visited[root.getID()] = true;
        while (!stack.empty()) {
            BasicBlock b2 = (BasicBlock)stack.peek();
            boolean allChildrenVisited = true;
            for (BasicBlock dst : this.getOutgoingDestinations(b2)) {
                int dstID = dst.getID();
                if (visited[dstID]) continue;
                allChildrenVisited = false;
                if (this.graph.findVertexFor((ExplicitVertexID)dst).outDegree() == 0) {
                    list2.add(dst);
                } else {
                    stack.push(dst);
                }
                visited[dstID] = true;
            }
            if (!allChildrenVisited) continue;
            stack.pop();
            list2.add(b2);
        }
        for (BasicBlock b3 : this.getBasicBlocks()) {
            if (visited[b3.getID()]) continue;
            this.printError("BB " + b3.getID() + " missing from po list!");
            break;
        }
        return list2;
    }

    public CFG clone(CloneInfo info, IRScope clonedScope) {
        CFG newCFG = new CFG(clonedScope);
        HashMap<BasicBlock, BasicBlock> cloneBBMap = new HashMap<BasicBlock, BasicBlock>();
        for (BasicBlock bb : this.getBasicBlocks()) {
            BasicBlock newBB = bb.clone(info, newCFG);
            newCFG.addBasicBlock(newBB);
            cloneBBMap.put(bb, newBB);
        }
        for (BasicBlock bb : this.getBasicBlocks()) {
            BasicBlock newSource = (BasicBlock)cloneBBMap.get(bb);
            for (Edge<BasicBlock, EdgeType> edge : this.getOutgoingEdges(bb)) {
                BasicBlock newDestination = (BasicBlock)cloneBBMap.get(edge.getDestination().getData());
                newCFG.addEdge(newSource, newDestination, (EdgeType)((Object)edge.getType()));
            }
        }
        for (BasicBlock bb : this.rescuerMap.keySet()) {
            newCFG.setRescuerBB((BasicBlock)cloneBBMap.get(bb), (BasicBlock)cloneBBMap.get(this.rescuerMap.get(bb)));
        }
        newCFG.entryBB = (BasicBlock)cloneBBMap.get(this.entryBB);
        newCFG.exitBB = (BasicBlock)cloneBBMap.get(this.exitBB);
        newCFG.globalEnsureBB = (BasicBlock)cloneBBMap.get(this.globalEnsureBB);
        return newCFG;
    }

    private void printError(String message2) {
        LOG.error(message2 + "\nGraph:\n" + String.valueOf(this) + "\nInstructions:\n" + this.toStringInstrs(), new Object[0]);
    }

    public static enum EdgeType {
        REGULAR,
        EXCEPTION,
        FALL_THROUGH,
        EXIT;

    }
}

