/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.GZIPException;
import com.jcraft.jzlib.GZIPOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.ext.zlib.RubyGzipFile;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOOutputStream;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Zlib::GzipWriter"}, parent="Zlib::GzipFile")
public class JZlibRubyGzipWriter
extends RubyGzipFile {
    private GZIPOutputStream io;

    @JRubyMethod(name={"new"}, rest=true, meta=true, keywords=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        JZlibRubyGzipWriter result2 = JZlibRubyGzipWriter.newInstance(context, (RubyClass)recv2, args2);
        return RubyGzipFile.wrapBlock(context, result2, block);
    }

    @Deprecated(since="10.0.0.0")
    public static JZlibRubyGzipWriter newInstance(IRubyObject recv2, IRubyObject[] args2) {
        return JZlibRubyGzipWriter.newInstance(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, args2);
    }

    public static JZlibRubyGzipWriter newInstance(ThreadContext context, RubyClass klass, IRubyObject[] args2) {
        JZlibRubyGzipWriter result2 = (JZlibRubyGzipWriter)klass.allocate(context);
        result2.callInit(args2, Block.NULL_BLOCK);
        return result2;
    }

    @JRubyMethod(name={"open"}, required=1, optional=3, checkArity=false, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2, 1, 4);
        args2[0] = Helpers.invoke(context, (IRubyObject)Access.fileClass(context), "open", args2[0], (IRubyObject)Create.newString(context, "wb"));
        JZlibRubyGzipWriter gzio = JZlibRubyGzipWriter.newInstance(context, (RubyClass)recv2, args2);
        return RubyGzipFile.wrapBlock(context, gzio, block);
    }

    public JZlibRubyGzipWriter(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject initialize(IRubyObject[] args2) {
        return this.initialize(this.getCurrentContext(), args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject opt = context.nil;
        int argc = args2.length;
        if (argc > 1 && !(opt = TypeConverter.checkHashType(context.runtime, opt)).isNil()) {
            --argc;
        }
        this.level = this.processLevel(context, argc, args2);
        this.processStrategy(context, argc, args2);
        this.initializeCommon(context, args2[0], this.level);
        this.ecopts(context, opt);
        return this;
    }

    private int processStrategy(ThreadContext context, int argc, IRubyObject[] args2) {
        return argc < 3 ? 0 : RubyZlib.FIXNUMARG(context, args2[2], 0);
    }

    private int processLevel(ThreadContext context, int argc, IRubyObject[] args2) {
        int level2 = argc < 2 ? -1 : RubyZlib.FIXNUMARG(context, args2[1], -1);
        JZlibRubyGzipWriter.checkLevel(context, level2);
        return level2;
    }

    private IRubyObject initializeCommon(ThreadContext context, IRubyObject stream, int level2) {
        Ruby runtime2 = context.runtime;
        this.realIo = stream;
        try {
            Deflater deflater = new Deflater(level2, 31, false);
            IOOutputStream ioOutputStream = new IOOutputStream(this, this.realIo, false, false){

                @Override
                public void write(byte[] bytes2, int off, int len) throws IOException {
                    byte[] bytesCopy = new byte[len];
                    System.arraycopy(bytes2, off, bytesCopy, 0, len);
                    super.write(bytesCopy, 0, len);
                }
            };
            this.io = new GZIPOutputStream((OutputStream)ioOutputStream, deflater, 512, false);
            long now2 = System.currentTimeMillis();
            this.mtime = RubyTime.newTime(runtime2, now2);
            this.io.setModifiedTime(now2 / 1000L);
            return this;
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    private static void checkLevel(ThreadContext context, int level2) {
        if (level2 != -1 && (level2 < 0 || level2 > 9)) {
            throw RubyZlib.newStreamError(context, "stream error: invalid level");
        }
    }

    @Override
    @JRubyMethod(name={"close"})
    public IRubyObject close(ThreadContext context) {
        if (!this.closed) {
            try {
                this.io.close();
                if (this.realIo.respondsTo("close")) {
                    this.realIo.callMethod(context, "close");
                }
            }
            catch (IOException ioe) {
                throw context.runtime.newIOErrorFromException(ioe);
            }
        }
        this.closed = true;
        return this.realIo;
    }

    @JRubyMethod(name={"append", "<<"})
    public IRubyObject append(IRubyObject p1) {
        this.write(p1);
        return this;
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true, checkArity=false)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.write(RubyKernel.sprintf(context, this, args2));
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject print(IRubyObject[] args2) {
        return this.print(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        IRubyObject sep;
        if (args2.length != 0) {
            int j = args2.length;
            for (int i2 = 0; i2 < j; ++i2) {
                this.write(args2[i2]);
            }
        }
        if (!(sep = Access.globalVariables(context).get("$\\")).isNil()) {
            this.write(sep);
        }
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject pos() {
        return this.pos(this.getCurrentContext());
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos(ThreadContext context) {
        return Convert.asFixnum(context, this.io.getTotalIn());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject set_orig_name(IRubyObject obj) {
        return this.set_orig_name(this.getCurrentContext(), obj);
    }

    @JRubyMethod(name={"orig_name="})
    public IRubyObject set_orig_name(ThreadContext context, IRubyObject obj) {
        this.nullFreeOrigName = this.ensureNonNull(Create.dupString(context, obj.convertToString()));
        try {
            this.io.setName(this.nullFreeOrigName.toString());
        }
        catch (GZIPException e) {
            throw RubyZlib.newGzipFileError(context, "header is already written");
        }
        return obj;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject set_comment(IRubyObject obj) {
        return this.set_comment(this.getCurrentContext(), obj);
    }

    @JRubyMethod(name={"comment="})
    public IRubyObject set_comment(ThreadContext context, IRubyObject obj) {
        this.nullFreeComment = this.ensureNonNull(Create.dupString(context, obj.convertToString()));
        try {
            this.io.setComment(this.nullFreeComment.toString());
        }
        catch (GZIPException e) {
            throw RubyZlib.newGzipFileError(context, "header is already written");
        }
        return obj;
    }

    private RubyString ensureNonNull(RubyString obj) {
        String str = obj.toString();
        if (str.indexOf(0) >= 0) {
            String trim = str.substring(0, str.indexOf(0));
            obj.setValue(new ByteList(trim.getBytes()));
        }
        return obj;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject putc(IRubyObject p1) {
        return this.putc(this.getCurrentContext(), p1);
    }

    @JRubyMethod(name={"putc"})
    public IRubyObject putc(ThreadContext context, IRubyObject p1) {
        try {
            this.io.write((int)Convert.toByte(context, p1));
            return p1;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.puts(context, this, args2);
    }

    @Override
    public IRubyObject finish(ThreadContext context) {
        if (!this.finished) {
            try {
                this.io.finish();
            }
            catch (IOException ioe) {
                throw context.runtime.newIOErrorFromException(ioe);
            }
        }
        this.finished = true;
        return this.realIo;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject flush(IRubyObject[] args2) {
        return this.flush(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"flush"}, optional=1, checkArity=false)
    public IRubyObject flush(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        int flush2 = argc > 0 && !args2[0].isNil() ? Convert.toInt(context, args2[0]) : 2;
        boolean tmp = this.io.getSyncFlush();
        try {
            if (flush2 != 0) {
                this.io.setSyncFlush(true);
            }
            this.io.flush();
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        finally {
            this.io.setSyncFlush(tmp);
        }
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject set_mtime(IRubyObject arg2) {
        return this.set_mtime(this.getCurrentContext(), arg2);
    }

    @JRubyMethod(name={"mtime="})
    public IRubyObject set_mtime(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyTime) {
            RubyTime timeArg;
            this.mtime = timeArg = (RubyTime)arg2;
        } else if (!arg2.isNil()) {
            this.mtime = RubyTime.newTime(context.runtime, Convert.toLong(context, arg2) * 1000L);
        }
        try {
            this.io.setModifiedTime(this.mtime.to_i_long());
        }
        catch (GZIPException e) {
            throw RubyZlib.newGzipFileError(context, "header is already written");
        }
        return context.nil;
    }

    @Override
    @JRubyMethod(name={"crc"})
    public IRubyObject crc(ThreadContext context) {
        long crc2 = 0L;
        try {
            crc2 = this.io.getCRC();
        }
        catch (GZIPException gZIPException) {
            // empty catch block
        }
        return Convert.asFixnum(context, crc2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject write(IRubyObject p1) {
        return this.write(this.getCurrentContext(), p1);
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write(ThreadContext context, IRubyObject p1) {
        RubyString str = p1.asString();
        if (this.enc2 != null && this.enc2 != ASCIIEncoding.INSTANCE) {
            str = EncodingUtils.strConvEncOpts(context, str, str.getEncoding(), this.enc2, 0, context.nil);
        }
        try {
            if (!str.isEmpty()) {
                this.io.write(str.getByteList().getUnsafeBytes(), str.getByteList().begin(), str.getByteList().length());
            }
            return Convert.asFixnum(context, str.getByteList().length());
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    @Override
    @JRubyMethod
    public IRubyObject set_sync(ThreadContext context, IRubyObject arg2) {
        IRubyObject s2 = super.set_sync(context, arg2);
        this.io.setSyncFlush(this.sync);
        return s2;
    }
}

