/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.timeout;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.ByteList;

public class Timeout {
    public static final String EXECUTOR_VARIABLE = "__executor__";
    private static final ByteList TIMEOUT_MESSAGE = ByteList.create("execution expired");

    public static void load(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        Object Timeout2 = Define.defineModule(context, "Timeout").defineMethods(context, Timeout.class);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new DaemonThreadFactory());
        executor.setRemoveOnCancelPolicy(true);
        ((RubyBasicObject)Timeout2).setInternalVariable(EXECUTOR_VARIABLE, executor);
        context.runtime.pushPostExitFunction(ctxt -> {
            executor.shutdown();
            return 0;
        });
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, Block block) {
        return Timeout.timeout(context, recv2, seconds, context.nil, block);
    }

    private static RubyString defaultTimeoutMessage(ThreadContext context) {
        RubyString message2 = Create.newString(context, TIMEOUT_MESSAGE);
        message2.setFrozen(true);
        return message2;
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, IRubyObject exceptionType, Block block) {
        return Timeout.timeout(context, recv2, seconds, exceptionType, context.nil, block);
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, IRubyObject exceptionType, IRubyObject message2, Block block) {
        if (Timeout.nilOrZeroSeconds(context, seconds)) {
            return block.yieldSpecific(context);
        }
        RubyModule Timeout2 = Access.getModule(context, "Timeout");
        RubyThread currentThread = context.getThread();
        AtomicBoolean latch = new AtomicBoolean(false);
        Object id = exceptionType.isNil() ? new Object() : null;
        RubyString exceptionMessage = message2.isNil() ? Timeout.defaultTimeoutMessage(context) : message2.convertToString();
        TimeoutTask timeoutRunnable = id != null ? TimeoutTask.newAnonymousTask(currentThread, Timeout2, latch, id, exceptionMessage) : TimeoutTask.newTaskWithException(currentThread, Timeout2, latch, exceptionType, exceptionMessage);
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Timeout2.getInternalVariable(EXECUTOR_VARIABLE);
        try {
            return Timeout.yieldWithTimeout(executor, context, seconds, block, timeoutRunnable, latch);
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == Timeout.getTimeoutError(context, Timeout2) && id != null) {
                Timeout.raiseTimeoutErrorIfMatches(context, Timeout2, re, id);
            }
            throw re;
        }
    }

    private static boolean nilOrZeroSeconds(ThreadContext context, IRubyObject seconds) {
        boolean bl;
        if (seconds instanceof RubyNumeric) {
            RubyNumeric secs = (RubyNumeric)seconds;
            bl = secs.isZero(context);
        } else {
            bl = seconds.isNil() || Helpers.invoke(context, seconds, "zero?").isTrue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject yieldWithTimeout(ScheduledThreadPoolExecutor executor, ThreadContext context, IRubyObject seconds, Block block, Runnable runnable, AtomicBoolean latch) throws RaiseException {
        long micros = (long)(RubyTime.convertTimeInterval(context, seconds) * 1000000.0);
        ScheduledFuture<?> timeoutFuture = null;
        try {
            timeoutFuture = executor.schedule(runnable, micros, TimeUnit.MICROSECONDS);
            IRubyObject iRubyObject = block.yield(context, seconds);
            return iRubyObject;
        }
        finally {
            if (timeoutFuture != null) {
                Timeout.killTimeoutThread(context, timeoutFuture, latch);
            }
        }
    }

    private static void killTimeoutThread(ThreadContext context, ScheduledFuture timeoutFuture, AtomicBoolean latch) {
        if (!latch.compareAndSet(false, true) || !timeoutFuture.cancel(false)) {
            try {
                timeoutFuture.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            context.pollThreadEvents();
        }
    }

    private static IRubyObject raiseTimeoutErrorIfMatches(ThreadContext context, RubyModule timeout2, RaiseException ex, Object id) {
        if (ex.getException().getInternalVariable("__identifier__") == id) {
            RubyException rubyException = ex.getException();
            return RubyKernel.raise(context, Access.kernelModule(context), new IRubyObject[]{Timeout.getTimeoutError(context, timeout2), rubyException.callMethod(context, "message"), rubyException.callMethod(context, "backtrace")}, Block.NULL_BLOCK);
        }
        return null;
    }

    private static RubyClass getTimeoutError(ThreadContext context, RubyModule timeout2) {
        return timeout2.getClass(context, "Error");
    }

    static {
        TIMEOUT_MESSAGE.setEncoding((Encoding)UTF8Encoding.INSTANCE);
    }

    private static class TimeoutTask
    implements Runnable {
        final RubyThread currentThread;
        final AtomicBoolean latch;
        final RubyModule timeout;
        final Object id;
        final IRubyObject exception;
        final RubyString message;

        private TimeoutTask(RubyThread currentThread, RubyModule timeout2, AtomicBoolean latch, Object id, IRubyObject exception2, RubyString message2) {
            this.currentThread = currentThread;
            this.timeout = timeout2;
            this.latch = latch;
            this.id = id;
            this.exception = exception2;
            this.message = message2;
        }

        static TimeoutTask newAnonymousTask(RubyThread currentThread, RubyModule timeout2, AtomicBoolean latch, Object id, RubyString message2) {
            return new TimeoutTask(currentThread, timeout2, latch, id, null, message2);
        }

        static TimeoutTask newTaskWithException(RubyThread currentThread, RubyModule timeout2, AtomicBoolean latch, IRubyObject exception2, RubyString message2) {
            return new TimeoutTask(currentThread, timeout2, latch, null, exception2, message2);
        }

        @Override
        public void run() {
            if (this.latch.compareAndSet(false, true)) {
                if (this.exception == null) {
                    this.raiseAnonymous(this.currentThread.getContext());
                } else {
                    this.raiseException();
                }
            }
        }

        private void raiseAnonymous(ThreadContext context) {
            RubyObject anonException = (RubyObject)Timeout.getTimeoutError(context, this.timeout).newInstance(context, this.message, Block.NULL_BLOCK);
            anonException.setInternalVariable("__identifier__", this.id);
            this.currentThread.raise(anonException);
        }

        private void raiseException() {
            this.currentThread.raise(this.exception, this.message);
        }
    }
}

