/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.FreedMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.ReifyingAllocator;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.cli.Options;

@JRubyClass(name={"FFI::MemoryPointer"}, parent="FFI::Pointer")
public class MemoryPointer
extends Pointer {
    public static RubyClass createMemoryPointerClass(ThreadContext context, RubyModule FFI2, RubyClass Pointer2) {
        ObjectAllocator allocator = (Boolean)Options.REIFY_FFI.load() != false ? new ReifyingAllocator(MemoryPointer.class) : MemoryPointer::new;
        return (RubyClass)((RubyModule)((RubyModule)((RubyModule)((RubyClass)FFI2.defineClassUnder(context, "MemoryPointer", Pointer2, allocator)).reifiedClass(MemoryPointer.class)).kindOf(new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof MemoryPointer && super.isKindOf(obj, type2);
            }
        })).defineMethods(context, MemoryPointer.class)).defineConstants(context, MemoryPointer.class);
    }

    public MemoryPointer(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    private MemoryPointer(Ruby runtime2, IRubyObject klass, MemoryIO io2, long total2, int typeSize) {
        super(runtime2, (RubyClass)klass, io2, total2, typeSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IRubyObject init(ThreadContext context, IRubyObject rbTypeSize, int count2, int align, boolean clear2, Block block) {
        this.typeSize = MemoryPointer.calculateTypeSize(context, rbTypeSize);
        this.size = this.typeSize * count2;
        if (this.size < 0L) {
            throw Error.argumentError(context, String.format("Negative size (%d objects of %d size)", count2, this.typeSize));
        }
        this.setMemoryIO(Factory.getInstance().allocateDirectMemory(context.runtime, this.size > 0L ? (int)this.size : 1, align, clear2));
        if (this.getMemoryIO() == null) {
            throw RaiseException.from(context.runtime, context.runtime.getNoMemoryError(), String.format("Failed to allocate %d objects of %d bytes", this.typeSize, count2));
        }
        if (!block.isGiven()) {
            return this;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, this);
            return iRubyObject;
        }
        finally {
            ((AllocatedDirectMemoryIO)((Object)this.getMemoryIO())).free();
            this.setMemoryIO(new FreedMemoryIO(context.runtime));
        }
    }

    static MemoryPointer allocate(Ruby runtime2, int typeSize, int count2, boolean clear2) {
        int total2 = typeSize * count2;
        MemoryIO io2 = Factory.getInstance().allocateDirectMemory(runtime2, total2 > 0 ? total2 : 1, clear2);
        if (io2 == null) {
            throw RaiseException.from(runtime2, runtime2.getNoMemoryError(), String.format("Failed to allocate %d objects of %d bytes", count2, typeSize));
        }
        return new MemoryPointer(runtime2, (IRubyObject)runtime2.getFFI().memptrClass, io2, (long)total2, typeSize);
    }

    @JRubyMethod(name={"from_string"}, meta=true)
    public static IRubyObject from_string(ThreadContext context, IRubyObject klass, IRubyObject s2) {
        ByteList bl = s2.convertToString().getByteList();
        MemoryPointer ptr = (MemoryPointer)((RubyClass)klass).newInstance(context, Convert.asFixnum(context, bl.length() + 1), Block.NULL_BLOCK);
        ptr.getMemoryIO().putZeroTerminatedByteArray(0L, bl.unsafeBytes(), bl.begin(), bl.length());
        return ptr;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, Block block) {
        IRubyObject iRubyObject;
        if (sizeArg instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)sizeArg;
            iRubyObject = this.init(context, RubyFixnum.one(context.runtime), Convert.toInt(context, fixnum), 1, true, block);
        } else {
            iRubyObject = this.init(context, sizeArg, 1, 1, true, block);
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject count2, Block block) {
        return this.init(context, sizeArg, Convert.toInt(context, count2), 1, true, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject count2, IRubyObject clear2, Block block) {
        return this.init(context, sizeArg, Convert.toInt(context, count2), 1, clear2.isTrue(), block);
    }

    @Override
    public final String toString() {
        return String.format("MemoryPointer[address=%#x, size=%d]", this.getAddress(), this.size);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        MemoryPointer mem;
        return Convert.asBoolean(context, this == obj || this.getAddress() == 0L && obj.isNil() || obj instanceof MemoryPointer && (mem = (MemoryPointer)obj).getAddress() == this.getAddress() && mem.getSize() == this.getSize());
    }

    @JRubyMethod(name={"free"})
    public final IRubyObject free(ThreadContext context) {
        ((AllocatedDirectMemoryIO)((Object)this.getMemoryIO())).free();
        this.setMemoryIO(new FreedMemoryIO(context.runtime));
        return context.nil;
    }

    @JRubyMethod(name={"autorelease="})
    public final IRubyObject autorelease(ThreadContext context, IRubyObject release) {
        ((AllocatedDirectMemoryIO)((Object)this.getMemoryIO())).setAutoRelease(release.isTrue());
        return context.nil;
    }

    @JRubyMethod(name={"autorelease?"})
    public final IRubyObject autorelease_p(ThreadContext context) {
        return Convert.asBoolean(context, ((AllocatedDirectMemoryIO)((Object)this.getMemoryIO())).isAutoRelease());
    }
}

